/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ClusterLoadState;
import org.apache.hadoop.hbase.master.balancer.RegionInfoComparator;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class SimpleLoadBalancer
extends BaseLoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleLoadBalancer.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private RegionInfoComparator riComparator = new RegionInfoComparator();
    private RegionPlan.RegionPlanComparator rpComparator = new RegionPlan.RegionPlanComparator();
    private float avgLoadOverall;
    private List<ServerAndLoad> serverLoadList;

    @Override
    public void setClusterLoad(Map<TableName, Map<ServerName, List<RegionInfo>>> clusterLoad) {
        this.serverLoadList = new ArrayList<ServerAndLoad>();
        HashMap<ServerName, Integer> server2LoadMap = new HashMap<ServerName, Integer>();
        float sum = 0.0f;
        for (Map.Entry<TableName, Map<ServerName, List<RegionInfo>>> clusterEntry : clusterLoad.entrySet()) {
            for (Map.Entry<ServerName, List<RegionInfo>> entry : clusterEntry.getValue().entrySet()) {
                if (entry.getKey().equals(this.masterServerName)) continue;
                int regionNum = entry.getValue().size();
                server2LoadMap.compute(entry.getKey(), (k, v) -> v == null ? regionNum : regionNum + v);
                sum += (float)regionNum;
            }
        }
        server2LoadMap.forEach((k, v) -> this.serverLoadList.add(new ServerAndLoad((ServerName)k, (int)v)));
        this.avgLoadOverall = sum / (float)this.serverLoadList.size();
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        float originSlop = this.slop;
        float originOverallSlop = this.overallSlop;
        super.setConf(conf);
        LOG.info("Update configuration of SimpleLoadBalancer, previous slop is " + originSlop + ", current slop is " + this.slop + "previous overallSlop is" + originOverallSlop + ", current overallSlop is " + originOverallSlop);
    }

    private void setLoad(List<ServerAndLoad> slList, int i, int loadChange) {
        ServerAndLoad newsl = new ServerAndLoad(slList.get(i).getServerName(), slList.get(i).getLoad() + loadChange);
        slList.set(i, newsl);
    }

    private boolean overallNeedsBalance() {
        int floor = (int)Math.floor(this.avgLoadOverall * (1.0f - this.overallSlop));
        int ceiling = (int)Math.ceil(this.avgLoadOverall * (1.0f + this.overallSlop));
        int max = 0;
        int min = Integer.MAX_VALUE;
        for (ServerAndLoad server : this.serverLoadList) {
            max = Math.max(server.getLoad(), max);
            min = Math.min(server.getLoad(), min);
        }
        if (max <= ceiling && min >= floor) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Skipping load balancing because cluster is balanced at overall level");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RegionPlan> balanceCluster(Map<ServerName, List<RegionInfo>> clusterMap) {
        Map.Entry entry;
        int regionCount;
        List<RegionPlan> regionsToReturn = this.balanceMasterRegions(clusterMap);
        if (regionsToReturn != null || clusterMap == null || clusterMap.size() <= 1) {
            return regionsToReturn;
        }
        if (this.masterServerName != null && clusterMap.containsKey(this.masterServerName)) {
            if (clusterMap.size() <= 2) {
                return null;
            }
            clusterMap = new HashMap<ServerName, List<RegionInfo>>(clusterMap);
            clusterMap.remove(this.masterServerName);
        }
        long startTime = System.currentTimeMillis();
        BaseLoadBalancer.Cluster c = new BaseLoadBalancer.Cluster(clusterMap, null, this.regionFinder, this.rackManager);
        if (!this.needsBalance(c) && !this.overallNeedsBalance()) {
            return null;
        }
        ClusterLoadState cs = new ClusterLoadState(clusterMap);
        int numServers = cs.getNumServers();
        NavigableMap<ServerAndLoad, List<RegionInfo>> serversByLoad = cs.getServersByLoad();
        int numRegions = cs.getNumRegions();
        float average = cs.getLoadAverage();
        int max = (int)Math.ceil(average);
        int min = (int)average;
        StringBuilder strBalanceParam = new StringBuilder();
        strBalanceParam.append("Balance parameter: numRegions=").append(numRegions).append(", numServers=").append(numServers).append(", max=").append(max).append(", min=").append(min);
        LOG.debug(strBalanceParam.toString());
        MinMaxPriorityQueue<RegionPlan> regionsToMove = MinMaxPriorityQueue.orderedBy(this.rpComparator).create();
        regionsToReturn = new ArrayList<RegionPlan>();
        int serversOverloaded = 0;
        boolean fetchFromTail = false;
        TreeMap<ServerName, BalanceInfo> serverBalanceInfo = new TreeMap<ServerName, BalanceInfo>();
        for (Map.Entry server2 : serversByLoad.descendingMap().entrySet()) {
            ServerAndLoad sal = (ServerAndLoad)server2.getKey();
            int load = sal.getLoad();
            if (load <= max) {
                serverBalanceInfo.put(sal.getServerName(), new BalanceInfo(0, 0, (List)server2.getValue()));
                continue;
            }
            ++serversOverloaded;
            List regions = (List)server2.getValue();
            int n = Math.min(load - max, regions.size());
            Collections.sort(regions, this.riComparator);
            int numTaken = 0;
            for (int i = 0; i <= n; ++i) {
                void var26_34;
                RegionInfo regionInfo = (RegionInfo)regions.get(i);
                if (!fetchFromTail) continue;
                RegionInfo regionInfo2 = (RegionInfo)regions.get(regions.size() - 1 - i);
                if (this.shouldBeOnMaster((RegionInfo)var26_34) && this.masterServerName.equals(sal.getServerName())) continue;
                regionsToMove.add(new RegionPlan((RegionInfo)var26_34, sal.getServerName(), null));
                if (++numTaken < n) continue;
                break;
            }
            serverBalanceInfo.put(sal.getServerName(), new BalanceInfo(n, -1 * numTaken, (List)server2.getValue()));
        }
        int totalNumMoved = regionsToMove.size();
        int neededRegions = 0;
        fetchFromTail = false;
        HashMap<ServerName, Integer> underloadedServers = new HashMap<ServerName, Integer>();
        int maxToTake = numRegions - min;
        for (Map.Entry entry2 : serversByLoad.entrySet()) {
            if (maxToTake == 0) break;
            int load = ((ServerAndLoad)entry2.getKey()).getLoad();
            if (load >= min) continue;
            int regionsToPut = min - load;
            maxToTake -= regionsToPut;
            underloadedServers.put(((ServerAndLoad)entry2.getKey()).getServerName(), regionsToPut);
        }
        int serversUnderloaded = underloadedServers.size();
        boolean bl = true;
        List<ServerName> sns = Arrays.asList(underloadedServers.keySet().toArray(new ServerName[serversUnderloaded]));
        Collections.shuffle(sns, RANDOM);
        while (regionsToMove.size() > 0) {
            void var23_28;
            int n;
            int cnt = 0;
            int n2 = n = var23_28 > 0 ? 0 : underloadedServers.size() - 1;
            while (n >= 0 && n < underloadedServers.size() && !regionsToMove.isEmpty()) {
                ServerName si = sns.get(n);
                int numToTake = (Integer)underloadedServers.get(si);
                if (numToTake != 0) {
                    this.addRegionPlan(regionsToMove, fetchFromTail, si, regionsToReturn);
                    underloadedServers.put(si, numToTake - 1);
                    ++cnt;
                    BalanceInfo bi = (BalanceInfo)serverBalanceInfo.get(si);
                    bi.setNumRegionsAdded(bi.getNumRegionsAdded() + 1);
                }
                n += var23_28;
            }
            if (cnt == 0) break;
            var23_28 = -var23_28;
        }
        for (Integer n : underloadedServers.values()) {
            neededRegions += n.intValue();
        }
        if (neededRegions != 0) {
            for (Map.Entry entry3 : serversByLoad.descendingMap().entrySet()) {
                int idx;
                BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(((ServerAndLoad)entry3.getKey()).getServerName());
                int n = idx = balanceInfo == null ? 0 : balanceInfo.getNextRegionForUnload();
                if (idx >= ((List)entry3.getValue()).size()) break;
                RegionInfo region = (RegionInfo)((List)entry3.getValue()).get(idx);
                if (region.isMetaRegion()) continue;
                regionsToMove.add(new RegionPlan(region, ((ServerAndLoad)entry3.getKey()).getServerName(), null));
                balanceInfo.setNumRegionsAdded(balanceInfo.getNumRegionsAdded() - 1);
                balanceInfo.setNextRegionForUnload(balanceInfo.getNextRegionForUnload() + 1);
                ++totalNumMoved;
                if (--neededRegions != 0) continue;
                break;
            }
        }
        Iterator<Object> cnt = serversByLoad.entrySet().iterator();
        while (cnt.hasNext() && (regionCount = ((ServerAndLoad)(entry = (Map.Entry)cnt.next()).getKey()).getLoad()) < min) {
            BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(((ServerAndLoad)entry.getKey()).getServerName());
            if (balanceInfo != null) {
                regionCount += balanceInfo.getNumRegionsAdded();
            }
            if (regionCount >= min) continue;
            int numToTake = min - regionCount;
            for (int numTaken = 0; numTaken < numToTake && 0 < regionsToMove.size(); ++numTaken) {
                this.addRegionPlan(regionsToMove, fetchFromTail, ((ServerAndLoad)entry.getKey()).getServerName(), regionsToReturn);
                balanceInfo.setNumRegionsAdded(balanceInfo.getNumRegionsAdded() + 1);
            }
        }
        if (min != max) {
            this.balanceOverall(regionsToReturn, serverBalanceInfo, fetchFromTail, regionsToMove, max, min);
        }
        long endTime = System.currentTimeMillis();
        if (!regionsToMove.isEmpty() || neededRegions != 0) {
            LOG.warn("regionsToMove=" + totalNumMoved + ", numServers=" + numServers + ", serversOverloaded=" + serversOverloaded + ", serversUnderloaded=" + serversUnderloaded);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<ServerName, List<RegionInfo>> e : clusterMap.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(e.getKey().toString());
                sb.append(" ");
                sb.append(e.getValue().size());
            }
            LOG.warn("Input " + sb.toString());
        }
        LOG.info("Done. Calculated a load balance in " + (endTime - startTime) + "ms. Moving " + totalNumMoved + " regions off of " + serversOverloaded + " overloaded servers onto " + serversUnderloaded + " less loaded servers");
        return regionsToReturn;
    }

    public void balanceOverall(List<RegionPlan> regionsToReturn, Map<ServerName, BalanceInfo> serverBalanceInfo, boolean fetchFromTail, MinMaxPriorityQueue<RegionPlan> regionsToMove, int max, int min) {
        int i;
        HashMap<ServerName, ArrayList<Integer>> returnMap = new HashMap<ServerName, ArrayList<Integer>>();
        for (i = 0; i < regionsToReturn.size(); ++i) {
            ArrayList<Integer> pos = (ArrayList<Integer>)returnMap.get(regionsToReturn.get(i).getDestination());
            if (pos == null) {
                pos = new ArrayList<Integer>();
                returnMap.put(regionsToReturn.get(i).getDestination(), pos);
            }
            pos.add(i);
        }
        for (i = 0; i < this.serverLoadList.size(); ++i) {
            ServerAndLoad serverload = this.serverLoadList.get(i);
            BalanceInfo balanceInfo = serverBalanceInfo.get(serverload.getServerName());
            if (balanceInfo == null) continue;
            this.setLoad(this.serverLoadList, i, balanceInfo.getNumRegionsAdded());
            if (balanceInfo.getHriList().size() + balanceInfo.getNumRegionsAdded() == max) {
                if (balanceInfo.getHriList().isEmpty()) {
                    LOG.debug("During balanceOverall, we found " + serverload.getServerName() + " has no RegionInfo, no operation needed");
                    continue;
                }
                if (balanceInfo.getNextRegionForUnload() >= balanceInfo.getHriList().size()) continue;
                RegionInfo hriToPlan = balanceInfo.getHriList().get(balanceInfo.getNextRegionForUnload());
                RegionPlan maxPlan = new RegionPlan(hriToPlan, serverload.getServerName(), null);
                regionsToMove.add(maxPlan);
                this.setLoad(this.serverLoadList, i, -1);
                continue;
            }
            if (balanceInfo.getHriList().size() + balanceInfo.getNumRegionsAdded() <= max && balanceInfo.getHriList().size() + balanceInfo.getNumRegionsAdded() >= min) continue;
            LOG.warn("Encounter incorrect region numbers after calculating move plan during balanceOverall, for this table, " + serverload.getServerName() + " originally has " + balanceInfo.getHriList().size() + " regions and " + balanceInfo.getNumRegionsAdded() + " regions have been added. Yet, max =" + max + ", min =" + min + ". Thus stop balance for this table");
            return;
        }
        Collections.sort(this.serverLoadList, new Comparator<ServerAndLoad>(){

            @Override
            public int compare(ServerAndLoad s1, ServerAndLoad s2) {
                if (s1.getLoad() == s2.getLoad()) {
                    return 0;
                }
                return s1.getLoad() > s2.getLoad() ? 1 : -1;
            }
        });
        int assignLength = regionsToMove.size();
        HashMap<ServerName, Pair<ServerAndLoad, Integer>> SnLoadMap = new HashMap<ServerName, Pair<ServerAndLoad, Integer>>();
        for (int i2 = 0; i2 < this.serverLoadList.size(); ++i2) {
            SnLoadMap.put(this.serverLoadList.get(i2).getServerName(), new Pair<ServerAndLoad, Integer>(this.serverLoadList.get(i2), i2));
        }
        ArrayList<RegionPlan> planToRemoveList = new ArrayList<RegionPlan>();
        HashMap<ServerName, Integer> sourceMap = new HashMap<ServerName, Integer>();
        for (RegionPlan plan : regionsToMove) {
            Pair shredLoad = (Pair)SnLoadMap.get(plan.getSource());
            if (!sourceMap.containsKey(plan.getSource())) {
                sourceMap.put(plan.getSource(), 0);
            }
            sourceMap.put(plan.getSource(), (Integer)sourceMap.get(plan.getSource()) + 1);
            if ((Integer)shredLoad.getSecond() >= assignLength || (Integer)sourceMap.get(plan.getSource()) != 1) continue;
            planToRemoveList.add(plan);
            this.setLoad(this.serverLoadList, (Integer)shredLoad.getSecond(), 1);
        }
        for (RegionPlan planToRemove : planToRemoveList) {
            regionsToMove.remove(planToRemove);
        }
        for (int i3 = 0; i3 < assignLength; ++i3) {
            if (sourceMap.containsKey(this.serverLoadList.get(i3).getServerName())) continue;
            this.addRegionPlan(regionsToMove, fetchFromTail, this.serverLoadList.get(i3).getServerName(), regionsToReturn);
            this.setLoad(this.serverLoadList, i3, 1);
            List pos = (List)returnMap.get(regionsToReturn.get(regionsToReturn.size() - 1).getSource());
            if (pos == null || pos.size() == 0) continue;
            regionsToReturn.get((Integer)pos.get(pos.size() - 1)).setDestination(regionsToReturn.get(regionsToReturn.size() - 1).getDestination());
            pos.remove(pos.size() - 1);
            regionsToReturn.remove(regionsToReturn.size() - 1);
        }
    }

    private void addRegionPlan(MinMaxPriorityQueue<RegionPlan> regionsToMove, boolean fetchFromTail, ServerName sn, List<RegionPlan> regionsToReturn) {
        RegionPlan rp = null;
        rp = !fetchFromTail ? (RegionPlan)regionsToMove.remove() : regionsToMove.removeLast();
        rp.setDestination(sn);
        regionsToReturn.add(rp);
    }

    @Override
    public List<RegionPlan> balanceCluster(TableName tableName, Map<ServerName, List<RegionInfo>> clusterState) throws HBaseIOException {
        LOG.debug("Start Generate Balance plan for table: " + tableName);
        return this.balanceCluster(clusterState);
    }

    static class BalanceInfo {
        private int nextRegionForUnload;
        private int numRegionsAdded;
        private List<RegionInfo> hriList;

        public BalanceInfo(int nextRegionForUnload, int numRegionsAdded, List<RegionInfo> hriList) {
            this.nextRegionForUnload = nextRegionForUnload;
            this.numRegionsAdded = numRegionsAdded;
            this.hriList = hriList;
        }

        int getNextRegionForUnload() {
            return this.nextRegionForUnload;
        }

        int getNumRegionsAdded() {
            return this.numRegionsAdded;
        }

        void setNumRegionsAdded(int numAdded) {
            this.numRegionsAdded = numAdded;
        }

        List<RegionInfo> getHriList() {
            return this.hriList;
        }

        void setNextRegionForUnload(int nextRegionForUnload) {
            this.nextRegionForUnload = nextRegionForUnload;
        }
    }
}

