/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.master.procedure.CloneSnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RestoreSnapshotProcedure;
import org.apache.hadoop.hbase.master.snapshot.DisabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.EnabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinator;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotExistsException;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.TablePartiallyOpenException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.hbase.util.TableDescriptorChecker;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
@InterfaceStability.Unstable
public class SnapshotManager
extends MasterProcedureManager
implements Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotManager.class);
    private static final int SNAPSHOT_WAKE_MILLIS_DEFAULT = 500;
    public static final String HBASE_SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLIS = "hbase.snapshot.sentinels.cleanup.timeoutMillis";
    public static final long SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLS_DEFAULT = 60000L;
    public static final String HBASE_SNAPSHOT_ENABLED = "hbase.snapshot.enabled";
    private static final String SNAPSHOT_WAKE_MILLIS_KEY = "hbase.snapshot.master.wakeMillis";
    public static final String ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION = "online-snapshot";
    public static final String SNAPSHOT_POOL_THREADS_KEY = "hbase.snapshot.master.threads";
    public static final int SNAPSHOT_POOL_THREADS_DEFAULT = 1;
    private boolean stopped;
    private MasterServices master;
    private ProcedureCoordinator coordinator;
    private boolean isSnapshotSupported = false;
    private final Map<TableName, SnapshotSentinel> snapshotHandlers = new ConcurrentHashMap<TableName, SnapshotSentinel>();
    private final ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("SnapshotHandlerChoreCleaner").setDaemon(true).build());
    private ScheduledFuture<?> snapshotHandlerChoreCleanerTask;
    private Map<TableName, Long> restoreTableToProcIdMap = new HashMap<TableName, Long>();
    private Path rootDir;
    private ExecutorService executorService;
    private ReentrantReadWriteLock takingSnapshotLock = new ReentrantReadWriteLock(true);

    public SnapshotManager() {
    }

    @VisibleForTesting
    SnapshotManager(MasterServices master, ProcedureCoordinator coordinator, ExecutorService pool, int sentinelCleanInterval) throws IOException, UnsupportedOperationException {
        this.master = master;
        this.rootDir = master.getMasterFileSystem().getRootDir();
        Configuration conf = master.getConfiguration();
        this.checkSnapshotSupport(conf, master.getMasterFileSystem());
        this.coordinator = coordinator;
        this.executorService = pool;
        this.resetTempDir();
        this.snapshotHandlerChoreCleanerTask = this.scheduleThreadPool.scheduleAtFixedRate(this::cleanupSentinels, sentinelCleanInterval, sentinelCleanInterval, TimeUnit.SECONDS);
    }

    public List<SnapshotProtos.SnapshotDescription> getCompletedSnapshots() throws IOException {
        return this.getCompletedSnapshots(SnapshotDescriptionUtils.getSnapshotsDir(this.rootDir), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SnapshotProtos.SnapshotDescription> getCompletedSnapshots(Path snapshotDir, boolean withCpCall) throws IOException {
        ArrayList<SnapshotProtos.SnapshotDescription> snapshotDescs = new ArrayList<SnapshotProtos.SnapshotDescription>();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        if (snapshotDir == null) {
            snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(this.rootDir);
        }
        if (!fs.exists(snapshotDir)) {
            return snapshotDescs;
        }
        FileStatus[] snapshots = fs.listStatus(snapshotDir, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs));
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        withCpCall = withCpCall && cpHost != null;
        for (FileStatus snapshot : snapshots) {
            Path info = new Path(snapshot.getPath(), ".snapshotinfo");
            if (!fs.exists(info)) {
                LOG.error("Snapshot information for " + snapshot.getPath() + " doesn't exist");
                continue;
            }
            try (FSDataInputStream in = null;){
                SnapshotDescription descPOJO;
                in = fs.open(info);
                SnapshotProtos.SnapshotDescription desc = SnapshotProtos.SnapshotDescription.parseFrom((InputStream)in);
                SnapshotDescription snapshotDescription = descPOJO = withCpCall ? ProtobufUtil.createSnapshotDesc(desc) : null;
                if (withCpCall) {
                    try {
                        cpHost.preListSnapshot(descPOJO);
                    }
                    catch (AccessDeniedException e) {
                        LOG.warn("Current user does not have access to " + desc.getName() + " snapshot. Either you should be owner of this snapshot or admin user.");
                        if (in == null) continue;
                        in.close();
                        continue;
                    }
                }
                snapshotDescs.add(desc);
                if (!withCpCall) continue;
                cpHost.postListSnapshot(descPOJO);
            }
        }
        return snapshotDescs;
    }

    private void resetTempDir() throws IOException {
        Path tmpdir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.rootDir, this.master.getConfiguration());
        FileSystem tmpFs = tmpdir.getFileSystem(this.master.getConfiguration());
        if (!tmpFs.delete(tmpdir, true)) {
            LOG.warn("Couldn't delete working snapshot directory: " + tmpdir);
        }
    }

    public void deleteSnapshot(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        if (!this.isSnapshotCompleted(snapshot)) {
            throw new SnapshotDoesNotExistException(ProtobufUtil.createSnapshotDesc(snapshot));
        }
        String snapshotName = snapshot.getName();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, this.rootDir);
        snapshot = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        SnapshotDescription snapshotPOJO = null;
        if (cpHost != null) {
            snapshotPOJO = ProtobufUtil.createSnapshotDesc(snapshot);
            cpHost.preDeleteSnapshot(snapshotPOJO);
        }
        LOG.debug("Deleting snapshot: " + snapshotName);
        if (!fs.delete(snapshotDir, true)) {
            throw new HBaseSnapshotException("Failed to delete snapshot directory: " + snapshotDir);
        }
        if (cpHost != null) {
            cpHost.postDeleteSnapshot(snapshotPOJO);
        }
    }

    public boolean isSnapshotDone(SnapshotProtos.SnapshotDescription expected) throws IOException {
        if (expected == null) {
            throw new UnknownSnapshotException("No snapshot name passed in request, can't figure out which snapshot you want to check.");
        }
        String ssString = ClientSnapshotDescriptionUtils.toString(expected);
        SnapshotSentinel handler = this.removeSentinelIfFinished(this.snapshotHandlers, expected);
        this.cleanupSentinels();
        if (handler == null) {
            if (!this.isSnapshotCompleted(expected)) {
                throw new UnknownSnapshotException("Snapshot " + ssString + " is not currently running or one of the known completed snapshots.");
            }
            return true;
        }
        try {
            handler.rethrowExceptionIfFailed();
        }
        catch (ForeignException e) {
            Procedure p = this.coordinator.getProcedure(expected.getName());
            String status = p != null ? p.getStatus() : expected.getName() + " not found in proclist " + this.coordinator.getProcedureNames();
            throw new HBaseSnapshotException("Snapshot " + ssString + " had an error.  " + status, e, ProtobufUtil.createSnapshotDesc(expected));
        }
        if (handler.isFinished()) {
            LOG.debug("Snapshot '" + ssString + "' has completed, notifying client.");
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Snapshoting '" + ssString + "' is still in progress!");
        }
        return false;
    }

    synchronized boolean isTakingSnapshot(SnapshotProtos.SnapshotDescription snapshot) {
        TableName snapshotTable = TableName.valueOf(snapshot.getTable());
        if (this.isTakingSnapshot(snapshotTable)) {
            return true;
        }
        for (Map.Entry<TableName, SnapshotSentinel> entry : this.snapshotHandlers.entrySet()) {
            SnapshotSentinel sentinel = entry.getValue();
            if (!snapshot.getName().equals(sentinel.getSnapshot().getName()) || sentinel.isFinished()) continue;
            return true;
        }
        return false;
    }

    public boolean isTakingSnapshot(TableName tableName) {
        SnapshotSentinel handler = this.snapshotHandlers.get(tableName);
        return handler != null && !handler.isFinished();
    }

    private synchronized void prepareToTakeSnapshot(SnapshotProtos.SnapshotDescription snapshot) throws HBaseSnapshotException {
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir, this.master.getConfiguration());
        TableName snapshotTable = TableName.valueOf(snapshot.getTable());
        if (this.isTakingSnapshot(snapshot)) {
            SnapshotSentinel handler = this.snapshotHandlers.get(snapshotTable);
            throw new SnapshotCreationException("Rejected taking " + ClientSnapshotDescriptionUtils.toString(snapshot) + " because we are already running another snapshot " + (handler != null ? "on the same table " + ClientSnapshotDescriptionUtils.toString(handler.getSnapshot()) : "with the same name"), ProtobufUtil.createSnapshotDesc(snapshot));
        }
        if (this.isRestoringTable(snapshotTable)) {
            throw new SnapshotCreationException("Rejected taking " + ClientSnapshotDescriptionUtils.toString(snapshot) + " because we are already have a restore in progress on the same snapshot.");
        }
        try {
            FileSystem workingDirFS = workingDir.getFileSystem(this.master.getConfiguration());
            workingDirFS.delete(workingDir, true);
            if (!workingDirFS.mkdirs(workingDir)) {
                throw new SnapshotCreationException("Couldn't create working directory (" + workingDir + ") for snapshot", ProtobufUtil.createSnapshotDesc(snapshot));
            }
        }
        catch (HBaseSnapshotException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SnapshotCreationException("Exception while checking to see if snapshot could be started.", e, ProtobufUtil.createSnapshotDesc(snapshot));
        }
    }

    private synchronized void snapshotDisabledTable(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.prepareToTakeSnapshot(snapshot);
        snapshot = snapshot.toBuilder().setType(SnapshotProtos.SnapshotDescription.Type.DISABLED).build();
        DisabledTableSnapshotHandler handler = new DisabledTableSnapshotHandler(snapshot, this.master, this);
        this.snapshotTable(snapshot, handler);
    }

    private synchronized void snapshotEnabledTable(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.prepareToTakeSnapshot(snapshot);
        EnabledTableSnapshotHandler handler = new EnabledTableSnapshotHandler(snapshot, this.master, this);
        this.snapshotTable(snapshot, handler);
    }

    private synchronized void snapshotTable(SnapshotProtos.SnapshotDescription snapshot, TakeSnapshotHandler handler) throws IOException {
        try {
            handler.prepare();
            this.executorService.submit(handler);
            this.snapshotHandlers.put(TableName.valueOf(snapshot.getTable()), handler);
        }
        catch (Exception e) {
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir, this.master.getConfiguration());
            FileSystem workingDirFs = workingDir.getFileSystem(this.master.getConfiguration());
            try {
                if (!workingDirFs.delete(workingDir, true)) {
                    LOG.error("Couldn't delete working directory (" + workingDir + " for snapshot:" + ClientSnapshotDescriptionUtils.toString(snapshot));
                }
            }
            catch (IOException e1) {
                LOG.error("Couldn't delete working directory (" + workingDir + " for snapshot:" + ClientSnapshotDescriptionUtils.toString(snapshot));
            }
            throw new SnapshotCreationException("Could not build snapshot handler", e, ProtobufUtil.createSnapshotDesc(snapshot));
        }
    }

    public ReadWriteLock getTakingSnapshotLock() {
        return this.takingSnapshotLock;
    }

    public synchronized boolean isTakingAnySnapshot() {
        return this.takingSnapshotLock.getReadHoldCount() > 0 || this.snapshotHandlers.size() > 0;
    }

    public void takeSnapshot(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.takingSnapshotLock.readLock().lock();
        try {
            this.takeSnapshotInternal(snapshot);
        }
        finally {
            this.takingSnapshotLock.readLock().unlock();
        }
    }

    private void takeSnapshotInternal(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        if (this.isSnapshotCompleted(snapshot)) {
            throw new SnapshotExistsException("Snapshot '" + snapshot.getName() + "' already stored on the filesystem.", ProtobufUtil.createSnapshotDesc(snapshot));
        }
        LOG.debug("No existing snapshot, attempting snapshot...");
        this.cleanupSentinels();
        TableDescriptor desc = null;
        try {
            desc = this.master.getTableDescriptors().get(TableName.valueOf(snapshot.getTable()));
        }
        catch (FileNotFoundException e) {
            String msg = "Table:" + snapshot.getTable() + " info doesn't exist!";
            LOG.error(msg);
            throw new SnapshotCreationException(msg, e, ProtobufUtil.createSnapshotDesc(snapshot));
        }
        catch (IOException e) {
            throw new SnapshotCreationException("Error while geting table description for table " + snapshot.getTable(), e, ProtobufUtil.createSnapshotDesc(snapshot));
        }
        if (desc == null) {
            throw new SnapshotCreationException("Table '" + snapshot.getTable() + "' doesn't exist, can't take snapshot.", ProtobufUtil.createSnapshotDesc(snapshot));
        }
        SnapshotProtos.SnapshotDescription.Builder builder = snapshot.toBuilder();
        if (!snapshot.hasVersion()) {
            builder.setVersion(2);
        }
        RpcServer.getRequestUser().ifPresent(user -> {
            if (AccessChecker.isAuthorizationSupported(this.master.getConfiguration())) {
                builder.setOwner(user.getShortName());
            }
        });
        snapshot = builder.build();
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        SnapshotDescription snapshotPOJO = null;
        if (cpHost != null) {
            snapshotPOJO = ProtobufUtil.createSnapshotDesc(snapshot);
            cpHost.preSnapshot(snapshotPOJO, desc);
        }
        TableName snapshotTable = TableName.valueOf(snapshot.getTable());
        if (this.master.getTableStateManager().isTableState(snapshotTable, TableState.State.ENABLED)) {
            LOG.debug("Table enabled, starting distributed snapshot.");
            this.snapshotEnabledTable(snapshot);
            LOG.debug("Started snapshot: " + ClientSnapshotDescriptionUtils.toString(snapshot));
        } else if (this.master.getTableStateManager().isTableState(snapshotTable, TableState.State.DISABLED)) {
            LOG.debug("Table is disabled, running snapshot entirely on master.");
            this.snapshotDisabledTable(snapshot);
            LOG.debug("Started snapshot: " + ClientSnapshotDescriptionUtils.toString(snapshot));
        } else {
            LOG.error("Can't snapshot table '" + snapshot.getTable() + "', isn't open or closed, we don't know what to do!");
            TablePartiallyOpenException tpoe = new TablePartiallyOpenException(snapshot.getTable() + " isn't fully open.");
            throw new SnapshotCreationException("Table is not entirely open or closed", tpoe, ProtobufUtil.createSnapshotDesc(snapshot));
        }
        if (cpHost != null) {
            cpHost.postSnapshot(snapshotPOJO, desc);
        }
    }

    public synchronized void setSnapshotHandlerForTesting(TableName tableName, SnapshotSentinel handler) {
        if (handler != null) {
            this.snapshotHandlers.put(tableName, handler);
        } else {
            this.snapshotHandlers.remove(tableName);
        }
    }

    ProcedureCoordinator getCoordinator() {
        return this.coordinator;
    }

    private boolean isSnapshotCompleted(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        try {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, this.rootDir);
            FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
            return fs.exists(snapshotDir);
        }
        catch (IllegalArgumentException iae) {
            throw new UnknownSnapshotException("Unexpected exception thrown", iae);
        }
    }

    private long cloneSnapshot(SnapshotProtos.SnapshotDescription reqSnapshot, TableName tableName, SnapshotProtos.SnapshotDescription snapshot, TableDescriptor snapshotTableDesc, NonceKey nonceKey, boolean restoreAcl) throws IOException {
        long procId;
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        TableDescriptor htd = TableDescriptorBuilder.copy(tableName, snapshotTableDesc);
        SnapshotDescription snapshotPOJO = null;
        if (cpHost != null) {
            snapshotPOJO = ProtobufUtil.createSnapshotDesc(snapshot);
            cpHost.preCloneSnapshot(snapshotPOJO, htd);
        }
        try {
            procId = this.cloneSnapshot(snapshot, htd, nonceKey, restoreAcl);
        }
        catch (IOException e) {
            LOG.error("Exception occurred while cloning the snapshot " + snapshot.getName() + " as table " + tableName.getNameAsString(), (Throwable)e);
            throw e;
        }
        LOG.info("Clone snapshot=" + snapshot.getName() + " as table=" + tableName);
        if (cpHost != null) {
            cpHost.postCloneSnapshot(snapshotPOJO, htd);
        }
        return procId;
    }

    synchronized long cloneSnapshot(SnapshotProtos.SnapshotDescription snapshot, TableDescriptor tableDescriptor, NonceKey nonceKey, boolean restoreAcl) throws HBaseSnapshotException {
        TableName tableName = tableDescriptor.getTableName();
        if (this.isTakingSnapshot(tableName)) {
            throw new RestoreSnapshotException("Snapshot in progress on the restore table=" + tableName);
        }
        if (this.isRestoringTable(tableName)) {
            throw new RestoreSnapshotException("Restore already in progress on the table=" + tableName);
        }
        try {
            long procId = this.master.getMasterProcedureExecutor().submitProcedure(new CloneSnapshotProcedure(this.master.getMasterProcedureExecutor().getEnvironment(), tableDescriptor, snapshot, restoreAcl), nonceKey);
            this.restoreTableToProcIdMap.put(tableName, procId);
            return procId;
        }
        catch (Exception e) {
            String msg = "Couldn't clone the snapshot=" + ClientSnapshotDescriptionUtils.toString(snapshot) + " on table=" + tableName;
            LOG.error(msg, (Throwable)e);
            throw new RestoreSnapshotException(msg, e);
        }
    }

    public long restoreOrCloneSnapshot(SnapshotProtos.SnapshotDescription reqSnapshot, NonceKey nonceKey, boolean restoreAcl) throws IOException {
        Path snapshotDir;
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        if (!fs.exists(snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(reqSnapshot, this.rootDir))) {
            LOG.error("A Snapshot named '" + reqSnapshot.getName() + "' does not exist.");
            throw new SnapshotDoesNotExistException(ProtobufUtil.createSnapshotDesc(reqSnapshot));
        }
        SnapshotProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        SnapshotManifest manifest = SnapshotManifest.open(this.master.getConfiguration(), fs, snapshotDir, snapshot);
        TableDescriptor snapshotTableDesc = manifest.getTableDescriptor();
        TableName tableName = TableName.valueOf(reqSnapshot.getTable());
        TableDescriptorChecker.sanityCheck(this.master.getConfiguration(), snapshotTableDesc);
        this.cleanupSentinels();
        SnapshotReferenceUtil.verifySnapshot(this.master.getConfiguration(), fs, manifest);
        long procId = MetaTableAccessor.tableExists(this.master.getConnection(), tableName) ? this.restoreSnapshot(reqSnapshot, tableName, snapshot, snapshotTableDesc, nonceKey, restoreAcl) : this.cloneSnapshot(reqSnapshot, tableName, snapshot, snapshotTableDesc, nonceKey, restoreAcl);
        return procId;
    }

    private long restoreSnapshot(SnapshotProtos.SnapshotDescription reqSnapshot, TableName tableName, SnapshotProtos.SnapshotDescription snapshot, TableDescriptor snapshotTableDesc, NonceKey nonceKey, boolean restoreAcl) throws IOException {
        long procId;
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        if (this.master.getTableStateManager().isTableState(TableName.valueOf(snapshot.getTable()), TableState.State.ENABLED)) {
            throw new UnsupportedOperationException("Table '" + TableName.valueOf(snapshot.getTable()) + "' must be disabled in order to perform a restore operation.");
        }
        SnapshotDescription snapshotPOJO = null;
        if (cpHost != null) {
            snapshotPOJO = ProtobufUtil.createSnapshotDesc(snapshot);
            cpHost.preRestoreSnapshot(snapshotPOJO, snapshotTableDesc);
        }
        try {
            procId = this.restoreSnapshot(snapshot, snapshotTableDesc, nonceKey, restoreAcl);
        }
        catch (IOException e) {
            LOG.error("Exception occurred while restoring the snapshot " + snapshot.getName() + " as table " + tableName.getNameAsString(), (Throwable)e);
            throw e;
        }
        LOG.info("Restore snapshot=" + snapshot.getName() + " as table=" + tableName);
        if (cpHost != null) {
            cpHost.postRestoreSnapshot(snapshotPOJO, snapshotTableDesc);
        }
        return procId;
    }

    private synchronized long restoreSnapshot(SnapshotProtos.SnapshotDescription snapshot, TableDescriptor tableDescriptor, NonceKey nonceKey, boolean restoreAcl) throws HBaseSnapshotException {
        TableName tableName = tableDescriptor.getTableName();
        if (this.isTakingSnapshot(tableName)) {
            throw new RestoreSnapshotException("Snapshot in progress on the restore table=" + tableName);
        }
        if (this.isRestoringTable(tableName)) {
            throw new RestoreSnapshotException("Restore already in progress on the table=" + tableName);
        }
        try {
            long procId = this.master.getMasterProcedureExecutor().submitProcedure(new RestoreSnapshotProcedure(this.master.getMasterProcedureExecutor().getEnvironment(), tableDescriptor, snapshot, restoreAcl), nonceKey);
            this.restoreTableToProcIdMap.put(tableName, procId);
            return procId;
        }
        catch (Exception e) {
            String msg = "Couldn't restore the snapshot=" + ClientSnapshotDescriptionUtils.toString(snapshot) + " on table=" + tableName;
            LOG.error(msg, (Throwable)e);
            throw new RestoreSnapshotException(msg, e);
        }
    }

    private synchronized boolean isRestoringTable(TableName tableName) {
        Long procId = this.restoreTableToProcIdMap.get(tableName);
        if (procId == null) {
            return false;
        }
        ProcedureExecutor<MasterProcedureEnv> procExec = this.master.getMasterProcedureExecutor();
        if (procExec.isRunning() && !procExec.isFinished(procId)) {
            return true;
        }
        this.restoreTableToProcIdMap.remove(tableName);
        return false;
    }

    private synchronized SnapshotSentinel removeSentinelIfFinished(Map<TableName, SnapshotSentinel> sentinels, SnapshotProtos.SnapshotDescription snapshot) {
        if (!snapshot.hasTable()) {
            return null;
        }
        TableName snapshotTable = TableName.valueOf(snapshot.getTable());
        SnapshotSentinel h = sentinels.get(snapshotTable);
        if (h == null) {
            return null;
        }
        if (!h.getSnapshot().getName().equals(snapshot.getName())) {
            return null;
        }
        if (h.isFinished()) {
            sentinels.remove(snapshotTable);
        }
        return h;
    }

    private void cleanupSentinels() {
        this.cleanupSentinels(this.snapshotHandlers);
        this.cleanupCompletedRestoreInMap();
    }

    private synchronized void cleanupSentinels(Map<TableName, SnapshotSentinel> sentinels) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        long sentinelsCleanupTimeoutMillis = this.master.getConfiguration().getLong(HBASE_SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLIS, 60000L);
        Iterator<Map.Entry<TableName, SnapshotSentinel>> it = sentinels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TableName, SnapshotSentinel> entry = it.next();
            SnapshotSentinel sentinel = entry.getValue();
            if (!sentinel.isFinished() || currentTime - sentinel.getCompletionTimestamp() <= sentinelsCleanupTimeoutMillis) continue;
            it.remove();
        }
    }

    private synchronized void cleanupCompletedRestoreInMap() {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.master.getMasterProcedureExecutor();
        Iterator<Map.Entry<TableName, Long>> it = this.restoreTableToProcIdMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TableName, Long> entry = it.next();
            Long procId = entry.getValue();
            if (!procExec.isRunning() || !procExec.isFinished(procId)) continue;
            it.remove();
        }
    }

    @Override
    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        for (SnapshotSentinel snapshotHandler : this.snapshotHandlers.values()) {
            snapshotHandler.cancel(why);
        }
        if (this.snapshotHandlerChoreCleanerTask != null) {
            this.snapshotHandlerChoreCleanerTask.cancel(true);
        }
        try {
            if (this.coordinator != null) {
                this.coordinator.close();
            }
        }
        catch (IOException e) {
            LOG.error("stop ProcedureCoordinator error", (Throwable)e);
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public void checkSnapshotSupport() throws UnsupportedOperationException {
        if (!this.isSnapshotSupported) {
            throw new UnsupportedOperationException("To use snapshots, You must add to the hbase-site.xml of the HBase Master: 'hbase.snapshot.enabled' property with value 'true'.");
        }
    }

    private void checkSnapshotSupport(Configuration conf, MasterFileSystem mfs) throws IOException, UnsupportedOperationException {
        String enabled = conf.get(HBASE_SNAPSHOT_ENABLED);
        boolean snapshotEnabled = conf.getBoolean(HBASE_SNAPSHOT_ENABLED, false);
        boolean userDisabled = enabled != null && enabled.trim().length() > 0 && !snapshotEnabled;
        HashSet<String> hfileCleaners = new HashSet<String>();
        String[] cleaners = conf.getStrings("hbase.master.hfilecleaner.plugins");
        if (cleaners != null) {
            Collections.addAll(hfileCleaners, cleaners);
        }
        HashSet logCleaners = new HashSet();
        cleaners = conf.getStrings("hbase.master.logcleaner.plugins");
        if (cleaners != null) {
            Collections.addAll(logCleaners, cleaners);
        }
        Path oldSnapshotDir = new Path(mfs.getRootDir(), ".snapshot");
        FileSystem fs = mfs.getFileSystem();
        List<SnapshotProtos.SnapshotDescription> ss = this.getCompletedSnapshots(new Path(this.rootDir, oldSnapshotDir), false);
        if (ss != null && !ss.isEmpty()) {
            LOG.error("Snapshots from an earlier release were found under: " + oldSnapshotDir);
            LOG.error("Please rename the directory as .hbase-snapshot");
        }
        if (snapshotEnabled) {
            hfileCleaners.add(SnapshotHFileCleaner.class.getName());
            hfileCleaners.add(HFileLinkCleaner.class.getName());
            conf.setStrings("hbase.master.hfilecleaner.plugins", hfileCleaners.toArray(new String[hfileCleaners.size()]));
            conf.setStrings("hbase.master.logcleaner.plugins", logCleaners.toArray(new String[logCleaners.size()]));
        } else {
            boolean bl = snapshotEnabled = hfileCleaners.contains(SnapshotHFileCleaner.class.getName()) && hfileCleaners.contains(HFileLinkCleaner.class.getName());
            if (snapshotEnabled) {
                LOG.warn("Snapshot log and hfile cleaners are present in the configuration, but the 'hbase.snapshot.enabled' property " + (userDisabled ? "is set to 'false'." : "is not set."));
            }
        }
        boolean bl = this.isSnapshotSupported = snapshotEnabled && !userDisabled;
        if (!snapshotEnabled) {
            FileStatus[] snapshots;
            LOG.info("Snapshot feature is not enabled, missing log and hfile cleaners.");
            Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(mfs.getRootDir());
            if (fs.exists(snapshotDir) && (snapshots = FSUtils.listStatus(fs, snapshotDir, new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs))) != null) {
                LOG.error("Snapshots are present, but cleaners are not enabled.");
                this.checkSnapshotSupport();
            }
        }
    }

    @Override
    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws KeeperException, IOException, UnsupportedOperationException {
        this.master = master;
        this.rootDir = master.getMasterFileSystem().getRootDir();
        this.checkSnapshotSupport(master.getConfiguration(), master.getMasterFileSystem());
        Configuration conf = master.getConfiguration();
        long wakeFrequency = conf.getInt(SNAPSHOT_WAKE_MILLIS_KEY, 500);
        long timeoutMillis = Math.max(conf.getLong("hbase.snapshot.master.timeoutMillis", 300000L), conf.getLong("hbase.snapshot.master.timeout.millis", 300000L));
        int opThreads = conf.getInt(SNAPSHOT_POOL_THREADS_KEY, 1);
        String name = master.getServerName().toString();
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool(name, opThreads);
        ZKProcedureCoordinator comms = new ZKProcedureCoordinator(master.getZooKeeper(), ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION, name);
        this.coordinator = new ProcedureCoordinator(comms, tpool, timeoutMillis, wakeFrequency);
        this.executorService = master.getExecutorService();
        this.resetTempDir();
        this.snapshotHandlerChoreCleanerTask = this.scheduleThreadPool.scheduleAtFixedRate(this::cleanupSentinels, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public String getProcedureSignature() {
        return ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION;
    }

    @Override
    public void execProcedure(HBaseProtos.ProcedureDescription desc) throws IOException {
        this.takeSnapshot(this.toSnapshotDescription(desc));
    }

    @Override
    public void checkPermissions(HBaseProtos.ProcedureDescription desc, AccessChecker accessChecker, User user) throws IOException {
    }

    @Override
    public boolean isProcedureDone(HBaseProtos.ProcedureDescription desc) throws IOException {
        return this.isSnapshotDone(this.toSnapshotDescription(desc));
    }

    private SnapshotProtos.SnapshotDescription toSnapshotDescription(HBaseProtos.ProcedureDescription desc) throws IOException {
        SnapshotProtos.SnapshotDescription.Builder builder = SnapshotProtos.SnapshotDescription.newBuilder();
        if (!desc.hasInstance()) {
            throw new IOException("Snapshot name is not defined: " + desc.toString());
        }
        String snapshotName = desc.getInstance();
        List<HBaseProtos.NameStringPair> props = desc.getConfigurationList();
        String table = null;
        for (HBaseProtos.NameStringPair prop : props) {
            if (!"table".equalsIgnoreCase(prop.getName())) continue;
            table = prop.getValue();
        }
        if (table == null) {
            throw new IOException("Snapshot table is not defined: " + desc.toString());
        }
        TableName tableName = TableName.valueOf(table);
        builder.setTable(tableName.getNameAsString());
        builder.setName(snapshotName);
        builder.setType(SnapshotProtos.SnapshotDescription.Type.FLUSH);
        return builder.build();
    }
}

