/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsTableWrapperAggregateImpl
implements MetricsTableWrapperAggregate,
Closeable {
    private final HRegionServer regionServer;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long period;
    private ScheduledFuture<?> tableMetricsUpdateTask;
    private ConcurrentHashMap<TableName, MetricsTableValues> metricsTableMap = new ConcurrentHashMap();

    public MetricsTableWrapperAggregateImpl(HRegionServer regionServer) {
        this.regionServer = regionServer;
        this.period = regionServer.conf.getLong("hbase.regionserver.metrics.period", 5000L) + 1000L;
        this.executor = CompatibilitySingletonFactory.getInstance(MetricsExecutor.class).getExecutor();
        this.runnable = new TableMetricsWrapperRunnable();
        this.tableMetricsUpdateTask = this.executor.scheduleWithFixedDelay(this.runnable, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getReadRequestCount(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.readRequestCount;
    }

    @Override
    public long getFilteredReadRequestCount(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.filteredReadRequestCount;
    }

    @Override
    public long getWriteRequestCount(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.writeRequestCount;
    }

    @Override
    public long getTotalRequestsCount(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.readRequestCount + metricsTable.writeRequestCount;
    }

    @Override
    public long getMemStoreSize(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.memstoreSize;
    }

    @Override
    public long getStoreFileSize(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.storeFileSize;
    }

    @Override
    public long getTableSize(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.memstoreSize + metricsTable.storeFileSize;
    }

    @Override
    public long getNumRegions(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.regionCount;
    }

    @Override
    public long getNumStores(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.storeCount;
    }

    @Override
    public long getNumStoreFiles(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.storeFileCount;
    }

    @Override
    public long getMaxStoreFileAge(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.maxStoreFileAge;
    }

    @Override
    public long getMinStoreFileAge(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.minStoreFileAge == Long.MAX_VALUE ? 0L : metricsTable.minStoreFileAge;
    }

    @Override
    public long getAvgStoreFileAge(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.storeFileCount == 0L ? 0L : metricsTable.totalStoreFileAge / metricsTable.storeFileCount;
    }

    @Override
    public long getNumReferenceFiles(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.referenceFileCount;
    }

    @Override
    public long getAvgRegionSize(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.regionCount == 0L ? 0L : (metricsTable.memstoreSize + metricsTable.storeFileSize) / metricsTable.regionCount;
    }

    public long getCpRequestCount(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf(table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.cpRequestCount;
    }

    @Override
    public void close() throws IOException {
        this.tableMetricsUpdateTask.cancel(true);
    }

    private static class MetricsTableValues {
        long readRequestCount;
        long filteredReadRequestCount;
        long writeRequestCount;
        long memstoreSize;
        long regionCount;
        long storeCount;
        long storeFileCount;
        long storeFileSize;
        long maxStoreFileAge;
        long minStoreFileAge = Long.MAX_VALUE;
        long totalStoreFileAge;
        long referenceFileCount;
        long cpRequestCount;

        private MetricsTableValues() {
        }
    }

    public class TableMetricsWrapperRunnable
    implements Runnable {
        @Override
        public void run() {
            TableName tbl;
            HashMap<TableName, MetricsTableValues> localMetricsTableMap = new HashMap<TableName, MetricsTableValues>();
            for (Region region : MetricsTableWrapperAggregateImpl.this.regionServer.getOnlineRegionsLocalContext()) {
                tbl = region.getTableDescriptor().getTableName();
                MetricsTableValues mt = (MetricsTableValues)localMetricsTableMap.get(tbl);
                if (mt == null) {
                    mt = new MetricsTableValues();
                    localMetricsTableMap.put(tbl, mt);
                }
                if (region.getStores() == null) continue;
                for (Store store : region.getStores()) {
                    mt.storeFileCount += (long)store.getStorefilesCount();
                    mt.memstoreSize += store.getMemStoreSize().getDataSize() + store.getMemStoreSize().getHeapSize() + store.getMemStoreSize().getOffHeapSize();
                    mt.storeFileSize += store.getStorefilesSize();
                    mt.referenceFileCount += store.getNumReferenceFiles();
                    if (store.getMaxStoreFileAge().isPresent()) {
                        mt.maxStoreFileAge = Math.max(mt.maxStoreFileAge, store.getMaxStoreFileAge().getAsLong());
                    }
                    if (store.getMinStoreFileAge().isPresent()) {
                        mt.minStoreFileAge = Math.min(mt.minStoreFileAge, store.getMinStoreFileAge().getAsLong());
                    }
                    if (store.getAvgStoreFileAge().isPresent()) {
                        mt.totalStoreFileAge = (long)store.getAvgStoreFileAge().getAsDouble() * (long)store.getStorefilesCount();
                    }
                    ++mt.storeCount;
                }
                ++mt.regionCount;
                mt.readRequestCount += region.getReadRequestsCount();
                mt.filteredReadRequestCount += MetricsTableWrapperAggregateImpl.this.getFilteredReadRequestCount(tbl.getNameAsString());
                mt.writeRequestCount += region.getWriteRequestsCount();
            }
            for (Map.Entry entry : localMetricsTableMap.entrySet()) {
                tbl = (TableName)entry.getKey();
                if (MetricsTableWrapperAggregateImpl.this.metricsTableMap.get(tbl) == null) {
                    CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).getTableAggregate().getOrCreateTableSource(tbl.getNameAsString(), MetricsTableWrapperAggregateImpl.this);
                }
                MetricsTableWrapperAggregateImpl.this.metricsTableMap.put(entry.getKey(), entry.getValue());
            }
            HashSet<TableName> existingTableNames = Sets.newHashSet(MetricsTableWrapperAggregateImpl.this.metricsTableMap.keySet());
            existingTableNames.removeAll(localMetricsTableMap.keySet());
            MetricsTableAggregateSource metricsTableAggregateSource = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).getTableAggregate();
            for (TableName table : existingTableNames) {
                metricsTableAggregateSource.deleteTableSource(table.getNameAsString());
                if (MetricsTableWrapperAggregateImpl.this.metricsTableMap.get(table) == null) continue;
                MetricsTableWrapperAggregateImpl.this.metricsTableMap.remove(table);
            }
        }
    }
}

