/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.PackagePrivateFieldAccessor;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.FilterWrapper;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.CallerDisconnectedException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcCallback;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushNonSloppyStoresFirstPolicy;
import org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hadoop.hbase.regionserver.FlushPolicyFactory;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionWALFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MetricsRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapperImpl;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.ReversedRegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.RowProcessor;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.Shipper;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.ThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.throttle.CompactionThroughputControllerFactory;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.StoreHotnessProtector;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationObserver;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HashedBytes;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.TableDescriptorChecker;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.ProtocolStringList;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HRegion
implements HeapSize,
PropagatingConfigurationObserver,
Region {
    private static final Logger LOG = LoggerFactory.getLogger(HRegion.class);
    public static final String LOAD_CFS_ON_DEMAND_CONFIG_KEY = "hbase.hregion.scan.loadColumnFamiliesOnDemand";
    public static final String HBASE_MAX_CELL_SIZE_KEY = "hbase.server.keyvalue.maxsize";
    public static final int DEFAULT_MAX_CELL_SIZE = 0xA00000;
    private static final Durability DEFAULT_DURABILITY = Durability.SYNC_WAL;
    public static final String HBASE_REGIONSERVER_MINIBATCH_SIZE = "hbase.regionserver.minibatch.size";
    public static final int DEFAULT_HBASE_REGIONSERVER_MINIBATCH_SIZE = 20000;
    public static final String WAL_HSYNC_CONF_KEY = "hbase.wal.hsync";
    public static final boolean DEFAULT_WAL_HSYNC = false;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean closing = new AtomicBoolean(false);
    private volatile long maxFlushedSeqId = -1L;
    private volatile long lastFlushOpSeqId = -1L;
    protected volatile long lastReplayedOpenRegionSeqId = -1L;
    protected volatile long lastReplayedCompactionSeqId = -1L;
    private final ConcurrentHashMap<HashedBytes, RowLockContext> lockedRows = new ConcurrentHashMap();
    protected final Map<byte[], HStore> stores = new ConcurrentSkipListMap<byte[], HStore>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    private Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    private final MemStoreSizing memStoreSizing = new ThreadSafeMemStoreSizing();
    @VisibleForTesting
    RegionServicesForStores regionServicesForStores;
    final LongAdder numMutationsWithoutWAL = new LongAdder();
    final LongAdder dataInMemoryWithoutWAL = new LongAdder();
    final LongAdder checkAndMutateChecksPassed = new LongAdder();
    final LongAdder checkAndMutateChecksFailed = new LongAdder();
    final LongAdder readRequestsCount = new LongAdder();
    final LongAdder filteredReadRequestsCount = new LongAdder();
    final LongAdder writeRequestsCount = new LongAdder();
    private final LongAdder blockedRequestsCount = new LongAdder();
    final LongAdder compactionsFinished = new LongAdder();
    final LongAdder compactionsFailed = new LongAdder();
    final LongAdder compactionNumFilesCompacted = new LongAdder();
    final LongAdder compactionNumBytesCompacted = new LongAdder();
    final LongAdder compactionsQueued = new LongAdder();
    final LongAdder flushesQueued = new LongAdder();
    private BlockCache blockCache;
    private MobFileCache mobFileCache;
    private final WAL wal;
    private final HRegionFileSystem fs;
    protected final Configuration conf;
    private final Configuration baseConf;
    private final int rowLockWaitDuration;
    static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;
    private Path regionDir;
    private FileSystem walFS;
    private boolean isRestoredRegion = false;
    final long busyWaitDuration;
    static final long DEFAULT_BUSY_WAIT_DURATION = 60000L;
    final int maxBusyWaitMultiplier;
    final long maxBusyWaitDuration;
    final long maxCellSize;
    private final int miniBatchSize;
    static final long DEFAULT_ROW_PROCESSOR_TIMEOUT = 60000L;
    final ExecutorService rowProcessorExecutor = Executors.newCachedThreadPool();
    private final ConcurrentHashMap<RegionScanner, Long> scannerReadPoints;
    private long openSeqNum = -1L;
    private boolean isLoadingCfsOnDemandDefault = false;
    private final AtomicInteger majorInProgress = new AtomicInteger(0);
    private final AtomicInteger minorInProgress = new AtomicInteger(0);
    Map<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private PrepareFlushResult prepareFlushResult = null;
    private volatile ConfigurationManager configurationManager;
    private volatile Long timeoutForWriteLock = null;
    final WriteState writestate = new WriteState();
    long memstoreFlushSize;
    final long timestampSlop;
    final long rowProcessorTimeout;
    private final ConcurrentMap<HStore, Long> lastStoreFlushTimeMap = new ConcurrentHashMap<HStore, Long>();
    final RegionServerServices rsServices;
    private RegionServerAccounting rsAccounting;
    private long flushCheckInterval;
    private long flushPerChanges;
    private long blockingMemStoreSize;
    final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock updatesLock = new ReentrantReadWriteLock();
    private boolean splitRequest;
    private byte[] explicitSplitPoint = null;
    private final MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
    private RegionCoprocessorHost coprocessorHost;
    private TableDescriptor htableDescriptor = null;
    private RegionSplitPolicy splitPolicy;
    private FlushPolicy flushPolicy;
    private final MetricsRegion metricsRegion;
    private final MetricsRegionWrapperImpl metricsRegionWrapper;
    private final Durability regionDurability;
    private final boolean regionStatsEnabled;
    private final NavigableMap<byte[], Integer> replicationScope = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
    private final StoreHotnessProtector storeHotnessProtector;
    private final Object closeLock = new Object();
    public static final String FAIR_REENTRANT_CLOSE_LOCK = "hbase.regionserver.fair.region.close.lock";
    public static final boolean DEFAULT_FAIR_REENTRANT_CLOSE_LOCK = true;
    public static final String MEMSTORE_PERIODIC_FLUSH_INTERVAL = "hbase.regionserver.optionalcacheflushinterval";
    public static final int DEFAULT_CACHE_FLUSH_INTERVAL = 3600000;
    public static final int SYSTEM_CACHE_FLUSH_INTERVAL = 300000;
    public static final String MEMSTORE_FLUSH_PER_CHANGES = "hbase.regionserver.flush.per.changes";
    public static final long DEFAULT_FLUSH_PER_CHANGES = 30000000L;
    public static final long MAX_FLUSH_PER_CHANGES = 1000000000L;
    private static final byte[] FOR_UNIT_TESTS_ONLY = Bytes.toBytes("ForUnitTestsOnly");
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + ClassSize.ARRAY + 55 * ClassSize.REFERENCE + 12 + 112 + 3);
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + (long)(3 * ClassSize.ATOMIC_LONG) + (long)(2 * ClassSize.CONCURRENT_HASHMAP) + WriteState.HEAP_SIZE + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)(2 * ClassSize.REENTRANT_LOCK) + MultiVersionConcurrencyControl.FIXED_SIZE + (long)(2 * ClassSize.TREEMAP) + (long)(2 * ClassSize.ATOMIC_INTEGER) + (long)ClassSize.STORE_SERVICES + StoreHotnessProtector.FIXED_SIZE;
    private static final List<Cell> MOCKED_LIST = new AbstractList<Cell>(){

        @Override
        public void add(int index, Cell element) {
        }

        @Override
        public boolean addAll(int index, Collection<? extends Cell> c) {
            return false;
        }

        @Override
        public KeyValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public void setRestoredRegion(boolean restoredRegion) {
        this.isRestoredRegion = restoredRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSmallestReadPoint() {
        long minimumReadPoint;
        ConcurrentHashMap<RegionScanner, Long> concurrentHashMap = this.scannerReadPoints;
        synchronized (concurrentHashMap) {
            minimumReadPoint = this.mvcc.getReadPoint();
            for (Long readPoint : this.scannerReadPoints.values()) {
                if (readPoint >= minimumReadPoint) continue;
                minimumReadPoint = readPoint;
            }
        }
        return minimumReadPoint;
    }

    @Deprecated
    @VisibleForTesting
    public HRegion(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
        this(new HRegionFileSystem(confParam, fs, tableDir, regionInfo), wal, confParam, htd, rsServices);
    }

    public HRegion(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
        Pair retainedRWRequestsCnt;
        if (htd == null) {
            throw new IllegalArgumentException("Need table descriptor");
        }
        if (confParam instanceof CompoundConfiguration) {
            throw new IllegalArgumentException("Need original base configuration");
        }
        this.wal = wal;
        this.fs = fs;
        this.baseConf = confParam;
        this.conf = new CompoundConfiguration().add(confParam).addBytesMap(htd.getValues());
        this.lock = new ReentrantReadWriteLock(this.conf.getBoolean(FAIR_REENTRANT_CLOSE_LOCK, true));
        this.flushCheckInterval = this.conf.getInt(MEMSTORE_PERIODIC_FLUSH_INTERVAL, 3600000);
        this.flushPerChanges = this.conf.getLong(MEMSTORE_FLUSH_PER_CHANGES, 30000000L);
        if (this.flushPerChanges > 1000000000L) {
            throw new IllegalArgumentException("hbase.regionserver.flush.per.changes can not exceed 1000000000");
        }
        int tmpRowLockDuration = this.conf.getInt("hbase.rowlock.wait.duration", 30000);
        if (tmpRowLockDuration <= 0) {
            LOG.info("Found hbase.rowlock.wait.duration set to {}. values <= 0 will cause all row locking to fail. Treating it as 1ms to avoid region failure.", (Object)tmpRowLockDuration);
            tmpRowLockDuration = 1;
        }
        this.rowLockWaitDuration = tmpRowLockDuration;
        this.isLoadingCfsOnDemandDefault = this.conf.getBoolean(LOAD_CFS_ON_DEMAND_CONFIG_KEY, true);
        this.htableDescriptor = htd;
        Set<byte[]> families = this.htableDescriptor.getColumnFamilyNames();
        for (byte[] family : families) {
            int scope;
            if (this.replicationScope.containsKey(family) || (scope = htd.getColumnFamily(family).getScope()) == 0) continue;
            this.replicationScope.put(Bytes.copy(family), scope);
        }
        this.rsServices = rsServices;
        if (rsServices != null) {
            this.blockCache = rsServices.getBlockCache().orElse(null);
            this.mobFileCache = rsServices.getMobFileCache().orElse(null);
        }
        this.regionServicesForStores = new RegionServicesForStores(this, rsServices);
        this.setHTableSpecificConf();
        this.scannerReadPoints = new ConcurrentHashMap();
        this.busyWaitDuration = this.conf.getLong("hbase.busy.wait.duration", 60000L);
        this.maxBusyWaitMultiplier = this.conf.getInt("hbase.busy.wait.multiplier.max", 2);
        if (this.busyWaitDuration * (long)this.maxBusyWaitMultiplier <= 0L) {
            throw new IllegalArgumentException("Invalid hbase.busy.wait.duration (" + this.busyWaitDuration + ") or hbase.busy.wait.multiplier.max (" + this.maxBusyWaitMultiplier + "). Their product should be positive");
        }
        this.maxBusyWaitDuration = this.conf.getLong("hbase.ipc.client.call.purge.timeout", 120000L);
        this.timestampSlop = this.conf.getLong("hbase.hregion.keyvalue.timestamp.slop.millisecs", Long.MAX_VALUE);
        this.rowProcessorTimeout = this.conf.getLong("hbase.hregion.row.processor.timeout", 60000L);
        this.storeHotnessProtector = new StoreHotnessProtector(this, this.conf);
        boolean forceSync = this.conf.getBoolean(WAL_HSYNC_CONF_KEY, false);
        Durability defaultDurability = forceSync ? Durability.FSYNC_WAL : Durability.SYNC_WAL;
        this.regionDurability = this.htableDescriptor.getDurability() == Durability.USE_DEFAULT ? defaultDurability : this.htableDescriptor.getDurability();
        HRegion.decorateRegionConfiguration(this.conf);
        if (rsServices != null) {
            this.rsAccounting = this.rsServices.getRegionServerAccounting();
            this.coprocessorHost = new RegionCoprocessorHost(this, rsServices, this.conf);
            this.metricsRegionWrapper = new MetricsRegionWrapperImpl(this);
            this.metricsRegion = new MetricsRegion(this.metricsRegionWrapper);
        } else {
            this.metricsRegionWrapper = null;
            this.metricsRegion = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Instantiated " + this + "; " + this.storeHotnessProtector.toString());
        }
        this.configurationManager = null;
        this.regionStatsEnabled = htd.getTableName().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) ? false : this.conf.getBoolean("hbase.client.backpressure.enabled", false);
        this.maxCellSize = this.conf.getLong(HBASE_MAX_CELL_SIZE_KEY, 0xA00000L);
        this.miniBatchSize = this.conf.getInt(HBASE_REGIONSERVER_MINIBATCH_SIZE, 20000);
        if (rsServices != null && rsServices.getRegionServerAccounting() != null && (retainedRWRequestsCnt = (Pair)rsServices.getRegionServerAccounting().getRetainedRegionRWRequestsCnt().get(this.getRegionInfo().getEncodedName())) != null) {
            this.setReadRequestsCount((Long)retainedRWRequestsCnt.getFirst());
            this.setWriteRequestsCount((Long)retainedRWRequestsCnt.getSecond());
            rsServices.getRegionServerAccounting().getRetainedRegionRWRequestsCnt().remove(this.getRegionInfo().getEncodedName());
        }
    }

    void setHTableSpecificConf() {
        if (this.htableDescriptor == null) {
            return;
        }
        long flushSize = this.htableDescriptor.getMemStoreFlushSize();
        if (flushSize <= 0L) {
            flushSize = this.conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
        this.memstoreFlushSize = flushSize;
        long mult = this.conf.getLong("hbase.hregion.memstore.block.multiplier", 4L);
        this.blockingMemStoreSize = this.memstoreFlushSize * mult;
    }

    @Deprecated
    public long initialize() throws IOException {
        return this.initialize(null);
    }

    @VisibleForTesting
    long initialize(CancelableProgressable reporter) throws IOException {
        if (this.htableDescriptor.getColumnFamilyCount() == 0) {
            throw new DoNotRetryIOException("Table " + this.htableDescriptor.getTableName().getNameAsString() + " should have at least one column family.");
        }
        MonitoredTask status = TaskMonitor.get().createStatus("Initializing region " + this);
        status.enableStatusJournal(true);
        long nextSeqId = -1L;
        try {
            long l = nextSeqId = this.initializeRegionInternals(reporter, status);
            return l;
        }
        catch (IOException e) {
            block10: {
                LOG.warn("Failed initialize of region= {}, starting to roll back memstore", (Object)this.getRegionInfo().getRegionNameAsString(), (Object)e);
                try {
                    this.dropMemStoreContents();
                }
                catch (IOException ioE) {
                    if (!this.conf.getBoolean("hbase.hregion.memstore.mslab.enabled", true)) break block10;
                    LOG.warn("Failed drop memstore of region= {}, some chunks may not released forever since MSLAB is enabled", (Object)this.getRegionInfo().getRegionNameAsString());
                }
            }
            throw e;
        }
        finally {
            if (nextSeqId == -1L) {
                status.abort("Exception during region " + this.getRegionInfo().getRegionNameAsString() + " initialization.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Region open journal:\n" + status.prettyPrintJournal());
            }
            status.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long initializeRegionInternals(CancelableProgressable reporter, MonitoredTask status) throws IOException {
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-open hook");
            this.coprocessorHost.preOpen();
        }
        if (this.getRegionInfo().getReplicaId() == 0) {
            status.setStatus("Writing region info on filesystem");
            this.fs.checkRegionInfoOnFilesystem();
        }
        status.setStatus("Initializing all the Stores");
        long maxSeqId = this.initializeStores(reporter, status);
        this.mvcc.advanceTo(maxSeqId);
        if (!this.isRestoredRegion && ServerRegionReplicaUtil.shouldReplayRecoveredEdits(this)) {
            Collection<HStore> stores = this.stores.values();
            try {
                stores.forEach(HStore::startReplayingFromWAL);
                maxSeqId = Math.max(maxSeqId, this.replayRecoveredEditsIfAny(this.maxSeqIdInStores, reporter, status));
                this.mvcc.advanceTo(maxSeqId);
            }
            finally {
                stores.forEach(HStore::stopReplayingFromWAL);
            }
        }
        this.lastReplayedOpenRegionSeqId = maxSeqId;
        this.writestate.setReadOnly(ServerRegionReplicaUtil.isReadOnly(this));
        this.writestate.flushRequested = false;
        this.writestate.compacting.set(0);
        if (this.writestate.writesEnabled) {
            status.setStatus("Cleaning up temporary data from old regions");
            this.fs.cleanupTempDir();
        }
        if (this.writestate.writesEnabled) {
            status.setStatus("Cleaning up detritus from prior splits");
            this.fs.cleanupAnySplitDetritus();
            this.fs.cleanupMergesDir();
        }
        this.splitPolicy = RegionSplitPolicy.create(this, this.conf);
        this.flushPolicy = FlushPolicyFactory.create(this, this.conf);
        long lastFlushTime = EnvironmentEdgeManager.currentTime();
        for (HStore store : this.stores.values()) {
            this.lastStoreFlushTimeMap.put(store, lastFlushTime);
        }
        long nextSeqId = maxSeqId + 1L;
        if (!this.isRestoredRegion) {
            long maxSeqIdFromFile = WALSplitUtil.getMaxRegionSequenceId(this.conf, RegionReplicaUtil.getRegionInfoForDefaultReplica(this.getRegionInfo()), this::getFilesystem, this::getWalFileSystem);
            nextSeqId = Math.max(maxSeqId, maxSeqIdFromFile) + 1L;
            if (RegionReplicaUtil.isDefaultReplica(this.getRegionInfo())) {
                LOG.debug("writing seq id for {}", (Object)this.getRegionInfo().getEncodedName());
                WALSplitUtil.writeRegionSequenceIdFile(this.getWalFileSystem(), this.getWALRegionDir(), nextSeqId - 1L);
                Path wrongRegionWALDir = FSUtils.getWrongWALRegionDir(this.conf, this.getRegionInfo().getTable(), this.getRegionInfo().getEncodedName());
                FileSystem walFs = this.getWalFileSystem();
                if (walFs.exists(wrongRegionWALDir) && !walFs.delete(wrongRegionWALDir, true)) {
                    LOG.debug("Failed to clean up wrong region WAL directory {}", (Object)wrongRegionWALDir);
                }
            }
        }
        LOG.info("Opened {}; next sequenceid={}", (Object)this.getRegionInfo().getShortNameToLog(), (Object)nextSeqId);
        this.closing.set(false);
        this.closed.set(false);
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor post-open hooks");
            this.coprocessorHost.postOpen();
        }
        status.markComplete("Region opened successfully");
        return nextSeqId;
    }

    private long initializeStores(CancelableProgressable reporter, MonitoredTask status) throws IOException {
        return this.initializeStores(reporter, status, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long initializeStores(CancelableProgressable reporter, MonitoredTask status, final boolean warmup) throws IOException {
        long maxSeqId = -1L;
        long maxMemstoreTS = -1L;
        if (this.htableDescriptor.getColumnFamilyCount() != 0) {
            ThreadPoolExecutor storeOpenerThreadPool = this.getStoreOpenAndCloseThreadPool("StoreOpener-" + this.getRegionInfo().getShortNameToLog());
            ExecutorCompletionService<HStore> completionService = new ExecutorCompletionService<HStore>(storeOpenerThreadPool);
            for (final ColumnFamilyDescriptor family : this.htableDescriptor.getColumnFamilies()) {
                status.setStatus("Instantiating store for column family " + family);
                completionService.submit(new Callable<HStore>(){

                    @Override
                    public HStore call() throws IOException {
                        return HRegion.this.instantiateHStore(family, warmup);
                    }
                });
            }
            boolean allStoresOpened = false;
            boolean hasSloppyStores = false;
            try {
                for (int i = 0; i < this.htableDescriptor.getColumnFamilyCount(); ++i) {
                    long maxStoreMemstoreTS;
                    Future future = completionService.take();
                    HStore store = (HStore)future.get();
                    this.stores.put(store.getColumnFamilyDescriptor().getName(), store);
                    if (store.isSloppyMemStore()) {
                        hasSloppyStores = true;
                    }
                    long storeMaxSequenceId = store.getMaxSequenceId().orElse(0L);
                    this.maxSeqIdInStores.put(Bytes.toBytes(store.getColumnFamilyName()), storeMaxSequenceId);
                    if (maxSeqId == -1L || storeMaxSequenceId > maxSeqId) {
                        maxSeqId = storeMaxSequenceId;
                    }
                    if ((maxStoreMemstoreTS = store.getMaxMemStoreTS().orElse(0L)) <= maxMemstoreTS) continue;
                    maxMemstoreTS = maxStoreMemstoreTS;
                }
                allStoresOpened = true;
                if (hasSloppyStores) {
                    this.htableDescriptor = TableDescriptorBuilder.newBuilder(this.htableDescriptor).setFlushPolicyClassName(FlushNonSloppyStoresFirstPolicy.class.getName()).build();
                    LOG.info("Setting FlushNonSloppyStoresFirstPolicy for the region=" + this);
                }
                storeOpenerThreadPool.shutdownNow();
            }
            catch (InterruptedException e) {
                try {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    catch (ExecutionException e2) {
                        throw new IOException(e2.getCause());
                    }
                }
                catch (Throwable throwable) {
                    storeOpenerThreadPool.shutdownNow();
                    if (!allStoresOpened) {
                        LOG.error("Could not initialize all stores for the region=" + this);
                        for (HStore store : this.stores.values()) {
                            try {
                                store.close();
                            }
                            catch (IOException e3) {
                                LOG.warn("close store {} failed in region {}", new Object[]{store.toString(), this, e3});
                            }
                        }
                    }
                    throw throwable;
                }
            }
            if (!allStoresOpened) {
                LOG.error("Could not initialize all stores for the region=" + this);
                for (HStore store : this.stores.values()) {
                    try {
                        store.close();
                    }
                    catch (IOException e) {
                        LOG.warn("close store {} failed in region {}", new Object[]{store.toString(), this, e});
                    }
                }
            }
        }
        return Math.max(maxSeqId, maxMemstoreTS + 1L);
    }

    private void initializeWarmup(CancelableProgressable reporter) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Initializing region " + this);
        status.setStatus("Warming up all the Stores");
        try {
            this.initializeStores(reporter, status, true);
        }
        finally {
            status.markComplete("Done warming up.");
        }
    }

    private NavigableMap<byte[], List<Path>> getStoreFiles() {
        TreeMap<byte[], List<Path>> allStoreFiles = new TreeMap<byte[], List<Path>>(Bytes.BYTES_COMPARATOR);
        for (HStore store : this.stores.values()) {
            Collection<HStoreFile> storeFiles = store.getStorefiles();
            if (storeFiles == null) continue;
            ArrayList<Path> storeFileNames = new ArrayList<Path>();
            for (HStoreFile storeFile : storeFiles) {
                storeFileNames.add(storeFile.getPath());
            }
            allStoreFiles.put(store.getColumnFamilyDescriptor().getName(), storeFileNames);
        }
        return allStoreFiles;
    }

    @VisibleForTesting
    protected void writeRegionOpenMarker(WAL wal, long openSeqId) throws IOException {
        NavigableMap<byte[], List<Path>> storeFiles = this.getStoreFiles();
        WALProtos.RegionEventDescriptor regionOpenDesc = ProtobufUtil.toRegionEventDescriptor(WALProtos.RegionEventDescriptor.EventType.REGION_OPEN, this.getRegionInfo(), openSeqId, this.getRegionServerServices().getServerName(), storeFiles);
        WALUtil.writeRegionEventMarker(wal, this.getReplicationScope(), this.getRegionInfo(), regionOpenDesc, this.mvcc);
    }

    private void writeRegionCloseMarker(WAL wal) throws IOException {
        NavigableMap<byte[], List<Path>> storeFiles = this.getStoreFiles();
        WALProtos.RegionEventDescriptor regionEventDesc = ProtobufUtil.toRegionEventDescriptor(WALProtos.RegionEventDescriptor.EventType.REGION_CLOSE, this.getRegionInfo(), this.mvcc.getReadPoint(), this.getRegionServerServices().getServerName(), storeFiles);
        WALUtil.writeRegionEventMarker(wal, this.getReplicationScope(), this.getRegionInfo(), regionEventDesc, this.mvcc);
        if (this.getWalFileSystem().exists(this.getWALRegionDir())) {
            WALSplitUtil.writeRegionSequenceIdFile(this.getWalFileSystem(), this.getWALRegionDir(), this.mvcc.getReadPoint());
        }
    }

    public boolean hasReferences() {
        return this.stores.values().stream().anyMatch(HStore::hasReferences);
    }

    public void blockUpdates() {
        this.updatesLock.writeLock().lock();
    }

    public void unblockUpdates() {
        this.updatesLock.writeLock().unlock();
    }

    public HDFSBlocksDistribution getHDFSBlocksDistribution() {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        this.stores.values().stream().filter(s -> s.getStorefiles() != null).flatMap(s -> s.getStorefiles().stream()).map(HStoreFile::getHDFSBlockDistribution).forEachOrdered(hdfsBlocksDistribution::add);
        return hdfsBlocksDistribution;
    }

    public static HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, TableDescriptor tableDescriptor, RegionInfo regionInfo) throws IOException {
        Path tablePath = FSUtils.getTableDir(FSUtils.getRootDir(conf), tableDescriptor.getTableName());
        return HRegion.computeHDFSBlocksDistribution(conf, tableDescriptor, regionInfo, tablePath);
    }

    public static HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, TableDescriptor tableDescriptor, RegionInfo regionInfo, Path tablePath) throws IOException {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        FileSystem fs = tablePath.getFileSystem(conf);
        HRegionFileSystem regionFs = new HRegionFileSystem(conf, fs, tablePath, regionInfo);
        for (ColumnFamilyDescriptor family : tableDescriptor.getColumnFamilies()) {
            List<LocatedFileStatus> locatedFileStatusList = HRegionFileSystem.getStoreFilesLocatedStatus(regionFs, family.getNameAsString(), true);
            if (locatedFileStatusList == null) continue;
            for (LocatedFileStatus status : locatedFileStatusList) {
                Path p = status.getPath();
                if (StoreFileInfo.isReference(p) || HFileLink.isHFileLink(p)) {
                    StoreFileInfo storeFileInfo = new StoreFileInfo(conf, fs, (FileStatus)status);
                    hdfsBlocksDistribution.add(storeFileInfo.computeHDFSBlocksDistribution(fs));
                    continue;
                }
                if (StoreFileInfo.isHFile(p)) {
                    FSUtils.addToHDFSBlocksDistribution(hdfsBlocksDistribution, status.getBlockLocations());
                    continue;
                }
                throw new IOException("path=" + p + " doesn't look like a valid StoreFile");
            }
        }
        return hdfsBlocksDistribution;
    }

    void incMemStoreSize(MemStoreSize mss) {
        this.incMemStoreSize(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
    }

    void incMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta, int cellsCountDelta) {
        if (this.rsAccounting != null) {
            this.rsAccounting.incGlobalMemStoreSize(dataSizeDelta, heapSizeDelta, offHeapSizeDelta);
        }
        long dataSize = this.memStoreSizing.incMemStoreSize(dataSizeDelta, heapSizeDelta, offHeapSizeDelta, cellsCountDelta);
        this.checkNegativeMemStoreDataSize(dataSize, dataSizeDelta);
    }

    void decrMemStoreSize(MemStoreSize mss) {
        this.decrMemStoreSize(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
    }

    void decrMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta, int cellsCountDelta) {
        if (this.rsAccounting != null) {
            this.rsAccounting.decGlobalMemStoreSize(dataSizeDelta, heapSizeDelta, offHeapSizeDelta);
        }
        long dataSize = this.memStoreSizing.decMemStoreSize(dataSizeDelta, heapSizeDelta, offHeapSizeDelta, cellsCountDelta);
        this.checkNegativeMemStoreDataSize(dataSize, -dataSizeDelta);
    }

    private void checkNegativeMemStoreDataSize(long memStoreDataSize, long delta) {
        if (memStoreDataSize < 0L) {
            LOG.error("Asked to modify this region's (" + this.toString() + ") memStoreSizing to a negative value which is incorrect. Current memStoreSizing=" + (memStoreDataSize - delta) + ", delta=" + delta, (Throwable)new Exception());
        }
    }

    @Override
    public RegionInfo getRegionInfo() {
        return this.fs.getRegionInfo();
    }

    RegionServerServices getRegionServerServices() {
        return this.rsServices;
    }

    @Override
    public long getReadRequestsCount() {
        return this.readRequestsCount.sum();
    }

    @Override
    public long getFilteredReadRequestsCount() {
        return this.filteredReadRequestsCount.sum();
    }

    @Override
    public long getWriteRequestsCount() {
        return this.writeRequestsCount.sum();
    }

    @Override
    public long getMemStoreDataSize() {
        return this.memStoreSizing.getDataSize();
    }

    @Override
    public long getMemStoreHeapSize() {
        return this.memStoreSizing.getHeapSize();
    }

    @Override
    public long getMemStoreOffHeapSize() {
        return this.memStoreSizing.getOffHeapSize();
    }

    public RegionServicesForStores getRegionServicesForStores() {
        return this.regionServicesForStores;
    }

    @Override
    public long getNumMutationsWithoutWAL() {
        return this.numMutationsWithoutWAL.sum();
    }

    @Override
    public long getDataInMemoryWithoutWAL() {
        return this.dataInMemoryWithoutWAL.sum();
    }

    @Override
    public long getBlockedRequestsCount() {
        return this.blockedRequestsCount.sum();
    }

    @Override
    public long getCheckAndMutateChecksPassed() {
        return this.checkAndMutateChecksPassed.sum();
    }

    @Override
    public long getCheckAndMutateChecksFailed() {
        return this.checkAndMutateChecksFailed.sum();
    }

    public MetricsRegion getMetrics() {
        return this.metricsRegion;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public boolean isClosing() {
        return this.closing.get();
    }

    @Override
    public boolean isReadOnly() {
        return this.writestate.isReadOnly();
    }

    @Override
    public boolean isAvailable() {
        return !this.isClosed() && !this.isClosing();
    }

    @Override
    public boolean isSplittable() {
        return this.isAvailable() && !this.hasReferences();
    }

    @Override
    public boolean isMergeable() {
        if (!this.isAvailable()) {
            LOG.debug("Region " + this + " is not mergeable because it is closing or closed");
            return false;
        }
        if (this.hasReferences()) {
            LOG.debug("Region " + this + " is not mergeable because it has references");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areWritesEnabled() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            return this.writestate.writesEnabled;
        }
    }

    @VisibleForTesting
    public MultiVersionConcurrencyControl getMVCC() {
        return this.mvcc;
    }

    @Override
    public long getMaxFlushedSeqId() {
        return this.maxFlushedSeqId;
    }

    public long getReadPoint(IsolationLevel isolationLevel) {
        if (isolationLevel != null && isolationLevel == IsolationLevel.READ_UNCOMMITTED) {
            return Long.MAX_VALUE;
        }
        return this.mvcc.getReadPoint();
    }

    public boolean isLoadingCfsOnDemandDefault() {
        return this.isLoadingCfsOnDemandDefault;
    }

    public Map<byte[], List<HStoreFile>> close() throws IOException {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], List<HStoreFile>> close(boolean abort) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Closing region " + this.getRegionInfo().getEncodedName() + (abort ? " due to abort" : ""));
        status.enableStatusJournal(true);
        status.setStatus("Waiting for close lock");
        try {
            Object object = this.closeLock;
            synchronized (object) {
                Map<byte[], List<HStoreFile>> map = this.doClose(abort, status);
                return map;
            }
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Region close journal:\n" + status.prettyPrintJournal());
            }
            status.cleanup();
        }
    }

    @VisibleForTesting
    public void setClosing(boolean closing) {
        this.closing.set(closing);
    }

    @VisibleForTesting
    public void setTimeoutForWriteLock(long timeoutForWriteLock) {
        assert (timeoutForWriteLock >= 0L);
        this.timeoutForWriteLock = timeoutForWriteLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="I think FindBugs is confused")
    private Map<byte[], List<HStoreFile>> doClose(boolean abort, MonitoredTask status) throws IOException {
        if (this.isClosed()) {
            LOG.warn("Region " + this + " already closed");
            return null;
        }
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-close hooks");
            this.coprocessorHost.preClose(abort);
        }
        status.setStatus("Disabling compacts and flushes for region");
        boolean canFlush = true;
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            canFlush = !this.writestate.readOnly;
            this.writestate.writesEnabled = false;
            LOG.debug("Closing {}, disabling compactions & flushes", (Object)this.getRegionInfo().getEncodedName());
            this.waitForFlushesAndCompactions();
        }
        if (!abort && this.worthPreFlushing() && canFlush) {
            status.setStatus("Pre-flushing region before close");
            LOG.info("Running close preflush of {}", (Object)this.getRegionInfo().getEncodedName());
            try {
                this.internalFlushcache(status);
            }
            catch (IOException ioe) {
                status.setStatus("Failed pre-flush " + this + "; " + ioe.getMessage());
            }
        }
        if (this.timeoutForWriteLock == null || this.timeoutForWriteLock == Long.MAX_VALUE) {
            this.lock.writeLock().lock();
        } else {
            try {
                boolean succeed = this.lock.writeLock().tryLock(this.timeoutForWriteLock, TimeUnit.SECONDS);
                if (!succeed) {
                    throw new IOException("Failed to get write lock when closing region");
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
        this.closing.set(true);
        status.setStatus("Disabling writes for close");
        try {
            if (this.isClosed()) {
                status.abort("Already got closed by another process");
                Map<byte[], List<HStoreFile>> e = null;
                return e;
            }
            LOG.debug("Updates disabled for region " + this);
            if (!abort && canFlush) {
                int failedfFlushCount = 0;
                int flushCount = 0;
                long tmp = 0L;
                long remainingSize = this.memStoreSizing.getDataSize();
                while (remainingSize > 0L) {
                    try {
                        this.internalFlushcache(status);
                        if (flushCount > 0) {
                            LOG.info("Running extra flush, " + flushCount + " (carrying snapshot?) " + this);
                        }
                        ++flushCount;
                        tmp = this.memStoreSizing.getDataSize();
                        if (tmp >= remainingSize) {
                            ++failedfFlushCount;
                        }
                        remainingSize = tmp;
                        if (failedfFlushCount <= 5) continue;
                        throw new DroppedSnapshotException("Failed clearing memory after " + flushCount + " attempts on region: " + Bytes.toStringBinary(this.getRegionInfo().getRegionName()));
                    }
                    catch (IOException ioe) {
                        status.setStatus("Failed flush " + this + ", putting online again");
                        WriteState writeState2 = this.writestate;
                        synchronized (writeState2) {
                            this.writestate.writesEnabled = true;
                        }
                        throw ioe;
                    }
                }
            }
            TreeMap<byte[], List<HStoreFile>> result = new TreeMap<byte[], List<HStoreFile>>(Bytes.BYTES_COMPARATOR);
            if (!this.stores.isEmpty()) {
                ThreadPoolExecutor storeCloserThreadPool = this.getStoreOpenAndCloseThreadPool("StoreCloser-" + this.getRegionInfo().getRegionNameAsString());
                ExecutorCompletionService<Pair<byte[], Collection<HStoreFile>>> completionService = new ExecutorCompletionService<Pair<byte[], Collection<HStoreFile>>>(storeCloserThreadPool);
                for (final HStore store : this.stores.values()) {
                    MemStoreSize mss = store.getFlushableSize();
                    if (!abort && mss.getDataSize() != 0L && !this.writestate.readOnly && this.getRegionServerServices() != null) {
                        this.getRegionServerServices().abort("Assertion failed while closing store " + this.getRegionInfo().getRegionNameAsString() + " " + store + ". flushableSize expected=0, actual={" + mss + "}. Current memStoreSize=" + this.memStoreSizing.getMemStoreSize() + ". Maybe a coprocessor operation failed and left the memstore in a partially updated state.", null);
                    }
                    completionService.submit(new Callable<Pair<byte[], Collection<HStoreFile>>>(){

                        @Override
                        public Pair<byte[], Collection<HStoreFile>> call() throws IOException {
                            return new Pair<byte[], Collection<HStoreFile>>(store.getColumnFamilyDescriptor().getName(), store.close());
                        }
                    });
                }
                try {
                    for (int i = 0; i < this.stores.size(); ++i) {
                        Future future = completionService.take();
                        Pair storeFiles = (Pair)future.get();
                        ArrayList familyFiles = (ArrayList)result.get(storeFiles.getFirst());
                        if (familyFiles == null) {
                            familyFiles = new ArrayList();
                            result.put((byte[])storeFiles.getFirst(), familyFiles);
                        }
                        familyFiles.addAll((Collection)storeFiles.getSecond());
                    }
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new IOException(cause);
                }
                finally {
                    storeCloserThreadPool.shutdownNow();
                }
            }
            status.setStatus("Writing region close event to WAL");
            if (!abort && this.wal != null && this.getRegionServerServices() != null && RegionReplicaUtil.isDefaultReplica(this.getRegionInfo())) {
                this.writeRegionCloseMarker(this.wal);
            }
            this.closed.set(true);
            if (!canFlush) {
                this.decrMemStoreSize(this.memStoreSizing.getMemStoreSize());
            } else if (this.memStoreSizing.getDataSize() != 0L) {
                LOG.error("Memstore data size is {} in region {}", (Object)this.memStoreSizing.getDataSize(), (Object)this);
            }
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor post-close hooks");
                this.coprocessorHost.postClose(abort);
            }
            if (this.metricsRegion != null) {
                this.metricsRegion.close();
            }
            if (this.metricsRegionWrapper != null) {
                Closeables.close(this.metricsRegionWrapper, true);
            }
            status.markComplete("Closed");
            LOG.info("Closed " + this);
            TreeMap<byte[], List<HStoreFile>> treeMap = result;
            return treeMap;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFlushesAndCompactions() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.readOnly) {
                return;
            }
            boolean interrupted = false;
            try {
                while (this.writestate.compacting.get() > 0 || this.writestate.flushing) {
                    LOG.debug("waiting for " + this.writestate.compacting + " compactions" + (this.writestate.flushing ? " & cache flush" : "") + " to complete for region " + this);
                    try {
                        this.writestate.wait();
                    }
                    catch (InterruptedException iex) {
                        LOG.warn("Interrupted while waiting in region {}", (Object)this);
                        interrupted = true;
                        break;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void waitForFlushes() {
        this.waitForFlushes(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForFlushes(long timeout) {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.readOnly) {
                return true;
            }
            if (!this.writestate.flushing) {
                return true;
            }
            long start = System.currentTimeMillis();
            long duration = 0L;
            boolean interrupted = false;
            LOG.debug("waiting for cache flush to complete for region " + this);
            try {
                while (this.writestate.flushing) {
                    if (timeout > 0L && duration >= timeout) {
                        break;
                    }
                    try {
                        long toWait = timeout == 0L ? 0L : timeout - duration;
                        this.writestate.wait(toWait);
                    }
                    catch (InterruptedException iex) {
                        LOG.warn("Interrupted while waiting in region {}", (Object)this);
                        interrupted = true;
                        break;
                    }
                    finally {
                        duration = System.currentTimeMillis() - start;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            LOG.debug("Waited {} ms for region {} flush to complete", (Object)duration, (Object)this);
            return !this.writestate.flushing;
        }
    }

    protected ThreadPoolExecutor getStoreOpenAndCloseThreadPool(String threadNamePrefix) {
        int numStores = Math.max(1, this.htableDescriptor.getColumnFamilyCount());
        int maxThreads = Math.min(numStores, this.conf.getInt("hbase.hstore.open.and.close.threads.max", 1));
        return HRegion.getOpenAndCloseThreadPool(maxThreads, threadNamePrefix);
    }

    protected ThreadPoolExecutor getStoreFileOpenAndCloseThreadPool(String threadNamePrefix) {
        int numStores = Math.max(1, this.htableDescriptor.getColumnFamilyCount());
        int maxThreads = Math.max(1, this.conf.getInt("hbase.hstore.open.and.close.threads.max", 1) / numStores);
        return HRegion.getOpenAndCloseThreadPool(maxThreads, threadNamePrefix);
    }

    static ThreadPoolExecutor getOpenAndCloseThreadPool(int maxThreads, final String threadNamePrefix) {
        return Threads.getBoundedCachedThreadPool(maxThreads, 30L, TimeUnit.SECONDS, new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadNamePrefix + "-" + this.count++);
            }
        });
    }

    private boolean worthPreFlushing() {
        return this.memStoreSizing.getDataSize() > this.conf.getLong("hbase.hregion.preclose.flush.size", 0x500000L);
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.htableDescriptor;
    }

    @VisibleForTesting
    void setTableDescriptor(TableDescriptor desc) {
        this.htableDescriptor = desc;
    }

    public WAL getWAL() {
        return this.wal;
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    @VisibleForTesting
    public void setBlockCache(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    public MobFileCache getMobFileCache() {
        return this.mobFileCache;
    }

    @VisibleForTesting
    public void setMobFileCache(MobFileCache mobFileCache) {
        this.mobFileCache = mobFileCache;
    }

    public RegionSplitPolicy getSplitPolicy() {
        return this.splitPolicy;
    }

    Configuration getBaseConf() {
        return this.baseConf;
    }

    public FileSystem getFilesystem() {
        return this.fs.getFileSystem();
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.fs;
    }

    HRegionWALFileSystem getRegionWALFileSystem() throws IOException {
        return new HRegionWALFileSystem(this.conf, this.getWalFileSystem(), FSUtils.getWALTableDir(this.conf, this.htableDescriptor.getTableName()), this.fs.getRegionInfo());
    }

    FileSystem getWalFileSystem() throws IOException {
        if (this.walFS == null) {
            this.walFS = FSUtils.getWALFileSystem(this.conf);
        }
        return this.walFS;
    }

    @VisibleForTesting
    public Path getWALRegionDir() throws IOException {
        if (this.regionDir == null) {
            this.regionDir = FSUtils.getWALRegionDir(this.conf, this.getRegionInfo().getTable(), this.getRegionInfo().getEncodedName());
        }
        return this.regionDir;
    }

    @Override
    public long getEarliestFlushTimeForAllStores() {
        return (Long)Collections.min(this.lastStoreFlushTimeMap.values());
    }

    @Override
    public long getOldestHfileTs(boolean majorCompactionOnly) throws IOException {
        long result = Long.MAX_VALUE;
        for (HStore store : this.stores.values()) {
            Collection<HStoreFile> storeFiles = store.getStorefiles();
            if (storeFiles == null) continue;
            for (HStoreFile file : storeFiles) {
                byte[] val;
                HFile.Reader reader;
                StoreFileReader sfReader = file.getReader();
                if (sfReader == null || (reader = sfReader.getHFileReader()) == null || majorCompactionOnly && ((val = reader.loadFileInfo().get(HStoreFile.MAJOR_COMPACTION_KEY)) == null || !Bytes.toBoolean(val))) continue;
                result = Math.min(result, reader.getFileContext().getFileCreateTime());
            }
        }
        return result == Long.MAX_VALUE ? 0L : result;
    }

    ClusterStatusProtos.RegionLoad.Builder setCompleteSequenceId(ClusterStatusProtos.RegionLoad.Builder regionLoadBldr) {
        long lastFlushOpSeqIdLocal = this.lastFlushOpSeqId;
        byte[] encodedRegionName = this.getRegionInfo().getEncodedNameAsBytes();
        regionLoadBldr.clearStoreCompleteSequenceId();
        for (byte[] familyName : this.stores.keySet()) {
            long earliest = this.wal.getEarliestMemStoreSeqNum(encodedRegionName, familyName);
            long csid = earliest == -1L ? lastFlushOpSeqIdLocal : earliest - 1L;
            regionLoadBldr.addStoreCompleteSequenceId(ClusterStatusProtos.StoreSequenceId.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap(familyName)).setSequenceId(csid).build());
        }
        return regionLoadBldr.setCompleteSequenceId(this.getMaxFlushedSeqId());
    }

    protected void doRegionCompactionPrep() throws IOException {
    }

    public void compact(boolean majorCompaction) throws IOException {
        if (majorCompaction) {
            this.stores.values().forEach(HStore::triggerMajorCompaction);
        }
        for (HStore s : this.stores.values()) {
            Optional<CompactionContext> compaction = s.requestCompaction();
            if (!compaction.isPresent()) continue;
            ThroughputController controller = null;
            if (this.rsServices != null) {
                controller = CompactionThroughputControllerFactory.create(this.rsServices, this.conf);
            }
            if (controller == null) {
                controller = NoLimitThroughputController.INSTANCE;
            }
            this.compact(compaction.get(), s, controller, null);
        }
    }

    @VisibleForTesting
    public void compactStores() throws IOException {
        for (HStore s : this.stores.values()) {
            Optional<CompactionContext> compaction = s.requestCompaction();
            if (!compaction.isPresent()) continue;
            this.compact(compaction.get(), s, NoLimitThroughputController.INSTANCE, null);
        }
    }

    @VisibleForTesting
    void compactStore(byte[] family, ThroughputController throughputController) throws IOException {
        HStore s = this.getStore(family);
        Optional<CompactionContext> compaction = s.requestCompaction();
        if (compaction.isPresent()) {
            this.compact(compaction.get(), s, throughputController, null);
        }
    }

    public boolean compact(CompactionContext compaction, HStore store, ThroughputController throughputController) throws IOException {
        return this.compact(compaction, store, throughputController, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compact(CompactionContext compaction, HStore store, ThroughputController throughputController, User user) throws IOException {
        if (!$assertionsDisabled) {
            if (compaction == null) throw new AssertionError();
            if (!compaction.hasSelection()) {
                throw new AssertionError();
            }
        }
        assert (!compaction.getRequest().getFiles().isEmpty());
        if (this.closing.get() || this.closed.get()) {
            LOG.debug("Skipping compaction on " + this + " because closing/closed");
            store.cancelRequestedCompaction(compaction);
            return false;
        }
        MonitoredTask status = null;
        boolean requestNeedsCancellation = true;
        try {
            byte[] cf = Bytes.toBytes(store.getColumnFamilyName());
            if (this.stores.get(cf) != store) {
                LOG.warn("Store " + store.getColumnFamilyName() + " on region " + this + " has been re-instantiated, cancel this compaction request.  It may be caused by the roll back of split transaction");
                boolean bl = false;
                return bl;
            }
            status = TaskMonitor.get().createStatus("Compacting " + store + " in " + this);
            status.enableStatusJournal(false);
            if (this.closed.get()) {
                String msg = "Skipping compaction on " + this + " because closed";
                LOG.debug(msg);
                status.abort(msg);
                boolean bl = false;
                return bl;
            }
            boolean wasStateSet = false;
            try {
                WriteState writeState = this.writestate;
                synchronized (writeState) {
                    if (!this.writestate.writesEnabled) {
                        String msg = "NOT compacting region " + this + ". Writes disabled.";
                        LOG.info(msg);
                        status.abort(msg);
                        boolean bl = false;
                        return bl;
                    }
                    wasStateSet = true;
                    this.writestate.compacting.incrementAndGet();
                }
                LOG.info("Starting compaction of {} in {}{}", new Object[]{store, this, compaction.getRequest().isOffPeak() ? " as an off-peak compaction" : ""});
                this.doRegionCompactionPrep();
                try {
                    status.setStatus("Compacting store " + store);
                    requestNeedsCancellation = false;
                    store.compact(compaction, throughputController, user);
                }
                catch (InterruptedIOException iioe) {
                    String msg = "region " + this + " compaction interrupted";
                    LOG.info(msg, (Throwable)iioe);
                    status.abort(msg);
                    boolean bl = false;
                    if (wasStateSet) {
                        WriteState writeState2 = this.writestate;
                        synchronized (writeState2) {
                            this.writestate.compacting.decrementAndGet();
                            if (this.writestate.compacting.get() <= 0) {
                                this.writestate.notifyAll();
                            }
                        }
                    }
                    if (requestNeedsCancellation) {
                        store.cancelRequestedCompaction(compaction);
                    }
                    if (status == null) return bl;
                    LOG.debug("Compaction status journal:\n\t" + status.prettyPrintJournal());
                    status.cleanup();
                    return bl;
                }
            }
            finally {
                if (wasStateSet) {
                    WriteState writeState = this.writestate;
                    synchronized (writeState) {
                        this.writestate.compacting.decrementAndGet();
                        if (this.writestate.compacting.get() <= 0) {
                            this.writestate.notifyAll();
                        }
                    }
                }
            }
            status.markComplete("Compaction complete");
            boolean bl = true;
            return bl;
        }
        finally {
            if (requestNeedsCancellation) {
                store.cancelRequestedCompaction(compaction);
            }
            if (status != null) {
                LOG.debug("Compaction status journal:\n\t" + status.prettyPrintJournal());
                status.cleanup();
            }
        }
    }

    public FlushResult flush(boolean force) throws IOException {
        return this.flushcache(force, false, FlushLifeCycleTracker.DUMMY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public FlushResultImpl flushcache(boolean forceFlushAllStores, boolean writeFlushRequestWalMarker, FlushLifeCycleTracker tracker) throws IOException {
        if (this.closing.get()) {
            msg = "Skipping flush on " + this + " because closing";
            HRegion.LOG.debug(msg);
            return new FlushResultImpl(FlushResult.Result.CANNOT_FLUSH, msg, false);
        }
        status = TaskMonitor.get().createStatus("Flushing " + this);
        status.enableStatusJournal(false);
        status.setStatus("Acquiring readlock on region");
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                msg = "Skipping flush on " + this + " because closed";
                HRegion.LOG.debug(msg);
                status.abort(msg);
                var6_8 = new FlushResultImpl(FlushResult.Result.CANNOT_FLUSH, msg, false);
                return var6_8;
            }
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor pre-flush hooks");
                this.coprocessorHost.preFlush(tracker);
            }
            if (this.numMutationsWithoutWAL.sum() > 0L) {
                this.numMutationsWithoutWAL.reset();
                this.dataInMemoryWithoutWAL.reset();
            }
            msg = this.writestate;
            synchronized (msg) {
                if (this.writestate.flushing || !this.writestate.writesEnabled) {
                    if (HRegion.LOG.isDebugEnabled()) {
                        HRegion.LOG.debug("NOT flushing memstore for region " + this + ", flushing=" + this.writestate.flushing + ", writesEnabled=" + this.writestate.writesEnabled);
                    }
                    msg = "Not flushing since " + (this.writestate.flushing != false ? "already flushing" : "writes not enabled");
                    status.abort(msg);
                    var7_11 = new FlushResultImpl(FlushResult.Result.CANNOT_FLUSH, msg, false);
                    return var7_11;
                }
                this.writestate.flushing = true;
                ** try [egrp 4[TRYBLOCK] [1 : 526->532)] { 
                {
                }
            }
lbl37:
            // 1 sources

            try {
                specificStoresToFlush = forceFlushAllStores != false ? this.stores.values() : this.flushPolicy.selectStoresToFlush();
                fs = this.internalFlushcache(specificStoresToFlush, status, writeFlushRequestWalMarker, tracker);
                if (this.coprocessorHost != null) {
                    status.setStatus("Running post-flush coprocessor hooks");
                    this.coprocessorHost.postFlush(tracker);
                }
                if (fs.isFlushSucceeded()) {
                    this.flushesQueued.reset();
                }
                status.markComplete("Flush successful");
                var7_12 = fs;
                var8_14 = this.writestate;
            }
            catch (Throwable var10_16) {
                var11_17 = this.writestate;
                synchronized (var11_17) {
                    this.writestate.flushing = false;
                    this.writestate.flushRequested = false;
                    this.writestate.notifyAll();
                }
                throw var10_16;
            }
            synchronized (var8_14) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
            return var7_12;
        }
        finally {
            this.lock.readLock().unlock();
            HRegion.LOG.debug("Flush status journal:\n\t" + status.prettyPrintJournal());
            status.cleanup();
        }
    }

    boolean shouldFlushStore(HStore store) {
        long earliest = this.wal.getEarliestMemStoreSeqNum(this.getRegionInfo().getEncodedNameAsBytes(), store.getColumnFamilyDescriptor().getName()) - 1L;
        if (earliest > 0L && earliest + this.flushPerChanges < this.mvcc.getReadPoint()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flush column family " + store.getColumnFamilyName() + " of " + this.getRegionInfo().getEncodedName() + " because unflushed sequenceid=" + earliest + " is > " + this.flushPerChanges + " from current=" + this.mvcc.getReadPoint());
            }
            return true;
        }
        if (this.flushCheckInterval <= 0L) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTime();
        if (store.timeOfOldestEdit() < now - this.flushCheckInterval) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flush column family: " + store.getColumnFamilyName() + " of " + this.getRegionInfo().getEncodedName() + " because time of oldest edit=" + store.timeOfOldestEdit() + " is > " + this.flushCheckInterval + " from now =" + now);
            }
            return true;
        }
        return false;
    }

    boolean shouldFlush(StringBuilder whyFlush) {
        whyFlush.setLength(0);
        if (this.maxFlushedSeqId > 0L && this.maxFlushedSeqId + this.flushPerChanges < this.mvcc.getReadPoint()) {
            whyFlush.append("more than max edits, " + this.flushPerChanges + ", since last flush");
            return true;
        }
        long modifiedFlushCheckInterval = this.flushCheckInterval;
        if (this.getRegionInfo().getTable().isSystemTable() && this.getRegionInfo().getReplicaId() == 0) {
            modifiedFlushCheckInterval = 300000L;
        }
        if (modifiedFlushCheckInterval <= 0L) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTime();
        if (now - this.getEarliestFlushTimeForAllStores() < modifiedFlushCheckInterval) {
            return false;
        }
        for (HStore s : this.stores.values()) {
            if (s.timeOfOldestEdit() >= now - modifiedFlushCheckInterval) continue;
            whyFlush.append(s.toString() + " has an old edit so flush to free WALs");
            return true;
        }
        return false;
    }

    private FlushResult internalFlushcache(MonitoredTask status) throws IOException {
        return this.internalFlushcache(this.stores.values(), status, false, FlushLifeCycleTracker.DUMMY);
    }

    private FlushResultImpl internalFlushcache(Collection<HStore> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker, FlushLifeCycleTracker tracker) throws IOException {
        return this.internalFlushcache(this.wal, -1L, storesToFlush, status, writeFlushWalMarker, tracker);
    }

    protected FlushResultImpl internalFlushcache(WAL wal, long myseqid, Collection<HStore> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker, FlushLifeCycleTracker tracker) throws IOException {
        PrepareFlushResult result = this.internalPrepareFlushCache(wal, myseqid, storesToFlush, status, writeFlushWalMarker, tracker);
        if (result.result == null) {
            return this.internalFlushCacheAndCommit(wal, status, result, storesToFlush);
        }
        return result.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="FindBugs seems confused about trxId")
    protected PrepareFlushResult internalPrepareFlushCache(WAL wal, long myseqid, Collection<HStore> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker, FlushLifeCycleTracker tracker) throws IOException {
        if (this.rsServices != null && this.rsServices.isAborted()) {
            throw new IOException("Aborting flush because server is aborted...");
        }
        long startTime = EnvironmentEdgeManager.currentTime();
        if (this.memStoreSizing.getDataSize() <= 0L) {
            MultiVersionConcurrencyControl.WriteEntry writeEntry;
            block19: {
                PrepareFlushResult flushOpSeqId2;
                block22: {
                    block20: {
                        PrepareFlushResult prepareFlushResult;
                        block21: {
                            this.updatesLock.writeLock().lock();
                            writeEntry = null;
                            try {
                                if (this.memStoreSizing.getDataSize() > 0L) break block19;
                                if (wal == null) break block20;
                                writeEntry = this.mvcc.begin();
                                long flushOpSeqId2 = writeEntry.getWriteNumber();
                                FlushResultImpl flushResult = new FlushResultImpl(FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY, flushOpSeqId2, "Nothing to flush", this.writeFlushRequestMarkerToWAL(wal, writeFlushWalMarker));
                                this.mvcc.completeAndWait(writeEntry);
                                writeEntry = null;
                                prepareFlushResult = new PrepareFlushResult(flushResult, myseqid);
                                if (writeEntry == null) break block21;
                                this.mvcc.complete(writeEntry);
                            }
                            catch (Throwable throwable) {
                                if (writeEntry != null) {
                                    this.mvcc.complete(writeEntry);
                                }
                                this.updatesLock.writeLock().unlock();
                                throw throwable;
                            }
                        }
                        this.updatesLock.writeLock().unlock();
                        return prepareFlushResult;
                    }
                    flushOpSeqId2 = new PrepareFlushResult(new FlushResultImpl(FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY, "Nothing to flush", false), myseqid);
                    if (writeEntry == null) break block22;
                    this.mvcc.complete(writeEntry);
                }
                this.updatesLock.writeLock().unlock();
                return flushOpSeqId2;
            }
            if (writeEntry != null) {
                this.mvcc.complete(writeEntry);
            }
            this.updatesLock.writeLock().unlock();
        }
        this.logFatLineOnFlush(storesToFlush, myseqid);
        status.setStatus("Obtaining lock to block concurrent updates");
        this.updatesLock.writeLock().lock();
        status.setStatus("Preparing flush snapshotting stores in " + this.getRegionInfo().getEncodedName());
        NonThreadSafeMemStoreSizing totalSizeOfFlushableStores = new NonThreadSafeMemStoreSizing();
        HashMap<byte[], Long> flushedFamilyNamesToSeq = new HashMap<byte[], Long>();
        for (HStore store : storesToFlush) {
            flushedFamilyNamesToSeq.put(store.getColumnFamilyDescriptor().getName(), store.preFlushSeqIDEstimation());
        }
        TreeMap<byte[], StoreFlushContext> storeFlushCtxs = new TreeMap<byte[], StoreFlushContext>(Bytes.BYTES_COMPARATOR);
        TreeMap<byte[], List<Path>> committedFiles = new TreeMap<byte[], List<Path>>(Bytes.BYTES_COMPARATOR);
        TreeMap<byte[], MemStoreSize> storeFlushableSize = new TreeMap<byte[], MemStoreSize>(Bytes.BYTES_COMPARATOR);
        long flushOpSeqId = -1L;
        long flushedSeqId = -1L;
        byte[] encodedRegionName = this.getRegionInfo().getEncodedNameAsBytes();
        try {
            if (wal != null) {
                Long earliestUnflushedSequenceIdForTheRegion = wal.startCacheFlush(encodedRegionName, flushedFamilyNamesToSeq);
                if (earliestUnflushedSequenceIdForTheRegion == null) {
                    String msg = this.getRegionInfo().getEncodedName() + " flush aborted; WAL closing.";
                    status.setStatus(msg);
                    PrepareFlushResult prepareFlushResult = new PrepareFlushResult(new FlushResultImpl(FlushResult.Result.CANNOT_FLUSH, msg, false), myseqid);
                    return prepareFlushResult;
                }
                flushOpSeqId = this.getNextSequenceId(wal);
                flushedSeqId = earliestUnflushedSequenceIdForTheRegion == -1L ? flushOpSeqId : earliestUnflushedSequenceIdForTheRegion - 1L;
            } else {
                flushedSeqId = flushOpSeqId = myseqid;
            }
            for (HStore s : storesToFlush) {
                storeFlushCtxs.put(s.getColumnFamilyDescriptor().getName(), s.createFlushContext(flushOpSeqId, tracker));
                committedFiles.put(s.getColumnFamilyDescriptor().getName(), null);
            }
            if (wal != null && !this.writestate.readOnly) {
                WALProtos.FlushDescriptor desc = ProtobufUtil.toFlushDescriptor(WALProtos.FlushDescriptor.FlushAction.START_FLUSH, this.getRegionInfo(), flushOpSeqId, committedFiles);
                WALUtil.writeFlushMarker(wal, this.getReplicationScope(), this.getRegionInfo(), desc, false, this.mvcc);
            }
            storeFlushCtxs.forEach((name, flush) -> {
                MemStoreSize snapshotSize = flush.prepare();
                totalSizeOfFlushableStores.incMemStoreSize(snapshotSize);
                storeFlushableSize.put((byte[])name, snapshotSize);
            });
        }
        catch (IOException ex) {
            this.doAbortFlushToWAL(wal, flushOpSeqId, committedFiles);
            throw ex;
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
        String s = "Finished memstore snapshotting " + this + ", syncing WAL and waiting on mvcc, flushsize=" + totalSizeOfFlushableStores;
        status.setStatus(s);
        HRegion.doSyncOfUnflushedWALChanges(wal, this.getRegionInfo());
        return new PrepareFlushResult(storeFlushCtxs, committedFiles, storeFlushableSize, startTime, flushOpSeqId, flushedSeqId, totalSizeOfFlushableStores);
    }

    private void logFatLineOnFlush(Collection<HStore> storesToFlush, long sequenceId) {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        StringBuilder perCfExtras = null;
        if (!this.isAllFamilies(storesToFlush)) {
            perCfExtras = new StringBuilder();
            for (HStore store : storesToFlush) {
                MemStoreSize mss = store.getFlushableSize();
                perCfExtras.append("; ").append(store.getColumnFamilyName());
                perCfExtras.append("={dataSize=").append(StringUtils.byteDesc((long)mss.getDataSize()));
                perCfExtras.append(", heapSize=").append(StringUtils.byteDesc((long)mss.getHeapSize()));
                perCfExtras.append(", offHeapSize=").append(StringUtils.byteDesc((long)mss.getOffHeapSize()));
                perCfExtras.append("}");
            }
        }
        MemStoreSize mss = this.memStoreSizing.getMemStoreSize();
        LOG.info("Flushing " + this.getRegionInfo().getEncodedName() + " " + storesToFlush.size() + "/" + this.stores.size() + " column families, dataSize=" + StringUtils.byteDesc((long)mss.getDataSize()) + " heapSize=" + StringUtils.byteDesc((long)mss.getHeapSize()) + (perCfExtras != null && perCfExtras.length() > 0 ? perCfExtras.toString() : "") + (this.wal != null ? "" : "; WAL is null, using passed sequenceid=" + sequenceId));
    }

    private void doAbortFlushToWAL(WAL wal, long flushOpSeqId, Map<byte[], List<Path>> committedFiles) {
        if (wal == null) {
            return;
        }
        try {
            WALProtos.FlushDescriptor desc = ProtobufUtil.toFlushDescriptor(WALProtos.FlushDescriptor.FlushAction.ABORT_FLUSH, this.getRegionInfo(), flushOpSeqId, committedFiles);
            WALUtil.writeFlushMarker(wal, this.getReplicationScope(), this.getRegionInfo(), desc, false, this.mvcc);
        }
        catch (Throwable t) {
            LOG.warn("Received unexpected exception trying to write ABORT_FLUSH marker to WAL: {} in  region {}", (Object)StringUtils.stringifyException((Throwable)t), (Object)this);
        }
        wal.abortCacheFlush(this.getRegionInfo().getEncodedNameAsBytes());
    }

    private static void doSyncOfUnflushedWALChanges(WAL wal, RegionInfo hri) throws IOException {
        if (wal == null) {
            return;
        }
        try {
            wal.sync();
        }
        catch (IOException ioe) {
            wal.abortCacheFlush(hri.getEncodedNameAsBytes());
            throw ioe;
        }
    }

    private boolean isAllFamilies(Collection<HStore> families) {
        return families == null || this.stores.size() == families.size();
    }

    private boolean writeFlushRequestMarkerToWAL(WAL wal, boolean writeFlushWalMarker) {
        if (writeFlushWalMarker && wal != null && !this.writestate.readOnly) {
            WALProtos.FlushDescriptor desc = ProtobufUtil.toFlushDescriptor(WALProtos.FlushDescriptor.FlushAction.CANNOT_FLUSH, this.getRegionInfo(), -1L, new TreeMap<byte[], List<Path>>(Bytes.BYTES_COMPARATOR));
            try {
                WALUtil.writeFlushMarker(wal, this.getReplicationScope(), this.getRegionInfo(), desc, true, this.mvcc);
                return true;
            }
            catch (IOException e) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : Received exception while trying to write the flush request to wal", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NN_NAKED_NOTIFY"}, justification="Intentional; notify is about completed flush")
    protected FlushResultImpl internalFlushCacheAndCommit(WAL wal, MonitoredTask status, PrepareFlushResult prepareResult, Collection<HStore> storesToFlush) throws IOException {
        TreeMap<byte[], StoreFlushContext> storeFlushCtxs = prepareResult.storeFlushCtxs;
        TreeMap<byte[], List<Path>> committedFiles = prepareResult.committedFiles;
        long startTime = prepareResult.startTime;
        long flushOpSeqId = prepareResult.flushOpSeqId;
        long flushedSeqId = prepareResult.flushedSeqId;
        String s = "Flushing stores of " + this;
        status.setStatus(s);
        if (LOG.isTraceEnabled()) {
            LOG.trace(s);
        }
        boolean compactionRequested = false;
        long flushedOutputFileSize = 0L;
        try {
            RegionServerSpaceQuotaManager regionServerSpaceQuotaManager;
            for (StoreFlushContext storeFlushContext : storeFlushCtxs.values()) {
                storeFlushContext.flushCache(status);
            }
            for (Map.Entry entry : storeFlushCtxs.entrySet()) {
                StoreFlushContext sfc = (StoreFlushContext)entry.getValue();
                boolean needsCompaction = sfc.commit(status);
                if (needsCompaction) {
                    compactionRequested = true;
                }
                byte[] storeName = (byte[])entry.getKey();
                List<Path> storeCommittedFiles = sfc.getCommittedFiles();
                committedFiles.put(storeName, storeCommittedFiles);
                if (storeCommittedFiles == null || storeCommittedFiles.isEmpty()) {
                    MemStoreSize storeFlushableSize = prepareResult.storeFlushableSize.get(storeName);
                    prepareResult.totalFlushableSize.decMemStoreSize(storeFlushableSize);
                }
                flushedOutputFileSize += sfc.getOutputFileSize();
            }
            storeFlushCtxs.clear();
            MemStoreSize mss = prepareResult.totalFlushableSize.getMemStoreSize();
            this.decrMemStoreSize(mss);
            if (this.rsServices != null && (regionServerSpaceQuotaManager = this.rsServices.getRegionServerSpaceQuotaManager()) != null) {
                regionServerSpaceQuotaManager.getRegionSizeStore().incrementRegionSize(this.getRegionInfo(), flushedOutputFileSize);
            }
            if (wal != null) {
                WALProtos.FlushDescriptor flushDescriptor = ProtobufUtil.toFlushDescriptor(WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH, this.getRegionInfo(), flushOpSeqId, committedFiles);
                WALUtil.writeFlushMarker(wal, this.getReplicationScope(), this.getRegionInfo(), flushDescriptor, true, this.mvcc);
            }
        }
        catch (Throwable t) {
            if (wal != null) {
                try {
                    WALProtos.FlushDescriptor flushDescriptor = ProtobufUtil.toFlushDescriptor(WALProtos.FlushDescriptor.FlushAction.ABORT_FLUSH, this.getRegionInfo(), flushOpSeqId, committedFiles);
                    WALUtil.writeFlushMarker(wal, this.replicationScope, this.getRegionInfo(), flushDescriptor, false, this.mvcc);
                }
                catch (Throwable throwable) {
                    LOG.warn(this.getRegionInfo().getEncodedName() + " : failed writing ABORT_FLUSH marker to WAL", throwable);
                }
                wal.abortCacheFlush(this.getRegionInfo().getEncodedNameAsBytes());
            }
            DroppedSnapshotException droppedSnapshotException = new DroppedSnapshotException("region: " + Bytes.toStringBinary(this.getRegionInfo().getRegionName()));
            droppedSnapshotException.initCause(t);
            status.abort("Flush failed: " + StringUtils.stringifyException((Throwable)t));
            this.closing.set(true);
            if (this.rsServices != null) {
                this.rsServices.abort("Replay of WAL required. Forcing server shutdown", droppedSnapshotException);
            }
            throw droppedSnapshotException;
        }
        if (wal != null) {
            wal.completeCacheFlush(this.getRegionInfo().getEncodedNameAsBytes(), flushedSeqId);
        }
        for (HStore hStore : storesToFlush) {
            this.lastStoreFlushTimeMap.put(hStore, startTime);
        }
        this.maxFlushedSeqId = flushedSeqId;
        this.lastFlushOpSeqId = flushOpSeqId;
        HRegion t = this;
        synchronized (t) {
            this.notifyAll();
        }
        long time = EnvironmentEdgeManager.currentTime() - startTime;
        MemStoreSize mss = prepareResult.totalFlushableSize.getMemStoreSize();
        long memstoresize = this.memStoreSizing.getMemStoreSize().getDataSize();
        String msg = "Finished flush of dataSize ~" + StringUtils.byteDesc((long)mss.getDataSize()) + "/" + mss.getDataSize() + ", heapSize ~" + StringUtils.byteDesc((long)mss.getHeapSize()) + "/" + mss.getHeapSize() + ", currentSize=" + StringUtils.byteDesc((long)memstoresize) + "/" + memstoresize + " for " + this.getRegionInfo().getEncodedName() + " in " + time + "ms, sequenceid=" + flushOpSeqId + ", compaction requested=" + compactionRequested + (wal == null ? "; wal=null" : "");
        LOG.info(msg);
        status.setStatus(msg);
        if (this.rsServices != null && this.rsServices.getMetrics() != null) {
            this.rsServices.getMetrics().updateFlush(this.getTableDescriptor().getTableName().getNameAsString(), time, mss.getDataSize(), flushedOutputFileSize);
        }
        return new FlushResultImpl(compactionRequested ? FlushResult.Result.FLUSHED_COMPACTION_NEEDED : FlushResult.Result.FLUSHED_NO_COMPACTION_NEEDED, flushOpSeqId);
    }

    @VisibleForTesting
    protected long getNextSequenceId(WAL wal) throws IOException {
        MultiVersionConcurrencyControl.WriteEntry we = this.mvcc.begin();
        this.mvcc.completeAndWait(we);
        return we.getWriteNumber();
    }

    @Override
    public RegionScannerImpl getScanner(Scan scan) throws IOException {
        return this.getScanner(scan, (List)null);
    }

    @Override
    public RegionScannerImpl getScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        return this.getScanner(scan, additionalScanners, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScannerImpl getScanner(Scan scan, List<KeyValueScanner> additionalScanners, long nonceGroup, long nonce) throws IOException {
        this.startRegionOperation(Region.Operation.SCAN);
        try {
            if (!scan.hasFamilies()) {
                for (byte[] family : this.htableDescriptor.getColumnFamilyNames()) {
                    scan.addFamily(family);
                }
            } else {
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    this.checkFamily(family);
                }
            }
            RegionScannerImpl regionScannerImpl = this.instantiateRegionScanner(scan, additionalScanners, nonceGroup, nonce);
            return regionScannerImpl;
        }
        finally {
            this.closeRegionOperation(Region.Operation.SCAN);
        }
    }

    protected RegionScanner instantiateRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        return this.instantiateRegionScanner(scan, additionalScanners, 0L, 0L);
    }

    protected RegionScannerImpl instantiateRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners, long nonceGroup, long nonce) throws IOException {
        if (scan.isReversed()) {
            if (scan.getFilter() != null) {
                scan.getFilter().setReversed(true);
            }
            return new ReversedRegionScannerImpl(scan, additionalScanners, this);
        }
        return new RegionScannerImpl(scan, additionalScanners, this, nonceGroup, nonce);
    }

    public void prepareDelete(Delete delete) throws IOException {
        if (delete.getFamilyCellMap().isEmpty()) {
            for (byte[] family : this.htableDescriptor.getColumnFamilyNames()) {
                delete.addFamily(family, delete.getTimestamp());
            }
        } else {
            for (byte[] family : delete.getFamilyCellMap().keySet()) {
                if (family == null) {
                    throw new NoSuchColumnFamilyException("Empty family is invalid");
                }
                this.checkFamily(family);
            }
        }
    }

    @Override
    public void delete(Delete delete) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation(Region.Operation.DELETE);
        try {
            this.doBatchMutate(delete);
        }
        finally {
            this.closeRegionOperation(Region.Operation.DELETE);
        }
    }

    void delete(NavigableMap<byte[], List<Cell>> familyMap, Durability durability) throws IOException {
        Delete delete = new Delete(FOR_UNIT_TESTS_ONLY);
        delete.setFamilyCellMap((NavigableMap)familyMap);
        delete.setDurability(durability);
        this.doBatchMutate(delete);
    }

    public void prepareDeleteTimestamps(Mutation mutation, Map<byte[], List<Cell>> familyMap, byte[] byteNow) throws IOException {
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            byte[] family = e.getKey();
            List<Cell> cells = e.getValue();
            assert (cells instanceof RandomAccess);
            TreeMap<byte[], Integer> kvCount = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = cells.get(i);
                if (cell.getTimestamp() == Long.MAX_VALUE && PrivateCellUtil.isDeleteType(cell)) {
                    byte[] qual = CellUtil.cloneQualifier(cell);
                    Integer count = (Integer)kvCount.get(qual);
                    if (count == null) {
                        kvCount.put(qual, 1);
                    } else {
                        kvCount.put(qual, count + 1);
                    }
                    count = (Integer)kvCount.get(qual);
                    Get get = new Get(CellUtil.cloneRow(cell));
                    get.setMaxVersions(count);
                    get.addColumn(family, qual);
                    if (this.coprocessorHost != null) {
                        if (this.coprocessorHost.prePrepareTimeStampForDeleteVersion(mutation, cell, byteNow, get)) continue;
                        this.updateDeleteLatestVersionTimestamp(cell, get, count, byteNow);
                        continue;
                    }
                    this.updateDeleteLatestVersionTimestamp(cell, get, count, byteNow);
                    continue;
                }
                PrivateCellUtil.updateLatestStamp(cell, byteNow);
            }
        }
    }

    void updateDeleteLatestVersionTimestamp(Cell cell, Get get, int count, byte[] byteNow) throws IOException {
        List<Cell> result = this.get(get, false);
        if (result.size() < count) {
            PrivateCellUtil.updateLatestStamp(cell, byteNow);
            return;
        }
        if (result.size() > count) {
            throw new RuntimeException("Unexpected size: " + result.size());
        }
        Cell getCell = result.get(count - 1);
        PrivateCellUtil.setTimestamp(cell, getCell.getTimestamp());
    }

    @Override
    public void put(Put put) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation(Region.Operation.PUT);
        try {
            this.doBatchMutate(put);
        }
        finally {
            this.closeRegionOperation(Region.Operation.PUT);
        }
    }

    public OperationStatus[] batchMutate(Mutation[] mutations, long nonceGroup, long nonce) throws IOException {
        return this.batchMutate(mutations, false, nonceGroup, nonce);
    }

    public OperationStatus[] batchMutate(Mutation[] mutations, boolean atomic, long nonceGroup, long nonce) throws IOException {
        return this.batchMutate(new MutationBatchOperation(this, mutations, atomic, nonceGroup, nonce));
    }

    @Override
    public OperationStatus[] batchMutate(Mutation[] mutations) throws IOException {
        return this.batchMutate(mutations, 0L, 0L);
    }

    public OperationStatus[] batchReplay(WALSplitUtil.MutationReplay[] mutations, long replaySeqId) throws IOException {
        if (!RegionReplicaUtil.isDefaultReplica(this.getRegionInfo()) && replaySeqId < this.lastReplayedOpenRegionSeqId) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.getRegionInfo().getEncodedName() + " : Skipping " + mutations.length + " mutations with replaySeqId=" + replaySeqId + " which is < than lastReplayedOpenRegionSeqId=" + this.lastReplayedOpenRegionSeqId);
                for (WALSplitUtil.MutationReplay mut : mutations) {
                    LOG.trace(this.getRegionInfo().getEncodedName() + " : Skipping : " + mut.mutation);
                }
            }
            OperationStatus[] statuses = new OperationStatus[mutations.length];
            for (int i = 0; i < statuses.length; ++i) {
                statuses[i] = OperationStatus.SUCCESS;
            }
            return statuses;
        }
        return this.batchMutate(new ReplayBatchOperation(this, mutations, replaySeqId));
    }

    OperationStatus[] batchMutate(BatchOperation<?> batchOp) throws IOException {
        boolean initialized = false;
        batchOp.startRegionOperation();
        try {
            while (!batchOp.isDone()) {
                if (!batchOp.isInReplay()) {
                    this.checkReadOnly();
                }
                this.checkResources();
                if (!initialized) {
                    this.writeRequestsCount.add(batchOp.size());
                    batchOp.checkAndPrepare();
                    initialized = true;
                }
                this.doMiniBatchMutate(batchOp);
                this.requestFlushIfNeeded();
            }
        }
        finally {
            if (this.rsServices != null && this.rsServices.getMetrics() != null) {
                this.rsServices.getMetrics().updateWriteQueryMeter(this.htableDescriptor.getTableName(), batchOp.size());
            }
            batchOp.closeRegionOperation();
        }
        return batchOp.retCodeDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMiniBatchMutate(BatchOperation<?> batchOp) throws IOException {
        ArrayList<Region.RowLock> acquiredRowLocks;
        MiniBatchOperationInProgress<Mutation> miniBatchOp;
        boolean locked;
        WALEdit walEdit;
        boolean success;
        block11: {
            MultiVersionConcurrencyControl.WriteEntry writeEntry;
            block9: {
                block10: {
                    success = false;
                    walEdit = null;
                    writeEntry = null;
                    locked = false;
                    miniBatchOp = null;
                    acquiredRowLocks = Lists.newArrayListWithCapacity(batchOp.size());
                    miniBatchOp = batchOp.lockRowsAndBuildMiniBatch(acquiredRowLocks);
                    if (miniBatchOp.getReadyToWriteCount() > 0) break block9;
                    if (writeEntry == null) break block10;
                    this.mvcc.complete(writeEntry);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                this.releaseRowLocks(acquiredRowLocks);
                int finalLastIndexExclusive = miniBatchOp != null ? miniBatchOp.getLastIndexExclusive() : batchOp.size();
                boolean finalSuccess = success;
                batchOp.visitBatchOperations(true, finalLastIndexExclusive, i -> {
                    batchOp.retCodeDetails[i] = finalSuccess ? OperationStatus.SUCCESS : OperationStatus.FAILURE;
                    return true;
                });
                batchOp.doPostOpCleanupForMiniBatch(miniBatchOp, walEdit, finalSuccess);
                batchOp.nextIndexToProcess = finalLastIndexExclusive;
                return;
            }
            try {
                this.lock(this.updatesLock.readLock(), miniBatchOp.getReadyToWriteCount());
                locked = true;
                long now = EnvironmentEdgeManager.currentTime();
                batchOp.prepareMiniBatchOperations(miniBatchOp, now, acquiredRowLocks);
                List<Pair<NonceKey, WALEdit>> walEdits = batchOp.buildWALEdits(miniBatchOp);
                Iterator<Pair<NonceKey, WALEdit>> it = walEdits.iterator();
                while (it.hasNext()) {
                    Pair<NonceKey, WALEdit> nonceKeyWALEditPair = it.next();
                    walEdit = nonceKeyWALEditPair.getSecond();
                    NonceKey nonceKey = nonceKeyWALEditPair.getFirst();
                    if (walEdit != null && !walEdit.isEmpty()) {
                        writeEntry = this.doWALAppend(walEdit, batchOp.durability, batchOp.getClusterIds(), now, nonceKey.getNonceGroup(), nonceKey.getNonce(), batchOp.getOrigLogSeqNum());
                    }
                    if (!it.hasNext() || writeEntry == null) continue;
                    this.mvcc.complete(writeEntry);
                    writeEntry = null;
                }
                writeEntry = batchOp.writeMiniBatchOperationsToMemStore(miniBatchOp, writeEntry);
                batchOp.completeMiniBatchOperations(miniBatchOp, writeEntry);
                writeEntry = null;
                success = true;
                if (writeEntry == null) break block11;
                this.mvcc.complete(writeEntry);
            }
            catch (Throwable throwable) {
                if (writeEntry != null) {
                    this.mvcc.complete(writeEntry);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                this.releaseRowLocks(acquiredRowLocks);
                int finalLastIndexExclusive = miniBatchOp != null ? miniBatchOp.getLastIndexExclusive() : batchOp.size();
                boolean finalSuccess = success;
                batchOp.visitBatchOperations(true, finalLastIndexExclusive, i -> {
                    batchOp.retCodeDetails[i] = finalSuccess ? OperationStatus.SUCCESS : OperationStatus.FAILURE;
                    return true;
                });
                batchOp.doPostOpCleanupForMiniBatch(miniBatchOp, walEdit, finalSuccess);
                batchOp.nextIndexToProcess = finalLastIndexExclusive;
                throw throwable;
            }
        }
        if (locked) {
            this.updatesLock.readLock().unlock();
        }
        this.releaseRowLocks(acquiredRowLocks);
        int finalLastIndexExclusive = miniBatchOp != null ? miniBatchOp.getLastIndexExclusive() : batchOp.size();
        boolean finalSuccess = success;
        batchOp.visitBatchOperations(true, finalLastIndexExclusive, i -> {
            batchOp.retCodeDetails[i] = finalSuccess ? OperationStatus.SUCCESS : OperationStatus.FAILURE;
            return true;
        });
        batchOp.doPostOpCleanupForMiniBatch(miniBatchOp, walEdit, finalSuccess);
        batchOp.nextIndexToProcess = finalLastIndexExclusive;
    }

    protected Durability getEffectiveDurability(Durability d) {
        return d == Durability.USE_DEFAULT ? this.regionDurability : d;
    }

    @Override
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, TimeRange timeRange, Mutation mutation) throws IOException {
        this.checkMutationType(mutation, row);
        return this.doCheckAndRowMutate(row, family, qualifier, op, comparator, timeRange, null, mutation);
    }

    @Override
    public boolean checkAndRowMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, TimeRange timeRange, RowMutations rm) throws IOException {
        return this.doCheckAndRowMutate(row, family, qualifier, op, comparator, timeRange, rm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckAndRowMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, TimeRange timeRange, RowMutations rowMutations, Mutation mutation) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation();
        try {
            Region.RowLock rowLock;
            block26: {
                Get get;
                block25: {
                    get = new Get(row);
                    this.checkFamily(family);
                    get.addColumn(family, qualifier);
                    if (timeRange != null) {
                        get.setTimeRange(timeRange.getMin(), timeRange.getMax());
                    }
                    this.checkRow(row, "doCheckAndRowMutate");
                    rowLock = this.getRowLockInternal(get.getRow(), false, null);
                    if (mutation == null || this.getCoprocessorHost() == null) break block25;
                    Boolean processed = null;
                    if (mutation instanceof Put) {
                        processed = this.getCoprocessorHost().preCheckAndPutAfterRowLock(row, family, qualifier, op, comparator, (Put)mutation);
                    } else if (mutation instanceof Delete) {
                        processed = this.getCoprocessorHost().preCheckAndDeleteAfterRowLock(row, family, qualifier, op, comparator, (Delete)mutation);
                    }
                    if (processed == null) break block25;
                    boolean bl = processed;
                    rowLock.release();
                    return bl;
                }
                try {
                    List<Cell> result = this.get(get, false);
                    boolean valueIsNull = comparator.getValue() == null || comparator.getValue().length == 0;
                    boolean matches = false;
                    long cellTs = 0L;
                    if (result.isEmpty() && valueIsNull) {
                        matches = true;
                    } else if (result.size() > 0 && result.get(0).getValueLength() == 0 && valueIsNull) {
                        matches = true;
                        cellTs = result.get(0).getTimestamp();
                    } else if (result.size() == 1 && !valueIsNull) {
                        Cell kv = result.get(0);
                        cellTs = kv.getTimestamp();
                        int compareResult = PrivateCellUtil.compareValue(kv, comparator);
                        matches = this.matches(op, compareResult);
                    }
                    if (!matches) break block26;
                    long now = EnvironmentEdgeManager.currentTime();
                    long ts = Math.max(now, cellTs);
                    byte[] byteTs = Bytes.toBytes(ts);
                    if (mutation != null) {
                        if (mutation instanceof Put) {
                            HRegion.updateCellTimestamps(mutation.getFamilyCellMap().values(), byteTs);
                        }
                    } else {
                        for (Mutation m : rowMutations.getMutations()) {
                            if (!(m instanceof Put)) continue;
                            HRegion.updateCellTimestamps(m.getFamilyCellMap().values(), byteTs);
                        }
                    }
                    if (mutation != null) {
                        this.doBatchMutate(mutation);
                    } else {
                        this.mutateRow(rowMutations);
                    }
                    this.checkAndMutateChecksPassed.increment();
                    boolean bl = true;
                    rowLock.release();
                    return bl;
                }
                catch (Throwable throwable) {
                    rowLock.release();
                    throw throwable;
                }
            }
            this.checkAndMutateChecksFailed.increment();
            boolean bl = false;
            rowLock.release();
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    private void checkMutationType(Mutation mutation, byte[] row) throws DoNotRetryIOException {
        boolean isPut = mutation instanceof Put;
        if (!isPut && !(mutation instanceof Delete)) {
            throw new DoNotRetryIOException("Action must be Put or Delete");
        }
        if (!Bytes.equals(row, mutation.getRow())) {
            throw new DoNotRetryIOException("Action's getRow must match");
        }
    }

    private boolean matches(CompareOperator op, int compareResult) {
        boolean matches = false;
        switch (op) {
            case LESS: {
                matches = compareResult < 0;
                break;
            }
            case LESS_OR_EQUAL: {
                matches = compareResult <= 0;
                break;
            }
            case EQUAL: {
                matches = compareResult == 0;
                break;
            }
            case NOT_EQUAL: {
                matches = compareResult != 0;
                break;
            }
            case GREATER_OR_EQUAL: {
                matches = compareResult >= 0;
                break;
            }
            case GREATER: {
                matches = compareResult > 0;
                break;
            }
            default: {
                throw new RuntimeException("Unknown Compare op " + op.name());
            }
        }
        return matches;
    }

    private void doBatchMutate(Mutation mutation) throws IOException {
        OperationStatus[] batchMutate = this.batchMutate(new Mutation[]{mutation});
        if (batchMutate[0].getOperationStatusCode().equals((Object)HConstants.OperationStatusCode.SANITY_CHECK_FAILURE)) {
            throw new FailedSanityCheckException(batchMutate[0].getExceptionMsg());
        }
        if (batchMutate[0].getOperationStatusCode().equals((Object)HConstants.OperationStatusCode.BAD_FAMILY)) {
            throw new NoSuchColumnFamilyException(batchMutate[0].getExceptionMsg());
        }
        if (batchMutate[0].getOperationStatusCode().equals((Object)HConstants.OperationStatusCode.STORE_TOO_BUSY)) {
            throw new RegionTooBusyException(batchMutate[0].getExceptionMsg());
        }
    }

    public void addRegionToSnapshot(SnapshotProtos.SnapshotDescription desc, ForeignExceptionSnare exnSnare) throws IOException {
        Path rootDir = FSUtils.getRootDir(this.conf);
        Path snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(desc, rootDir, this.conf);
        SnapshotManifest manifest = SnapshotManifest.create(this.conf, this.getFilesystem(), snapshotDir, desc, exnSnare);
        manifest.addRegion(this);
    }

    private void updateSequenceId(Iterable<List<Cell>> cellItr, long sequenceId) throws IOException {
        for (List<Cell> cells : cellItr) {
            if (cells == null) {
                return;
            }
            for (Cell cell : cells) {
                PrivateCellUtil.setSequenceId(cell, sequenceId);
            }
        }
    }

    private static void updateCellTimestamps(Iterable<List<Cell>> cellItr, byte[] now) throws IOException {
        for (List<Cell> cells : cellItr) {
            if (cells == null) continue;
            assert (cells instanceof RandomAccess);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                PrivateCellUtil.updateLatestStamp(cells.get(i), now);
            }
        }
    }

    void rewriteCellTags(Map<byte[], List<Cell>> familyMap, Mutation m) {
        if (m.getTTL() == Long.MAX_VALUE) {
            return;
        }
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            List<Cell> cells = e.getValue();
            assert (cells instanceof RandomAccess);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = cells.get(i);
                List<Tag> newTags = TagUtil.carryForwardTags(null, cell);
                newTags = TagUtil.carryForwardTTLTag(newTags, m.getTTL());
                cells.set(i, PrivateCellUtil.createCell(cell, newTags));
            }
        }
    }

    void checkResources() throws RegionTooBusyException {
        if (this.getRegionInfo().isMetaRegion()) {
            return;
        }
        MemStoreSize mss = this.memStoreSizing.getMemStoreSize();
        if (mss.getHeapSize() + mss.getOffHeapSize() > this.blockingMemStoreSize) {
            this.blockedRequestsCount.increment();
            this.requestFlush();
            throw new RegionTooBusyException("Over memstore limit=" + org.apache.hadoop.hbase.procedure2.util.StringUtils.humanSize(this.blockingMemStoreSize) + ", regionName=" + (this.getRegionInfo() == null ? "unknown" : this.getRegionInfo().getEncodedName()) + ", server=" + (this.getRegionServerServices() == null ? "unknown" : this.getRegionServerServices().getServerName()));
        }
    }

    protected void checkReadOnly() throws IOException {
        if (this.isReadOnly()) {
            throw new DoNotRetryIOException("region is read only");
        }
    }

    protected void checkReadsEnabled() throws IOException {
        if (!this.writestate.readsEnabled) {
            throw new IOException(this.getRegionInfo().getEncodedName() + ": The region's reads are disabled. Cannot serve the request");
        }
    }

    public void setReadsEnabled(boolean readsEnabled) {
        if (readsEnabled && !this.writestate.readsEnabled) {
            LOG.info(this.getRegionInfo().getEncodedName() + " : Enabling reads for region.");
        }
        this.writestate.setReadsEnabled(readsEnabled);
    }

    void put(byte[] row, byte[] family, List<Cell> edits) throws IOException {
        TreeMap<byte[], List<Cell>> familyMap = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);
        familyMap.put(family, edits);
        Put p = new Put(row);
        p.setFamilyCellMap(familyMap);
        this.doBatchMutate(p);
    }

    private void applyToMemStore(HStore store, List<Cell> cells, boolean delta, MemStoreSizing memstoreAccounting) throws IOException {
        boolean upsert;
        boolean bl = upsert = delta && store.getColumnFamilyDescriptor().getMaxVersions() == 1;
        if (upsert) {
            store.upsert(cells, this.getSmallestReadPoint(), memstoreAccounting);
        } else {
            store.add(cells, memstoreAccounting);
        }
    }

    private void applyToMemStore(HStore store, Cell cell, MemStoreSizing memstoreAccounting) throws IOException {
        if (store == null) {
            this.checkFamily(CellUtil.cloneFamily(cell));
        }
        store.add(cell, memstoreAccounting);
    }

    public void checkFamilies(Collection<byte[]> families) throws NoSuchColumnFamilyException {
        for (byte[] family : families) {
            this.checkFamily(family);
        }
    }

    public void checkTimestamps(Map<byte[], List<Cell>> familyMap, long now) throws FailedSanityCheckException {
        if (this.timestampSlop == Long.MAX_VALUE) {
            return;
        }
        long maxTs = now + this.timestampSlop;
        for (List<Cell> kvs : familyMap.values()) {
            assert (kvs instanceof RandomAccess);
            int listSize = kvs.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = kvs.get(i);
                long ts = cell.getTimestamp();
                if (ts == Long.MAX_VALUE || ts <= maxTs) continue;
                throw new FailedSanityCheckException("Timestamp for KV out of range " + cell + " (too.new=" + this.timestampSlop + ")");
            }
        }
    }

    private boolean isFlushSize(MemStoreSize size) {
        return size.getHeapSize() + size.getOffHeapSize() > this.getMemStoreFlushSize();
    }

    protected long replayRecoveredEditsIfAny(Map<byte[], Long> maxSeqIdInStores, CancelableProgressable reporter, MonitoredTask status) throws IOException {
        NavigableSet<Path> files;
        long minSeqIdForTheRegion = -1L;
        for (Long maxSeqIdInStore : maxSeqIdInStores.values()) {
            if (maxSeqIdInStore >= minSeqIdForTheRegion && minSeqIdForTheRegion != -1L) continue;
            minSeqIdForTheRegion = maxSeqIdInStore;
        }
        long seqId = minSeqIdForTheRegion;
        FileSystem walFS = this.getWalFileSystem();
        FileSystem rootFS = this.getFilesystem();
        Path wrongRegionWALDir = FSUtils.getWrongWALRegionDir(this.conf, this.getRegionInfo().getTable(), this.getRegionInfo().getEncodedName());
        Path regionWALDir = this.getWALRegionDir();
        Path regionDir = FSUtils.getRegionDirFromRootDir(FSUtils.getRootDir(this.conf), this.getRegionInfo());
        NavigableSet<Path> filesUnderWrongRegionWALDir = WALSplitUtil.getSplitEditFilesSorted(walFS, wrongRegionWALDir);
        seqId = Math.max(seqId, this.replayRecoveredEditsForPaths(minSeqIdForTheRegion, walFS, filesUnderWrongRegionWALDir, reporter, regionDir));
        NavigableSet<Path> filesUnderRootDir = Collections.emptyNavigableSet();
        if (!regionWALDir.equals((Object)regionDir)) {
            filesUnderRootDir = WALSplitUtil.getSplitEditFilesSorted(rootFS, regionDir);
            seqId = Math.max(seqId, this.replayRecoveredEditsForPaths(minSeqIdForTheRegion, rootFS, filesUnderRootDir, reporter, regionDir));
        }
        if ((seqId = Math.max(seqId, this.replayRecoveredEditsForPaths(minSeqIdForTheRegion, walFS, files = WALSplitUtil.getSplitEditFilesSorted(walFS, regionWALDir), reporter, regionWALDir))) > minSeqIdForTheRegion) {
            this.internalFlushcache(null, seqId, this.stores.values(), status, false, FlushLifeCycleTracker.DUMMY);
        }
        if (files.size() > 0 && this.conf.getBoolean("hbase.region.archive.recovered.edits", false)) {
            String fakeFamilyName = WALSplitUtil.getRegionDirRecoveredEditsDir(regionWALDir).getName();
            HashSet<HStoreFile> fakeStoreFiles = new HashSet<HStoreFile>(files.size());
            for (Path file : files) {
                fakeStoreFiles.add(new HStoreFile(walFS, file, this.conf, null, null, true));
            }
            this.getRegionWALFileSystem().archiveRecoveredEdits(fakeFamilyName, fakeStoreFiles);
        } else {
            for (Path file : Iterables.concat(files, filesUnderWrongRegionWALDir)) {
                if (!walFS.delete(file, false)) {
                    LOG.error("Failed delete of {}", (Object)file);
                    continue;
                }
                LOG.debug("Deleted recovered.edits file={}", (Object)file);
            }
            for (Path file : filesUnderRootDir) {
                if (!rootFS.delete(file, false)) {
                    LOG.error("Failed delete of {}", (Object)file);
                    continue;
                }
                LOG.debug("Deleted recovered.edits file={}", (Object)file);
            }
        }
        return seqId;
    }

    private long replayRecoveredEditsForPaths(long minSeqIdForTheRegion, FileSystem fs, NavigableSet<Path> files, CancelableProgressable reporter, Path regionDir) throws IOException {
        long seqid = minSeqIdForTheRegion;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + (files == null ? 0 : files.size()) + " recovered edits file(s) under " + regionDir);
        }
        if (files == null || files.isEmpty()) {
            return minSeqIdForTheRegion;
        }
        for (Path edits : files) {
            if (edits == null || !fs.exists(edits)) {
                LOG.warn("Null or non-existent edits file: " + edits);
                continue;
            }
            if (HRegion.isZeroLengthThenDelete(fs, edits)) continue;
            String fileName = edits.getName();
            long maxSeqId = Math.abs(Long.parseLong(fileName));
            if (maxSeqId <= minSeqIdForTheRegion) {
                if (!LOG.isDebugEnabled()) continue;
                String msg = "Maximum sequenceid for this wal is " + maxSeqId + " and minimum sequenceid for the region " + this + "  is " + minSeqIdForTheRegion + ", skipped the whole file, path=" + edits;
                LOG.debug(msg);
                continue;
            }
            try {
                seqid = Math.max(seqid, this.replayRecoveredEdits(edits, this.maxSeqIdInStores, reporter, fs));
            }
            catch (IOException e) {
                boolean skipErrors = this.conf.getBoolean("hbase.hregion.edits.replay.skip.errors", this.conf.getBoolean("hbase.skip.errors", false));
                if (this.conf.get("hbase.skip.errors") != null) {
                    LOG.warn("The property 'hbase.skip.errors' has been deprecated. Please use hbase.hregion.edits.replay.skip.errors instead.");
                }
                if (skipErrors) {
                    Path p = WALSplitUtil.moveAsideBadEditsFile(fs, edits);
                    LOG.error("hbase.hregion.edits.replay.skip.errors=true so continuing. Renamed " + edits + " as " + p, (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        return seqid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replayRecoveredEdits(Path edits, Map<byte[], Long> maxSeqIdInStores, CancelableProgressable reporter, FileSystem fs) throws IOException {
        String msg = "Replaying edits from " + edits;
        LOG.info(msg);
        MonitoredTask status = TaskMonitor.get().createStatus(msg);
        status.setStatus("Opening recovered edits");
        WAL.Reader reader = null;
        try {
            reader = WALFactory.createReader(fs, edits, this.conf);
            long currentEditSeqId = -1L;
            long currentReplaySeqId = -1L;
            long firstSeqIdInLog = -1L;
            long skippedEdits = 0L;
            long editsCount = 0L;
            long intervalEdits = 0L;
            HStore store = null;
            boolean reported_once = false;
            ServerNonceManager ng = this.rsServices == null ? null : this.rsServices.getNonceManager();
            try {
                WAL.Entry entry;
                int interval = this.conf.getInt("hbase.hstore.report.interval.edits", 2000);
                int period = this.conf.getInt("hbase.hstore.report.period", 300000);
                long lastReport = EnvironmentEdgeManager.currentTime();
                if (this.coprocessorHost != null) {
                    this.coprocessorHost.preReplayWALs(this.getRegionInfo(), edits);
                }
                while ((entry = reader.next()) != null) {
                    WALKeyImpl key = entry.getKey();
                    WALEdit val = entry.getEdit();
                    if (ng != null) {
                        ng.reportOperationFromWal(key.getNonceGroup(), key.getNonce(), key.getWriteTime());
                    }
                    if (reporter != null && (intervalEdits += (long)val.size()) >= (long)interval) {
                        intervalEdits = 0L;
                        long cur = EnvironmentEdgeManager.currentTime();
                        if (lastReport + (long)period <= cur) {
                            status.setStatus("Replaying edits... skipped=" + skippedEdits + " edits=" + editsCount);
                            if (!reporter.progress()) {
                                msg = "Progressable reporter failed, stopping replay for region " + this;
                                LOG.warn(msg);
                                status.abort(msg);
                                throw new IOException(msg);
                            }
                            reported_once = true;
                            lastReport = cur;
                        }
                    }
                    if (firstSeqIdInLog == -1L) {
                        firstSeqIdInLog = key.getSequenceId();
                    }
                    if (currentEditSeqId > key.getSequenceId()) {
                        LOG.error(this.getRegionInfo().getEncodedName() + " : Found decreasing SeqId. PreId=" + currentEditSeqId + " key=" + key + "; edit=" + val);
                    } else {
                        currentEditSeqId = key.getSequenceId();
                    }
                    long l = currentReplaySeqId = key.getOrigLogSeqNum() > 0L ? key.getOrigLogSeqNum() : currentEditSeqId;
                    if (this.coprocessorHost != null) {
                        status.setStatus("Running pre-WAL-restore hook in coprocessors");
                        if (this.coprocessorHost.preWALRestore(this.getRegionInfo(), key, val)) continue;
                    }
                    boolean checkRowWithinBoundary = false;
                    if (!Bytes.equals(key.getEncodedRegionName(), this.getRegionInfo().getEncodedNameAsBytes())) {
                        checkRowWithinBoundary = true;
                    }
                    boolean flush = false;
                    NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
                    for (Cell cell : val.getCells()) {
                        if (WALEdit.isMetaEditFamily(cell)) {
                            WALProtos.CompactionDescriptor compaction;
                            if (!checkRowWithinBoundary && (compaction = WALEdit.getCompaction(cell)) != null) {
                                this.replayWALCompactionMarker(compaction, false, true, Long.MAX_VALUE);
                            }
                            ++skippedEdits;
                            continue;
                        }
                        if (store == null || !CellUtil.matchingFamily(cell, store.getColumnFamilyDescriptor().getName())) {
                            store = this.getStore(cell);
                        }
                        if (store == null) {
                            LOG.warn("No family for cell {} in region {}", (Object)cell, (Object)this);
                            ++skippedEdits;
                            continue;
                        }
                        if (checkRowWithinBoundary && !HRegion.rowIsInRange(this.getRegionInfo(), cell.getRowArray(), cell.getRowOffset(), cell.getRowLength())) {
                            LOG.warn("Row of {} is not within region boundary for region {}", (Object)cell, (Object)this);
                            ++skippedEdits;
                            continue;
                        }
                        if (key.getSequenceId() <= maxSeqIdInStores.get(store.getColumnFamilyDescriptor().getName())) {
                            ++skippedEdits;
                            continue;
                        }
                        PrivateCellUtil.setSequenceId(cell, currentReplaySeqId);
                        this.restoreEdit(store, cell, memStoreSizing);
                        ++editsCount;
                    }
                    MemStoreSize mss = memStoreSizing.getMemStoreSize();
                    this.incMemStoreSize(mss);
                    flush = this.isFlushSize(this.memStoreSizing.getMemStoreSize());
                    if (flush) {
                        this.internalFlushcache(null, currentEditSeqId, this.stores.values(), status, false, FlushLifeCycleTracker.DUMMY);
                    }
                    if (this.coprocessorHost == null) continue;
                    this.coprocessorHost.postWALRestore(this.getRegionInfo(), key, val);
                }
                if (this.coprocessorHost != null) {
                    this.coprocessorHost.postReplayWALs(this.getRegionInfo(), edits);
                }
            }
            catch (EOFException eof) {
                Path p = WALSplitUtil.moveAsideBadEditsFile(this.walFS, edits);
                msg = "EnLongAddered EOF. Most likely due to Master failure during wal splitting, so we have this data in another edit. Continuing, but renaming " + edits + " as " + p + " for region " + this;
                LOG.warn(msg, (Throwable)eof);
                status.abort(msg);
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof ParseException) {
                    Path p = WALSplitUtil.moveAsideBadEditsFile(this.walFS, edits);
                    msg = "File corruption enLongAddered!  Continuing, but renaming " + edits + " as " + p;
                    LOG.warn(msg, (Throwable)ioe);
                    status.setStatus(msg);
                }
                status.abort(StringUtils.stringifyException((Throwable)ioe));
                throw ioe;
            }
            if (reporter != null && !reported_once) {
                reporter.progress();
            }
            msg = "Applied " + editsCount + ", skipped " + skippedEdits + ", firstSequenceIdInLog=" + firstSeqIdInLog + ", maxSequenceIdInLog=" + currentEditSeqId + ", path=" + edits;
            status.markComplete(msg);
            LOG.debug(msg);
            long l = currentEditSeqId;
            return l;
        }
        finally {
            status.cleanup();
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replayWALCompactionMarker(WALProtos.CompactionDescriptor compaction, boolean pickCompactionFiles, boolean removeFiles, long replaySeqId) throws IOException {
        try {
            this.checkTargetRegion(compaction.getEncodedRegionName().toByteArray(), "Compaction marker from WAL ", compaction);
        }
        catch (WrongRegionException wre) {
            if (RegionReplicaUtil.isDefaultReplica(this.getRegionInfo())) {
                return;
            }
            throw wre;
        }
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (replaySeqId < this.lastReplayedOpenRegionSeqId) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : Skipping replaying compaction event :" + TextFormat.shortDebugString(compaction) + " because its sequence id " + replaySeqId + " is smaller than this regions lastReplayedOpenRegionSeqId of " + this.lastReplayedOpenRegionSeqId);
                return;
            }
            if (replaySeqId < this.lastReplayedCompactionSeqId) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : Skipping replaying compaction event :" + TextFormat.shortDebugString(compaction) + " because its sequence id " + replaySeqId + " is smaller than this regions lastReplayedCompactionSeqId of " + this.lastReplayedCompactionSeqId);
                return;
            }
            this.lastReplayedCompactionSeqId = replaySeqId;
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getRegionInfo().getEncodedName() + " : Replaying compaction marker " + TextFormat.shortDebugString(compaction) + " with seqId=" + replaySeqId + " and lastReplayedOpenRegionSeqId=" + this.lastReplayedOpenRegionSeqId);
            }
            this.startRegionOperation(Region.Operation.REPLAY_EVENT);
            try {
                HStore store = this.getStore(compaction.getFamilyName().toByteArray());
                if (store == null) {
                    LOG.warn(this.getRegionInfo().getEncodedName() + " : Found Compaction WAL edit for deleted family:" + Bytes.toString(compaction.getFamilyName().toByteArray()));
                    return;
                }
                store.replayCompactionMarker(compaction, pickCompactionFiles, removeFiles);
                this.logRegionFiles();
            }
            catch (FileNotFoundException ex) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : At least one of the store files in compaction: " + TextFormat.shortDebugString(compaction) + " doesn't exist any more. Skip loading the file(s)", (Throwable)ex);
            }
            finally {
                this.closeRegionOperation(Region.Operation.REPLAY_EVENT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replayWALFlushMarker(WALProtos.FlushDescriptor flush, long replaySeqId) throws IOException {
        this.checkTargetRegion(flush.getEncodedRegionName().toByteArray(), "Flush marker from WAL ", flush);
        if (ServerRegionReplicaUtil.isDefaultReplica(this.getRegionInfo())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getRegionInfo().getEncodedName() + " : Replaying flush marker " + TextFormat.shortDebugString(flush));
        }
        this.startRegionOperation(Region.Operation.REPLAY_EVENT);
        try {
            WALProtos.FlushDescriptor.FlushAction action = flush.getAction();
            switch (action) {
                case START_FLUSH: {
                    this.replayWALFlushStartMarker(flush);
                    break;
                }
                case COMMIT_FLUSH: {
                    this.replayWALFlushCommitMarker(flush);
                    break;
                }
                case ABORT_FLUSH: {
                    this.replayWALFlushAbortMarker(flush);
                    break;
                }
                case CANNOT_FLUSH: {
                    this.replayWALFlushCannotFlushMarker(flush, replaySeqId);
                    break;
                }
                default: {
                    LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush event with unknown action, ignoring. " + TextFormat.shortDebugString(flush));
                }
            }
            this.logRegionFiles();
        }
        finally {
            this.closeRegionOperation(Region.Operation.REPLAY_EVENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    PrepareFlushResult replayWALFlushStartMarker(WALProtos.FlushDescriptor flush) throws IOException {
        byte[] family;
        long flushSeqId = flush.getFlushSequenceNumber();
        HashSet<HStore> storesToFlush = new HashSet<HStore>();
        for (WALProtos.FlushDescriptor.StoreFlushDescriptor storeFlush : flush.getStoreFlushesList()) {
            family = storeFlush.getFamilyName().toByteArray();
            HStore store = this.getStore(family);
            if (store == null) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush start marker from primary, but the family is not found. Ignoring StoreFlushDescriptor:" + TextFormat.shortDebugString(storeFlush));
                continue;
            }
            storesToFlush.add(store);
        }
        MonitoredTask status = TaskMonitor.get().createStatus("Preparing flush " + this);
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            block20: {
                try {
                    if (flush.getFlushSequenceNumber() < this.lastReplayedOpenRegionSeqId) {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : Skipping replaying flush event :" + TextFormat.shortDebugString(flush) + " because its sequence id is smaller than this regions lastReplayedOpenRegionSeqId  of " + this.lastReplayedOpenRegionSeqId);
                        family = null;
                        return family;
                    }
                    if (this.numMutationsWithoutWAL.sum() > 0L) {
                        this.numMutationsWithoutWAL.reset();
                        this.dataInMemoryWithoutWAL.reset();
                    }
                    if (!this.writestate.flushing) {
                        PrepareFlushResult prepareResult = this.internalPrepareFlushCache(null, flushSeqId, storesToFlush, status, false, FlushLifeCycleTracker.DUMMY);
                        if (prepareResult.result == null) {
                            this.writestate.flushing = true;
                            this.prepareFlushResult = prepareResult;
                            status.markComplete("Flush prepare successful");
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(this.getRegionInfo().getEncodedName() + " :  Prepared flush with seqId:" + flush.getFlushSequenceNumber());
                            }
                        } else {
                            if (prepareResult.getResult().getResult() == FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY) {
                                this.writestate.flushing = true;
                                this.prepareFlushResult = prepareResult;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(this.getRegionInfo().getEncodedName() + " :  Prepared empty flush with seqId:" + flush.getFlushSequenceNumber());
                                }
                            }
                            status.abort("Flush prepare failed with " + prepareResult.result);
                        }
                        PrepareFlushResult prepareFlushResult = prepareResult;
                        return prepareFlushResult;
                    }
                    if (flush.getFlushSequenceNumber() == this.prepareFlushResult.flushOpSeqId) {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush prepare marker with the same seqId: " + flush.getFlushSequenceNumber() + " before clearing the previous one with seqId: " + this.prepareFlushResult.flushOpSeqId + ". Ignoring");
                        break block20;
                    }
                    if (flush.getFlushSequenceNumber() < this.prepareFlushResult.flushOpSeqId) {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush prepare marker with a smaller seqId: " + flush.getFlushSequenceNumber() + " before clearing the previous one with seqId: " + this.prepareFlushResult.flushOpSeqId + ". Ignoring");
                    } else {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush prepare marker with a larger seqId: " + flush.getFlushSequenceNumber() + " before clearing the previous one with seqId: " + this.prepareFlushResult.flushOpSeqId + ". Ignoring");
                    }
                }
                finally {
                    status.cleanup();
                    this.writestate.notifyAll();
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @SuppressWarnings(value={"NN_NAKED_NOTIFY"}, justification="Intentional; post memstore flush")
    void replayWALFlushCommitMarker(WALProtos.FlushDescriptor flush) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Committing flush " + this);
        Object object = this.writestate;
        synchronized (object) {
            try {
                if (flush.getFlushSequenceNumber() < this.lastReplayedOpenRegionSeqId) {
                    LOG.warn(this.getRegionInfo().getEncodedName() + " : Skipping replaying flush event :" + TextFormat.shortDebugString(flush) + " because its sequence id is smaller than this regions lastReplayedOpenRegionSeqId  of " + this.lastReplayedOpenRegionSeqId);
                    return;
                }
                if (this.writestate.flushing) {
                    PrepareFlushResult prepareFlushResult = this.prepareFlushResult;
                    if (flush.getFlushSequenceNumber() == prepareFlushResult.flushOpSeqId) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(this.getRegionInfo().getEncodedName() + " : Received a flush commit marker with seqId:" + flush.getFlushSequenceNumber() + " and a previous prepared snapshot was found");
                        }
                        this.replayFlushInStores(flush, prepareFlushResult, true);
                        this.decrMemStoreSize(prepareFlushResult.totalFlushableSize.getMemStoreSize());
                        this.prepareFlushResult = null;
                        this.writestate.flushing = false;
                    } else if (flush.getFlushSequenceNumber() < prepareFlushResult.flushOpSeqId) {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush commit marker with smaller seqId: " + flush.getFlushSequenceNumber() + " than what we have prepared with seqId: " + prepareFlushResult.flushOpSeqId + ". Picking up new file, but not dropping  prepared memstore snapshot");
                        this.replayFlushInStores(flush, prepareFlushResult, false);
                    } else {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush commit marker with larger seqId: " + flush.getFlushSequenceNumber() + " than what we have prepared with seqId: " + prepareFlushResult.flushOpSeqId + ". Picking up new file and dropping prepared memstore snapshot");
                        this.replayFlushInStores(flush, prepareFlushResult, true);
                        this.decrMemStoreSize(prepareFlushResult.totalFlushableSize.getMemStoreSize());
                        this.dropMemStoreContentsForSeqId(flush.getFlushSequenceNumber(), null);
                        this.prepareFlushResult = null;
                        this.writestate.flushing = false;
                    }
                    this.setReadsEnabled(true);
                } else {
                    LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush commit marker with seqId:" + flush.getFlushSequenceNumber() + ", but no previous prepared snapshot was found");
                    this.replayFlushInStores(flush, null, false);
                    this.dropMemStoreContentsForSeqId(flush.getFlushSequenceNumber(), null);
                }
                status.markComplete("Flush commit successful");
                this.maxFlushedSeqId = flush.getFlushSequenceNumber();
                this.mvcc.advanceTo(flush.getFlushSequenceNumber());
            }
            catch (FileNotFoundException ex) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : At least one of the store files in flush: " + TextFormat.shortDebugString(flush) + " doesn't exist any more. Skip loading the file(s)", (Throwable)ex);
            }
            finally {
                status.cleanup();
                this.writestate.notifyAll();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    private void replayFlushInStores(WALProtos.FlushDescriptor flush, PrepareFlushResult prepareFlushResult, boolean dropMemstoreSnapshot) throws IOException {
        for (WALProtos.FlushDescriptor.StoreFlushDescriptor storeFlush : flush.getStoreFlushesList()) {
            byte[] family = storeFlush.getFamilyName().toByteArray();
            HStore store = this.getStore(family);
            if (store == null) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a flush commit marker from primary, but the family is not found.Ignoring StoreFlushDescriptor:" + storeFlush);
                continue;
            }
            ProtocolStringList flushFiles = storeFlush.getFlushOutputList();
            StoreFlushContext ctx = null;
            long startTime = EnvironmentEdgeManager.currentTime();
            if (prepareFlushResult == null || prepareFlushResult.storeFlushCtxs == null) {
                ctx = store.createFlushContext(flush.getFlushSequenceNumber(), FlushLifeCycleTracker.DUMMY);
            } else {
                ctx = prepareFlushResult.storeFlushCtxs.get(family);
                startTime = prepareFlushResult.startTime;
            }
            if (ctx == null) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : Unexpected: flush commit marker received from store " + Bytes.toString(family) + " but no associated flush context. Ignoring");
                continue;
            }
            ctx.replayFlush(flushFiles, dropMemstoreSnapshot);
            this.lastStoreFlushTimeMap.put(store, startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemStoreSize dropMemStoreContents() throws IOException {
        NonThreadSafeMemStoreSizing totalFreedSize = new NonThreadSafeMemStoreSizing();
        this.updatesLock.writeLock().lock();
        try {
            for (HStore s : this.stores.values()) {
                MemStoreSize memStoreSize = this.doDropStoreMemStoreContentsForSeqId(s, -1L);
                LOG.info("Drop memstore for Store " + s.getColumnFamilyName() + " in region " + this.getRegionInfo().getRegionNameAsString() + " , dropped memstoresize: [" + memStoreSize + " }");
                totalFreedSize.incMemStoreSize(memStoreSize);
            }
            MemStoreSize memStoreSize = totalFreedSize.getMemStoreSize();
            return memStoreSize;
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemStoreSize dropMemStoreContentsForSeqId(long seqId, HStore store) throws IOException {
        NonThreadSafeMemStoreSizing totalFreedSize = new NonThreadSafeMemStoreSizing();
        this.updatesLock.writeLock().lock();
        try {
            long currentSeqId = this.mvcc.getReadPoint();
            if (seqId >= currentSeqId) {
                LOG.info(this.getRegionInfo().getEncodedName() + " : Dropping memstore contents as well since replayed flush seqId: " + seqId + " is greater than current seqId:" + currentSeqId);
                if (store == null) {
                    for (HStore s : this.stores.values()) {
                        totalFreedSize.incMemStoreSize(this.doDropStoreMemStoreContentsForSeqId(s, currentSeqId));
                    }
                } else {
                    totalFreedSize.incMemStoreSize(this.doDropStoreMemStoreContentsForSeqId(store, currentSeqId));
                }
            } else {
                LOG.info(this.getRegionInfo().getEncodedName() + " : Not dropping memstore contents since replayed flush seqId: " + seqId + " is smaller than current seqId:" + currentSeqId);
            }
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
        return totalFreedSize.getMemStoreSize();
    }

    private MemStoreSize doDropStoreMemStoreContentsForSeqId(HStore s, long currentSeqId) throws IOException {
        MemStoreSize flushableSize = s.getFlushableSize();
        this.decrMemStoreSize(flushableSize);
        StoreFlushContext ctx = s.createFlushContext(currentSeqId, FlushLifeCycleTracker.DUMMY);
        ctx.prepare();
        ctx.abort();
        return flushableSize;
    }

    private void replayWALFlushAbortMarker(WALProtos.FlushDescriptor flush) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayWALFlushCannotFlushMarker(WALProtos.FlushDescriptor flush, long replaySeqId) {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.lastReplayedOpenRegionSeqId > replaySeqId) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : Skipping replaying flush event :" + TextFormat.shortDebugString(flush) + " because its sequence id " + replaySeqId + " is smaller than this regions lastReplayedOpenRegionSeqId of " + this.lastReplayedOpenRegionSeqId);
                return;
            }
            this.setReadsEnabled(true);
        }
    }

    @VisibleForTesting
    PrepareFlushResult getPrepareFlushResult() {
        return this.prepareFlushResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NN_NAKED_NOTIFY"}, justification="Intentional; cleared the memstore")
    void replayWALRegionEventMarker(WALProtos.RegionEventDescriptor regionEvent) throws IOException {
        this.checkTargetRegion(regionEvent.getEncodedRegionName().toByteArray(), "RegionEvent marker from WAL ", regionEvent);
        this.startRegionOperation(Region.Operation.REPLAY_EVENT);
        try {
            if (ServerRegionReplicaUtil.isDefaultReplica(this.getRegionInfo())) {
                return;
            }
            if (regionEvent.getEventType() == WALProtos.RegionEventDescriptor.EventType.REGION_CLOSE) {
                return;
            }
            if (regionEvent.getEventType() != WALProtos.RegionEventDescriptor.EventType.REGION_OPEN) {
                LOG.warn(this.getRegionInfo().getEncodedName() + " : Unknown region event received, ignoring :" + TextFormat.shortDebugString(regionEvent));
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getRegionInfo().getEncodedName() + " : Replaying region open event marker " + TextFormat.shortDebugString(regionEvent));
            }
            WriteState writeState = this.writestate;
            synchronized (writeState) {
                if (this.lastReplayedOpenRegionSeqId > regionEvent.getLogSequenceNumber()) {
                    LOG.warn(this.getRegionInfo().getEncodedName() + " : Skipping replaying region event :" + TextFormat.shortDebugString(regionEvent) + " because its sequence id is smaller than this regions lastReplayedOpenRegionSeqId  of " + this.lastReplayedOpenRegionSeqId);
                    return;
                }
                this.lastReplayedOpenRegionSeqId = regionEvent.getLogSequenceNumber();
                for (WALProtos.StoreDescriptor storeDescriptor : regionEvent.getStoresList()) {
                    byte[] family = storeDescriptor.getFamilyName().toByteArray();
                    HStore store = this.getStore(family);
                    if (store == null) {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a region open marker from primary, but the family is not found. Ignoring. StoreDescriptor:" + storeDescriptor);
                        continue;
                    }
                    long storeSeqId = store.getMaxSequenceId().orElse(0L);
                    ProtocolStringList storeFiles = storeDescriptor.getStoreFileList();
                    try {
                        store.refreshStoreFiles(storeFiles);
                    }
                    catch (FileNotFoundException ex) {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : At least one of the store files: " + storeFiles + " doesn't exist any more. Skip loading the file(s)", (Throwable)ex);
                        continue;
                    }
                    if (store.getMaxSequenceId().orElse(0L) != storeSeqId) {
                        this.lastStoreFlushTimeMap.put(store, EnvironmentEdgeManager.currentTime());
                    }
                    if (this.writestate.flushing && this.prepareFlushResult.flushOpSeqId <= regionEvent.getLogSequenceNumber()) {
                        StoreFlushContext ctx;
                        StoreFlushContext storeFlushContext = ctx = this.prepareFlushResult.storeFlushCtxs == null ? null : this.prepareFlushResult.storeFlushCtxs.get(family);
                        if (ctx != null) {
                            MemStoreSize mss = store.getFlushableSize();
                            ctx.abort();
                            this.decrMemStoreSize(mss);
                            this.prepareFlushResult.storeFlushCtxs.remove(family);
                        }
                    }
                    this.dropMemStoreContentsForSeqId(regionEvent.getLogSequenceNumber(), store);
                    if (storeSeqId <= this.maxFlushedSeqId) continue;
                    this.maxFlushedSeqId = storeSeqId;
                }
                this.dropPrepareFlushIfPossible();
                this.mvcc.await();
                this.setReadsEnabled(true);
                HRegion hRegion = this;
                synchronized (hRegion) {
                    this.notifyAll();
                }
            }
            this.logRegionFiles();
        }
        finally {
            this.closeRegionOperation(Region.Operation.REPLAY_EVENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replayWALBulkLoadEventMarker(WALProtos.BulkLoadDescriptor bulkLoadEvent) throws IOException {
        this.checkTargetRegion(bulkLoadEvent.getEncodedRegionName().toByteArray(), "BulkLoad marker from WAL ", bulkLoadEvent);
        if (ServerRegionReplicaUtil.isDefaultReplica(this.getRegionInfo())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getRegionInfo().getEncodedName() + " : Replaying bulkload event marker " + TextFormat.shortDebugString(bulkLoadEvent));
        }
        boolean multipleFamilies = false;
        byte[] family = null;
        for (WALProtos.StoreDescriptor storeDescriptor : bulkLoadEvent.getStoresList()) {
            byte[] fam = storeDescriptor.getFamilyName().toByteArray();
            if (family == null) {
                family = fam;
                continue;
            }
            if (Bytes.equals(family, fam)) continue;
            multipleFamilies = true;
            break;
        }
        this.startBulkRegionOperation(multipleFamilies);
        try {
            WriteState writeState = this.writestate;
            synchronized (writeState) {
                block18: {
                    if (bulkLoadEvent.getBulkloadSeqNum() < 0L || this.lastReplayedOpenRegionSeqId < bulkLoadEvent.getBulkloadSeqNum()) break block18;
                    LOG.warn(this.getRegionInfo().getEncodedName() + " : Skipping replaying bulkload event :" + TextFormat.shortDebugString(bulkLoadEvent) + " because its sequence id is smaller than this region's lastReplayedOpenRegionSeqId =" + this.lastReplayedOpenRegionSeqId);
                    return;
                }
                for (WALProtos.StoreDescriptor storeDescriptor : bulkLoadEvent.getStoresList()) {
                    family = storeDescriptor.getFamilyName().toByteArray();
                    HStore store = this.getStore(family);
                    if (store == null) {
                        LOG.warn(this.getRegionInfo().getEncodedName() + " : Received a bulk load marker from primary, but the family is not found. Ignoring. StoreDescriptor:" + storeDescriptor);
                        continue;
                    }
                    ProtocolStringList storeFiles = storeDescriptor.getStoreFileList();
                    for (String storeFile : storeFiles) {
                        StoreFileInfo storeFileInfo = null;
                        try {
                            storeFileInfo = this.fs.getStoreFileInfo(Bytes.toString(family), storeFile);
                            store.bulkLoadHFile(storeFileInfo);
                        }
                        catch (FileNotFoundException ex) {
                            LOG.warn(this.getRegionInfo().getEncodedName() + " : " + (storeFileInfo != null ? storeFileInfo.toString() : new Path(Bytes.toString(family), storeFile).toString()) + " doesn't exist any more. Skip loading the file");
                        }
                    }
                }
            }
            if (bulkLoadEvent.getBulkloadSeqNum() > 0L) {
                this.mvcc.advanceTo(bulkLoadEvent.getBulkloadSeqNum());
            }
        }
        finally {
            this.closeBulkRegionOperation();
        }
    }

    private void dropPrepareFlushIfPossible() {
        if (this.writestate.flushing) {
            boolean canDrop = true;
            if (this.prepareFlushResult.storeFlushCtxs != null) {
                for (Map.Entry<byte[], StoreFlushContext> entry : this.prepareFlushResult.storeFlushCtxs.entrySet()) {
                    HStore store = this.getStore(entry.getKey());
                    if (store == null || store.getSnapshotSize().getDataSize() <= 0L) continue;
                    canDrop = false;
                    break;
                }
            }
            if (canDrop) {
                this.writestate.flushing = false;
                this.prepareFlushResult = null;
            }
        }
    }

    @Override
    public boolean refreshStoreFiles() throws IOException {
        return this.refreshStoreFiles(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NN_NAKED_NOTIFY"}, justification="Notify is about post replay. Intentional")
    protected boolean refreshStoreFiles(boolean force) throws IOException {
        if (!force && ServerRegionReplicaUtil.isDefaultReplica(this.getRegionInfo())) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getRegionInfo().getEncodedName() + " : Refreshing store files to see whether we can free up memstore");
        }
        long totalFreedDataSize = 0L;
        long smallestSeqIdInStores = Long.MAX_VALUE;
        this.startRegionOperation();
        try {
            HashMap<HStore, Long> map = new HashMap<HStore, Long>();
            Iterator iterator = this.writestate;
            synchronized (iterator) {
                for (HStore store : this.stores.values()) {
                    long maxSeqIdBefore = store.getMaxSequenceId().orElse(0L);
                    store.refreshStoreFiles();
                    long storeSeqId = store.getMaxSequenceId().orElse(0L);
                    if (storeSeqId < smallestSeqIdInStores) {
                        smallestSeqIdInStores = storeSeqId;
                    }
                    if (storeSeqId <= maxSeqIdBefore) continue;
                    if (this.writestate.flushing && this.prepareFlushResult.flushOpSeqId <= storeSeqId) {
                        StoreFlushContext ctx;
                        StoreFlushContext storeFlushContext = ctx = this.prepareFlushResult.storeFlushCtxs == null ? null : this.prepareFlushResult.storeFlushCtxs.get(store.getColumnFamilyDescriptor().getName());
                        if (ctx != null) {
                            MemStoreSize mss = store.getFlushableSize();
                            ctx.abort();
                            this.decrMemStoreSize(mss);
                            this.prepareFlushResult.storeFlushCtxs.remove(store.getColumnFamilyDescriptor().getName());
                            totalFreedDataSize += mss.getDataSize();
                        }
                    }
                    map.put(store, storeSeqId);
                }
                this.dropPrepareFlushIfPossible();
                for (HStore s : this.stores.values()) {
                    this.mvcc.advanceTo(s.getMaxMemStoreTS().orElse(0L));
                }
                if (this.lastReplayedOpenRegionSeqId < smallestSeqIdInStores) {
                    this.lastReplayedOpenRegionSeqId = smallestSeqIdInStores;
                }
            }
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    totalFreedDataSize += this.dropMemStoreContentsForSeqId((Long)entry.getValue(), (HStore)entry.getKey()).getDataSize();
                }
            }
            iterator = this;
            synchronized (iterator) {
                this.notifyAll();
            }
            boolean bl = totalFreedDataSize > 0L;
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    private void logRegionFiles() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.getRegionInfo().getEncodedName() + " : Store files for region: ");
            this.stores.values().stream().filter(s -> s.getStorefiles() != null).flatMap(s -> s.getStorefiles().stream()).forEachOrdered(sf -> LOG.trace(this.getRegionInfo().getEncodedName() + " : " + sf));
        }
    }

    private void checkTargetRegion(byte[] encodedRegionName, String exceptionMsg, Object payload) throws WrongRegionException {
        if (Bytes.equals(this.getRegionInfo().getEncodedNameAsBytes(), encodedRegionName)) {
            return;
        }
        if (!RegionReplicaUtil.isDefaultReplica(this.getRegionInfo()) && Bytes.equals(encodedRegionName, this.fs.getRegionInfoForFS().getEncodedNameAsBytes())) {
            return;
        }
        throw new WrongRegionException(exceptionMsg + payload + " targetted for region " + Bytes.toStringBinary(encodedRegionName) + " does not match this region: " + this.getRegionInfo());
    }

    @VisibleForTesting
    protected void restoreEdit(HStore s, Cell cell, MemStoreSizing memstoreAccounting) {
        s.add(cell, memstoreAccounting);
    }

    private static boolean isZeroLengthThenDelete(FileSystem fs, Path p) throws IOException {
        FileStatus stat = fs.getFileStatus(p);
        if (stat.getLen() > 0L) {
            return false;
        }
        LOG.warn("File " + p + " is zero-length, deleting.");
        fs.delete(p, false);
        return true;
    }

    protected HStore instantiateHStore(ColumnFamilyDescriptor family, boolean warmup) throws IOException {
        if (family.isMobEnabled()) {
            if (HFile.getFormatVersion(this.conf) < 3) {
                throw new IOException("A minimum HFile version of 3 is required for MOB feature. Consider setting hfile.format.version accordingly.");
            }
            return new HMobStore(this, family, this.conf, warmup);
        }
        return new HStore(this, family, this.conf, warmup);
    }

    @Override
    public HStore getStore(byte[] column) {
        return this.stores.get(column);
    }

    private HStore getStore(Cell cell) {
        return this.stores.entrySet().stream().filter(e -> CellUtil.matchingFamily(cell, (byte[])e.getKey())).map(e -> (HStore)e.getValue()).findFirst().orElse(null);
    }

    public List<HStore> getStores() {
        return new ArrayList<HStore>(this.stores.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoreFileList(byte[][] columns) throws IllegalArgumentException {
        ArrayList<String> storeFileNames = new ArrayList<String>();
        Object object = this.closeLock;
        synchronized (object) {
            for (byte[] column : columns) {
                HStore store = this.stores.get(column);
                if (store == null) {
                    throw new IllegalArgumentException("No column family : " + new String(column, StandardCharsets.UTF_8) + " available");
                }
                Collection<HStoreFile> storeFiles = store.getStorefiles();
                if (storeFiles == null) continue;
                for (HStoreFile storeFile : storeFiles) {
                    storeFileNames.add(storeFile.getPath().toString());
                }
                this.logRegionFiles();
            }
        }
        return storeFileNames;
    }

    void checkRow(byte[] row, String op) throws IOException {
        if (!HRegion.rowIsInRange(this.getRegionInfo(), row)) {
            throw new WrongRegionException("Requested row out of range for " + op + " on HRegion " + this + ", startKey='" + Bytes.toStringBinary(this.getRegionInfo().getStartKey()) + "', getEndKey()='" + Bytes.toStringBinary(this.getRegionInfo().getEndKey()) + "', row='" + Bytes.toStringBinary(row) + "'");
        }
    }

    public Region.RowLock getRowLock(byte[] row) throws IOException {
        return this.getRowLock(row, false);
    }

    @Override
    public Region.RowLock getRowLock(byte[] row, boolean readLock) throws IOException {
        this.checkRow(row, "row lock");
        return this.getRowLockInternal(row, readLock, null);
    }

    /*
     * Exception decompiling
     */
    protected Region.RowLock getRowLockInternal(byte[] row, boolean readLock, Region.RowLock prevRowLock) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void releaseRowLocks(List<Region.RowLock> rowLocks) {
        if (rowLocks != null) {
            for (Region.RowLock rowLock : rowLocks) {
                rowLock.release();
            }
            rowLocks.clear();
        }
    }

    @VisibleForTesting
    public int getReadLockCount() {
        return this.lock.getReadLockCount();
    }

    public ConcurrentHashMap<HashedBytes, RowLockContext> getLockedRows() {
        return this.lockedRows;
    }

    private static boolean hasMultipleColumnFamilies(Collection<Pair<byte[], String>> familyPaths) {
        boolean multipleFamilies = false;
        byte[] family = null;
        for (Pair<byte[], String> pair : familyPaths) {
            byte[] fam = pair.getFirst();
            if (family == null) {
                family = fam;
                continue;
            }
            if (Bytes.equals(family, fam)) continue;
            multipleFamilies = true;
            break;
        }
        return multipleFamilies;
    }

    public Map<byte[], List<Path>> bulkLoadHFiles(Collection<Pair<byte[], String>> familyPaths, boolean assignSeqId, BulkLoadListener bulkLoadListener) throws IOException {
        return this.bulkLoadHFiles(familyPaths, assignSeqId, bulkLoadListener, false, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], List<Path>> bulkLoadHFiles(Collection<Pair<byte[], String>> familyPaths, boolean assignSeqId, BulkLoadListener bulkLoadListener, boolean copyFile, List<String> clusterIds, boolean replicate) throws IOException {
        long seqId = -1L;
        TreeMap<byte[], List<Path>> storeFiles = new TreeMap<byte[], List<Path>>(Bytes.BYTES_COMPARATOR);
        HashMap<String, Long> storeFilesSizes = new HashMap<String, Long>();
        Preconditions.checkNotNull(familyPaths);
        this.startBulkRegionOperation(HRegion.hasMultipleColumnFamilies(familyPaths));
        boolean isSuccessful = false;
        try {
            byte[] familyName;
            this.writeRequestsCount.increment();
            IOException ioException = null;
            ArrayList<Pair<byte[], String>> failures = new ArrayList<Pair<byte[], String>>();
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = p.getFirst();
                String path = p.getSecond();
                HStore store = this.getStore(byArray);
                if (store == null) {
                    ioException = new DoNotRetryIOException("No such column family " + Bytes.toStringBinary(byArray));
                } else {
                    try {
                        store.assertBulkLoadHFileOk(new Path(path));
                    }
                    catch (WrongRegionException wre) {
                        failures.add(p);
                    }
                    catch (IOException ioe) {
                        ioException = ioe;
                    }
                }
                if (ioException == null) continue;
                LOG.error("There was IO error when checking if the bulk load is ok in region {}.", (Object)this, (Object)ioException);
                throw ioException;
            }
            if (failures.size() != 0) {
                StringBuilder list = new StringBuilder();
                for (Pair pair : failures) {
                    list.append("\n").append(Bytes.toString((byte[])pair.getFirst())).append(" : ").append((String)pair.getSecond());
                }
                LOG.warn("There was a recoverable bulk load failure likely due to a split. These (family, HFile) pairs were not loaded: {}, in region {}", (Object)list.toString(), (Object)this);
                Iterator<Object> iterator = null;
                return iterator;
            }
            if (assignSeqId) {
                FlushResultImpl fs = this.flushcache(true, false, FlushLifeCycleTracker.DUMMY);
                if (fs.isFlushSucceeded()) {
                    seqId = fs.flushSequenceId;
                } else if (fs.getResult() == FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY) {
                    seqId = fs.flushSequenceId;
                } else if (fs.getResult() == FlushResult.Result.CANNOT_FLUSH) {
                    this.waitForFlushes();
                } else {
                    throw new IOException("Could not bulk load with an assigned sequential ID because the flush didn't run. Reason for not flushing: " + fs.failureReason);
                }
            }
            TreeMap familyWithFinalPath = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (Pair pair : familyPaths) {
                familyName = (byte[])pair.getFirst();
                String path = (String)pair.getSecond();
                HStore store = this.getStore(familyName);
                if (!familyWithFinalPath.containsKey(familyName)) {
                    familyWithFinalPath.put(familyName, new ArrayList());
                }
                List lst = (List)familyWithFinalPath.get(familyName);
                try {
                    String finalPath = path;
                    if (bulkLoadListener != null) {
                        finalPath = bulkLoadListener.prepareBulkLoad(familyName, path, copyFile);
                    }
                    Pair<Path, Path> pair2 = store.preBulkLoadHFile(finalPath, seqId);
                    lst.add(pair2);
                }
                catch (IOException ioe) {
                    LOG.error("There was a partial failure due to IO when attempting to load " + Bytes.toString((byte[])pair.getFirst()) + " : " + (String)pair.getSecond(), (Throwable)ioe);
                    if (bulkLoadListener != null) {
                        try {
                            bulkLoadListener.failedBulkLoad(familyName, path);
                        }
                        catch (Exception ex) {
                            LOG.error("Error while calling failedBulkLoad for family " + Bytes.toString(familyName) + " with path " + path, (Throwable)ex);
                        }
                    }
                    throw ioe;
                }
            }
            if (this.getCoprocessorHost() != null) {
                for (Map.Entry entry : familyWithFinalPath.entrySet()) {
                    this.getCoprocessorHost().preCommitStoreFile((byte[])entry.getKey(), (List)entry.getValue());
                }
            }
            for (Map.Entry entry : familyWithFinalPath.entrySet()) {
                familyName = (byte[])entry.getKey();
                for (Pair p : (List)entry.getValue()) {
                    String path = ((Path)p.getFirst()).toString();
                    Path commitedStoreFile = (Path)p.getSecond();
                    HStore store = this.getStore(familyName);
                    try {
                        store.bulkLoadHFile(familyName, path, commitedStoreFile);
                        try {
                            FileSystem fs = commitedStoreFile.getFileSystem(this.baseConf);
                            storeFilesSizes.put(commitedStoreFile.getName(), fs.getFileStatus(commitedStoreFile).getLen());
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to find the size of hfile " + commitedStoreFile, (Throwable)e);
                            storeFilesSizes.put(commitedStoreFile.getName(), 0L);
                        }
                        if (storeFiles.containsKey(familyName)) {
                            ((List)storeFiles.get(familyName)).add(commitedStoreFile);
                        } else {
                            ArrayList<Path> storeFileNames = new ArrayList<Path>();
                            storeFileNames.add(commitedStoreFile);
                            storeFiles.put(familyName, storeFileNames);
                        }
                        if (bulkLoadListener == null) continue;
                        bulkLoadListener.doneBulkLoad(familyName, path);
                    }
                    catch (IOException ioe) {
                        LOG.error("There was a partial failure due to IO when attempting to load " + Bytes.toString(familyName) + " : " + p.getSecond(), (Throwable)ioe);
                        if (bulkLoadListener != null) {
                            try {
                                bulkLoadListener.failedBulkLoad(familyName, path);
                            }
                            catch (Exception ex) {
                                LOG.error("Error while calling failedBulkLoad for family " + Bytes.toString(familyName) + " with path " + path, (Throwable)ex);
                            }
                        }
                        throw ioe;
                    }
                }
            }
            isSuccessful = true;
        }
        finally {
            block48: {
                if (this.wal != null && !storeFiles.isEmpty()) {
                    try {
                        WALProtos.BulkLoadDescriptor bulkLoadDescriptor = ProtobufUtil.toBulkLoadDescriptor(this.getRegionInfo().getTable(), UnsafeByteOperations.unsafeWrap(this.getRegionInfo().getEncodedNameAsBytes()), storeFiles, storeFilesSizes, seqId, clusterIds, replicate);
                        WALUtil.writeBulkLoadMarkerAndSync(this.wal, this.getReplicationScope(), this.getRegionInfo(), bulkLoadDescriptor, this.mvcc);
                    }
                    catch (IOException iOException) {
                        if (this.rsServices == null) break block48;
                        isSuccessful = false;
                        this.rsServices.abort("Failed to write bulk load event into WAL.", iOException);
                    }
                }
            }
            this.closeBulkRegionOperation();
        }
        return isSuccessful ? storeFiles : null;
    }

    public boolean equals(Object o) {
        return o instanceof HRegion && Bytes.equals(this.getRegionInfo().getRegionName(), ((HRegion)o).getRegionInfo().getRegionName());
    }

    public int hashCode() {
        return Bytes.hashCode(this.getRegionInfo().getRegionName());
    }

    public String toString() {
        return this.getRegionInfo().getRegionNameAsString();
    }

    public static HRegion newHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration conf, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
        try {
            Class regionClass = conf.getClass("hbase.hregion.impl", HRegion.class);
            Constructor c = regionClass.getConstructor(Path.class, WAL.class, FileSystem.class, Configuration.class, RegionInfo.class, TableDescriptor.class, RegionServerServices.class);
            return (HRegion)c.newInstance(tableDir, wal, fs, conf, regionInfo, htd, rsServices);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not instantiate a region instance.", e);
        }
    }

    public static HRegion createHRegion(RegionInfo info, Path rootDir, Configuration conf, TableDescriptor hTableDescriptor, WAL wal, boolean initialize) throws IOException {
        LOG.info("creating " + info + ", tableDescriptor=" + (hTableDescriptor == null ? "null" : hTableDescriptor) + ", regionDir=" + rootDir);
        HRegion.createRegionDir(conf, info, rootDir);
        FileSystem fs = rootDir.getFileSystem(conf);
        Path tableDir = FSUtils.getTableDir(rootDir, info.getTable());
        HRegion region = HRegion.newHRegion(tableDir, wal, fs, conf, info, hTableDescriptor, null);
        if (initialize) {
            region.initialize(null);
        }
        return region;
    }

    public static HRegionFileSystem createRegionDir(Configuration configuration, RegionInfo ri, Path rootDir) throws IOException {
        FileSystem fs = rootDir.getFileSystem(configuration);
        Path tableDir = FSUtils.getTableDir(rootDir, ri.getTable());
        return HRegionFileSystem.createRegionOnFileSystem(configuration, fs, tableDir, ri);
    }

    public static HRegion createHRegion(RegionInfo info, Path rootDir, Configuration conf, TableDescriptor hTableDescriptor, WAL wal) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, wal, true);
    }

    public static HRegion openHRegion(RegionInfo info, TableDescriptor htd, WAL wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(RegionInfo info, TableDescriptor htd, WAL wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        return HRegion.openHRegion(FSUtils.getRootDir(conf), info, htd, wal, conf, rsServices, reporter);
    }

    public static HRegion openHRegion(Path rootDir, RegionInfo info, TableDescriptor htd, WAL wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(rootDir, info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(Path rootDir, RegionInfo info, TableDescriptor htd, WAL wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        FileSystem fs = null;
        if (rsServices != null) {
            fs = rsServices.getFileSystem();
        }
        if (fs == null) {
            fs = rootDir.getFileSystem(conf);
        }
        return HRegion.openHRegion(conf, fs, rootDir, info, htd, wal, rsServices, reporter);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, RegionInfo info, TableDescriptor htd, WAL wal) throws IOException {
        return HRegion.openHRegion(conf, fs, rootDir, info, htd, wal, null, null);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, RegionInfo info, TableDescriptor htd, WAL wal, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        Path tableDir = FSUtils.getTableDir(rootDir, info.getTable());
        return HRegion.openHRegion(conf, fs, rootDir, tableDir, info, htd, wal, rsServices, reporter);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, Path tableDir, RegionInfo info, TableDescriptor htd, WAL wal, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening region: " + info);
        }
        HRegion r = HRegion.newHRegion(tableDir, wal, fs, conf, info, htd, rsServices);
        return r.openHRegion(reporter);
    }

    @VisibleForTesting
    public NavigableMap<byte[], Integer> getReplicationScope() {
        return this.replicationScope;
    }

    public static HRegion openHRegion(HRegion other, CancelableProgressable reporter) throws IOException {
        HRegionFileSystem regionFs = other.getRegionFileSystem();
        HRegion r = HRegion.newHRegion(regionFs.getTableDir(), other.getWAL(), regionFs.getFileSystem(), other.baseConf, other.getRegionInfo(), other.getTableDescriptor(), null);
        return r.openHRegion(reporter);
    }

    public static Region openHRegion(Region other, CancelableProgressable reporter) throws IOException {
        return HRegion.openHRegion((HRegion)other, reporter);
    }

    protected HRegion openHRegion(CancelableProgressable reporter) throws IOException {
        try {
            TableDescriptorChecker.checkCompression(this.htableDescriptor);
            TableDescriptorChecker.checkEncryption(this.conf, this.htableDescriptor);
            TableDescriptorChecker.checkClassLoading(this.conf, this.htableDescriptor);
            this.openSeqNum = this.initialize(reporter);
            this.mvcc.advanceTo(this.openSeqNum);
            if (this.wal != null && this.getRegionServerServices() != null && RegionReplicaUtil.isDefaultReplica(this.getRegionInfo())) {
                this.writeRegionOpenMarker(this.wal, this.openSeqNum);
            }
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
        return this;
    }

    public static HRegion openReadOnlyFileSystemHRegion(Configuration conf, FileSystem fs, Path tableDir, RegionInfo info, TableDescriptor htd) throws IOException {
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening region (readOnly filesystem): " + info);
        }
        if (info.getReplicaId() <= 0) {
            info = RegionInfoBuilder.newBuilder(info).setReplicaId(1).build();
        }
        HRegion r = HRegion.newHRegion(tableDir, null, fs, conf, info, htd, null);
        r.writestate.setReadOnly(true);
        return r.openHRegion(null);
    }

    public static void warmupHRegion(RegionInfo info, TableDescriptor htd, WAL wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HRegion.Warming up region: " + info);
        }
        Path rootDir = FSUtils.getRootDir(conf);
        Path tableDir = FSUtils.getTableDir(rootDir, info.getTable());
        FileSystem fs = null;
        if (rsServices != null) {
            fs = rsServices.getFileSystem();
        }
        if (fs == null) {
            fs = rootDir.getFileSystem(conf);
        }
        HRegion r = HRegion.newHRegion(tableDir, wal, fs, conf, info, htd, null);
        r.initializeWarmup(reporter);
    }

    @Deprecated
    public static Path getRegionDir(Path tabledir, String name) {
        return new Path(tabledir, name);
    }

    public static boolean rowIsInRange(RegionInfo info, byte[] row) {
        return !(info.getStartKey().length != 0 && Bytes.compareTo(info.getStartKey(), row) > 0 || info.getEndKey().length != 0 && Bytes.compareTo(info.getEndKey(), row) <= 0);
    }

    public static boolean rowIsInRange(RegionInfo info, byte[] row, int offset, short length) {
        return !(info.getStartKey().length != 0 && Bytes.compareTo(info.getStartKey(), 0, info.getStartKey().length, row, offset, length) > 0 || info.getEndKey().length != 0 && Bytes.compareTo(info.getEndKey(), 0, info.getEndKey().length, row, offset, length) <= 0);
    }

    @Override
    public Result get(Get get) throws IOException {
        boolean stale;
        this.prepareGet(get);
        List<Cell> results = this.get(get, true);
        boolean bl = stale = this.getRegionInfo().getReplicaId() != 0;
        return Result.create(results, get.isCheckExistenceOnly() ? Boolean.valueOf(!results.isEmpty()) : null, stale);
    }

    void prepareGet(Get get) throws IOException {
        this.checkRow(get.getRow(), "Get");
        if (get.hasFamilies()) {
            for (byte[] family : get.familySet()) {
                this.checkFamily(family);
            }
        } else {
            for (byte[] family : this.htableDescriptor.getColumnFamilyNames()) {
                get.addFamily(family);
            }
        }
    }

    @Override
    public List<Cell> get(Get get, boolean withCoprocessor) throws IOException {
        return this.get(get, withCoprocessor, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cell> get(Get get, boolean withCoprocessor, long nonceGroup, long nonce) throws IOException {
        ArrayList<Cell> results = new ArrayList<Cell>();
        long before = EnvironmentEdgeManager.currentTime();
        if (withCoprocessor && this.coprocessorHost != null && this.coprocessorHost.preGet(get, results)) {
            this.metricsUpdateForGet(results, before);
            return results;
        }
        Scan scan = new Scan(get);
        if (scan.getLoadColumnFamiliesOnDemandValue() == null) {
            scan.setLoadColumnFamiliesOnDemand(this.isLoadingCfsOnDemandDefault());
        }
        try (InternalScanner scanner = null;){
            scanner = this.getScanner(scan, null, nonceGroup, nonce);
            scanner.next(results);
        }
        if (withCoprocessor && this.coprocessorHost != null) {
            this.coprocessorHost.postGet(get, results);
        }
        this.metricsUpdateForGet(results, before);
        return results;
    }

    void metricsUpdateForGet(List<Cell> results, long before) {
        if (this.metricsRegion != null) {
            this.metricsRegion.updateGet(EnvironmentEdgeManager.currentTime() - before);
        }
    }

    @Override
    public void mutateRow(RowMutations rm) throws IOException {
        List<Mutation> m = rm.getMutations();
        this.batchMutate(m.toArray(new Mutation[m.size()]), true, 0L, 0L);
    }

    @Override
    public void mutateRowsWithLocks(Collection<Mutation> mutations, final Collection<byte[]> rowsToLock, long nonceGroup, long nonce) throws IOException {
        this.batchMutate(new MutationBatchOperation(this, mutations.toArray(new Mutation[mutations.size()]), true, nonceGroup, nonce){

            @Override
            public MiniBatchOperationInProgress<Mutation> lockRowsAndBuildMiniBatch(List<Region.RowLock> acquiredRowLocks) throws IOException {
                Region.RowLock prevRowLock = null;
                for (byte[] row : rowsToLock) {
                    try {
                        Region.RowLock rowLock = this.region.getRowLockInternal(row, false, prevRowLock);
                        if (rowLock == prevRowLock) continue;
                        acquiredRowLocks.add(rowLock);
                        prevRowLock = rowLock;
                    }
                    catch (IOException ioe) {
                        LOG.warn("Failed getting lock, row={}, in region {}", new Object[]{Bytes.toStringBinary(row), this, ioe});
                        throw ioe;
                    }
                }
                return this.createMiniBatch(this.size(), this.size());
            }
        });
    }

    public ClientProtos.RegionLoadStats getLoadStatistics() {
        float occupancy;
        if (!this.regionStatsEnabled) {
            return null;
        }
        ClientProtos.RegionLoadStats.Builder stats = ClientProtos.RegionLoadStats.newBuilder();
        stats.setMemStoreLoad((int)Math.min(100L, this.memStoreSizing.getMemStoreSize().getHeapSize() * 100L / this.memstoreFlushSize));
        if (this.rsServices.getHeapMemoryManager() != null && (occupancy = this.rsServices.getHeapMemoryManager().getHeapOccupancyPercent()) != -0.0f) {
            stats.setHeapOccupancy((int)(occupancy * 100.0f));
        }
        stats.setCompactionPressure((int)(this.rsServices.getCompactionPressure() * 100.0 > 100.0 ? 100.0 : this.rsServices.getCompactionPressure() * 100.0));
        return stats.build();
    }

    @Override
    public void processRowsWithLocks(RowProcessor<?, ?> processor) throws IOException {
        this.processRowsWithLocks(processor, this.rowProcessorTimeout, 0L, 0L);
    }

    @Override
    public void processRowsWithLocks(RowProcessor<?, ?> processor, long nonceGroup, long nonce) throws IOException {
        this.processRowsWithLocks(processor, this.rowProcessorTimeout, nonceGroup, nonce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRowsWithLocks(RowProcessor<?, ?> processor, long timeout, long nonceGroup, long nonce) throws IOException {
        for (byte[] row : processor.getRowsToLock()) {
            this.checkRow(row, "processRowsWithLocks");
        }
        if (!processor.readOnly()) {
            this.checkReadOnly();
        }
        this.checkResources();
        this.startRegionOperation();
        WALEdit walEdit = new WALEdit();
        this.preProcess(processor, walEdit);
        if (processor.readOnly()) {
            try {
                long now = EnvironmentEdgeManager.currentTime();
                this.doProcessRowWithTimeout(processor, now, this, null, null, timeout);
                processor.postProcess(this, walEdit, true);
            }
            finally {
                this.closeRegionOperation();
            }
            return;
        }
        boolean locked = false;
        ArrayList<Region.RowLock> acquiredRowLocks = null;
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        Collection<byte[]> rowsToLock = processor.getRowsToLock();
        MultiVersionConcurrencyControl.WriteEntry writeEntry = null;
        NonThreadSafeMemStoreSizing memstoreAccounting = new NonThreadSafeMemStoreSizing();
        try {
            boolean success = false;
            try {
                acquiredRowLocks = new ArrayList<Region.RowLock>(rowsToLock.size());
                Region.RowLock prevRowLock = null;
                for (byte[] row : rowsToLock) {
                    Region.RowLock rowLock = this.getRowLockInternal(row, false, prevRowLock);
                    if (rowLock == prevRowLock) continue;
                    acquiredRowLocks.add(rowLock);
                    prevRowLock = rowLock;
                }
                this.lock(this.updatesLock.readLock(), acquiredRowLocks.isEmpty() ? 1 : acquiredRowLocks.size());
                locked = true;
                long now = EnvironmentEdgeManager.currentTime();
                this.doProcessRowWithTimeout(processor, now, this, mutations, walEdit, timeout);
                if (!mutations.isEmpty()) {
                    this.writeRequestsCount.add(mutations.size());
                    processor.preBatchMutate(this, walEdit);
                    writeEntry = !walEdit.isEmpty() ? this.doWALAppend(walEdit, this.getEffectiveDurability(processor.useDurability()), processor.getClusterIds(), now, nonceGroup, nonce) : this.mvcc.begin();
                    long sequenceId = writeEntry.getWriteNumber();
                    for (Mutation m : mutations) {
                        this.rewriteCellTags(m.getFamilyCellMap(), m);
                        CellScanner cellScanner = m.cellScanner();
                        while (cellScanner.advance()) {
                            Cell cell = cellScanner.current();
                            if (walEdit.isEmpty()) {
                                PrivateCellUtil.setSequenceId(cell, sequenceId);
                            }
                            this.applyToMemStore(this.getStore(cell), cell, memstoreAccounting);
                        }
                    }
                    processor.postBatchMutate(this);
                    this.mvcc.completeAndWait(writeEntry);
                    writeEntry = null;
                    if (locked) {
                        this.updatesLock.readLock().unlock();
                        locked = false;
                    }
                    this.releaseRowLocks(acquiredRowLocks);
                    if (this.rsServices != null && this.rsServices.getMetrics() != null) {
                        this.rsServices.getMetrics().updateWriteQueryMeter(this.htableDescriptor.getTableName(), mutations.size());
                    }
                }
                success = true;
            }
            finally {
                if (writeEntry != null) {
                    this.mvcc.complete(writeEntry);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                this.releaseRowLocks(acquiredRowLocks);
            }
            processor.postProcess(this, walEdit, success);
        }
        finally {
            this.closeRegionOperation();
            if (!mutations.isEmpty()) {
                this.incMemStoreSize(memstoreAccounting.getMemStoreSize());
                this.requestFlushIfNeeded();
            }
        }
    }

    private void preProcess(RowProcessor<?, ?> processor, WALEdit walEdit) throws IOException {
        try {
            processor.preProcess(this, walEdit);
        }
        catch (IOException e) {
            this.closeRegionOperation();
            throw e;
        }
    }

    private void doProcessRowWithTimeout(final RowProcessor<?, ?> processor, final long now, final HRegion region, final List<Mutation> mutations, final WALEdit walEdit, long timeout) throws IOException {
        if (timeout < 0L) {
            try {
                processor.process(now, region, mutations, walEdit);
            }
            catch (IOException e) {
                String row = processor.getRowsToLock().isEmpty() ? "" : " on row(s):" + Bytes.toStringBinary(processor.getRowsToLock().iterator().next()) + "...";
                LOG.warn("RowProcessor: {}, in region {}, throws Exception {}", new Object[]{processor.getClass().getName(), this.getRegionInfo().getRegionNameAsString(), row, e});
                throw e;
            }
            return;
        }
        FutureTask<Void> task = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                try {
                    processor.process(now, region, mutations, walEdit);
                    return null;
                }
                catch (IOException e) {
                    String row = processor.getRowsToLock().isEmpty() ? "" : " on row(s):" + Bytes.toStringBinary(processor.getRowsToLock().iterator().next()) + "...";
                    LOG.warn("RowProcessor: {}, in region {}, throws Exception {}", new Object[]{processor.getClass().getName(), HRegion.this.getRegionInfo().getRegionNameAsString(), row, e});
                    throw e;
                }
            }
        });
        this.rowProcessorExecutor.execute(task);
        try {
            task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            String row = processor.getRowsToLock().isEmpty() ? "" : " on row(s):" + Bytes.toStringBinary(processor.getRowsToLock().iterator().next()) + "...";
            LOG.error("RowProcessor timeout: {} ms, in region {}, {}", new Object[]{timeout, this.getRegionInfo().getRegionNameAsString(), row});
            throw new IOException(te);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Result append(Append append) throws IOException {
        return this.append(append, 0L, 0L);
    }

    public Result append(Append mutation, long nonceGroup, long nonce) throws IOException {
        return this.doDelta(Region.Operation.APPEND, mutation, nonceGroup, nonce, mutation.isReturnResults());
    }

    @Override
    public Result increment(Increment increment) throws IOException {
        return this.increment(increment, 0L, 0L);
    }

    public Result increment(Increment mutation, long nonceGroup, long nonce) throws IOException {
        return this.doDelta(Region.Operation.INCREMENT, mutation, nonceGroup, nonce, mutation.isReturnResults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result doDelta(Region.Operation op, Mutation mutation, long nonceGroup, long nonce, boolean returnResults) throws IOException {
        Result result;
        NonThreadSafeMemStoreSizing memstoreAccounting;
        Region.RowLock rowLock;
        block31: {
            this.checkReadOnly();
            this.checkResources();
            this.checkRow(mutation.getRow(), op.toString());
            this.checkFamilies(mutation.getFamilyCellMap().keySet());
            this.writeRequestsCount.increment();
            MultiVersionConcurrencyControl.WriteEntry writeEntry = null;
            this.startRegionOperation(op);
            ArrayList<Cell> results = returnResults ? new ArrayList<Cell>(mutation.size()) : null;
            rowLock = null;
            memstoreAccounting = new NonThreadSafeMemStoreSizing();
            try {
                block28: {
                    Result result2;
                    block29: {
                        rowLock = this.getRowLockInternal(mutation.getRow(), false, null);
                        this.lock(this.updatesLock.readLock());
                        Result cpResult = this.doCoprocessorPreCall(op, mutation);
                        if (cpResult == null) break block28;
                        result2 = returnResults ? cpResult : null;
                        this.updatesLock.readLock().unlock();
                        if (writeEntry == null) break block29;
                        this.mvcc.complete(writeEntry);
                    }
                    if (rowLock != null) {
                        rowLock.release();
                    }
                    this.incMemStoreSize(memstoreAccounting.getMemStoreSize());
                    this.requestFlushIfNeeded();
                    this.closeRegionOperation(op);
                    if (this.metricsRegion == null) return result2;
                    switch (op) {
                        case INCREMENT: {
                            this.metricsRegion.updateIncrement();
                            return result2;
                        }
                        case APPEND: {
                            this.metricsRegion.updateAppend();
                            return result2;
                        }
                    }
                    return result2;
                }
                Durability effectiveDurability = this.getEffectiveDurability(mutation.getDurability());
                HashMap<HStore, List<Cell>> forMemStore = new HashMap<HStore, List<Cell>>(mutation.getFamilyCellMap().size());
                WALEdit walEdit = this.reckonDeltas(op, mutation, effectiveDurability, forMemStore, results);
                if (walEdit != null && !walEdit.isEmpty()) {
                    writeEntry = this.doWALAppend(walEdit, effectiveDurability, nonceGroup, nonce);
                } else {
                    this.recordMutationWithoutWal(mutation.getFamilyCellMap());
                    writeEntry = this.mvcc.begin();
                    this.updateSequenceId(forMemStore.values(), writeEntry.getWriteNumber());
                }
                for (Map.Entry e : forMemStore.entrySet()) {
                    this.applyToMemStore((HStore)e.getKey(), (List)e.getValue(), true, memstoreAccounting);
                }
                this.mvcc.completeAndWait(writeEntry);
                if (this.rsServices != null && this.rsServices.getNonceManager() != null) {
                    this.rsServices.getNonceManager().addMvccToOperationContext(nonceGroup, nonce, writeEntry.getWriteNumber());
                }
                if (this.rsServices != null && this.rsServices.getMetrics() != null) {
                    this.rsServices.getMetrics().updateWriteQueryMeter(this.htableDescriptor.getTableName());
                }
                writeEntry = null;
                break block30;
            }
            catch (Throwable throwable) {
                if (writeEntry != null) {
                    this.mvcc.complete(writeEntry);
                }
                if (rowLock != null) {
                    rowLock.release();
                }
                this.incMemStoreSize(memstoreAccounting.getMemStoreSize());
                this.requestFlushIfNeeded();
                this.closeRegionOperation(op);
                if (this.metricsRegion == null) throw throwable;
                switch (op) {
                    case INCREMENT: {
                        this.metricsRegion.updateIncrement();
                        throw throwable;
                    }
                    case APPEND: {
                        this.metricsRegion.updateAppend();
                        throw throwable;
                    }
                }
                throw throwable;
            }
            {
                block30: {
                    finally {
                        this.updatesLock.readLock().unlock();
                    }
                }
                Result result2 = result = results != null && returnResults ? Result.create(results) : Result.EMPTY_RESULT;
                if (writeEntry == null) break block31;
                this.mvcc.complete(writeEntry);
            }
        }
        if (rowLock != null) {
            rowLock.release();
        }
        this.incMemStoreSize(memstoreAccounting.getMemStoreSize());
        this.requestFlushIfNeeded();
        this.closeRegionOperation(op);
        if (this.metricsRegion == null) return result;
        switch (op) {
            case INCREMENT: {
                this.metricsRegion.updateIncrement();
                return result;
            }
            case APPEND: {
                this.metricsRegion.updateAppend();
                return result;
            }
        }
        return result;
    }

    private MultiVersionConcurrencyControl.WriteEntry doWALAppend(WALEdit walEdit, Durability durability, long nonceGroup, long nonce) throws IOException {
        return this.doWALAppend(walEdit, durability, WALKey.EMPTY_UUIDS, System.currentTimeMillis(), nonceGroup, nonce);
    }

    private MultiVersionConcurrencyControl.WriteEntry doWALAppend(WALEdit walEdit, Durability durability, List<UUID> clusterIds, long now, long nonceGroup, long nonce) throws IOException {
        return this.doWALAppend(walEdit, durability, clusterIds, now, nonceGroup, nonce, -1L);
    }

    private MultiVersionConcurrencyControl.WriteEntry doWALAppend(WALEdit walEdit, Durability durability, List<UUID> clusterIds, long now, long nonceGroup, long nonce, long origLogSeqNum) throws IOException {
        WALKeyImpl walKey;
        Preconditions.checkArgument(walEdit != null && !walEdit.isEmpty(), "WALEdit is null or empty!");
        Preconditions.checkArgument(!walEdit.isReplay() || origLogSeqNum != -1L, "Invalid replay sequence Id for replay WALEdit!");
        WALKeyImpl wALKeyImpl = walKey = walEdit.isReplay() ? new WALKeyImpl(this.getRegionInfo().getEncodedNameAsBytes(), this.htableDescriptor.getTableName(), -1L, now, clusterIds, nonceGroup, nonce, this.mvcc) : new WALKeyImpl(this.getRegionInfo().getEncodedNameAsBytes(), this.htableDescriptor.getTableName(), -1L, now, clusterIds, nonceGroup, nonce, this.mvcc, this.getReplicationScope());
        if (walEdit.isReplay()) {
            walKey.setOrigLogSeqNum(origLogSeqNum);
        }
        MultiVersionConcurrencyControl.WriteEntry writeEntry = null;
        try {
            long txid = this.wal.appendData(this.getRegionInfo(), walKey, walEdit);
            if (txid != 0L) {
                this.sync(txid, durability);
            }
            writeEntry = walKey.getWriteEntry();
        }
        catch (IOException ioe) {
            if (walKey != null && walKey.getWriteEntry() != null) {
                this.mvcc.complete(walKey.getWriteEntry());
            }
            throw ioe;
        }
        return writeEntry;
    }

    private Result doCoprocessorPreCall(Region.Operation op, Mutation mutation) throws IOException {
        Result result = null;
        if (this.coprocessorHost != null) {
            switch (op) {
                case INCREMENT: {
                    result = this.coprocessorHost.preIncrementAfterRowLock((Increment)mutation);
                    break;
                }
                case APPEND: {
                    result = this.coprocessorHost.preAppendAfterRowLock((Append)mutation);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(op.toString());
                }
            }
        }
        return result;
    }

    private WALEdit reckonDeltas(Region.Operation op, Mutation mutation, Durability effectiveDurability, Map<HStore, List<Cell>> forMemStore, List<Cell> results) throws IOException {
        WALEdit walEdit = null;
        long now = EnvironmentEdgeManager.currentTime();
        boolean writeToWAL = effectiveDurability != Durability.SKIP_WAL;
        for (Map.Entry entry : mutation.getFamilyCellMap().entrySet()) {
            byte[] columnFamilyName = (byte[])entry.getKey();
            List deltas = (List)entry.getValue();
            List<Cell> toApply = this.reckonDeltasByStore(this.stores.get(columnFamilyName), op, mutation, effectiveDurability, now, deltas, results);
            if (toApply.isEmpty()) continue;
            for (Cell cell : toApply) {
                HStore store = this.getStore(cell);
                if (store == null) {
                    this.checkFamily(CellUtil.cloneFamily(cell));
                    continue;
                }
                forMemStore.computeIfAbsent(store, key -> new ArrayList()).add(cell);
            }
            if (!writeToWAL) continue;
            if (walEdit == null) {
                walEdit = new WALEdit();
            }
            walEdit.getCells().addAll(toApply);
        }
        return walEdit;
    }

    private List<Cell> reckonDeltasByStore(HStore store, Region.Operation op, Mutation mutation, Durability effectiveDurability, long now, List<Cell> deltas, List<Cell> results) throws IOException {
        byte[] columnFamily = store.getColumnFamilyDescriptor().getName();
        List<Pair<Cell, Cell>> cellPairs = new ArrayList<Pair<Cell, Cell>>(deltas.size());
        TimeRange tr = null;
        switch (op) {
            case INCREMENT: {
                tr = ((Increment)mutation).getTimeRange();
                break;
            }
            case APPEND: {
                tr = ((Append)mutation).getTimeRange();
                break;
            }
        }
        List<Cell> currentValues = this.get(mutation, store, deltas, null, tr);
        int currentValuesIndex = 0;
        for (int i = 0; i < deltas.size(); ++i) {
            int newCellSize;
            Cell delta = deltas.get(i);
            Cell currentValue = null;
            if (currentValuesIndex < currentValues.size() && CellUtil.matchingQualifier(currentValues.get(currentValuesIndex), delta)) {
                currentValue = currentValues.get(currentValuesIndex);
                if (i < deltas.size() - 1 && !CellUtil.matchingQualifier(delta, deltas.get(i + 1))) {
                    ++currentValuesIndex;
                }
            }
            Cell newCell = null;
            switch (op) {
                case INCREMENT: {
                    long deltaAmount = HRegion.getLongValue(delta);
                    long newValue = currentValue == null ? deltaAmount : HRegion.getLongValue(currentValue) + deltaAmount;
                    newCell = HRegion.reckonDelta(delta, currentValue, columnFamily, now, mutation, oldCell -> Bytes.toBytes(newValue));
                    break;
                }
                case APPEND: {
                    newCell = HRegion.reckonDelta(delta, currentValue, columnFamily, now, mutation, oldCell -> ByteBuffer.wrap(new byte[delta.getValueLength() + oldCell.getValueLength()]).put(oldCell.getValueArray(), oldCell.getValueOffset(), oldCell.getValueLength()).put(delta.getValueArray(), delta.getValueOffset(), delta.getValueLength()).array());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(op.toString());
                }
            }
            if (this.maxCellSize > 0L && (long)(newCellSize = PrivateCellUtil.estimatedSerializedSizeOf(newCell)) > this.maxCellSize) {
                String msg = "Cell with size " + newCellSize + " exceeds limit of " + this.maxCellSize + " bytes in region " + this;
                LOG.debug(msg);
                throw new DoNotRetryIOException(msg);
            }
            cellPairs.add(new Pair<Cell, Cell>(currentValue, newCell));
            if (results == null) continue;
            results.add(newCell);
        }
        if (this.coprocessorHost != null) {
            cellPairs = op == Region.Operation.INCREMENT ? this.coprocessorHost.postIncrementBeforeWAL(mutation, cellPairs) : this.coprocessorHost.postAppendBeforeWAL(mutation, cellPairs);
        }
        return cellPairs.stream().map(Pair::getSecond).collect(Collectors.toList());
    }

    private static Cell reckonDelta(Cell delta, Cell currentCell, byte[] columnFamily, long now, Mutation mutation, Function<Cell, byte[]> supplier) throws IOException {
        List<Tag> tags = TagUtil.carryForwardTags(delta);
        tags = TagUtil.carryForwardTTLTag(tags, mutation.getTTL());
        if (currentCell != null) {
            tags = TagUtil.carryForwardTags(tags, currentCell);
            byte[] newValue = supplier.apply(currentCell);
            return ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(mutation.getRow(), 0, mutation.getRow().length).setFamily(columnFamily, 0, columnFamily.length).setQualifier(CellUtil.cloneQualifier(delta)).setTimestamp(Math.max(currentCell.getTimestamp() + 1L, now)).setType(KeyValue.Type.Put.getCode()).setValue(newValue, 0, newValue.length).setTags(TagUtil.fromList(tags)).build();
        }
        PrivateCellUtil.updateLatestStamp(delta, now);
        return CollectionUtils.isEmpty(tags) ? delta : PrivateCellUtil.createCell(delta, tags);
    }

    private static long getLongValue(Cell cell) throws DoNotRetryIOException {
        int len = cell.getValueLength();
        if (len != 8) {
            throw new DoNotRetryIOException("Field is not a long, it's " + len + " bytes wide");
        }
        return PrivateCellUtil.getValueAsLong(cell);
    }

    private List<Cell> get(Mutation mutation, HStore store, List<Cell> coordinates, IsolationLevel isolation, TimeRange tr) throws IOException {
        HRegion.sort(coordinates, store.getComparator());
        Get get = new Get(mutation.getRow());
        if (isolation != null) {
            get.setIsolationLevel(isolation);
        }
        for (Cell cell : coordinates) {
            get.addColumn(store.getColumnFamilyDescriptor().getName(), CellUtil.cloneQualifier(cell));
        }
        if (tr != null) {
            get.setTimeRange(tr.getMin(), tr.getMax());
        }
        return this.get(get, false);
    }

    private static List<Cell> sort(List<Cell> cells, CellComparator comparator) {
        cells.sort(comparator);
        return cells;
    }

    void checkFamily(byte[] family) throws NoSuchColumnFamilyException {
        if (!this.htableDescriptor.hasColumnFamily(family)) {
            throw new NoSuchColumnFamilyException("Column family " + Bytes.toString(family) + " does not exist in region " + this + " in table " + this.htableDescriptor);
        }
    }

    @Override
    public long heapSize() {
        return DEEP_OVERHEAD + this.stores.values().stream().mapToLong(HStore::heapSize).sum();
    }

    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        String serviceName = CoprocessorRpcUtils.getServiceName(serviceDesc);
        if (this.coprocessorServiceHandlers.containsKey(serviceName)) {
            LOG.error("Coprocessor service {} already registered, rejecting request from {} in region {}", new Object[]{serviceName, instance, this});
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceName, instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered coprocessor service: region=" + Bytes.toStringBinary(this.getRegionInfo().getRegionName()) + " service=" + serviceName);
        }
        return true;
    }

    public Message execService(RpcController controller, ClientProtos.CoprocessorServiceCall call) throws IOException {
        IOException exception;
        String serviceName = call.getServiceName();
        Service service = this.coprocessorServiceHandlers.get(serviceName);
        if (service == null) {
            throw new UnknownProtocolException(null, "No registered coprocessor service found for " + serviceName + " in region " + Bytes.toStringBinary(this.getRegionInfo().getRegionName()));
        }
        Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
        String methodName = call.getMethodName();
        Descriptors.MethodDescriptor methodDesc = CoprocessorRpcUtils.getMethodDescriptor(methodName, serviceDesc);
        Message.Builder builder = service.getRequestPrototype(methodDesc).newBuilderForType();
        org.apache.hadoop.hbase.protobuf.ProtobufUtil.mergeFrom(builder, call.getRequest().toByteArray());
        Message request = CoprocessorRpcUtils.getRequest(service, methodDesc, call.getRequest());
        if (this.coprocessorHost != null) {
            request = this.coprocessorHost.preEndpointInvocation(service, methodName, request);
        }
        final Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
        service.callMethod(methodDesc, controller, request, new org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback<Message>(){

            @Override
            public void run(Message message) {
                if (message != null) {
                    responseBuilder.mergeFrom(message);
                }
            }
        });
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postEndpointInvocation(service, methodName, request, responseBuilder);
        }
        if ((exception = CoprocessorRpcUtils.getControllerException(controller)) != null) {
            throw exception;
        }
        return responseBuilder.build();
    }

    boolean shouldForceSplit() {
        return this.splitRequest;
    }

    byte[] getExplicitSplitPoint() {
        return this.explicitSplitPoint;
    }

    void forceSplit(byte[] sp) {
        this.splitRequest = true;
        if (sp != null) {
            this.explicitSplitPoint = sp;
        }
    }

    void clearSplit() {
        this.splitRequest = false;
        this.explicitSplitPoint = null;
    }

    public byte[] checkSplit() {
        if (this.getRegionInfo().isMetaRegion() || TableName.NAMESPACE_TABLE_NAME.equals(this.getRegionInfo().getTable())) {
            if (this.shouldForceSplit()) {
                LOG.warn("Cannot split meta region in HBase 0.20 and above");
            }
            return null;
        }
        if (this.isClosing()) {
            return null;
        }
        if (!this.splitPolicy.shouldSplit()) {
            return null;
        }
        byte[] ret = this.splitPolicy.getSplitPoint();
        if (ret != null) {
            try {
                this.checkRow(ret, "calculated split");
            }
            catch (IOException e) {
                LOG.error("Ignoring invalid split for region {}", (Object)this, (Object)e);
                return null;
            }
        }
        return ret;
    }

    public int getCompactPriority() {
        return this.stores.values().stream().mapToInt(HStore::getCompactPriority).min().orElse(Integer.MIN_VALUE);
    }

    public RegionCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    @VisibleForTesting
    public void setCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
        this.coprocessorHost = coprocessorHost;
    }

    @Override
    public void startRegionOperation() throws IOException {
        this.startRegionOperation(Region.Operation.ANY);
    }

    @Override
    public void startRegionOperation(Region.Operation op) throws IOException {
        switch (op) {
            case GET: 
            case SCAN: {
                this.checkReadsEnabled();
                break;
            }
        }
        if (op == Region.Operation.MERGE_REGION || op == Region.Operation.SPLIT_REGION || op == Region.Operation.COMPACT_REGION || op == Region.Operation.COMPACT_SWITCH) {
            return;
        }
        if (this.closing.get()) {
            throw new NotServingRegionException(this.getRegionInfo().getRegionNameAsString() + " is closing");
        }
        this.lock(this.lock.readLock());
        if (this.closed.get()) {
            this.lock.readLock().unlock();
            throw new NotServingRegionException(this.getRegionInfo().getRegionNameAsString() + " is closed");
        }
        if (op == Region.Operation.SNAPSHOT) {
            this.stores.values().forEach(HStore::preSnapshotOperation);
        }
        try {
            if (this.coprocessorHost != null) {
                this.coprocessorHost.postStartRegionOperation(op);
            }
        }
        catch (Exception e) {
            this.lock.readLock().unlock();
            throw new IOException(e);
        }
    }

    @Override
    public void closeRegionOperation() throws IOException {
        this.closeRegionOperation(Region.Operation.ANY);
    }

    @Override
    public void closeRegionOperation(Region.Operation operation) throws IOException {
        if (operation == Region.Operation.SNAPSHOT) {
            this.stores.values().forEach(HStore::postSnapshotOperation);
        }
        this.lock.readLock().unlock();
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postCloseRegionOperation(operation);
        }
    }

    private void startBulkRegionOperation(boolean writeLockNeeded) throws NotServingRegionException, RegionTooBusyException, InterruptedIOException {
        if (this.closing.get()) {
            throw new NotServingRegionException(this.getRegionInfo().getRegionNameAsString() + " is closing");
        }
        if (writeLockNeeded) {
            this.lock(this.lock.writeLock());
        } else {
            this.lock(this.lock.readLock());
        }
        if (this.closed.get()) {
            if (writeLockNeeded) {
                this.lock.writeLock().unlock();
            } else {
                this.lock.readLock().unlock();
            }
            throw new NotServingRegionException(this.getRegionInfo().getRegionNameAsString() + " is closed");
        }
    }

    private void closeBulkRegionOperation() {
        if (this.lock.writeLock().isHeldByCurrentThread()) {
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().unlock();
        }
    }

    private void recordMutationWithoutWal(Map<byte[], List<Cell>> familyMap) {
        this.numMutationsWithoutWAL.increment();
        if (this.numMutationsWithoutWAL.sum() <= 1L) {
            LOG.info("writing data to region " + this + " with WAL disabled. Data may be lost in the event of a crash.");
        }
        long mutationSize = 0L;
        for (List<Cell> cells : familyMap.values()) {
            assert (cells instanceof RandomAccess);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = cells.get(i);
                mutationSize += (long)cell.getSerializedSize();
            }
        }
        this.dataInMemoryWithoutWAL.add(mutationSize);
    }

    private void lock(Lock lock) throws RegionTooBusyException, InterruptedIOException {
        this.lock(lock, 1);
    }

    private void lock(Lock lock, int multiplier) throws RegionTooBusyException, InterruptedIOException {
        try {
            long waitTime = Math.min(this.maxBusyWaitDuration, this.busyWaitDuration * (long)Math.min(multiplier, this.maxBusyWaitMultiplier));
            if (!lock.tryLock(waitTime, TimeUnit.MILLISECONDS)) {
                throw new RegionTooBusyException("Failed to obtain lock; regionName=" + (this.getRegionInfo() == null ? "unknown" : this.getRegionInfo().getRegionNameAsString()) + ", server=" + (this.getRegionServerServices() == null ? "unknown" : this.getRegionServerServices().getServerName()));
            }
        }
        catch (InterruptedException ie) {
            LOG.info("Interrupted while waiting for a lock in region {}", (Object)this);
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(ie);
            throw iie;
        }
    }

    private void sync(long txid, Durability durability) throws IOException {
        if (this.getRegionInfo().isMetaRegion()) {
            this.wal.sync(txid);
        } else {
            switch (durability) {
                case USE_DEFAULT: {
                    if (!this.shouldSyncWAL()) break;
                    this.wal.sync(txid);
                    break;
                }
                case SKIP_WAL: {
                    break;
                }
                case ASYNC_WAL: {
                    break;
                }
                case SYNC_WAL: {
                    this.wal.sync(txid, false);
                    break;
                }
                case FSYNC_WAL: {
                    this.wal.sync(txid, true);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown durability " + (Object)((Object)durability));
                }
            }
        }
    }

    private boolean shouldSyncWAL() {
        return this.regionDurability.ordinal() > Durability.ASYNC_WAL.ordinal();
    }

    public long getOpenSeqNum() {
        return this.openSeqNum;
    }

    @Override
    public Map<byte[], Long> getMaxStoreSeqId() {
        return this.maxSeqIdInStores;
    }

    public long getOldestSeqIdOfStore(byte[] familyName) {
        return this.wal.getEarliestMemStoreSeqNum(this.getRegionInfo().getEncodedNameAsBytes(), familyName);
    }

    @Override
    public CompactionState getCompactionState() {
        boolean hasMinor;
        boolean hasMajor = this.majorInProgress.get() > 0;
        boolean bl = hasMinor = this.minorInProgress.get() > 0;
        return hasMajor ? (hasMinor ? CompactionState.MAJOR_AND_MINOR : CompactionState.MAJOR) : (hasMinor ? CompactionState.MINOR : CompactionState.NONE);
    }

    public void reportCompactionRequestStart(boolean isMajor) {
        (isMajor ? this.majorInProgress : this.minorInProgress).incrementAndGet();
    }

    public void reportCompactionRequestEnd(boolean isMajor, int numFiles, long filesSizeCompacted) {
        int newValue = (isMajor ? this.majorInProgress : this.minorInProgress).decrementAndGet();
        this.compactionsFinished.increment();
        this.compactionNumFilesCompacted.add(numFiles);
        this.compactionNumBytesCompacted.add(filesSizeCompacted);
        assert (newValue >= 0);
    }

    public void reportCompactionRequestFailure() {
        this.compactionsFailed.increment();
    }

    public void incrementCompactionsQueuedCount() {
        this.compactionsQueued.increment();
    }

    public void decrementCompactionsQueuedCount() {
        this.compactionsQueued.decrement();
    }

    public void incrementFlushesQueuedCount() {
        this.flushesQueued.increment();
    }

    @VisibleForTesting
    public long getReadPoint() {
        return this.getReadPoint(IsolationLevel.READ_COMMITTED);
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.storeHotnessProtector.update(conf);
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
        this.configurationManager = manager;
        this.stores.values().forEach(manager::registerObserver);
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
        this.stores.values().forEach(this.configurationManager::deregisterObserver);
    }

    @Override
    public CellComparator getCellComparator() {
        return this.getRegionInfo().isMetaRegion() ? CellComparatorImpl.META_COMPARATOR : CellComparatorImpl.COMPARATOR;
    }

    public long getMemStoreFlushSize() {
        return this.memstoreFlushSize;
    }

    void throwException(String title, String regionName) {
        StringBuilder buf = new StringBuilder();
        buf.append(title + ", ");
        buf.append(this.getRegionInfo().toString());
        buf.append(this.getRegionInfo().isMetaRegion() ? " meta region " : " ");
        buf.append("stores: ");
        for (HStore s : this.stores.values()) {
            buf.append(s.getColumnFamilyDescriptor().getNameAsString());
            buf.append(" size: ");
            buf.append(s.getMemStoreSize().getDataSize());
            buf.append(" ");
        }
        buf.append("end-of-stores");
        buf.append(", memstore size ");
        buf.append(this.getMemStoreDataSize());
        if (this.getRegionInfo().getRegionNameAsString().startsWith(regionName)) {
            throw new RuntimeException(buf.toString());
        }
    }

    @Override
    public void requestCompaction(String why, int priority, boolean major, CompactionLifeCycleTracker tracker) throws IOException {
        if (major) {
            this.stores.values().forEach(HStore::triggerMajorCompaction);
        }
        this.rsServices.getCompactionRequestor().requestCompaction(this, why, priority, tracker, RpcServer.getRequestUser().orElse(null));
    }

    @Override
    public void requestCompaction(byte[] family, String why, int priority, boolean major, CompactionLifeCycleTracker tracker) throws IOException {
        HStore store = this.stores.get(family);
        if (store == null) {
            throw new NoSuchColumnFamilyException("column family " + Bytes.toString(family) + " does not exist in region " + this.getRegionInfo().getRegionNameAsString());
        }
        if (major) {
            store.triggerMajorCompaction();
        }
        this.rsServices.getCompactionRequestor().requestCompaction(this, store, why, priority, tracker, RpcServer.getRequestUser().orElse(null));
    }

    private void requestFlushIfNeeded() throws RegionTooBusyException {
        if (this.isFlushSize(this.memStoreSizing.getMemStoreSize())) {
            this.requestFlush();
        }
    }

    private void requestFlush() {
        if (this.rsServices == null) {
            return;
        }
        this.requestFlush0(FlushLifeCycleTracker.DUMMY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFlush0(FlushLifeCycleTracker tracker) {
        boolean shouldFlush = false;
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (!this.writestate.isFlushRequested()) {
                shouldFlush = true;
                this.writestate.flushRequested = true;
            }
        }
        if (shouldFlush) {
            this.rsServices.getFlushRequester().requestFlush(this, false, tracker);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flush requested on " + this.getRegionInfo().getEncodedName());
            }
        } else {
            tracker.notExecuted("Flush already requested on " + this);
        }
    }

    @Override
    public void requestFlush(FlushLifeCycleTracker tracker) throws IOException {
        this.requestFlush0(tracker);
    }

    static void decorateRegionConfiguration(Configuration conf) {
        String replicationCoprocessorClass;
        String plugins;
        if (ReplicationUtils.isReplicationForBulkLoadDataEnabled(conf) && !(plugins = conf.get("hbase.coprocessor.region.classes", "")).contains(replicationCoprocessorClass = ReplicationObserver.class.getCanonicalName())) {
            conf.set("hbase.coprocessor.region.classes", (plugins.equals("") ? "" : plugins + ",") + replicationCoprocessorClass);
        }
    }

    @VisibleForTesting
    public void setReadRequestsCount(long readRequestsCount) {
        this.readRequestsCount.add(readRequestsCount);
    }

    @VisibleForTesting
    public void setWriteRequestsCount(long writeRequestsCount) {
        this.writeRequestsCount.add(writeRequestsCount);
    }

    private /* synthetic */ RowLockContext lambda$getRowLockInternal$9(HashedBytes rowKey) {
        return new RowLockContext(rowKey);
    }

    class RegionScannerImpl
    implements RegionScanner,
    Shipper,
    RpcCallback {
        KeyValueHeap storeHeap = null;
        KeyValueHeap joinedHeap = null;
        protected Cell joinedContinuationRow = null;
        private boolean filterClosed = false;
        protected final byte[] stopRow;
        protected final boolean includeStopRow;
        protected final HRegion region;
        protected final CellComparator comparator;
        private final long readPt;
        private final long maxResultSize;
        private final ScannerContext defaultScannerContext;
        private final FilterWrapper filter;

        @Override
        public RegionInfo getRegionInfo() {
            return this.region.getRegionInfo();
        }

        RegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
            this(scan, additionalScanners, region, 0L, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region, long nonceGroup, long nonce) throws IOException {
            this.region = region;
            this.maxResultSize = scan.getMaxResultSize();
            this.filter = scan.hasFilter() ? new FilterWrapper(scan.getFilter()) : null;
            this.comparator = region.getCellComparator();
            this.defaultScannerContext = ScannerContext.newBuilder().setBatchLimit(scan.getBatch()).build();
            this.stopRow = scan.getStopRow();
            this.includeStopRow = scan.includeStopRow();
            IsolationLevel isolationLevel = scan.getIsolationLevel();
            long mvccReadPoint = PackagePrivateFieldAccessor.getMvccReadPoint(scan);
            ConcurrentHashMap concurrentHashMap = HRegion.this.scannerReadPoints;
            synchronized (concurrentHashMap) {
                this.readPt = mvccReadPoint > 0L ? mvccReadPoint : (nonce == 0L || HRegion.this.rsServices == null || HRegion.this.rsServices.getNonceManager() == null ? HRegion.this.getReadPoint(isolationLevel) : HRegion.this.rsServices.getNonceManager().getMvccFromOperationContext(nonceGroup, nonce));
                HRegion.this.scannerReadPoints.put(this, this.readPt);
            }
            this.initializeScanners(scan, additionalScanners);
        }

        protected void initializeScanners(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(scan.getFamilyMap().size());
            ArrayList<KeyValueScanner> joinedScanners = new ArrayList<KeyValueScanner>(scan.getFamilyMap().size());
            ArrayList<KeyValueScanner> instantiatedScanners = new ArrayList<KeyValueScanner>();
            if (additionalScanners != null && !additionalScanners.isEmpty()) {
                scanners.addAll(additionalScanners);
                instantiatedScanners.addAll(additionalScanners);
            }
            try {
                for (Map.Entry<byte[], NavigableSet<byte[]>> entry : scan.getFamilyMap().entrySet()) {
                    HStore store = HRegion.this.stores.get(entry.getKey());
                    KeyValueScanner scanner = store.getScanner(scan, entry.getValue(), this.readPt);
                    instantiatedScanners.add(scanner);
                    if (this.filter == null || !scan.doLoadColumnFamiliesOnDemand() || this.filter.isFamilyEssential(entry.getKey())) {
                        scanners.add(scanner);
                        continue;
                    }
                    joinedScanners.add(scanner);
                }
                this.initializeKVHeap(scanners, joinedScanners, this.region);
            }
            catch (Throwable t) {
                throw this.handleException(instantiatedScanners, t);
            }
        }

        protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
            this.storeHeap = new KeyValueHeap(scanners, this.comparator);
            if (!joinedScanners.isEmpty()) {
                this.joinedHeap = new KeyValueHeap(joinedScanners, this.comparator);
            }
        }

        private IOException handleException(List<KeyValueScanner> instantiatedScanners, Throwable t) {
            HRegion.this.scannerReadPoints.remove(this);
            if (this.storeHeap != null) {
                this.storeHeap.close();
                this.storeHeap = null;
                if (this.joinedHeap != null) {
                    this.joinedHeap.close();
                    this.joinedHeap = null;
                }
            } else {
                for (KeyValueScanner scanner : instantiatedScanners) {
                    scanner.close();
                }
            }
            return t instanceof IOException ? (IOException)t : new IOException(t);
        }

        @Override
        public long getMaxResultSize() {
            return this.maxResultSize;
        }

        @Override
        public long getMvccReadPoint() {
            return this.readPt;
        }

        @Override
        public int getBatch() {
            return this.defaultScannerContext.getBatchLimit();
        }

        protected void resetFilters() throws IOException {
            if (this.filter != null) {
                this.filter.reset();
            }
        }

        @Override
        public boolean next(List<Cell> outResults) throws IOException {
            return this.next(outResults, this.defaultScannerContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean next(List<Cell> outResults, ScannerContext scannerContext) throws IOException {
            if (this.filterClosed) {
                throw new UnknownScannerException("Scanner was closed (timed out?) after we renewed it. Could be caused by a very slow scanner or a lengthy garbage collection");
            }
            HRegion.this.startRegionOperation(Region.Operation.SCAN);
            try {
                boolean bl = this.nextRaw(outResults, scannerContext);
                return bl;
            }
            finally {
                HRegion.this.closeRegionOperation(Region.Operation.SCAN);
            }
        }

        @Override
        public boolean nextRaw(List<Cell> outResults) throws IOException {
            return this.nextRaw(outResults, this.defaultScannerContext);
        }

        @Override
        public boolean nextRaw(List<Cell> outResults, ScannerContext scannerContext) throws IOException {
            if (this.storeHeap == null) {
                throw new UnknownScannerException("Scanner was closed");
            }
            boolean moreValues = false;
            if (outResults.isEmpty()) {
                moreValues = this.nextInternal(outResults, scannerContext);
            } else {
                ArrayList<Cell> tmpList = new ArrayList<Cell>();
                moreValues = this.nextInternal(tmpList, scannerContext);
                outResults.addAll(tmpList);
            }
            if (!outResults.isEmpty()) {
                HRegion.this.readRequestsCount.increment();
            }
            if (HRegion.this.rsServices != null && HRegion.this.rsServices.getMetrics() != null) {
                HRegion.this.rsServices.getMetrics().updateReadQueryMeter(this.getRegionInfo().getTable());
            }
            if (!scannerContext.mayHaveMoreCellsInRow()) {
                this.resetFilters();
            }
            if (this.isFilterDoneInternal()) {
                moreValues = false;
            }
            return moreValues;
        }

        private boolean populateFromJoinedHeap(List<Cell> results, ScannerContext scannerContext) throws IOException {
            assert (this.joinedContinuationRow != null);
            boolean moreValues = this.populateResult(results, this.joinedHeap, scannerContext, this.joinedContinuationRow);
            if (!scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                this.joinedContinuationRow = null;
            }
            HRegion.sort(results, this.comparator);
            return moreValues;
        }

        private boolean populateResult(List<Cell> results, KeyValueHeap heap, ScannerContext scannerContext, Cell currentRowCell) throws IOException {
            Cell nextKv;
            boolean moreCellsInRow = false;
            boolean tmpKeepProgress = scannerContext.getKeepProgress();
            ScannerContext.LimitScope limitScope = ScannerContext.LimitScope.BETWEEN_CELLS;
            do {
                scannerContext.setKeepProgress(true);
                heap.next(results, scannerContext);
                scannerContext.setKeepProgress(tmpKeepProgress);
                nextKv = heap.peek();
                moreCellsInRow = this.moreCellsInRow(nextKv, currentRowCell);
                if (!moreCellsInRow) {
                    this.incrementCountOfRowsScannedMetric(scannerContext);
                }
                if (moreCellsInRow && scannerContext.checkBatchLimit(limitScope)) {
                    return scannerContext.setScannerState(ScannerContext.NextState.BATCH_LIMIT_REACHED).hasMoreValues();
                }
                if (scannerContext.checkSizeLimit(limitScope)) {
                    ScannerContext.NextState state = moreCellsInRow ? ScannerContext.NextState.SIZE_LIMIT_REACHED_MID_ROW : ScannerContext.NextState.SIZE_LIMIT_REACHED;
                    return scannerContext.setScannerState(state).hasMoreValues();
                }
                if (!scannerContext.checkTimeLimit(limitScope)) continue;
                ScannerContext.NextState state = moreCellsInRow ? ScannerContext.NextState.TIME_LIMIT_REACHED_MID_ROW : ScannerContext.NextState.TIME_LIMIT_REACHED;
                return scannerContext.setScannerState(state).hasMoreValues();
            } while (moreCellsInRow);
            return nextKv != null;
        }

        private boolean moreCellsInRow(Cell nextKv, Cell currentRowCell) {
            return nextKv != null && CellUtil.matchingRows(nextKv, currentRowCell);
        }

        @Override
        public synchronized boolean isFilterDone() throws IOException {
            return this.isFilterDoneInternal();
        }

        private boolean isFilterDoneInternal() throws IOException {
            return this.filter != null && this.filter.filterAllRemaining();
        }

        private boolean nextInternal(List<Cell> results, ScannerContext scannerContext) throws IOException {
            boolean shouldStop;
            if (!results.isEmpty()) {
                throw new IllegalArgumentException("First parameter should be an empty list");
            }
            if (scannerContext == null) {
                throw new IllegalArgumentException("Scanner context cannot be null");
            }
            Optional<RpcCall> rpcCall = RpcServer.getCurrentCall();
            int initialBatchProgress = scannerContext.getBatchProgress();
            long initialSizeProgress = scannerContext.getDataSizeProgress();
            long initialHeapSizeProgress = scannerContext.getHeapSizeProgress();
            ScannerContext.LimitScope limitScope = ScannerContext.LimitScope.BETWEEN_CELLS;
            while (true) {
                boolean hasFilterRow;
                long afterTime;
                if (scannerContext.getKeepProgress()) {
                    scannerContext.setProgress(initialBatchProgress, initialSizeProgress, initialHeapSizeProgress);
                } else {
                    scannerContext.clearProgress();
                }
                if (rpcCall.isPresent() && (afterTime = rpcCall.get().disconnectSince()) >= 0L) {
                    throw new CallerDisconnectedException("Aborting on region " + this.getRegionInfo().getRegionNameAsString() + ", call " + this + " after " + afterTime + " ms, since caller disconnected");
                }
                Cell current = this.storeHeap.peek();
                shouldStop = this.shouldStop(current);
                boolean bl = hasFilterRow = this.filter != null && this.filter.hasFilterRow();
                if (hasFilterRow) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("filter#hasFilterRow is true which prevents partial results from being  formed. Changing scope of limits that may create partials");
                    }
                    scannerContext.setSizeLimitScope(ScannerContext.LimitScope.BETWEEN_ROWS);
                    scannerContext.setTimeLimitScope(ScannerContext.LimitScope.BETWEEN_ROWS);
                    limitScope = ScannerContext.LimitScope.BETWEEN_ROWS;
                }
                if (scannerContext.checkTimeLimit(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                    if (hasFilterRow) {
                        throw new IncompatibleFilterException("Filter whose hasFilterRow() returns true is incompatible with scans that must  stop mid-row because of a limit. ScannerContext:" + scannerContext);
                    }
                    return true;
                }
                if (this.joinedContinuationRow == null) {
                    boolean mayHaveData;
                    if (shouldStop) {
                        if (hasFilterRow) {
                            this.filter.filterRowCells(results);
                        }
                        return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                    }
                    if (this.filterRowKey(current)) {
                        this.incrementCountOfRowsFilteredMetric(scannerContext);
                        if (this.isFilterDoneInternal()) {
                            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        }
                        this.incrementCountOfRowsScannedMetric(scannerContext);
                        boolean moreRows = this.nextRow(scannerContext, current);
                        if (!moreRows) {
                            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        }
                        results.clear();
                        if (!scannerContext.checkTimeLimit(limitScope)) continue;
                        return true;
                    }
                    this.populateResult(results, this.storeHeap, scannerContext, current);
                    if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                        if (hasFilterRow) {
                            throw new IncompatibleFilterException("Filter whose hasFilterRow() returns true is incompatible with scans that must  stop mid-row because of a limit. ScannerContext:" + scannerContext);
                        }
                        return true;
                    }
                    Cell nextKv = this.storeHeap.peek();
                    shouldStop = this.shouldStop(nextKv);
                    boolean isEmptyRow = results.isEmpty();
                    FilterWrapper.FilterRowRetCode ret = FilterWrapper.FilterRowRetCode.NOT_CALLED;
                    if (hasFilterRow) {
                        ret = this.filter.filterRowCellsWithRet(results);
                        if (scannerContext.getKeepProgress()) {
                            scannerContext.setProgress(initialBatchProgress, initialSizeProgress, initialHeapSizeProgress);
                        } else {
                            scannerContext.clearProgress();
                        }
                        scannerContext.incrementBatchProgress(results.size());
                        for (Cell cell : results) {
                            scannerContext.incrementSizeProgress(PrivateCellUtil.estimatedSerializedSizeOf(cell), cell.heapSize());
                        }
                    }
                    if (isEmptyRow || ret == FilterWrapper.FilterRowRetCode.EXCLUDE || this.filterRow()) {
                        this.incrementCountOfRowsFilteredMetric(scannerContext);
                        results.clear();
                        boolean moreRows = this.nextRow(scannerContext, current);
                        if (!moreRows) {
                            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        }
                        if (!shouldStop) {
                            if (!scannerContext.checkTimeLimit(limitScope)) continue;
                            return true;
                        }
                        return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                    }
                    if (this.joinedHeap != null && (mayHaveData = this.joinedHeapMayHaveData(current))) {
                        this.joinedContinuationRow = current;
                        this.populateFromJoinedHeap(results, scannerContext);
                        if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                            return true;
                        }
                    }
                } else {
                    this.populateFromJoinedHeap(results, scannerContext);
                    if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                        return true;
                    }
                }
                if (this.joinedContinuationRow != null) {
                    return scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                }
                if (!results.isEmpty()) break;
                this.incrementCountOfRowsFilteredMetric(scannerContext);
                boolean moreRows = this.nextRow(scannerContext, current);
                if (!moreRows) {
                    return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                }
                if (shouldStop) break;
            }
            if (shouldStop) {
                return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
            }
            return scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
        }

        protected void incrementCountOfRowsFilteredMetric(ScannerContext scannerContext) {
            HRegion.this.filteredReadRequestsCount.increment();
            if (scannerContext == null || !scannerContext.isTrackingMetrics()) {
                return;
            }
            scannerContext.getMetrics().countOfRowsFiltered.incrementAndGet();
        }

        protected void incrementCountOfRowsScannedMetric(ScannerContext scannerContext) {
            if (scannerContext == null || !scannerContext.isTrackingMetrics()) {
                return;
            }
            scannerContext.getMetrics().countOfRowsScanned.incrementAndGet();
        }

        private boolean joinedHeapMayHaveData(Cell currentRowCell) throws IOException {
            Cell nextJoinedKv = this.joinedHeap.peek();
            boolean matchCurrentRow = nextJoinedKv != null && CellUtil.matchingRows(nextJoinedKv, currentRowCell);
            boolean matchAfterSeek = false;
            if (!matchCurrentRow) {
                Cell firstOnCurrentRow = PrivateCellUtil.createFirstOnRow(currentRowCell);
                boolean seekSuccessful = this.joinedHeap.requestSeek(firstOnCurrentRow, true, true);
                matchAfterSeek = seekSuccessful && this.joinedHeap.peek() != null && CellUtil.matchingRows(this.joinedHeap.peek(), currentRowCell);
            }
            return matchCurrentRow || matchAfterSeek;
        }

        private boolean filterRow() throws IOException {
            return this.filter != null && !this.filter.hasFilterRow() && this.filter.filterRow();
        }

        private boolean filterRowKey(Cell current) throws IOException {
            return this.filter != null && this.filter.filterRowKey(current);
        }

        protected boolean nextRow(ScannerContext scannerContext, Cell curRowCell) throws IOException {
            Cell next;
            assert (this.joinedContinuationRow == null) : "Trying to go to next row during joinedHeap read.";
            while ((next = this.storeHeap.peek()) != null && CellUtil.matchingRows(next, curRowCell)) {
                this.storeHeap.next(MOCKED_LIST);
            }
            this.resetFilters();
            return this.region.getCoprocessorHost() == null || this.region.getCoprocessorHost().postScannerFilterRow(this, curRowCell);
        }

        protected boolean shouldStop(Cell currentRowCell) {
            if (currentRowCell == null) {
                return true;
            }
            if (this.stopRow == null || Bytes.equals(this.stopRow, HConstants.EMPTY_END_ROW)) {
                return false;
            }
            int c = this.comparator.compareRows(currentRowCell, this.stopRow, 0, this.stopRow.length);
            return c > 0 || c == 0 && !this.includeStopRow;
        }

        @Override
        public synchronized void close() {
            if (this.storeHeap != null) {
                this.storeHeap.close();
                this.storeHeap = null;
            }
            if (this.joinedHeap != null) {
                this.joinedHeap.close();
                this.joinedHeap = null;
            }
            HRegion.this.scannerReadPoints.remove(this);
            this.filterClosed = true;
        }

        KeyValueHeap getStoreHeapForTesting() {
            return this.storeHeap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean reseek(byte[] row) throws IOException {
            if (row == null) {
                throw new IllegalArgumentException("Row cannot be null.");
            }
            boolean result = false;
            HRegion.this.startRegionOperation();
            Cell kv = PrivateCellUtil.createFirstOnRow(row, 0, (short)row.length);
            try {
                result = this.storeHeap.requestSeek(kv, true, true);
                if (this.joinedHeap != null) {
                    result = this.joinedHeap.requestSeek(kv, true, true) || result;
                }
            }
            finally {
                HRegion.this.closeRegionOperation();
            }
            return result;
        }

        @Override
        public void shipped() throws IOException {
            if (this.storeHeap != null) {
                this.storeHeap.shipped();
            }
            if (this.joinedHeap != null) {
                this.joinedHeap.shipped();
            }
        }

        @Override
        public void run() throws IOException {
            this.close();
        }
    }

    public static interface BulkLoadListener {
        public String prepareBulkLoad(byte[] var1, String var2, boolean var3) throws IOException;

        public void doneBulkLoad(byte[] var1, String var2) throws IOException;

        public void failedBulkLoad(byte[] var1, String var2) throws IOException;
    }

    public static class RowLockImpl
    implements Region.RowLock {
        private final RowLockContext context;
        private final Lock lock;

        public RowLockImpl(RowLockContext context, Lock lock) {
            this.context = context;
            this.lock = lock;
        }

        public Lock getLock() {
            return this.lock;
        }

        @VisibleForTesting
        public RowLockContext getContext() {
            return this.context;
        }

        @Override
        public void release() {
            this.lock.unlock();
            this.context.cleanUp();
        }

        public String toString() {
            return "RowLockImpl{context=" + this.context + ", lock=" + this.lock + '}';
        }
    }

    @VisibleForTesting
    class RowLockContext {
        private final HashedBytes row;
        final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        final AtomicBoolean usable = new AtomicBoolean(true);
        final AtomicInteger count = new AtomicInteger(0);
        final Object lock = new Object();
        private String threadName;

        RowLockContext(HashedBytes row) {
            this.row = row;
        }

        RowLockImpl newWriteLock() {
            Lock l = this.readWriteLock.writeLock();
            return this.getRowLock(l);
        }

        RowLockImpl newReadLock() {
            Lock l = this.readWriteLock.readLock();
            return this.getRowLock(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RowLockImpl getRowLock(Lock l) {
            this.count.incrementAndGet();
            Object object = this.lock;
            synchronized (object) {
                if (this.usable.get()) {
                    return new RowLockImpl(this, l);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanUp() {
            long c = this.count.decrementAndGet();
            if (c <= 0L) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.count.get() <= 0 && this.usable.get()) {
                        this.usable.set(false);
                        RowLockContext removed = (RowLockContext)HRegion.this.lockedRows.remove(this.row);
                        assert (removed == this) : "we should never remove a different context";
                    }
                }
            }
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public String toString() {
            return "RowLockContext{row=" + this.row + ", readWriteLock=" + this.readWriteLock + ", count=" + this.count + ", threadName=" + this.threadName + '}';
        }
    }

    static class ReplayBatchOperation
    extends BatchOperation<WALSplitUtil.MutationReplay> {
        private long origLogSeqNum = 0L;

        public ReplayBatchOperation(HRegion region, WALSplitUtil.MutationReplay[] operations, long origLogSeqNum) {
            super(region, operations);
            this.origLogSeqNum = origLogSeqNum;
        }

        @Override
        public Mutation getMutation(int index) {
            return ((WALSplitUtil.MutationReplay[])this.operations)[index].mutation;
        }

        @Override
        public long getNonceGroup(int index) {
            return ((WALSplitUtil.MutationReplay[])this.operations)[index].nonceGroup;
        }

        @Override
        public long getNonce(int index) {
            return ((WALSplitUtil.MutationReplay[])this.operations)[index].nonce;
        }

        @Override
        public Mutation[] getMutationsForCoprocs() {
            return null;
        }

        @Override
        public boolean isInReplay() {
            return true;
        }

        @Override
        public long getOrigLogSeqNum() {
            return this.origLogSeqNum;
        }

        @Override
        public void startRegionOperation() throws IOException {
            this.region.startRegionOperation(Region.Operation.REPLAY_BATCH_MUTATE);
        }

        @Override
        public void closeRegionOperation() throws IOException {
            this.region.closeRegionOperation(Region.Operation.REPLAY_BATCH_MUTATE);
        }

        @Override
        protected void checkAndPreparePut(Put p) throws IOException {
            NavigableMap<byte[], List<Cell>> familyCellMap = p.getFamilyCellMap();
            ArrayList<byte[]> nonExistentList = null;
            for (byte[] family : familyCellMap.keySet()) {
                if (this.region.htableDescriptor.hasColumnFamily(family)) continue;
                if (nonExistentList == null) {
                    nonExistentList = new ArrayList<byte[]>();
                }
                nonExistentList.add(family);
            }
            if (nonExistentList != null) {
                for (byte[] family : nonExistentList) {
                    LOG.info("No family for {} omit from reply in region {}.", (Object)Bytes.toString(family), (Object)this);
                    familyCellMap.remove(family);
                }
            }
        }

        @Override
        public void checkAndPrepare() throws IOException {
            long now = EnvironmentEdgeManager.currentTime();
            this.visitBatchOperations(true, this.size(), index -> {
                this.checkAndPrepareMutation(index, now);
                return true;
            });
        }

        @Override
        public void prepareMiniBatchOperations(MiniBatchOperationInProgress<Mutation> miniBatchOp, long timestamp, List<Region.RowLock> acquiredRowLocks) throws IOException {
            this.visitBatchOperations(true, miniBatchOp.getLastIndexExclusive(), index -> {
                for (List cells : this.getMutation(index).getFamilyCellMap().values()) {
                    miniBatchOp.addCellCount(cells.size());
                }
                return true;
            });
        }

        @Override
        public MultiVersionConcurrencyControl.WriteEntry writeMiniBatchOperationsToMemStore(MiniBatchOperationInProgress<Mutation> miniBatchOp, MultiVersionConcurrencyControl.WriteEntry writeEntry) throws IOException {
            super.writeMiniBatchOperationsToMemStore(miniBatchOp, this.getOrigLogSeqNum());
            return writeEntry;
        }

        @Override
        public void completeMiniBatchOperations(MiniBatchOperationInProgress<Mutation> miniBatchOp, MultiVersionConcurrencyControl.WriteEntry writeEntry) throws IOException {
            super.completeMiniBatchOperations(miniBatchOp, writeEntry);
            this.region.mvcc.advanceTo(this.getOrigLogSeqNum());
        }
    }

    static class MutationBatchOperation
    extends BatchOperation<Mutation> {
        private long nonceGroup;
        private long nonce;

        public MutationBatchOperation(HRegion region, Mutation[] operations, boolean atomic, long nonceGroup, long nonce) {
            super(region, operations);
            this.atomic = atomic;
            this.nonceGroup = nonceGroup;
            this.nonce = nonce;
        }

        @Override
        public Mutation getMutation(int index) {
            return ((Mutation[])this.operations)[index];
        }

        @Override
        public long getNonceGroup(int index) {
            return this.nonceGroup;
        }

        @Override
        public long getNonce(int index) {
            return this.nonce;
        }

        @Override
        public Mutation[] getMutationsForCoprocs() {
            return (Mutation[])this.operations;
        }

        @Override
        public boolean isInReplay() {
            return false;
        }

        @Override
        public long getOrigLogSeqNum() {
            return -1L;
        }

        @Override
        public void startRegionOperation() throws IOException {
            this.region.startRegionOperation(Region.Operation.BATCH_MUTATE);
        }

        @Override
        public void closeRegionOperation() throws IOException {
            this.region.closeRegionOperation(Region.Operation.BATCH_MUTATE);
        }

        @Override
        public void checkAndPreparePut(Put p) throws IOException {
            this.region.checkFamilies(p.getFamilyCellMap().keySet());
        }

        @Override
        public void checkAndPrepare() throws IOException {
            final int[] metrics = new int[]{0, 0};
            this.visitBatchOperations(true, this.size(), new BatchOperation.Visitor(){
                private long now = EnvironmentEdgeManager.currentTime();
                private WALEdit walEdit;

                @Override
                public boolean visit(int index) throws IOException {
                    if (region.coprocessorHost != null) {
                        if (this.walEdit == null) {
                            this.walEdit = new WALEdit();
                        }
                        this.callPreMutateCPHook(index, this.walEdit, metrics);
                        if (!this.walEdit.isEmpty()) {
                            walEditsFromCoprocessors[index] = this.walEdit;
                            this.walEdit = null;
                        }
                    }
                    if (this.isOperationPending(index)) {
                        this.checkAndPrepareMutation(index, this.now);
                    }
                    return true;
                }
            });
            if (this.region.metricsRegion != null) {
                if (metrics[0] > 0) {
                    this.region.metricsRegion.updatePut();
                }
                if (metrics[1] > 0) {
                    this.region.metricsRegion.updateDelete();
                }
            }
        }

        @Override
        public void prepareMiniBatchOperations(MiniBatchOperationInProgress<Mutation> miniBatchOp, long timestamp, List<Region.RowLock> acquiredRowLocks) throws IOException {
            byte[] byteTS = Bytes.toBytes(timestamp);
            this.visitBatchOperations(true, miniBatchOp.getLastIndexExclusive(), index -> {
                WALEdit fromCP;
                Mutation mutation = this.getMutation(index);
                if (mutation instanceof Put) {
                    HRegion.updateCellTimestamps(this.familyCellMaps[index].values(), byteTS);
                    miniBatchOp.incrementNumOfPuts();
                } else {
                    this.region.prepareDeleteTimestamps(mutation, this.familyCellMaps[index], byteTS);
                    miniBatchOp.incrementNumOfDeletes();
                }
                this.region.rewriteCellTags(this.familyCellMaps[index], mutation);
                if (this.region.getEffectiveDurability(mutation.getDurability()) != Durability.SKIP_WAL) {
                    for (List cells : mutation.getFamilyCellMap().values()) {
                        miniBatchOp.addCellCount(cells.size());
                    }
                }
                if ((fromCP = this.walEditsFromCoprocessors[index]) != null) {
                    miniBatchOp.addCellCount(fromCP.size());
                }
                return true;
            });
            if (this.region.coprocessorHost != null) {
                this.region.coprocessorHost.preBatchMutate(miniBatchOp);
                this.checkAndMergeCPMutations(miniBatchOp, acquiredRowLocks, timestamp);
            }
        }

        @Override
        public List<Pair<NonceKey, WALEdit>> buildWALEdits(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            List<Pair<NonceKey, WALEdit>> walEdits = super.buildWALEdits(miniBatchOp);
            if (walEdits.size() > 1) {
                throw new IOException("Found multiple nonce keys per batch!");
            }
            return walEdits;
        }

        @Override
        public MultiVersionConcurrencyControl.WriteEntry writeMiniBatchOperationsToMemStore(MiniBatchOperationInProgress<Mutation> miniBatchOp, @Nullable MultiVersionConcurrencyControl.WriteEntry writeEntry) throws IOException {
            if (writeEntry == null) {
                writeEntry = this.region.mvcc.begin();
            }
            super.writeMiniBatchOperationsToMemStore(miniBatchOp, writeEntry.getWriteNumber());
            return writeEntry;
        }

        @Override
        public void completeMiniBatchOperations(MiniBatchOperationInProgress<Mutation> miniBatchOp, MultiVersionConcurrencyControl.WriteEntry writeEntry) throws IOException {
            if (this.region.coprocessorHost != null) {
                this.region.coprocessorHost.postBatchMutate(miniBatchOp);
            }
            super.completeMiniBatchOperations(miniBatchOp, writeEntry);
        }

        @Override
        public void doPostOpCleanupForMiniBatch(MiniBatchOperationInProgress<Mutation> miniBatchOp, WALEdit walEdit, boolean success) throws IOException {
            super.doPostOpCleanupForMiniBatch(miniBatchOp, walEdit, success);
            if (miniBatchOp != null) {
                if (this.region.coprocessorHost != null) {
                    this.visitBatchOperations(false, miniBatchOp.getLastIndexExclusive(), i -> {
                        if (this.retCodeDetails[i].getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                            Mutation m = this.getMutation(i);
                            if (m instanceof Put) {
                                this.region.coprocessorHost.postPut((Put)m, walEdit, m.getDurability());
                            } else {
                                this.region.coprocessorHost.postDelete((Delete)m, walEdit, m.getDurability());
                            }
                        }
                        return true;
                    });
                }
                if (this.region.metricsRegion != null) {
                    if (miniBatchOp.getNumOfPuts() > 0) {
                        this.region.metricsRegion.updatePut();
                    }
                    if (miniBatchOp.getNumOfDeletes() > 0) {
                        this.region.metricsRegion.updateDelete();
                    }
                }
            }
            if (this.region.coprocessorHost != null) {
                this.region.coprocessorHost.postBatchMutateIndispensably(miniBatchOp != null ? miniBatchOp : this.createMiniBatch(this.size(), 0), success);
            }
        }

        private void callPreMutateCPHook(int index, WALEdit walEdit, int[] metrics) throws IOException {
            Mutation m = this.getMutation(index);
            if (m instanceof Put) {
                if (this.region.coprocessorHost.prePut((Put)m, walEdit, m.getDurability())) {
                    metrics[0] = metrics[0] + 1;
                    this.retCodeDetails[index] = OperationStatus.SUCCESS;
                }
            } else if (m instanceof Delete) {
                Delete curDel = (Delete)m;
                if (curDel.getFamilyCellMap().isEmpty()) {
                    this.region.prepareDelete(curDel);
                }
                if (this.region.coprocessorHost.preDelete(curDel, walEdit, m.getDurability())) {
                    metrics[1] = metrics[1] + 1;
                    this.retCodeDetails[index] = OperationStatus.SUCCESS;
                }
            } else {
                String msg = "Put/Delete mutations only supported in a batch";
                this.retCodeDetails[index] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, msg);
                if (this.isAtomic()) {
                    throw new IOException(msg);
                }
            }
        }

        private void checkAndMergeCPMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp, List<Region.RowLock> acquiredRowLocks, long timestamp) throws IOException {
            this.visitBatchOperations(true, this.nextIndexToProcess + miniBatchOp.size(), i -> {
                Mutation[] cpMutations = miniBatchOp.getOperationsFromCoprocessors(i - this.nextIndexToProcess);
                if (cpMutations == null) {
                    return true;
                }
                Mutation mutation = this.getMutation(i);
                for (Mutation cpMutation : cpMutations) {
                    this.checkAndPrepareMutation(cpMutation, timestamp);
                    acquiredRowLocks.add(this.region.getRowLockInternal(cpMutation.getRow(), true, null));
                    NavigableMap<byte[], List<Cell>> cpFamilyMap = cpMutation.getFamilyCellMap();
                    this.region.rewriteCellTags(cpFamilyMap, mutation);
                    this.mergeFamilyMaps(this.familyCellMaps[i], cpFamilyMap);
                    if (this.region.getEffectiveDurability(mutation.getDurability()) == Durability.SKIP_WAL) continue;
                    for (List cells : cpFamilyMap.values()) {
                        miniBatchOp.addCellCount(cells.size());
                    }
                }
                return true;
            });
        }

        private void mergeFamilyMaps(Map<byte[], List<Cell>> familyMap, Map<byte[], List<Cell>> toBeMerged) {
            for (Map.Entry<byte[], List<Cell>> entry : toBeMerged.entrySet()) {
                List<Cell> cells = familyMap.get(entry.getKey());
                if (cells == null) {
                    familyMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                cells.addAll((Collection<Cell>)entry.getValue());
            }
        }
    }

    private static abstract class BatchOperation<T> {
        protected final T[] operations;
        protected final OperationStatus[] retCodeDetails;
        protected final WALEdit[] walEditsFromCoprocessors;
        protected final Map<byte[], List<Cell>>[] familyCellMaps;
        protected final HRegion region;
        protected int nextIndexToProcess = 0;
        protected final ObservedExceptionsInBatch observedExceptions;
        protected Durability durability;
        protected boolean atomic = false;

        public BatchOperation(HRegion region, T[] operations) {
            this.operations = operations;
            this.retCodeDetails = new OperationStatus[operations.length];
            Arrays.fill(this.retCodeDetails, OperationStatus.NOT_RUN);
            this.walEditsFromCoprocessors = new WALEdit[operations.length];
            this.familyCellMaps = new Map[operations.length];
            this.region = region;
            this.observedExceptions = new ObservedExceptionsInBatch();
            this.durability = Durability.USE_DEFAULT;
        }

        public void visitBatchOperations(boolean pendingOnly, int lastIndexExclusive, Visitor visitor) throws IOException {
            assert (lastIndexExclusive <= this.size());
            for (int i = this.nextIndexToProcess; i < lastIndexExclusive && (pendingOnly && !this.isOperationPending(i) || visitor.visit(i)); ++i) {
            }
        }

        public abstract Mutation getMutation(int var1);

        public abstract long getNonceGroup(int var1);

        public abstract long getNonce(int var1);

        public abstract Mutation[] getMutationsForCoprocs();

        public abstract boolean isInReplay();

        public abstract long getOrigLogSeqNum();

        public abstract void startRegionOperation() throws IOException;

        public abstract void closeRegionOperation() throws IOException;

        public abstract void checkAndPrepare() throws IOException;

        protected abstract void checkAndPreparePut(Put var1) throws IOException;

        public abstract void prepareMiniBatchOperations(MiniBatchOperationInProgress<Mutation> var1, long var2, List<Region.RowLock> var4) throws IOException;

        public abstract MultiVersionConcurrencyControl.WriteEntry writeMiniBatchOperationsToMemStore(MiniBatchOperationInProgress<Mutation> var1, MultiVersionConcurrencyControl.WriteEntry var2) throws IOException;

        protected void writeMiniBatchOperationsToMemStore(MiniBatchOperationInProgress<Mutation> miniBatchOp, long writeNumber) throws IOException {
            NonThreadSafeMemStoreSizing memStoreAccounting = new NonThreadSafeMemStoreSizing();
            this.visitBatchOperations(true, miniBatchOp.getLastIndexExclusive(), index -> {
                if (this.isInReplay() || this.getMutation(index).getDurability() == Durability.SKIP_WAL) {
                    this.region.updateSequenceId(this.familyCellMaps[index].values(), writeNumber);
                }
                this.applyFamilyMapToMemStore(this.familyCellMaps[index], memStoreAccounting);
                return true;
            });
            this.region.incMemStoreSize(memStoreAccounting.getDataSize(), memStoreAccounting.getHeapSize(), memStoreAccounting.getOffHeapSize(), memStoreAccounting.getCellsCount());
        }

        public boolean isDone() {
            return this.nextIndexToProcess == this.operations.length;
        }

        public int size() {
            return this.operations.length;
        }

        public boolean isOperationPending(int index) {
            return this.retCodeDetails[index].getOperationStatusCode() == HConstants.OperationStatusCode.NOT_RUN;
        }

        public List<UUID> getClusterIds() {
            assert (this.size() != 0);
            return this.getMutation(0).getClusterIds();
        }

        boolean isAtomic() {
            return this.atomic;
        }

        protected void checkAndPrepareMutation(Mutation mutation, long timestamp) throws IOException {
            this.region.checkRow(mutation.getRow(), "batchMutate");
            if (mutation instanceof Put) {
                this.checkAndPreparePut((Put)mutation);
                this.region.checkTimestamps(mutation.getFamilyCellMap(), timestamp);
            } else {
                this.region.prepareDelete((Delete)mutation);
            }
        }

        protected void checkAndPrepareMutation(int index, long timestamp) throws IOException {
            block13: {
                Mutation mutation = this.getMutation(index);
                try {
                    this.checkAndPrepareMutation(mutation, timestamp);
                    this.familyCellMaps[index] = mutation.getFamilyCellMap();
                    Durability tmpDur = this.region.getEffectiveDurability(mutation.getDurability());
                    if (tmpDur.ordinal() > this.durability.ordinal()) {
                        this.durability = tmpDur;
                    }
                }
                catch (NoSuchColumnFamilyException nscfe) {
                    String msg = "No such column family in batch mutation in region " + this;
                    if (this.observedExceptions.hasSeenNoSuchFamily()) {
                        LOG.warn(msg + nscfe.getMessage());
                    } else {
                        LOG.warn(msg, (Throwable)nscfe);
                        this.observedExceptions.sawNoSuchFamily();
                    }
                    this.retCodeDetails[index] = new OperationStatus(HConstants.OperationStatusCode.BAD_FAMILY, nscfe.getMessage());
                    if (this.isAtomic()) {
                        throw nscfe;
                    }
                }
                catch (FailedSanityCheckException fsce) {
                    String msg = "Batch Mutation did not pass sanity check in region " + this;
                    if (this.observedExceptions.hasSeenFailedSanityCheck()) {
                        LOG.warn(msg + fsce.getMessage());
                    } else {
                        LOG.warn(msg, (Throwable)fsce);
                        this.observedExceptions.sawFailedSanityCheck();
                    }
                    this.retCodeDetails[index] = new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, fsce.getMessage());
                    if (this.isAtomic()) {
                        throw fsce;
                    }
                }
                catch (WrongRegionException we) {
                    String msg = "Batch mutation had a row that does not belong to this region " + this;
                    if (this.observedExceptions.hasSeenWrongRegion()) {
                        LOG.warn(msg + we.getMessage());
                    } else {
                        LOG.warn(msg, (Throwable)we);
                        this.observedExceptions.sawWrongRegion();
                    }
                    this.retCodeDetails[index] = new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, we.getMessage());
                    if (!this.isAtomic()) break block13;
                    throw we;
                }
            }
        }

        public MiniBatchOperationInProgress<Mutation> lockRowsAndBuildMiniBatch(List<Region.RowLock> acquiredRowLocks) throws IOException {
            int lastIndexExclusive;
            int readyToWriteCount = 0;
            Region.RowLock prevRowLock = null;
            for (lastIndexExclusive = 0; lastIndexExclusive < this.size() && (this.isAtomic() || readyToWriteCount != this.region.miniBatchSize); ++lastIndexExclusive) {
                if (!this.isOperationPending(lastIndexExclusive)) continue;
                NavigableMap<byte[], List<Cell>> curFamilyCellMap = this.getMutation(lastIndexExclusive).getFamilyCellMap();
                try {
                    this.region.storeHotnessProtector.start(curFamilyCellMap);
                }
                catch (RegionTooBusyException rtbe) {
                    this.region.storeHotnessProtector.finish(curFamilyCellMap);
                    if (this.isAtomic()) {
                        throw rtbe;
                    }
                    this.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.STORE_TOO_BUSY, rtbe.getMessage());
                    continue;
                }
                Mutation mutation = this.getMutation(lastIndexExclusive);
                Region.RowLock rowLock = null;
                boolean throwException = false;
                try {
                    rowLock = this.region.getRowLockInternal(mutation.getRow(), !this.isAtomic(), prevRowLock);
                }
                catch (InterruptedIOException | TimeoutIOException e) {
                    throwException = true;
                    throw e;
                }
                catch (IOException ioe) {
                    LOG.warn("Failed getting lock, row={}, in region {}", new Object[]{Bytes.toStringBinary(mutation.getRow()), this, ioe});
                    if (this.isAtomic()) {
                        throwException = true;
                        throw ioe;
                    }
                }
                catch (Throwable throwable) {
                    throwException = true;
                    throw throwable;
                }
                finally {
                    if (throwException) {
                        this.region.storeHotnessProtector.finish(curFamilyCellMap);
                    }
                }
                if (rowLock == null) {
                    if (!this.isAtomic()) break;
                    this.region.storeHotnessProtector.finish(curFamilyCellMap);
                    throw new IOException("Can't apply all operations atomically!");
                }
                if (rowLock != prevRowLock) {
                    acquiredRowLocks.add(rowLock);
                    prevRowLock = rowLock;
                }
                ++readyToWriteCount;
            }
            return this.createMiniBatch(lastIndexExclusive, readyToWriteCount);
        }

        protected MiniBatchOperationInProgress<Mutation> createMiniBatch(int lastIndexExclusive, int readyToWriteCount) {
            return new MiniBatchOperationInProgress<Mutation>(this.getMutationsForCoprocs(), this.retCodeDetails, this.walEditsFromCoprocessors, this.nextIndexToProcess, lastIndexExclusive, readyToWriteCount);
        }

        public List<Pair<NonceKey, WALEdit>> buildWALEdits(final MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            final ArrayList<Pair<NonceKey, WALEdit>> walEdits = new ArrayList<Pair<NonceKey, WALEdit>>();
            this.visitBatchOperations(true, this.nextIndexToProcess + miniBatchOp.size(), new Visitor(){
                private Pair<NonceKey, WALEdit> curWALEditForNonce;

                @Override
                public boolean visit(int index) throws IOException {
                    Mutation m = this.getMutation(index);
                    if (region.getEffectiveDurability(m.getDurability()) == Durability.SKIP_WAL) {
                        region.recordMutationWithoutWal(m.getFamilyCellMap());
                        return true;
                    }
                    long nonceGroup = this.getNonceGroup(index);
                    long nonce = this.getNonce(index);
                    if (this.curWALEditForNonce == null || this.curWALEditForNonce.getFirst().getNonceGroup() != nonceGroup || this.curWALEditForNonce.getFirst().getNonce() != nonce) {
                        this.curWALEditForNonce = new Pair<NonceKey, WALEdit>(new NonceKey(nonceGroup, nonce), new WALEdit(miniBatchOp.getCellCount(), this.isInReplay()));
                        walEdits.add(this.curWALEditForNonce);
                    }
                    WALEdit walEdit = this.curWALEditForNonce.getSecond();
                    WALEdit fromCP = walEditsFromCoprocessors[index];
                    if (fromCP != null) {
                        for (Cell cell : fromCP.getCells()) {
                            walEdit.add(cell);
                        }
                    }
                    walEdit.add(familyCellMaps[index]);
                    return true;
                }
            });
            return walEdits;
        }

        public void completeMiniBatchOperations(MiniBatchOperationInProgress<Mutation> miniBatchOp, MultiVersionConcurrencyControl.WriteEntry writeEntry) throws IOException {
            if (writeEntry != null) {
                this.region.mvcc.completeAndWait(writeEntry);
            }
        }

        public void doPostOpCleanupForMiniBatch(MiniBatchOperationInProgress<Mutation> miniBatchOp, WALEdit walEdit, boolean success) throws IOException {
            this.doFinishHotnessProtector(miniBatchOp);
        }

        private void doFinishHotnessProtector(MiniBatchOperationInProgress<Mutation> miniBatchOp) {
            if (!this.region.storeHotnessProtector.isEnable()) {
                return;
            }
            if (miniBatchOp == null) {
                return;
            }
            int finalLastIndexExclusive = miniBatchOp.getLastIndexExclusive();
            block3: for (int i = this.nextIndexToProcess; i < finalLastIndexExclusive; ++i) {
                switch (this.retCodeDetails[i].getOperationStatusCode()) {
                    case SUCCESS: 
                    case FAILURE: {
                        this.region.storeHotnessProtector.finish(this.getMutation(i).getFamilyCellMap());
                        continue block3;
                    }
                }
            }
        }

        protected void applyFamilyMapToMemStore(Map<byte[], List<Cell>> familyMap, MemStoreSizing memstoreAccounting) throws IOException {
            for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<Cell> cells = e.getValue();
                assert (cells instanceof RandomAccess);
                this.region.applyToMemStore(this.region.getStore(family), cells, false, memstoreAccounting);
            }
        }

        @FunctionalInterface
        public static interface Visitor {
            public boolean visit(int var1) throws IOException;
        }
    }

    public static interface FlushResult {
        public Result getResult();

        public boolean isFlushSucceeded();

        public boolean isCompactionNeeded();

        public static enum Result {
            FLUSHED_NO_COMPACTION_NEEDED,
            FLUSHED_COMPACTION_NEEDED,
            CANNOT_FLUSH_MEMSTORE_EMPTY,
            CANNOT_FLUSH;

        }
    }

    static class ObservedExceptionsInBatch {
        private boolean wrongRegion = false;
        private boolean failedSanityCheck = false;
        private boolean wrongFamily = false;

        ObservedExceptionsInBatch() {
        }

        boolean hasSeenWrongRegion() {
            return this.wrongRegion;
        }

        void sawWrongRegion() {
            this.wrongRegion = true;
        }

        boolean hasSeenFailedSanityCheck() {
            return this.failedSanityCheck;
        }

        void sawFailedSanityCheck() {
            this.failedSanityCheck = true;
        }

        boolean hasSeenNoSuchFamily() {
            return this.wrongFamily;
        }

        void sawNoSuchFamily() {
            this.wrongFamily = true;
        }
    }

    @VisibleForTesting
    static class PrepareFlushResult {
        final FlushResultImpl result;
        final TreeMap<byte[], StoreFlushContext> storeFlushCtxs;
        final TreeMap<byte[], List<Path>> committedFiles;
        final TreeMap<byte[], MemStoreSize> storeFlushableSize;
        final long startTime;
        final long flushOpSeqId;
        final long flushedSeqId;
        final MemStoreSizing totalFlushableSize;

        PrepareFlushResult(FlushResultImpl result, long flushSeqId) {
            this(result, null, null, null, Math.max(0L, flushSeqId), 0L, 0L, MemStoreSizing.DUD);
        }

        PrepareFlushResult(TreeMap<byte[], StoreFlushContext> storeFlushCtxs, TreeMap<byte[], List<Path>> committedFiles, TreeMap<byte[], MemStoreSize> storeFlushableSize, long startTime, long flushSeqId, long flushedSeqId, MemStoreSizing totalFlushableSize) {
            this(null, storeFlushCtxs, committedFiles, storeFlushableSize, startTime, flushSeqId, flushedSeqId, totalFlushableSize);
        }

        private PrepareFlushResult(FlushResultImpl result, TreeMap<byte[], StoreFlushContext> storeFlushCtxs, TreeMap<byte[], List<Path>> committedFiles, TreeMap<byte[], MemStoreSize> storeFlushableSize, long startTime, long flushSeqId, long flushedSeqId, MemStoreSizing totalFlushableSize) {
            this.result = result;
            this.storeFlushCtxs = storeFlushCtxs;
            this.committedFiles = committedFiles;
            this.storeFlushableSize = storeFlushableSize;
            this.startTime = startTime;
            this.flushOpSeqId = flushSeqId;
            this.flushedSeqId = flushedSeqId;
            this.totalFlushableSize = totalFlushableSize;
        }

        public FlushResult getResult() {
            return this.result;
        }
    }

    public static class FlushResultImpl
    implements FlushResult {
        final FlushResult.Result result;
        final String failureReason;
        final long flushSequenceId;
        final boolean wroteFlushWalMarker;

        FlushResultImpl(FlushResult.Result result, long flushSequenceId) {
            this(result, flushSequenceId, null, false);
            assert (result == FlushResult.Result.FLUSHED_NO_COMPACTION_NEEDED || result == FlushResult.Result.FLUSHED_COMPACTION_NEEDED);
        }

        FlushResultImpl(FlushResult.Result result, String failureReason, boolean wroteFlushMarker) {
            this(result, -1L, failureReason, wroteFlushMarker);
            assert (result == FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY || result == FlushResult.Result.CANNOT_FLUSH);
        }

        FlushResultImpl(FlushResult.Result result, long flushSequenceId, String failureReason, boolean wroteFlushMarker) {
            this.result = result;
            this.flushSequenceId = flushSequenceId;
            this.failureReason = failureReason;
            this.wroteFlushWalMarker = wroteFlushMarker;
        }

        @Override
        public boolean isFlushSucceeded() {
            return this.result == FlushResult.Result.FLUSHED_NO_COMPACTION_NEEDED || this.result == FlushResult.Result.FLUSHED_COMPACTION_NEEDED;
        }

        @Override
        public boolean isCompactionNeeded() {
            return this.result == FlushResult.Result.FLUSHED_COMPACTION_NEEDED;
        }

        public String toString() {
            return "flush result:" + (Object)((Object)this.result) + ", " + "failureReason:" + this.failureReason + "," + "flush seq id" + this.flushSequenceId;
        }

        @Override
        public FlushResult.Result getResult() {
            return this.result;
        }
    }

    static class WriteState {
        volatile boolean flushing = false;
        volatile boolean flushRequested = false;
        AtomicInteger compacting = new AtomicInteger(0);
        volatile boolean writesEnabled = true;
        volatile boolean readOnly = false;
        volatile boolean readsEnabled = true;
        static final long HEAP_SIZE = ClassSize.align(ClassSize.OBJECT + 5);

        WriteState() {
        }

        synchronized void setReadOnly(boolean onOff) {
            this.writesEnabled = !onOff;
            this.readOnly = onOff;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        boolean isFlushRequested() {
            return this.flushRequested;
        }

        void setReadsEnabled(boolean readsEnabled) {
            this.readsEnabled = readsEnabled;
        }
    }
}

