/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.favored;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FavoredNodesManager {
    private static final Logger LOG = LoggerFactory.getLogger(FavoredNodesManager.class);
    private final FavoredNodesPlan globalFavoredNodesAssignmentPlan;
    private final Map<ServerName, List<RegionInfo>> primaryRSToRegionMap;
    private final Map<ServerName, List<RegionInfo>> secondaryRSToRegionMap;
    private final Map<ServerName, List<RegionInfo>> teritiaryRSToRegionMap;
    private final MasterServices masterServices;
    private final RackManager rackManager;
    private int datanodeDataTransferPort;

    public FavoredNodesManager(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.globalFavoredNodesAssignmentPlan = new FavoredNodesPlan();
        this.primaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.secondaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.teritiaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.rackManager = new RackManager(masterServices.getConfiguration());
    }

    public synchronized void initialize(SnapshotOfRegionAssignmentFromMeta snapshot) {
        this.globalFavoredNodesAssignmentPlan.updateFavoredNodesMap(snapshot.getExistingAssignmentPlan());
        this.primaryRSToRegionMap.putAll(snapshot.getPrimaryToRegionInfoMap());
        this.secondaryRSToRegionMap.putAll(snapshot.getSecondaryToRegionInfoMap());
        this.teritiaryRSToRegionMap.putAll(snapshot.getTertiaryToRegionInfoMap());
        this.datanodeDataTransferPort = this.getDataNodePort();
    }

    @VisibleForTesting
    public int getDataNodePort() {
        HdfsConfiguration.init();
        HdfsConfiguration dnConf = new HdfsConfiguration(this.masterServices.getConfiguration());
        int dnPort = NetUtils.createSocketAddr((String)dnConf.get("dfs.datanode.address", "0.0.0.0:50010")).getPort();
        LOG.debug("Loaded default datanode port for FN: " + this.datanodeDataTransferPort);
        return dnPort;
    }

    public synchronized List<ServerName> getFavoredNodes(RegionInfo regionInfo) {
        return this.globalFavoredNodesAssignmentPlan.getFavoredNodes(regionInfo);
    }

    public static boolean isFavoredNodeApplicable(RegionInfo regionInfo) {
        return !regionInfo.getTable().isSystemTable();
    }

    public static Set<RegionInfo> filterNonFNApplicableRegions(Collection<RegionInfo> regions) {
        return regions.stream().filter(r -> !FavoredNodesManager.isFavoredNodeApplicable(r)).collect(Collectors.toSet());
    }

    public synchronized List<ServerName> getFavoredNodesWithDNPort(RegionInfo regionInfo) {
        if (this.getFavoredNodes(regionInfo) == null) {
            return null;
        }
        ArrayList<ServerName> fnWithDNPort = Lists.newArrayList();
        for (ServerName sn : this.getFavoredNodes(regionInfo)) {
            fnWithDNPort.add(ServerName.valueOf(sn.getHostname(), this.datanodeDataTransferPort, -1L));
        }
        return fnWithDNPort;
    }

    public synchronized void updateFavoredNodes(Map<RegionInfo, List<ServerName>> regionFNMap) throws IOException {
        RegionInfo regionInfo;
        HashMap<RegionInfo, List<ServerName>> regionToFavoredNodes = new HashMap<RegionInfo, List<ServerName>>();
        for (Map.Entry<RegionInfo, List<ServerName>> entry : regionFNMap.entrySet()) {
            regionInfo = entry.getKey();
            List<ServerName> servers = entry.getValue();
            if (servers.size() != Sets.newHashSet(servers).size()) {
                throw new IOException("Duplicates found: " + servers);
            }
            if (!FavoredNodesManager.isFavoredNodeApplicable(regionInfo)) {
                throw new IOException("Can't update FN for a un-applicable region: " + regionInfo.getRegionNameAsString() + " with " + servers);
            }
            if (servers.size() != 3) {
                throw new IOException("At least 3 favored nodes should be present for region : " + regionInfo.getEncodedName() + " current FN servers:" + servers);
            }
            ArrayList<ServerName> serversWithNoStartCodes = Lists.newArrayList();
            for (ServerName sn : servers) {
                if (sn.getStartcode() == -1L) {
                    serversWithNoStartCodes.add(sn);
                    continue;
                }
                serversWithNoStartCodes.add(ServerName.valueOf(sn.getHostname(), sn.getPort(), -1L));
            }
            regionToFavoredNodes.put(regionInfo, serversWithNoStartCodes);
        }
        FavoredNodeAssignmentHelper.updateMetaWithFavoredNodesInfo(regionToFavoredNodes, this.masterServices.getConnection());
        this.deleteFavoredNodesForRegions(regionToFavoredNodes.keySet());
        for (Map.Entry<RegionInfo, List<ServerName>> entry : regionToFavoredNodes.entrySet()) {
            regionInfo = entry.getKey();
            List<ServerName> serversWithNoStartCodes = entry.getValue();
            this.globalFavoredNodesAssignmentPlan.updateFavoredNodesMap(regionInfo, serversWithNoStartCodes);
            this.addToReplicaLoad(regionInfo, serversWithNoStartCodes);
        }
    }

    private synchronized void addToReplicaLoad(RegionInfo hri, List<ServerName> servers) {
        ServerName serverToUse = ServerName.valueOf(servers.get(FavoredNodesPlan.Position.PRIMARY.ordinal()).getAddress().toString(), -1L);
        List<RegionInfo> regionList = this.primaryRSToRegionMap.get(serverToUse);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(hri);
        this.primaryRSToRegionMap.put(serverToUse, regionList);
        serverToUse = ServerName.valueOf(servers.get(FavoredNodesPlan.Position.SECONDARY.ordinal()).getAddress(), -1L);
        regionList = this.secondaryRSToRegionMap.get(serverToUse);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(hri);
        this.secondaryRSToRegionMap.put(serverToUse, regionList);
        serverToUse = ServerName.valueOf(servers.get(FavoredNodesPlan.Position.TERTIARY.ordinal()).getAddress(), -1L);
        regionList = this.teritiaryRSToRegionMap.get(serverToUse);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(hri);
        this.teritiaryRSToRegionMap.put(serverToUse, regionList);
    }

    public synchronized Map<ServerName, List<Integer>> getReplicaLoad(List<ServerName> servers) {
        HashMap<ServerName, List<Integer>> result = Maps.newHashMap();
        for (ServerName sn : servers) {
            ServerName serverWithNoStartCode = ServerName.valueOf(sn.getAddress(), -1L);
            ArrayList<Integer> countList = Lists.newArrayList();
            if (this.primaryRSToRegionMap.containsKey(serverWithNoStartCode)) {
                countList.add(this.primaryRSToRegionMap.get(serverWithNoStartCode).size());
            } else {
                countList.add(0);
            }
            if (this.secondaryRSToRegionMap.containsKey(serverWithNoStartCode)) {
                countList.add(this.secondaryRSToRegionMap.get(serverWithNoStartCode).size());
            } else {
                countList.add(0);
            }
            if (this.teritiaryRSToRegionMap.containsKey(serverWithNoStartCode)) {
                countList.add(this.teritiaryRSToRegionMap.get(serverWithNoStartCode).size());
            } else {
                countList.add(0);
            }
            result.put(sn, countList);
        }
        return result;
    }

    public synchronized void deleteFavoredNodesForRegion(RegionInfo regionInfo) {
        List<ServerName> favNodes = this.getFavoredNodes(regionInfo);
        if (favNodes != null) {
            if (this.primaryRSToRegionMap.containsKey(favNodes.get(FavoredNodesPlan.Position.PRIMARY.ordinal()))) {
                this.primaryRSToRegionMap.get(favNodes.get(FavoredNodesPlan.Position.PRIMARY.ordinal())).remove(regionInfo);
            }
            if (this.secondaryRSToRegionMap.containsKey(favNodes.get(FavoredNodesPlan.Position.SECONDARY.ordinal()))) {
                this.secondaryRSToRegionMap.get(favNodes.get(FavoredNodesPlan.Position.SECONDARY.ordinal())).remove(regionInfo);
            }
            if (this.teritiaryRSToRegionMap.containsKey(favNodes.get(FavoredNodesPlan.Position.TERTIARY.ordinal()))) {
                this.teritiaryRSToRegionMap.get(favNodes.get(FavoredNodesPlan.Position.TERTIARY.ordinal())).remove(regionInfo);
            }
            this.globalFavoredNodesAssignmentPlan.removeFavoredNodes(regionInfo);
        }
    }

    public synchronized void deleteFavoredNodesForRegions(Collection<RegionInfo> regionInfoList) {
        for (RegionInfo regionInfo : regionInfoList) {
            this.deleteFavoredNodesForRegion(regionInfo);
        }
    }

    @VisibleForTesting
    public synchronized Set<RegionInfo> getRegionsOfFavoredNode(ServerName serverName) {
        HashSet<RegionInfo> regionInfos = Sets.newHashSet();
        ServerName serverToUse = ServerName.valueOf(serverName.getAddress(), -1L);
        if (this.primaryRSToRegionMap.containsKey(serverToUse)) {
            regionInfos.addAll((Collection)this.primaryRSToRegionMap.get(serverToUse));
        }
        if (this.secondaryRSToRegionMap.containsKey(serverToUse)) {
            regionInfos.addAll((Collection)this.secondaryRSToRegionMap.get(serverToUse));
        }
        if (this.teritiaryRSToRegionMap.containsKey(serverToUse)) {
            regionInfos.addAll((Collection<RegionInfo>)this.teritiaryRSToRegionMap.get(serverToUse));
        }
        return regionInfos;
    }

    public RackManager getRackManager() {
        return this.rackManager;
    }
}

