/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaState;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaUtil
extends QuotaTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaUtil.class);
    public static final String QUOTA_CONF_KEY = "hbase.quota.enabled";
    private static final boolean QUOTA_ENABLED_DEFAULT = false;
    public static final String READ_CAPACITY_UNIT_CONF_KEY = "hbase.quota.read.capacity.unit";
    public static final long DEFAULT_READ_CAPACITY_UNIT = 1024L;
    public static final String WRITE_CAPACITY_UNIT_CONF_KEY = "hbase.quota.write.capacity.unit";
    public static final long DEFAULT_WRITE_CAPACITY_UNIT = 1024L;
    public static final HTableDescriptor QUOTA_TABLE_DESC = new HTableDescriptor(QUOTA_TABLE_NAME);

    public static boolean isQuotaEnabled(Configuration conf) {
        return conf.getBoolean(QUOTA_CONF_KEY, false);
    }

    public static void addTableQuota(Connection connection, TableName table, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getTableRowKey(table), data);
    }

    public static void deleteTableQuota(Connection connection, TableName table) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getTableRowKey(table));
    }

    public static void addNamespaceQuota(Connection connection, String namespace, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getNamespaceRowKey(namespace), data);
    }

    public static void deleteNamespaceQuota(Connection connection, String namespace) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getNamespaceRowKey(namespace));
    }

    public static void addUserQuota(Connection connection, String user, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getUserRowKey(user), data);
    }

    public static void addUserQuota(Connection connection, String user, TableName table, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getUserRowKey(user), QuotaUtil.getSettingsQualifierForUserTable(table), data);
    }

    public static void addUserQuota(Connection connection, String user, String namespace, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getUserRowKey(user), QuotaUtil.getSettingsQualifierForUserNamespace(namespace), data);
    }

    public static void deleteUserQuota(Connection connection, String user) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getUserRowKey(user));
    }

    public static void deleteUserQuota(Connection connection, String user, TableName table) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getUserRowKey(user), QuotaUtil.getSettingsQualifierForUserTable(table));
    }

    public static void deleteUserQuota(Connection connection, String user, String namespace) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getUserRowKey(user), QuotaUtil.getSettingsQualifierForUserNamespace(namespace));
    }

    public static void addRegionServerQuota(Connection connection, String regionServer, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getRegionServerRowKey(regionServer), data);
    }

    public static void deleteRegionServerQuota(Connection connection, String regionServer) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getRegionServerRowKey(regionServer));
    }

    protected static void switchExceedThrottleQuota(Connection connection, boolean exceedThrottleQuotaEnabled) throws IOException {
        if (exceedThrottleQuotaEnabled) {
            QuotaUtil.checkRSQuotaToEnableExceedThrottle(QuotaUtil.getRegionServerQuota(connection, "all"));
        }
        Put put = new Put(QuotaUtil.getExceedThrottleQuotaRowKey());
        put.addColumn(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS, Bytes.toBytes(exceedThrottleQuotaEnabled));
        QuotaUtil.doPut(connection, put);
    }

    private static void checkRSQuotaToEnableExceedThrottle(QuotaProtos.Quotas quotas) throws IOException {
        if (quotas != null && quotas.hasThrottle()) {
            QuotaProtos.Throttle throttle = quotas.getThrottle();
            boolean hasReadQuota = false;
            boolean hasWriteQuota = false;
            if (throttle.hasReqNum() || throttle.hasReqSize() || throttle.hasReqCapacityUnit()) {
                hasReadQuota = true;
                hasWriteQuota = true;
            }
            if (!hasReadQuota && (throttle.hasReadNum() || throttle.hasReadSize() || throttle.hasReadCapacityUnit())) {
                hasReadQuota = true;
            }
            if (!hasReadQuota) {
                throw new DoNotRetryIOException("Please set at least one read region server quota before enable exceed throttle quota");
            }
            if (!hasWriteQuota && (throttle.hasWriteNum() || throttle.hasWriteSize() || throttle.hasWriteCapacityUnit())) {
                hasWriteQuota = true;
            }
            if (!hasWriteQuota) {
                throw new DoNotRetryIOException("Please set at least one write region server quota before enable exceed throttle quota");
            }
            List<Pair> list = Arrays.asList(Pair.newPair(throttle.hasReqNum(), throttle.getReqNum()), Pair.newPair(throttle.hasReadNum(), throttle.getReadNum()), Pair.newPair(throttle.hasWriteNum(), throttle.getWriteNum()), Pair.newPair(throttle.hasReqSize(), throttle.getReqSize()), Pair.newPair(throttle.hasReadSize(), throttle.getReadSize()), Pair.newPair(throttle.hasWriteSize(), throttle.getWriteSize()), Pair.newPair(throttle.hasReqCapacityUnit(), throttle.getReqCapacityUnit()), Pair.newPair(throttle.hasReadCapacityUnit(), throttle.getReadCapacityUnit()), Pair.newPair(throttle.hasWriteCapacityUnit(), throttle.getWriteCapacityUnit()));
            for (Pair pair : list) {
                if (!((Boolean)pair.getFirst()).booleanValue() || ((QuotaProtos.TimedQuota)pair.getSecond()).getTimeUnit() == HBaseProtos.TimeUnit.SECONDS) continue;
                throw new DoNotRetryIOException("All region server quota must be in seconds time unit if enable exceed throttle quota");
            }
        } else {
            throw new DoNotRetryIOException("Please set region server quota before enable exceed throttle quota");
        }
    }

    protected static boolean isExceedThrottleQuotaEnabled(Connection connection) throws IOException {
        Get get = new Get(QuotaUtil.getExceedThrottleQuotaRowKey());
        get.addColumn(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        Result result = QuotaUtil.doGet(connection, get);
        if (result.isEmpty()) {
            return false;
        }
        return Bytes.toBoolean(result.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS));
    }

    private static void addQuotas(Connection connection, byte[] rowKey, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, rowKey, QUOTA_QUALIFIER_SETTINGS, data);
    }

    private static void addQuotas(Connection connection, byte[] rowKey, byte[] qualifier, QuotaProtos.Quotas data) throws IOException {
        Put put = new Put(rowKey);
        put.addColumn(QUOTA_FAMILY_INFO, qualifier, QuotaUtil.quotasToData(data));
        QuotaUtil.doPut(connection, put);
    }

    private static void deleteQuotas(Connection connection, byte[] rowKey) throws IOException {
        QuotaUtil.deleteQuotas(connection, rowKey, null);
    }

    private static void deleteQuotas(Connection connection, byte[] rowKey, byte[] qualifier) throws IOException {
        String ns;
        QuotaProtos.Quotas namespaceQuota;
        Delete delete = new Delete(rowKey);
        if (qualifier != null) {
            delete.addColumns(QUOTA_FAMILY_INFO, qualifier);
        }
        if (QuotaUtil.isNamespaceRowKey(rowKey) && (namespaceQuota = QuotaUtil.getNamespaceQuota(connection, ns = QuotaUtil.getNamespaceFromRowKey(rowKey))) != null && namespaceQuota.hasSpace()) {
            QuotaUtil.deleteTableUsageSnapshotsForNamespace(connection, ns);
        }
        QuotaUtil.doDelete(connection, delete);
    }

    public static Map<String, UserQuotaState> fetchUserQuotas(Connection connection, List<Get> gets, final Map<TableName, Double> tableMachineQuotaFactors, final double factor) throws IOException {
        long nowTs = EnvironmentEdgeManager.currentTime();
        Result[] results = QuotaUtil.doGet(connection, gets);
        HashMap<String, UserQuotaState> userQuotas = new HashMap<String, UserQuotaState>(results.length);
        for (int i = 0; i < results.length; ++i) {
            byte[] key = gets.get(i).getRow();
            assert (QuotaUtil.isUserRowKey(key));
            String user = QuotaUtil.getUserFromRowKey(key);
            final UserQuotaState quotaInfo = new UserQuotaState(nowTs);
            userQuotas.put(user, quotaInfo);
            if (results[i].isEmpty()) continue;
            assert (Bytes.equals(key, results[i].getRow()));
            try {
                QuotaUtil.parseUserResult(user, results[i], new QuotaTableUtil.UserQuotasVisitor(){

                    @Override
                    public void visitUserQuotas(String userName, String namespace, QuotaProtos.Quotas quotas) {
                        quotas = QuotaUtil.updateClusterQuotaToMachineQuota(quotas, factor);
                        quotaInfo.setQuotas(namespace, quotas);
                    }

                    @Override
                    public void visitUserQuotas(String userName, TableName table, QuotaProtos.Quotas quotas) {
                        quotas = QuotaUtil.updateClusterQuotaToMachineQuota(quotas, tableMachineQuotaFactors.containsKey(table) ? (Double)tableMachineQuotaFactors.get(table) : 1.0);
                        quotaInfo.setQuotas(table, quotas);
                    }

                    @Override
                    public void visitUserQuotas(String userName, QuotaProtos.Quotas quotas) {
                        quotas = QuotaUtil.updateClusterQuotaToMachineQuota(quotas, factor);
                        quotaInfo.setQuotas(quotas);
                    }
                });
                continue;
            }
            catch (IOException e) {
                LOG.error("Unable to parse user '" + user + "' quotas", (Throwable)e);
                userQuotas.remove(user);
            }
        }
        return userQuotas;
    }

    public static Map<TableName, QuotaState> fetchTableQuotas(Connection connection, List<Get> gets, final Map<TableName, Double> tableMachineFactors) throws IOException {
        return QuotaUtil.fetchGlobalQuotas("table", connection, gets, new KeyFromRow<TableName>(){

            @Override
            public TableName getKeyFromRow(byte[] row) {
                assert (QuotaTableUtil.isTableRowKey(row));
                return QuotaTableUtil.getTableFromRowKey(row);
            }

            @Override
            public double getFactor(TableName tableName) {
                return tableMachineFactors.containsKey(tableName) ? (Double)tableMachineFactors.get(tableName) : 1.0;
            }
        });
    }

    public static Map<String, QuotaState> fetchNamespaceQuotas(Connection connection, List<Get> gets, final double factor) throws IOException {
        return QuotaUtil.fetchGlobalQuotas("namespace", connection, gets, new KeyFromRow<String>(){

            @Override
            public String getKeyFromRow(byte[] row) {
                assert (QuotaTableUtil.isNamespaceRowKey(row));
                return QuotaTableUtil.getNamespaceFromRowKey(row);
            }

            @Override
            public double getFactor(String s) {
                return factor;
            }
        });
    }

    public static Map<String, QuotaState> fetchRegionServerQuotas(Connection connection, List<Get> gets) throws IOException {
        return QuotaUtil.fetchGlobalQuotas("regionServer", connection, gets, new KeyFromRow<String>(){

            @Override
            public String getKeyFromRow(byte[] row) {
                assert (QuotaTableUtil.isRegionServerRowKey(row));
                return QuotaTableUtil.getRegionServerFromRowKey(row);
            }

            @Override
            public double getFactor(String s) {
                return 1.0;
            }
        });
    }

    public static <K> Map<K, QuotaState> fetchGlobalQuotas(String type, Connection connection, List<Get> gets, KeyFromRow<K> kfr) throws IOException {
        long nowTs = EnvironmentEdgeManager.currentTime();
        Result[] results = QuotaUtil.doGet(connection, gets);
        HashMap<K, QuotaState> globalQuotas = new HashMap<K, QuotaState>(results.length);
        for (int i = 0; i < results.length; ++i) {
            byte[] row = gets.get(i).getRow();
            K key = kfr.getKeyFromRow(row);
            QuotaState quotaInfo = new QuotaState(nowTs);
            globalQuotas.put(key, quotaInfo);
            if (results[i].isEmpty()) continue;
            assert (Bytes.equals(row, results[i].getRow()));
            byte[] data = results[i].getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
            if (data == null) continue;
            try {
                QuotaProtos.Quotas quotas = QuotaUtil.quotasFromData(data);
                quotas = QuotaUtil.updateClusterQuotaToMachineQuota(quotas, kfr.getFactor(key));
                quotaInfo.setQuotas(quotas);
                continue;
            }
            catch (IOException e) {
                LOG.error("Unable to parse " + type + " '" + key + "' quotas", (Throwable)e);
                globalQuotas.remove(key);
            }
        }
        return globalQuotas;
    }

    private static QuotaProtos.Quotas updateClusterQuotaToMachineQuota(QuotaProtos.Quotas quotas, double factor) {
        QuotaProtos.Quotas.Builder newQuotas = QuotaProtos.Quotas.newBuilder(quotas);
        if (newQuotas.hasThrottle()) {
            QuotaProtos.Throttle.Builder throttle = QuotaProtos.Throttle.newBuilder(newQuotas.getThrottle());
            if (throttle.hasReqNum()) {
                throttle.setReqNum(QuotaUtil.updateTimedQuota(throttle.getReqNum(), factor));
            }
            if (throttle.hasReqSize()) {
                throttle.setReqSize(QuotaUtil.updateTimedQuota(throttle.getReqSize(), factor));
            }
            if (throttle.hasReadNum()) {
                throttle.setReadNum(QuotaUtil.updateTimedQuota(throttle.getReadNum(), factor));
            }
            if (throttle.hasReadSize()) {
                throttle.setReadSize(QuotaUtil.updateTimedQuota(throttle.getReadSize(), factor));
            }
            if (throttle.hasWriteNum()) {
                throttle.setWriteNum(QuotaUtil.updateTimedQuota(throttle.getWriteNum(), factor));
            }
            if (throttle.hasWriteSize()) {
                throttle.setWriteSize(QuotaUtil.updateTimedQuota(throttle.getWriteSize(), factor));
            }
            if (throttle.hasReqCapacityUnit()) {
                throttle.setReqCapacityUnit(QuotaUtil.updateTimedQuota(throttle.getReqCapacityUnit(), factor));
            }
            if (throttle.hasReadCapacityUnit()) {
                throttle.setReadCapacityUnit(QuotaUtil.updateTimedQuota(throttle.getReadCapacityUnit(), factor));
            }
            if (throttle.hasWriteCapacityUnit()) {
                throttle.setWriteCapacityUnit(QuotaUtil.updateTimedQuota(throttle.getWriteCapacityUnit(), factor));
            }
            newQuotas.setThrottle(throttle.build());
        }
        return newQuotas.build();
    }

    private static QuotaProtos.TimedQuota updateTimedQuota(QuotaProtos.TimedQuota timedQuota, double factor) {
        if (timedQuota.getScope() == QuotaProtos.QuotaScope.CLUSTER) {
            QuotaProtos.TimedQuota.Builder newTimedQuota = QuotaProtos.TimedQuota.newBuilder(timedQuota);
            newTimedQuota.setSoftLimit(Math.max(1L, (long)((double)timedQuota.getSoftLimit() * factor))).setScope(QuotaProtos.QuotaScope.MACHINE);
            return newTimedQuota.build();
        }
        return timedQuota;
    }

    private static void doPut(Connection connection, Put put) throws IOException {
        try (Table table = connection.getTable(QUOTA_TABLE_NAME);){
            table.put(put);
        }
    }

    private static void doDelete(Connection connection, Delete delete) throws IOException {
        try (Table table = connection.getTable(QUOTA_TABLE_NAME);){
            table.delete(delete);
        }
    }

    public static long calculateMutationSize(Mutation mutation) {
        long size = 0L;
        for (Map.Entry entry : mutation.getFamilyCellMap().entrySet()) {
            for (Cell cell : (List)entry.getValue()) {
                size += (long)cell.getSerializedSize();
            }
        }
        return size;
    }

    public static long calculateResultSize(Result result) {
        long size = 0L;
        for (Cell cell : result.rawCells()) {
            size += (long)cell.getSerializedSize();
        }
        return size;
    }

    public static long calculateResultSize(List<Result> results) {
        long size = 0L;
        for (Result result : results) {
            for (Cell cell : result.rawCells()) {
                size += (long)cell.getSerializedSize();
            }
        }
        return size;
    }

    public static void enableTableIfNotEnabled(Connection conn, TableName tableName) throws IOException {
        try {
            conn.getAdmin().enableTable(tableName);
        }
        catch (TableNotDisabledException | TableNotFoundException doNotRetryIOException) {
            // empty catch block
        }
    }

    public static void disableTableIfNotDisabled(Connection conn, TableName tableName) throws IOException {
        try {
            conn.getAdmin().disableTable(tableName);
        }
        catch (TableNotEnabledException | TableNotFoundException doNotRetryIOException) {
            // empty catch block
        }
    }

    static {
        QUOTA_TABLE_DESC.addFamily(new HColumnDescriptor(QUOTA_FAMILY_INFO).setScope(0).setBloomFilterType(BloomType.ROW).setMaxVersions(1));
        QUOTA_TABLE_DESC.addFamily(new HColumnDescriptor(QUOTA_FAMILY_USAGE).setScope(0).setBloomFilterType(BloomType.ROW).setMaxVersions(1));
    }

    private static interface KeyFromRow<T> {
        public T getKeyFromRow(byte[] var1);

        public double getFactor(T var1);
    }
}

