/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.regionserver.MetricsTableLatencies;
import org.apache.hadoop.hbase.regionserver.MetricsTableLatenciesImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableQueryMeter;
import org.apache.hadoop.hbase.regionserver.MetricsTableQueryMeterImpl;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerTableMetrics {
    private final MetricsTableLatencies latencies = CompatibilitySingletonFactory.getInstance(MetricsTableLatencies.class);
    private final MetricsTableQueryMeter queryMeter = new MetricsTableQueryMeterImpl(MetricRegistries.global().get(((MetricsTableLatenciesImpl)this.latencies).getMetricRegistryInfo()).get());

    public void updatePut(TableName table, long time) {
        this.latencies.updatePut(table.getNameAsString(), time);
    }

    public void updatePutBatch(TableName table, long time) {
        this.latencies.updatePutBatch(table.getNameAsString(), time);
    }

    public void updateGet(TableName table, long time) {
        this.latencies.updateGet(table.getNameAsString(), time);
    }

    public void updateIncrement(TableName table, long time) {
        this.latencies.updateIncrement(table.getNameAsString(), time);
    }

    public void updateAppend(TableName table, long time) {
        this.latencies.updateAppend(table.getNameAsString(), time);
    }

    public void updateDelete(TableName table, long time) {
        this.latencies.updateDelete(table.getNameAsString(), time);
    }

    public void updateDeleteBatch(TableName table, long time) {
        this.latencies.updateDeleteBatch(table.getNameAsString(), time);
    }

    public void updateCheckAndDelete(TableName table, long time) {
        this.latencies.updateCheckAndDelete(table.getNameAsString(), time);
    }

    public void updateCheckAndPut(TableName table, long time) {
        this.latencies.updateCheckAndPut(table.getNameAsString(), time);
    }

    public void updateScanTime(TableName table, long time) {
        this.latencies.updateScanTime(table.getNameAsString(), time);
    }

    public void updateScanSize(TableName table, long size) {
        this.latencies.updateScanSize(table.getNameAsString(), size);
    }

    public void updateTableReadQueryMeter(TableName table, long count) {
        this.queryMeter.updateTableReadQueryMeter(table, count);
    }

    public void updateTableReadQueryMeter(TableName table) {
        this.queryMeter.updateTableReadQueryMeter(table);
    }

    public void updateTableWriteQueryMeter(TableName table, long count) {
        this.queryMeter.updateTableWriteQueryMeter(table, count);
    }

    public void updateTableWriteQueryMeter(TableName table) {
        this.queryMeter.updateTableWriteQueryMeter(table);
    }
}

