/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.security.visibility.VisibilityExpEvaluator;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class VisibilityLabelFilter
extends FilterBase {
    private final VisibilityExpEvaluator expEvaluator;
    private final Map<ByteRange, Integer> cfVsMaxVersions;
    private final ByteRange curFamily;
    private final ByteRange curQualifier;
    private int curFamilyMaxVersions;
    private int curQualMetVersions;

    public VisibilityLabelFilter(VisibilityExpEvaluator expEvaluator, Map<ByteRange, Integer> cfVsMaxVersions) {
        this.expEvaluator = expEvaluator;
        this.cfVsMaxVersions = cfVsMaxVersions;
        this.curFamily = new SimpleMutableByteRange();
        this.curQualifier = new SimpleMutableByteRange();
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    public Filter.ReturnCode filterCell(Cell cell) throws IOException {
        if (this.curFamily.getBytes() == null || !PrivateCellUtil.matchingFamily(cell, this.curFamily.getBytes(), this.curFamily.getOffset(), this.curFamily.getLength())) {
            this.curFamily.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
            this.curFamilyMaxVersions = this.cfVsMaxVersions.get(this.curFamily);
            this.curQualifier.unset();
        }
        if (this.curQualifier.getBytes() == null || !PrivateCellUtil.matchingQualifier(cell, this.curQualifier.getBytes(), this.curQualifier.getOffset(), this.curQualifier.getLength())) {
            this.curQualifier.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            this.curQualMetVersions = 0;
        }
        ++this.curQualMetVersions;
        if (this.curQualMetVersions > this.curFamilyMaxVersions) {
            return Filter.ReturnCode.SKIP;
        }
        return this.expEvaluator.evaluate(cell) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
    }

    @Override
    public void reset() throws IOException {
        this.curFamily.unset();
        this.curQualifier.unset();
        this.curFamilyMaxVersions = 0;
        this.curQualMetVersions = 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VisibilityLabelFilter)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        VisibilityLabelFilter f = (VisibilityLabelFilter)obj;
        return this.expEvaluator.equals(f.expEvaluator) && this.cfVsMaxVersions.equals(f.cfVsMaxVersions);
    }

    public int hashCode() {
        return Objects.hash(this.expEvaluator, this.cfVsMaxVersions);
    }
}

