/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.exceptions.MasterRegistryFetchException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.net.HostAndPort;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterRegistry
implements ConnectionRegistry {
    public static final String MASTER_REGISTRY_HEDGED_REQS_FANOUT_KEY = "hbase.client.master_registry.hedged.fanout";
    public static final int MASTER_REGISTRY_HEDGED_REQS_FANOUT_DEFAULT = 2;
    private static final String MASTER_ADDRS_CONF_SEPARATOR = ",";
    private final int hedgedReadFanOut;
    private final ImmutableMap<ServerName, MasterProtos.ClientMetaService.Interface> masterAddr2Stub;
    private final RpcClient rpcClient;
    private final RpcControllerFactory rpcControllerFactory;

    private static Set<ServerName> parseMasterAddrs(Configuration conf) throws UnknownHostException {
        HashSet<ServerName> masterAddrs = new HashSet<ServerName>();
        String configuredMasters = MasterRegistry.getMasterAddr(conf);
        for (String masterAddr : configuredMasters.split(MASTER_ADDRS_CONF_SEPARATOR)) {
            HostAndPort masterHostPort = HostAndPort.fromString(masterAddr.trim()).withDefaultPort(16000);
            masterAddrs.add(ServerName.valueOf(masterHostPort.toString(), -1L));
        }
        Preconditions.checkArgument(!masterAddrs.isEmpty(), "At least one master address is needed");
        return masterAddrs;
    }

    MasterRegistry(Configuration conf) throws IOException {
        this.hedgedReadFanOut = Math.max(1, conf.getInt(MASTER_REGISTRY_HEDGED_REQS_FANOUT_KEY, 2));
        int rpcTimeoutMs = (int)Math.min(Integer.MAX_VALUE, conf.getLong("hbase.rpc.timeout", 60000L));
        this.rpcClient = RpcClientFactory.createClient(conf, null);
        this.rpcControllerFactory = RpcControllerFactory.instantiate(conf);
        Set<ServerName> masterAddrs = MasterRegistry.parseMasterAddrs(conf);
        ImmutableMap.Builder<ServerName, MasterProtos.ClientMetaService.Stub> builder = ImmutableMap.builderWithExpectedSize(masterAddrs.size());
        User user = User.getCurrent();
        for (ServerName masterAddr : masterAddrs) {
            builder.put(masterAddr, MasterProtos.ClientMetaService.newStub(this.rpcClient.createRpcChannel(masterAddr, user, rpcTimeoutMs)));
        }
        this.masterAddr2Stub = builder.build();
    }

    @VisibleForTesting
    public static String getMasterAddr(Configuration conf) throws UnknownHostException {
        String masterAddrFromConf = conf.get("hbase.masters");
        if (!Strings.isNullOrEmpty(masterAddrFromConf)) {
            return masterAddrFromConf;
        }
        String hostname = DNS.getHostname(conf, DNS.ServerType.MASTER);
        int port = conf.getInt("hbase.master.port", 16000);
        return String.format("%s:%d", hostname, port);
    }

    private <T extends Message> CompletableFuture<T> call(MasterProtos.ClientMetaService.Interface stub, Callable<T> callable) {
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        CompletableFuture future = new CompletableFuture();
        callable.call(controller, stub, (T resp) -> {
            if (controller.failed()) {
                future.completeExceptionally(controller.getFailed());
            } else {
                future.complete(resp);
            }
        });
        return future;
    }

    private IOException badResponse(String debug) {
        return new IOException(String.format("Invalid result for request %s. Will be retried", debug));
    }

    private <T extends Message> void groupCall(CompletableFuture<T> future, List<MasterProtos.ClientMetaService.Interface> masterStubs, int startIndexInclusive, Callable<T> callable, Predicate<T> isValidResp, String debug, ConcurrentLinkedQueue<Throwable> errors) {
        int endIndexExclusive = Math.min(startIndexInclusive + this.hedgedReadFanOut, masterStubs.size());
        AtomicInteger remaining = new AtomicInteger(endIndexExclusive - startIndexInclusive);
        for (int i = startIndexInclusive; i < endIndexExclusive; ++i) {
            FutureUtils.addListener(this.call(masterStubs.get(i), callable), (r, e) -> {
                if (future.isDone()) {
                    return;
                }
                if (e == null && !isValidResp.test(r)) {
                    e = this.badResponse(debug);
                }
                if (e != null) {
                    errors.add((Throwable)e);
                    if (remaining.decrementAndGet() == 0) {
                        if (endIndexExclusive == masterStubs.size()) {
                            RetriesExhaustedException ex = new RetriesExhaustedException("masters", masterStubs.size(), new ArrayList<Throwable>(errors));
                            future.completeExceptionally(new MasterRegistryFetchException(this.masterAddr2Stub.keySet(), (Throwable)ex));
                        } else {
                            this.groupCall(future, masterStubs, endIndexExclusive, callable, isValidResp, debug, errors);
                        }
                    }
                } else {
                    future.complete(r);
                }
            });
        }
    }

    private <T extends Message> CompletableFuture<T> call(Callable<T> callable, Predicate<T> isValidResp, String debug) {
        ArrayList<MasterProtos.ClientMetaService.Interface> masterStubs = new ArrayList<MasterProtos.ClientMetaService.Interface>(this.masterAddr2Stub.values());
        Collections.shuffle(masterStubs, ThreadLocalRandom.current());
        CompletableFuture future = new CompletableFuture();
        this.groupCall(future, masterStubs, 0, callable, isValidResp, debug, new ConcurrentLinkedQueue<Throwable>());
        return future;
    }

    private RegionLocations transformMetaRegionLocations(MasterProtos.GetMetaRegionLocationsResponse resp) {
        ArrayList<HRegionLocation> regionLocations = new ArrayList<HRegionLocation>();
        resp.getMetaLocationsList().forEach(location -> regionLocations.add(ProtobufUtil.toRegionLocation(location)));
        return new RegionLocations(regionLocations);
    }

    @Override
    public CompletableFuture<RegionLocations> getMetaRegionLocations() {
        return this.call((c, s2, d) -> s2.getMetaRegionLocations(c, MasterProtos.GetMetaRegionLocationsRequest.getDefaultInstance(), d), r -> r.getMetaLocationsCount() != 0, "getMetaLocationsCount").thenApply(this::transformMetaRegionLocations);
    }

    @Override
    public CompletableFuture<String> getClusterId() {
        return this.call((c, s2, d) -> s2.getClusterId(c, MasterProtos.GetClusterIdRequest.getDefaultInstance(), d), MasterProtos.GetClusterIdResponse::hasClusterId, "getClusterId()").thenApply(MasterProtos.GetClusterIdResponse::getClusterId);
    }

    private ServerName transformServerName(MasterProtos.GetActiveMasterResponse resp) {
        return ProtobufUtil.toServerName(resp.getServerName());
    }

    @Override
    public CompletableFuture<ServerName> getActiveMaster() {
        return this.call((c, s2, d) -> s2.getActiveMaster(c, MasterProtos.GetActiveMasterRequest.getDefaultInstance(), d), MasterProtos.GetActiveMasterResponse::hasServerName, "getActiveMaster()").thenApply(this::transformServerName);
    }

    @VisibleForTesting
    Set<ServerName> getParsedMasterServers() {
        return this.masterAddr2Stub.keySet();
    }

    @Override
    public void close() {
        if (this.rpcClient != null) {
            this.rpcClient.close();
        }
    }

    @FunctionalInterface
    private static interface Callable<T> {
        public void call(HBaseRpcController var1, MasterProtos.ClientMetaService.Interface var2, RpcCallback<T> var3);
    }
}

