/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.SplitWALManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ServerCrashProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.ServerCrashState>
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(ServerCrashProcedure.class);
    private ServerName serverName;
    private boolean notifiedDeadServer = false;
    private List<RegionInfo> regionsOnCrashedServer;
    private boolean carryingMeta = false;
    private boolean shouldSplitWal;
    private MonitoredTask status;
    private MasterProcedureProtos.ServerCrashState currentRunningState = this.getInitialState();

    public ServerCrashProcedure(MasterProcedureEnv env, ServerName serverName, boolean shouldSplitWal, boolean carryingMeta) {
        this.serverName = serverName;
        this.shouldSplitWal = shouldSplitWal;
        this.carryingMeta = carryingMeta;
        this.setOwner(env.getRequestUser());
    }

    public ServerCrashProcedure() {
    }

    public boolean isInRecoverMetaState() {
        return this.getCurrentState() == MasterProcedureProtos.ServerCrashState.SERVER_CRASH_PROCESS_META;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws ProcedureSuspendedException, ProcedureYieldException {
        MasterServices services = env.getMasterServices();
        AssignmentManager am = env.getAssignmentManager();
        this.updateProgress(true);
        if (!this.notifiedDeadServer) {
            services.getServerManager().getDeadServers().processing(this.serverName);
            this.notifiedDeadServer = true;
        }
        switch (state) {
            case SERVER_CRASH_START: 
            case SERVER_CRASH_SPLIT_META_LOGS: 
            case SERVER_CRASH_DELETE_SPLIT_META_WALS_DIR: 
            case SERVER_CRASH_ASSIGN_META: {
                break;
            }
            default: {
                if (!env.getAssignmentManager().waitMetaLoaded(this)) break;
                throw new ProcedureSuspendedException();
            }
        }
        try {
            switch (state) {
                case SERVER_CRASH_START: {
                    LOG.info("Start " + this);
                    if (this.carryingMeta) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_META_LOGS);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_SPLIT_META_LOGS: {
                    if (env.getMasterConfiguration().getBoolean("hbase.split.wal.zk.coordinated", true)) {
                        this.splitMetaLogs(env);
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN_META);
                        break;
                    }
                    am.getRegionStates().metaLogSplitting(this.serverName);
                    this.addChildProcedure(this.createSplittingWalProcedures(env, true));
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_DELETE_SPLIT_META_WALS_DIR);
                    break;
                }
                case SERVER_CRASH_DELETE_SPLIT_META_WALS_DIR: {
                    if (this.isSplittingDone(env, true)) {
                        this.cleanupSplitDir(env);
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN_META);
                        am.getRegionStates().metaLogSplit(this.serverName);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_META_LOGS);
                    break;
                }
                case SERVER_CRASH_ASSIGN_META: {
                    this.assignRegions(env, Arrays.asList(RegionInfoBuilder.FIRST_META_REGIONINFO));
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_GET_REGIONS: {
                    this.regionsOnCrashedServer = this.getRegionsOnCrashedServer(env);
                    if (this.regionsOnCrashedServer != null) {
                        LOG.info("{} had {} regions", (Object)this.serverName, (Object)this.regionsOnCrashedServer.size());
                        if (LOG.isTraceEnabled()) {
                            this.regionsOnCrashedServer.stream().forEach(ri -> LOG.trace(ri.getShortNameToLog()));
                        }
                    }
                    if (!this.shouldSplitWal) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_LOGS);
                    break;
                }
                case SERVER_CRASH_SPLIT_LOGS: {
                    if (env.getMasterConfiguration().getBoolean("hbase.split.wal.zk.coordinated", true)) {
                        this.splitLogs(env);
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                        break;
                    }
                    am.getRegionStates().logSplitting(this.serverName);
                    this.addChildProcedure(this.createSplittingWalProcedures(env, false));
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_DELETE_SPLIT_WALS_DIR);
                    break;
                }
                case SERVER_CRASH_DELETE_SPLIT_WALS_DIR: {
                    if (this.isSplittingDone(env, false)) {
                        this.cleanupSplitDir(env);
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                        am.getRegionStates().logSplit(this.serverName);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_LOGS);
                    break;
                }
                case SERVER_CRASH_ASSIGN: {
                    if (this.filterDefaultMetaRegions()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Assigning regions " + RegionInfo.getShortNameToLog(this.regionsOnCrashedServer) + ", " + this + "; cycles=" + this.getCycles());
                        }
                        this.assignRegions(env, this.regionsOnCrashedServer);
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_FINISH);
                    break;
                }
                case SERVER_CRASH_HANDLE_RIT2: {
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_FINISH);
                    break;
                }
                case SERVER_CRASH_FINISH: {
                    LOG.info("removed crashed server {} after splitting done", (Object)this.serverName);
                    services.getAssignmentManager().getRegionStates().removeServer(this.serverName);
                    services.getServerManager().getDeadServers().finish(this.serverName);
                    this.updateProgress(true);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Failed state=" + state + ", retry " + this + "; cycles=" + this.getCycles(), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    List<RegionInfo> getRegionsOnCrashedServer(MasterProcedureEnv env) {
        return env.getMasterServices().getAssignmentManager().getRegionsOnServer(this.serverName);
    }

    private void cleanupSplitDir(MasterProcedureEnv env) {
        SplitWALManager splitWALManager = env.getMasterServices().getSplitWALManager();
        try {
            splitWALManager.deleteWALDir(this.serverName);
        }
        catch (IOException e) {
            LOG.warn("Remove WAL directory of server {} failed, ignore...", (Object)this.serverName, (Object)e);
        }
    }

    private boolean isSplittingDone(MasterProcedureEnv env, boolean splitMeta) {
        LOG.debug("check if splitting WALs of {} done? isMeta: {}", (Object)this.serverName, (Object)splitMeta);
        SplitWALManager splitWALManager = env.getMasterServices().getSplitWALManager();
        try {
            return splitWALManager.getWALsToSplit(this.serverName, splitMeta).size() == 0;
        }
        catch (IOException e) {
            LOG.warn("get filelist of serverName {} failed, retry...", (Object)this.serverName, (Object)e);
            return false;
        }
    }

    private Procedure[] createSplittingWalProcedures(MasterProcedureEnv env, boolean splitMeta) throws IOException {
        LOG.info("Splitting WALs {}, isMeta: {}", (Object)this, (Object)splitMeta);
        SplitWALManager splitWALManager = env.getMasterServices().getSplitWALManager();
        List<Procedure> procedures = splitWALManager.splitWALs(this.serverName, splitMeta);
        return procedures.toArray(new Procedure[procedures.size()]);
    }

    private boolean filterDefaultMetaRegions() {
        if (this.regionsOnCrashedServer == null) {
            return false;
        }
        this.regionsOnCrashedServer.removeIf(this::isDefaultMetaRegion);
        return !this.regionsOnCrashedServer.isEmpty();
    }

    private boolean isDefaultMetaRegion(RegionInfo hri) {
        return hri.isMetaRegion() && RegionReplicaUtil.isDefaultReplica(hri);
    }

    private void splitMetaLogs(MasterProcedureEnv env) throws IOException {
        LOG.debug("Splitting meta WALs {}", (Object)this);
        MasterWalManager mwm = env.getMasterServices().getMasterWalManager();
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        am.getRegionStates().metaLogSplitting(this.serverName);
        mwm.splitMetaLog(this.serverName);
        am.getRegionStates().metaLogSplit(this.serverName);
        LOG.debug("Done splitting meta WALs {}", (Object)this);
    }

    private void splitLogs(MasterProcedureEnv env) throws IOException {
        LOG.debug("Splitting WALs {}", (Object)this);
        MasterWalManager mwm = env.getMasterServices().getMasterWalManager();
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        am.getRegionStates().logSplitting(this.serverName);
        mwm.splitLog(this.serverName);
        if (!this.carryingMeta) {
            mwm.archiveMetaLog(this.serverName);
        }
        am.getRegionStates().logSplit(this.serverName);
        LOG.debug("Done splitting WALs {}", (Object)this);
    }

    void updateProgress(boolean updateState) {
        String msg = "Processing ServerCrashProcedure of " + this.serverName;
        if (this.status == null) {
            this.status = TaskMonitor.get().createStatus(msg);
            return;
        }
        if (this.currentRunningState == MasterProcedureProtos.ServerCrashState.SERVER_CRASH_FINISH) {
            this.status.markComplete(msg + " done");
            return;
        }
        if (updateState) {
            this.currentRunningState = (MasterProcedureProtos.ServerCrashState)this.getCurrentState();
        }
        int childrenLatch = this.getChildrenLatch();
        this.status.setStatus(msg + " current State " + this.currentRunningState + (childrenLatch > 0 ? "; remaining num of running child procedures = " + childrenLatch : ""));
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws IOException {
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected MasterProcedureProtos.ServerCrashState getState(int stateId) {
        return MasterProcedureProtos.ServerCrashState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.ServerCrashState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.ServerCrashState getInitialState() {
        return MasterProcedureProtos.ServerCrashState.SERVER_CRASH_START;
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitServerExclusiveLock(this, this.getServerName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeServerExclusiveLock(this, this.getServerName());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getProcName());
        sb.append(", splitWal=");
        sb.append(this.shouldSplitWal);
        sb.append(", meta=");
        sb.append(this.carryingMeta);
    }

    @Override
    public String getProcName() {
        return this.getClass().getSimpleName() + " " + this.serverName;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ServerCrashStateData.Builder state = MasterProcedureProtos.ServerCrashStateData.newBuilder().setServerName(ProtobufUtil.toServerName(this.serverName)).setCarryingMeta(this.carryingMeta).setShouldSplitWal(this.shouldSplitWal);
        if (this.regionsOnCrashedServer != null && !this.regionsOnCrashedServer.isEmpty()) {
            for (RegionInfo hri : this.regionsOnCrashedServer) {
                state.addRegionsOnCrashedServer(ProtobufUtil.toRegionInfo(hri));
            }
        }
        serializer.serialize(state.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ServerCrashStateData state = serializer.deserialize(MasterProcedureProtos.ServerCrashStateData.class);
        this.serverName = ProtobufUtil.toServerName(state.getServerName());
        this.carryingMeta = state.hasCarryingMeta() ? state.getCarryingMeta() : false;
        this.shouldSplitWal = state.getShouldSplitWal();
        int size = state.getRegionsOnCrashedServerCount();
        if (size > 0) {
            this.regionsOnCrashedServer = new ArrayList<RegionInfo>(size);
            for (HBaseProtos.RegionInfo ri : state.getRegionsOnCrashedServerList()) {
                this.regionsOnCrashedServer.add(ProtobufUtil.toRegionInfo(ri));
            }
        }
        this.updateProgress(false);
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return this.carryingMeta;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.CRASH_HANDLER;
    }

    @Override
    protected boolean shouldWaitClientAck(MasterProcedureEnv env) {
        return false;
    }

    protected boolean isMatchingRegionLocation(RegionStateNode rsn) {
        return this.serverName.equals(rsn.getRegionLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignRegions(MasterProcedureEnv env, List<RegionInfo> regions) throws IOException {
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        for (RegionInfo region : regions) {
            RegionStateNode regionNode = am.getRegionStates().getOrCreateRegionStateNode(region);
            regionNode.lock();
            try {
                if (!this.isMatchingRegionLocation(regionNode)) {
                    if (!am.isRunning()) {
                        throw new DoNotRetryIOException("AssignmentManager has been stopped, can not process assignment any more");
                    }
                    LOG.info("{} found {} whose regionLocation no longer matches {}, skipping assign...", new Object[]{this, regionNode, this.serverName});
                    continue;
                }
                if (regionNode.getProcedure() != null) {
                    LOG.info("{} found RIT {}; {}", new Object[]{this, regionNode.getProcedure(), regionNode});
                    regionNode.getProcedure().serverCrashed(env, regionNode, this.getServerName());
                    continue;
                }
                if (env.getMasterServices().getTableStateManager().isTableState(regionNode.getTable(), TableState.State.DISABLING)) {
                    env.getAssignmentManager().regionClosedAbnormally(regionNode);
                    LOG.info("{} found table disabling for region {}, set it state to ABNORMALLY_CLOSED.", (Object)this, (Object)regionNode);
                    continue;
                }
                if (env.getMasterServices().getTableStateManager().isTableState(regionNode.getTable(), TableState.State.DISABLED)) {
                    LOG.warn("Found table disabled for region {}, procDetails: {}", (Object)regionNode, (Object)this);
                    continue;
                }
                TransitRegionStateProcedure proc = TransitRegionStateProcedure.assign(env, region, true, null);
                regionNode.setProcedure(proc);
                this.addChildProcedure(new TransitRegionStateProcedure[]{proc});
            }
            finally {
                regionNode.unlock();
            }
        }
    }

    @Override
    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getMasterServices().getMasterMetrics().getServerCrashProcMetrics();
    }

    @Override
    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    public static void updateProgress(MasterProcedureEnv env, long parentId) {
        if (parentId == -1L) {
            return;
        }
        Procedure<MasterProcedureEnv> parentProcedure = env.getMasterServices().getMasterProcedureExecutor().getProcedure(parentId);
        if (parentProcedure != null && parentProcedure instanceof ServerCrashProcedure) {
            ((ServerCrashProcedure)parentProcedure).updateProgress(false);
        }
    }
}

