/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsWALSourceImpl
extends BaseSourceImpl
implements MetricsWALSource {
    private final MetricHistogram appendSizeHisto;
    private final MetricHistogram appendTimeHisto = this.getMetricsRegistry().newTimeHistogram("appendTime", "Time an append to the log took.");
    private final MetricHistogram syncTimeHisto;
    private final MutableFastCounter appendCount;
    private final MutableFastCounter slowAppendCount;
    private final MutableFastCounter logRollRequested;
    private final MutableFastCounter errorRollRequested;
    private final MutableFastCounter lowReplicationRollRequested;
    private final MutableFastCounter slowSyncRollRequested;
    private final MutableFastCounter sizeRollRequested;
    private final MutableFastCounter writtenBytes;

    public MetricsWALSourceImpl() {
        this("WAL", "Metrics about HBase RegionServer WAL", "regionserver", "RegionServer,sub=WAL");
    }

    public MetricsWALSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.appendSizeHisto = this.getMetricsRegistry().newSizeHistogram("appendSize", "Size (in bytes) of the data appended to the WAL.");
        this.appendCount = this.getMetricsRegistry().newCounter("appendCount", "Number of appends to the write ahead log.", 0L);
        this.slowAppendCount = this.getMetricsRegistry().newCounter("slowAppendCount", "Number of appends that were slow.", 0L);
        this.syncTimeHisto = this.getMetricsRegistry().newTimeHistogram("syncTime", "The time it took to sync the WAL to HDFS.");
        this.logRollRequested = this.getMetricsRegistry().newCounter("rollRequest", "How many times a roll has been requested total", 0L);
        this.errorRollRequested = this.getMetricsRegistry().newCounter("errorRollRequest", "How many times a roll was requested due to I/O or other errors.", 0L);
        this.lowReplicationRollRequested = this.getMetricsRegistry().newCounter("lowReplicaRollRequest", "How many times a roll was requested due to too few datanodes in the write pipeline.", 0L);
        this.slowSyncRollRequested = this.getMetricsRegistry().newCounter("slowSyncRollRequest", "How many times a roll was requested due to sync too slow on the write pipeline.", 0L);
        this.sizeRollRequested = this.getMetricsRegistry().newCounter("sizeRollRequest", "How many times a roll was requested due to file size roll threshold.", 0L);
        this.writtenBytes = this.getMetricsRegistry().newCounter("writtenBytes", "Size (in bytes) of the data written to the WAL.", 0L);
    }

    @Override
    public void incrementAppendSize(long size) {
        this.appendSizeHisto.add(size);
    }

    @Override
    public void incrementAppendTime(long time) {
        this.appendTimeHisto.add(time);
    }

    @Override
    public void incrementAppendCount() {
        this.appendCount.incr();
    }

    @Override
    public void incrementSlowAppendCount() {
        this.slowAppendCount.incr();
    }

    @Override
    public void incrementSyncTime(long time) {
        this.syncTimeHisto.add(time);
    }

    @Override
    public void incrementLogRollRequested() {
        this.logRollRequested.incr();
    }

    @Override
    public void incrementErrorLogRoll() {
        this.errorRollRequested.incr();
    }

    @Override
    public void incrementLowReplicationLogRoll() {
        this.lowReplicationRollRequested.incr();
    }

    @Override
    public void incrementSlowSyncLogRoll() {
        this.slowSyncRollRequested.incr();
    }

    @Override
    public void incrementSizeLogRoll() {
        this.sizeRollRequested.incr();
    }

    @Override
    public long getSlowAppendCount() {
        return this.slowAppendCount.value();
    }

    @Override
    public void incrementWrittenBytes(long val) {
        this.writtenBytes.incr(val);
    }

    @Override
    public long getWrittenBytes() {
        return this.writtenBytes.value();
    }
}

