/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class LoadCandidateGenerator
extends CandidateGenerator {
    LoadCandidateGenerator() {
    }

    @Override
    BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
        cluster.sortServersByRegionCount();
        int thisServer = this.pickMostLoadedServer(cluster, -1);
        int otherServer = this.pickLeastLoadedServer(cluster, thisServer);
        return this.pickRandomRegions(cluster, thisServer, otherServer);
    }

    private int pickLeastLoadedServer(BaseLoadBalancer.Cluster cluster, int thisServer) {
        Integer[] servers = cluster.serverIndicesSortedByRegionCount;
        int index = 0;
        while (servers[index] == null || servers[index] == thisServer) {
            if (++index != servers.length) continue;
            return -1;
        }
        return servers[index];
    }

    private int pickMostLoadedServer(BaseLoadBalancer.Cluster cluster, int thisServer) {
        Integer[] servers = cluster.serverIndicesSortedByRegionCount;
        int index = servers.length - 1;
        while (servers[index] == null || servers[index] == thisServer) {
            if (--index >= 0) continue;
            return -1;
        }
        return servers[index];
    }
}

