/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MergeNormalizationPlan
implements NormalizationPlan {
    private final RegionInfo firstRegion;
    private final RegionInfo secondRegion;

    public MergeNormalizationPlan(RegionInfo firstRegion, RegionInfo secondRegion) {
        this.firstRegion = firstRegion;
        this.secondRegion = secondRegion;
    }

    @Override
    public long submit(MasterServices masterServices) throws IOException {
        return masterServices.mergeRegions(new RegionInfo[]{this.firstRegion, this.secondRegion}, false, 0L, 0L);
    }

    @Override
    public NormalizationPlan.PlanType getType() {
        return NormalizationPlan.PlanType.MERGE;
    }

    RegionInfo getFirstRegion() {
        return this.firstRegion;
    }

    RegionInfo getSecondRegion() {
        return this.secondRegion;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("firstRegion", this.firstRegion).append("secondRegion", this.secondRegion).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeNormalizationPlan that = (MergeNormalizationPlan)o;
        return new EqualsBuilder().append(this.firstRegion, that.firstRegion).append(this.secondRegion, that.secondRegion).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.firstRegion).append(this.secondRegion).toHashCode();
    }
}

