/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SnapshotSegmentScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;

@InterfaceAudience.Private
public class CompositeImmutableSegment
extends ImmutableSegment {
    private final List<ImmutableSegment> segments;
    private long keySize = 0L;

    public CompositeImmutableSegment(CellComparator comparator, List<ImmutableSegment> segments) {
        super(comparator, segments);
        this.segments = segments;
        for (ImmutableSegment s2 : segments) {
            this.timeRangeTracker.includeTimestamp(s2.getTimeRangeTracker().getMax());
            this.timeRangeTracker.includeTimestamp(s2.getTimeRangeTracker().getMin());
            this.keySize += s2.getDataSize();
        }
    }

    @Override
    @VisibleForTesting
    public List<Segment> getAllSegments() {
        return new ArrayList<Segment>(this.segments);
    }

    @Override
    public int getNumOfSegments() {
        return this.segments.size();
    }

    @Override
    public boolean isEmpty() {
        for (ImmutableSegment s2 : this.segments) {
            if (s2.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCellsCount() {
        int result = 0;
        for (ImmutableSegment s2 : this.segments) {
            result += s2.getCellsCount();
        }
        return result;
    }

    @Override
    public void close() {
        for (ImmutableSegment s2 : this.segments) {
            s2.close();
        }
    }

    @Override
    public Cell maybeCloneWithAllocator(Cell cell, boolean forceCloneOfBigCell) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public boolean shouldSeek(TimeRange tr, long oldestUnexpiredTS) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public KeyValueScanner getScanner(long readPoint) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPoint) {
        ArrayList<KeyValueScanner> list = new ArrayList<KeyValueScanner>(this.segments.size());
        AbstractMemStore.addToScanners(this.segments, readPoint, list);
        return list;
    }

    @Override
    public boolean isTagsPresent() {
        for (ImmutableSegment s2 : this.segments) {
            if (!s2.isTagsPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void incScannerCount() {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public void decScannerCount() {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    protected CompositeImmutableSegment setCellSet(CellSet cellSetOld, CellSet cellSetNew) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    protected long indexEntrySize() {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    protected boolean canBeFlattened() {
        return false;
    }

    @Override
    public long getDataSize() {
        return this.keySize;
    }

    @Override
    public long getHeapSize() {
        long result = 0L;
        for (ImmutableSegment s2 : this.segments) {
            result += s2.getHeapSize();
        }
        return result;
    }

    @Override
    public long incMemStoreSize(long delta, long heapOverhead, long offHeapOverhead, int cellsCount) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public long getMinSequenceId() {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public TimeRangeTracker getTimeRangeTracker() {
        return this.timeRangeTracker;
    }

    @Override
    public Cell last() {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public Iterator<Cell> iterator() {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public SortedSet<Cell> headSet(Cell firstKeyOnRow) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public int compare(Cell left, Cell right) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    public int compareRows(Cell left, Cell right) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    protected CellSet getCellSet() {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    protected void internalAdd(Cell cell, boolean mslabUsed, MemStoreSizing memstoreSizing, boolean sizeAddedPreOperation) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    protected void updateMetaInfo(Cell cellToAdd, boolean succ, boolean mslabUsed, MemStoreSizing memstoreSizing, boolean sizeAddedPreOperation) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    protected SortedSet<Cell> tailSet(Cell firstCell) {
        throw new IllegalStateException("Not supported by CompositeImmutableScanner");
    }

    @Override
    void dump(Logger log) {
        for (ImmutableSegment s2 : this.segments) {
            s2.dump(log);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("This is CompositeImmutableSegment and those are its segments:: ");
        for (ImmutableSegment s2 : this.segments) {
            sb.append(s2.toString());
        }
        return sb.toString();
    }

    @Override
    List<KeyValueScanner> getSnapshotScanners() {
        ArrayList<KeyValueScanner> list = new ArrayList<KeyValueScanner>(this.segments.size());
        for (ImmutableSegment segment : this.segments) {
            list.add(new SnapshotSegmentScanner(segment));
        }
        return list;
    }
}

