/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CurrentHourProvider {
    @VisibleForTesting
    static volatile Tick tick = CurrentHourProvider.nextTick();

    private CurrentHourProvider() {
        throw new AssertionError();
    }

    @VisibleForTesting
    static Tick nextTick() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(EnvironmentEdgeManager.currentTime());
        int currentHour = calendar.get(11);
        CurrentHourProvider.moveToNextHour(calendar);
        return new Tick(currentHour, calendar.getTimeInMillis());
    }

    private static void moveToNextHour(Calendar calendar) {
        calendar.add(11, 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static int getCurrentHour() {
        Tick tick = CurrentHourProvider.tick;
        if (EnvironmentEdgeManager.currentTime() < tick.expirationTimeInMillis) {
            return tick.currentHour;
        }
        CurrentHourProvider.tick = tick = CurrentHourProvider.nextTick();
        return tick.currentHour;
    }

    private static final class Tick {
        final int currentHour;
        final long expirationTimeInMillis;

        Tick(int currentHour, long expirationTimeInMillis) {
            this.currentHour = currentHour;
            this.expirationTimeInMillis = expirationTimeInMillis;
        }
    }
}

