/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.HandlerUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class UnassignRegionHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UnassignRegionHandler.class);
    private final String encodedName;
    private final long closeProcId;
    private final boolean abort;
    private final ServerName destination;
    private final RetryCounter retryCounter;

    public UnassignRegionHandler(HRegionServer server, String encodedName, long closeProcId, boolean abort, @Nullable ServerName destination, EventType eventType) {
        super(server, eventType);
        this.encodedName = encodedName;
        this.closeProcId = closeProcId;
        this.abort = abort;
        this.destination = destination;
        this.retryCounter = HandlerUtil.getRetryCounter();
    }

    private HRegionServer getServer() {
        return (HRegionServer)this.server;
    }

    @Override
    public void process() throws IOException {
        HRegionServer rs = this.getServer();
        byte[] encodedNameBytes = Bytes.toBytes(this.encodedName);
        Boolean previous = rs.getRegionsInTransitionInRS().putIfAbsent(encodedNameBytes, Boolean.FALSE);
        if (previous != null) {
            if (previous.booleanValue()) {
                long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
                LOG.warn("Received CLOSE for the region: {}, which we are already trying to OPEN. try again after {}ms", (Object)this.encodedName, (Object)backoff);
                rs.getExecutorService().delayedSubmit(this, backoff, TimeUnit.MILLISECONDS);
            } else {
                LOG.info("Received CLOSE for the region: {}, which we are already trying to CLOSE, but not completed yet", (Object)this.encodedName);
            }
            return;
        }
        HRegion region = rs.getRegion(this.encodedName);
        if (region == null) {
            LOG.debug("Received CLOSE for a region {} which is not online, and we're not opening/closing.", (Object)this.encodedName);
            rs.getRegionsInTransitionInRS().remove(encodedNameBytes, Boolean.FALSE);
            return;
        }
        String regionName = region.getRegionInfo().getEncodedName();
        LOG.info("Close {}", (Object)regionName);
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().preClose(this.abort);
        }
        if (region.close(this.abort) == null) {
            LOG.warn("Can't close region {}, was already closed during close()", (Object)regionName);
            rs.getRegionsInTransitionInRS().remove(encodedNameBytes, Boolean.FALSE);
            return;
        }
        rs.removeRegion(region, this.destination);
        if (!rs.reportRegionStateTransition(new RegionServerServices.RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED, -1L, this.closeProcId, -1L, region.getRegionInfo()))) {
            throw new IOException("Failed to report close to master: " + regionName);
        }
        rs.finishRegionProcedure(this.closeProcId);
        rs.getRegionsInTransitionInRS().remove(encodedNameBytes, Boolean.FALSE);
        LOG.info("Closed {}", (Object)regionName);
    }

    @Override
    protected void handleException(Throwable t) {
        LOG.warn("Fatal error occurred while closing region {}, aborting...", (Object)this.encodedName, (Object)t);
        this.getServer().getRegionsInTransitionInRS().remove(Bytes.toBytes(this.encodedName));
        this.getServer().abort("Failed to close region " + this.encodedName + " and can not recover", t);
    }

    public static UnassignRegionHandler create(HRegionServer server, String encodedName, long closeProcId, boolean abort, @Nullable ServerName destination) {
        HRegion region = server.getRegion(encodedName);
        EventType eventType = region != null && region.getRegionInfo().isMetaRegion() ? EventType.M_RS_CLOSE_META : EventType.M_RS_CLOSE_REGION;
        return new UnassignRegionHandler(server, encodedName, closeProcId, abort, destination, eventType);
    }
}

