/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.exceptions.RequestTooBigException;
import org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerRpcConnection;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcServerResponder;
import org.apache.hadoop.hbase.ipc.SimpleServerCall;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="False positive according to http://sourceforge.net/p/findbugs/bugs/1032/")
class SimpleServerRpcConnection
extends ServerRpcConnection {
    final SocketChannel channel;
    private ByteBuff data;
    private ByteBuffer dataLengthBuffer;
    private ByteBuffer preambleBuffer;
    private final LongAdder rpcCount = new LongAdder();
    private long lastContact;
    private final Socket socket;
    final SimpleRpcServerResponder responder;
    private boolean connectionPreambleRead = false;
    final ConcurrentLinkedDeque<RpcResponse> responseQueue = new ConcurrentLinkedDeque();
    final Lock responseWriteLock = new ReentrantLock();
    long lastSentTime = -1L;

    public SimpleServerRpcConnection(SimpleRpcServer rpcServer, SocketChannel channel, long lastContact) {
        super(rpcServer);
        this.channel = channel;
        this.lastContact = lastContact;
        this.data = null;
        this.dataLengthBuffer = ByteBuffer.allocate(4);
        this.socket = channel.socket();
        this.addr = this.socket.getInetAddress();
        this.hostAddress = this.addr == null ? "*Unknown*" : this.addr.getHostAddress();
        this.remotePort = this.socket.getPort();
        if (rpcServer.socketSendBufferSize != 0) {
            try {
                this.socket.setSendBufferSize(rpcServer.socketSendBufferSize);
            }
            catch (IOException e) {
                SimpleRpcServer.LOG.warn("Connection: unable to set socket send buffer size to " + rpcServer.socketSendBufferSize);
            }
        }
        this.responder = rpcServer.responder;
    }

    public void setLastContact(long lastContact) {
        this.lastContact = lastContact;
    }

    public long getLastContact() {
        return this.lastContact;
    }

    boolean isIdle() {
        return this.rpcCount.sum() == 0L;
    }

    protected void decRpcCount() {
        this.rpcCount.decrement();
    }

    protected void incRpcCount() {
        this.rpcCount.increment();
    }

    private int readPreamble() throws IOException {
        int count;
        if (this.preambleBuffer == null) {
            this.preambleBuffer = ByteBuffer.allocate(6);
        }
        if ((count = this.rpcServer.channelRead(this.channel, this.preambleBuffer)) < 0 || this.preambleBuffer.remaining() > 0) {
            return count;
        }
        this.preambleBuffer.flip();
        if (!this.processPreamble(this.preambleBuffer)) {
            return -1;
        }
        this.preambleBuffer = null;
        this.connectionPreambleRead = true;
        return count;
    }

    private int read4Bytes() throws IOException {
        if (this.dataLengthBuffer.remaining() > 0) {
            return this.rpcServer.channelRead(this.channel, this.dataLengthBuffer);
        }
        return 0;
    }

    public int readAndProcess() throws IOException, InterruptedException {
        int count;
        if (!this.connectionPreambleRead) {
            count = this.readPreamble();
            if (!this.connectionPreambleRead) {
                return count;
            }
        }
        if ((count = this.read4Bytes()) < 0 || this.dataLengthBuffer.remaining() > 0) {
            return count;
        }
        if (this.data == null) {
            this.dataLengthBuffer.flip();
            int dataLength = this.dataLengthBuffer.getInt();
            if (dataLength == -1 && !this.useWrap) {
                this.dataLengthBuffer.clear();
                return 0;
            }
            if (dataLength < 0) {
                throw new DoNotRetryIOException("Unexpected data length " + dataLength + "!! from " + this.getHostAddress());
            }
            if (dataLength > this.rpcServer.maxRequestSize) {
                String msg = "RPC data length of " + dataLength + " received from " + this.getHostAddress() + " is greater than max allowed " + this.rpcServer.maxRequestSize + ". Set \"" + "hbase.ipc.max.request.size" + "\" on server to override this limit (not recommended)";
                SimpleRpcServer.LOG.warn(msg);
                if (this.connectionHeaderRead && this.connectionPreambleRead) {
                    this.incRpcCount();
                    final ByteBuffer buf = ByteBuffer.allocate(1);
                    InputStream is = new InputStream(){

                        @Override
                        public int read() throws IOException {
                            SimpleServerRpcConnection.this.rpcServer.channelRead(SimpleServerRpcConnection.this.channel, buf);
                            buf.flip();
                            byte x = buf.get();
                            buf.flip();
                            return x;
                        }
                    };
                    CodedInputStream cis = CodedInputStream.newInstance(is);
                    int headerSize = cis.readRawVarint32();
                    RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
                    ProtobufUtil.mergeFrom((Message.Builder)builder, cis, headerSize);
                    RPCProtos.RequestHeader header = (RPCProtos.RequestHeader)builder.build();
                    SimpleServerCall reqTooBig = new SimpleServerCall(header.getCallId(), this.service, null, null, null, null, this, 0L, this.addr, System.currentTimeMillis(), 0, this.rpcServer.bbAllocator, this.rpcServer.cellBlockBuilder, null, this.responder);
                    RequestTooBigException reqTooBigEx = new RequestTooBigException(msg);
                    this.rpcServer.metrics.exception(reqTooBigEx);
                    if (VersionInfoUtil.hasMinimumVersion(this.connectionHeader.getVersionInfo(), 1, 3)) {
                        reqTooBig.setResponse(null, null, reqTooBigEx, msg);
                    } else {
                        reqTooBig.setResponse(null, null, new DoNotRetryIOException(msg), msg);
                    }
                    reqTooBig.sendResponseIfReady();
                }
                return -1;
            }
            this.initByteBuffToReadInto(dataLength);
            this.incRpcCount();
        }
        if ((count = this.channelDataRead(this.channel, this.data)) >= 0 && this.data.remaining() == 0) {
            this.process();
        }
        return count;
    }

    private void initByteBuffToReadInto(int length) {
        this.data = this.rpcServer.bbAllocator.allocate(length);
        this.callCleanup = this.data::release;
    }

    protected int channelDataRead(ReadableByteChannel channel, ByteBuff buf) throws IOException {
        int count = buf.read(channel);
        if (count > 0) {
            this.rpcServer.metrics.receivedBytes(count);
        }
        return count;
    }

    private void process() throws IOException, InterruptedException {
        this.data.rewind();
        try {
            if (this.skipInitialSaslHandshake) {
                this.skipInitialSaslHandshake = false;
                return;
            }
            if (this.useSasl) {
                this.saslReadAndProcess(this.data);
            } else {
                this.processOneRpc(this.data);
            }
        }
        finally {
            this.dataLengthBuffer.clear();
            this.data = null;
            this.callCleanup = null;
        }
    }

    @Override
    public synchronized void close() {
        block9: {
            block8: {
                this.disposeSasl();
                this.data = null;
                this.callCleanup = null;
                if (!this.channel.isOpen()) {
                    return;
                }
                try {
                    this.socket.shutdownOutput();
                }
                catch (Exception ignored) {
                    if (!SimpleRpcServer.LOG.isTraceEnabled()) break block8;
                    SimpleRpcServer.LOG.trace("Ignored exception", (Throwable)ignored);
                }
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception ignored) {
                if (!SimpleRpcServer.LOG.isTraceEnabled()) break block9;
                SimpleRpcServer.LOG.trace("Ignored exception", (Throwable)ignored);
            }
        }
    }

    @Override
    public boolean isConnectionOpen() {
        return this.channel.isOpen();
    }

    public SimpleServerCall createCall(int id, BlockingService service, Descriptors.MethodDescriptor md, RPCProtos.RequestHeader header, Message param, CellScanner cellScanner, long size, InetAddress remoteAddress, int timeout, RpcServer.CallCleanup reqCleanup) {
        return new SimpleServerCall(id, service, md, header, param, cellScanner, this, size, remoteAddress, System.currentTimeMillis(), timeout, this.rpcServer.bbAllocator, this.rpcServer.cellBlockBuilder, reqCleanup, this.responder);
    }

    @Override
    protected void doRespond(RpcResponse resp) throws IOException {
        this.responder.doRespond(this, resp);
    }
}

