/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.StripeStoreConfig;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.StripeStoreFlusher;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcatenatedLists;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StripeCompactionPolicy
extends CompactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(StripeCompactionPolicy.class);
    private ExploringCompactionPolicy stripePolicy = null;
    private StripeStoreConfig config;

    public StripeCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo, StripeStoreConfig config) {
        super(conf, storeConfigInfo);
        this.config = config;
        this.stripePolicy = new ExploringCompactionPolicy(conf, storeConfigInfo);
    }

    public List<HStoreFile> preSelectFilesForCoprocessor(StripeInformationProvider si, List<HStoreFile> filesCompacting) {
        ArrayList<HStoreFile> candidateFiles = new ArrayList<HStoreFile>(si.getStorefiles());
        candidateFiles.removeAll(filesCompacting);
        return candidateFiles;
    }

    public StripeCompactionRequest createEmptyRequest(StripeInformationProvider si, CompactionRequestImpl request) {
        if (si.getStripeCount() > 0) {
            return new BoundaryStripeCompactionRequest(request, si.getStripeBoundaries());
        }
        Pair<Long, Integer> targetKvsAndCount = this.estimateTargetKvs(request.getFiles(), this.config.getInitialCount());
        return new SplitStripeCompactionRequest(request, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (int)targetKvsAndCount.getSecond(), (long)targetKvsAndCount.getFirst());
    }

    public StripeStoreFlusher.StripeFlushRequest selectFlush(CellComparator comparator, StripeInformationProvider si, int kvCount) {
        if (this.config.isUsingL0Flush()) {
            return new StripeStoreFlusher.StripeFlushRequest(comparator);
        }
        if (si.getStripeCount() == 0) {
            int initialCount = this.config.getInitialCount();
            return new StripeStoreFlusher.SizeStripeFlushRequest(comparator, initialCount, kvCount / initialCount);
        }
        return new StripeStoreFlusher.BoundaryStripeFlushRequest(comparator, si.getStripeBoundaries());
    }

    public StripeCompactionRequest selectCompaction(StripeInformationProvider si, List<HStoreFile> filesCompacting, boolean isOffpeak) throws IOException {
        boolean shouldCompactL0;
        if (!filesCompacting.isEmpty()) {
            LOG.debug("Not selecting compaction: " + filesCompacting.size() + " files compacting");
            return null;
        }
        Collection<HStoreFile> allFiles = si.getStorefiles();
        if (StoreUtils.hasReferences(allFiles)) {
            LOG.debug("There are references in the store; compacting all files");
            long targetKvs = this.estimateTargetKvs(allFiles, this.config.getInitialCount()).getFirst();
            SplitStripeCompactionRequest request = new SplitStripeCompactionRequest(allFiles, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, targetKvs);
            request.setMajorRangeFull();
            request.getRequest().setAfterSplit(true);
            return request;
        }
        int stripeCount = si.getStripeCount();
        List<HStoreFile> l0Files = si.getLevel0Files();
        boolean bl = shouldCompactL0 = this.config.getLevel0MinFiles() <= l0Files.size() || this.allL0FilesExpired(si);
        if (stripeCount == 0) {
            if (!shouldCompactL0) {
                return null;
            }
            return this.selectL0OnlyCompaction(si);
        }
        boolean canDropDeletesNoL0 = l0Files.isEmpty();
        if (shouldCompactL0) {
            StripeCompactionRequest result;
            if (!canDropDeletesNoL0 && (result = this.selectSingleStripeCompaction(si, !this.shouldSelectL0Files(si), canDropDeletesNoL0, isOffpeak)) != null) {
                return result;
            }
            LOG.debug("Selecting L0 compaction with " + l0Files.size() + " files");
            return this.selectL0OnlyCompaction(si);
        }
        StripeCompactionRequest result = this.selectExpiredMergeCompaction(si, canDropDeletesNoL0);
        if (result != null) {
            return result;
        }
        return this.selectSingleStripeCompaction(si, false, canDropDeletesNoL0, isOffpeak);
    }

    public boolean needsCompactions(StripeInformationProvider si, List<HStoreFile> filesCompacting) {
        return filesCompacting.isEmpty() && (StoreUtils.hasReferences(si.getStorefiles()) || si.getLevel0Files().size() >= this.config.getLevel0MinFiles() || this.needsSingleStripeCompaction(si) || this.hasExpiredStripes(si) || this.allL0FilesExpired(si));
    }

    @Override
    public boolean shouldPerformMajorCompaction(Collection<HStoreFile> filesToCompact) throws IOException {
        return false;
    }

    @Override
    public boolean throttleCompaction(long compactionSize) {
        return compactionSize > this.comConf.getThrottlePoint();
    }

    protected boolean needsSingleStripeCompaction(StripeInformationProvider si) {
        int minFiles = this.config.getStripeCompactMinFiles();
        for (List list : si.getStripes()) {
            if (list.size() < minFiles) continue;
            return true;
        }
        return false;
    }

    protected StripeCompactionRequest selectSingleStripeCompaction(StripeInformationProvider si, boolean includeL0, boolean canDropDeletesWithoutL0, boolean isOffpeak) throws IOException {
        StripeCompactionRequest req;
        ArrayList<ImmutableList<HStoreFile>> stripes = si.getStripes();
        int bqIndex = -1;
        List<HStoreFile> bqSelection = null;
        int stripeCount = stripes.size();
        long bqTotalSize = -1L;
        for (int i = 0; i < stripeCount; ++i) {
            List<HStoreFile> selection = this.selectSimpleCompaction((List<HStoreFile>)stripes.get(i), !canDropDeletesWithoutL0 && includeL0, isOffpeak, false);
            if (selection.isEmpty()) continue;
            long size = 0L;
            for (HStoreFile sf : selection) {
                size += sf.getReader().length();
            }
            if (bqSelection != null && selection.size() <= bqSelection.size() && (selection.size() != bqSelection.size() || size >= bqTotalSize)) continue;
            bqSelection = selection;
            bqIndex = i;
            bqTotalSize = size;
        }
        if (bqSelection == null) {
            LOG.debug("No good compaction is possible in any stripe");
            return null;
        }
        ArrayList<HStoreFile> filesToCompact = new ArrayList<HStoreFile>(bqSelection);
        int targetCount = 1;
        long targetKvs = Long.MAX_VALUE;
        boolean hasAllFiles = filesToCompact.size() == stripes.get(bqIndex).size();
        String splitString = "";
        if (hasAllFiles && bqTotalSize >= this.config.getSplitSize()) {
            if (includeL0) {
                return null;
            }
            Pair<Long, Integer> kvsAndCount = this.estimateTargetKvs(filesToCompact, this.config.getSplitCount());
            targetKvs = kvsAndCount.getFirst();
            targetCount = kvsAndCount.getSecond();
            splitString = "; the stripe will be split into at most " + targetCount + " stripes with " + targetKvs + " target KVs";
        }
        LOG.debug("Found compaction in a stripe with end key [" + Bytes.toString(si.getEndRow(bqIndex)) + "], with " + filesToCompact.size() + " files of total size " + bqTotalSize + splitString);
        if (includeL0) {
            assert (hasAllFiles);
            List<HStoreFile> l0Files = si.getLevel0Files();
            LOG.debug("Adding " + l0Files.size() + " files to compaction to be able to drop deletes");
            ConcatenatedLists<HStoreFile> sfs = new ConcatenatedLists<HStoreFile>();
            sfs.addSublist(filesToCompact);
            sfs.addSublist(l0Files);
            req = new BoundaryStripeCompactionRequest(sfs, si.getStripeBoundaries());
        } else {
            req = new SplitStripeCompactionRequest(filesToCompact, si.getStartRow(bqIndex), si.getEndRow(bqIndex), targetCount, targetKvs);
        }
        if (hasAllFiles && (canDropDeletesWithoutL0 || includeL0)) {
            req.setMajorRange(si.getStartRow(bqIndex), si.getEndRow(bqIndex));
        }
        req.getRequest().setOffPeak(isOffpeak);
        return req;
    }

    private List<HStoreFile> selectSimpleCompaction(List<HStoreFile> sfs, boolean allFilesOnly, boolean isOffpeak, boolean forceCompact) {
        int minFilesLocal = Math.max(allFilesOnly ? sfs.size() : 0, this.config.getStripeCompactMinFiles());
        int maxFilesLocal = Math.max(this.config.getStripeCompactMaxFiles(), minFilesLocal);
        List<HStoreFile> selected = this.stripePolicy.applyCompactionPolicy(sfs, false, isOffpeak, minFilesLocal, maxFilesLocal);
        if (forceCompact && (selected == null || selected.isEmpty()) && !sfs.isEmpty()) {
            return this.stripePolicy.selectCompactFiles(sfs, maxFilesLocal, isOffpeak);
        }
        return selected;
    }

    private boolean shouldSelectL0Files(StripeInformationProvider si) {
        return si.getLevel0Files().size() > this.config.getStripeCompactMaxFiles() || StripeCompactionPolicy.getTotalFileSize(si.getLevel0Files()) > this.comConf.getMaxCompactSize();
    }

    private StripeCompactionRequest selectL0OnlyCompaction(StripeInformationProvider si) {
        StripeCompactionRequest request;
        List<HStoreFile> l0Files;
        List<HStoreFile> selectedFiles = l0Files = si.getLevel0Files();
        if (this.shouldSelectL0Files(si)) {
            selectedFiles = this.selectSimpleCompaction(l0Files, false, false, true);
            assert (!selectedFiles.isEmpty()) : "Selected L0 files should not be empty";
        }
        if (si.getStripeCount() == 0) {
            Pair<Long, Integer> estimate = this.estimateTargetKvs(selectedFiles, this.config.getInitialCount());
            long targetKvs = estimate.getFirst();
            int targetCount = estimate.getSecond();
            request = new SplitStripeCompactionRequest(selectedFiles, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, targetCount, targetKvs);
            if (selectedFiles.size() == l0Files.size()) {
                ((SplitStripeCompactionRequest)request).setMajorRangeFull();
            }
            LOG.debug("Creating {} initial stripes with {} kvs each via L0 compaction of {}/{} files", new Object[]{targetCount, targetKvs, selectedFiles.size(), l0Files.size()});
        } else {
            request = new BoundaryStripeCompactionRequest(selectedFiles, si.getStripeBoundaries());
            LOG.debug("Boundary L0 compaction of {}/{} files", (Object)selectedFiles.size(), (Object)l0Files.size());
        }
        return request;
    }

    private StripeCompactionRequest selectExpiredMergeCompaction(StripeInformationProvider si, boolean canDropDeletesNoL0) {
        long cfTtl = this.storeConfigInfo.getStoreFileTtl();
        if (cfTtl == Long.MAX_VALUE) {
            return null;
        }
        long timestampCutoff = EnvironmentEdgeManager.currentTime() - cfTtl;
        int start = -1;
        int bestStart = -1;
        int length = 0;
        int bestLength = 0;
        ArrayList<ImmutableList<HStoreFile>> stripes = si.getStripes();
        block0: for (int i = 0; i < stripes.size(); ++i) {
            for (HStoreFile storeFile : stripes.get(i)) {
                if (storeFile.getReader().getMaxTimestamp() < timestampCutoff) continue;
                if (length > bestLength) {
                    bestStart = start;
                    bestLength = length;
                }
                start = -1;
                length = 0;
                continue block0;
            }
            if (start == -1) {
                start = i;
            }
            ++length;
        }
        if (length > bestLength) {
            bestStart = start;
            bestLength = length;
        }
        if (bestLength == 0) {
            return null;
        }
        if (bestLength == 1) {
            if (bestStart == stripes.size() - 1) {
                return null;
            }
            ++bestLength;
        }
        LOG.debug("Merging " + bestLength + " stripes to delete expired store files");
        int endIndex = bestStart + bestLength - 1;
        ConcatenatedLists<HStoreFile> sfs = new ConcatenatedLists<HStoreFile>();
        sfs.addAllSublists(stripes.subList(bestStart, endIndex + 1));
        SplitStripeCompactionRequest result = new SplitStripeCompactionRequest(sfs, si.getStartRow(bestStart), si.getEndRow(endIndex), 1, Long.MAX_VALUE);
        if (canDropDeletesNoL0) {
            result.setMajorRangeFull();
        }
        return result;
    }

    protected boolean hasExpiredStripes(StripeInformationProvider si) {
        ArrayList<ImmutableList<HStoreFile>> stripes = si.getStripes();
        for (ImmutableList<HStoreFile> stripe : stripes) {
            if (!this.allFilesExpired(stripe)) continue;
            return true;
        }
        return false;
    }

    protected boolean allL0FilesExpired(StripeInformationProvider si) {
        return this.allFilesExpired(si.getLevel0Files());
    }

    private boolean allFilesExpired(List<HStoreFile> storeFiles) {
        if (storeFiles == null || storeFiles.isEmpty()) {
            return false;
        }
        long cfTtl = this.storeConfigInfo.getStoreFileTtl();
        if (cfTtl == Long.MAX_VALUE) {
            return false;
        }
        long timestampCutoff = EnvironmentEdgeManager.currentTime() - cfTtl;
        for (HStoreFile storeFile : storeFiles) {
            if (storeFile.getReader().getMaxTimestamp() < timestampCutoff || storeFile.getReader().getEntries() == 0L) continue;
            return false;
        }
        return true;
    }

    private static long getTotalKvCount(Collection<HStoreFile> candidates) {
        long totalSize = 0L;
        for (HStoreFile storeFile : candidates) {
            totalSize += storeFile.getReader().getEntries();
        }
        return totalSize;
    }

    public static long getTotalFileSize(Collection<HStoreFile> candidates) {
        long totalSize = 0L;
        for (HStoreFile storeFile : candidates) {
            totalSize += storeFile.getReader().length();
        }
        return totalSize;
    }

    private Pair<Long, Integer> estimateTargetKvs(Collection<HStoreFile> files, double splitCount) {
        double newRatio;
        long totalSize = StripeCompactionPolicy.getTotalFileSize(files);
        long targetPartSize = this.config.getSplitPartSize();
        assert (targetPartSize > 0L && splitCount > 0.0);
        double ratio = (double)totalSize / (splitCount * (double)targetPartSize);
        while (ratio > 1.0 && !(1.0 / (newRatio = (double)totalSize / ((splitCount + 1.0) * (double)targetPartSize)) >= ratio)) {
            ratio = newRatio;
            splitCount += 1.0;
        }
        long kvCount = (long)((double)StripeCompactionPolicy.getTotalKvCount(files) / splitCount);
        return new Pair<Long, Integer>(kvCount, (int)Math.ceil(splitCount));
    }

    public static interface StripeInformationProvider {
        public Collection<HStoreFile> getStorefiles();

        public byte[] getStartRow(int var1);

        public byte[] getEndRow(int var1);

        public List<HStoreFile> getLevel0Files();

        public List<byte[]> getStripeBoundaries();

        public ArrayList<ImmutableList<HStoreFile>> getStripes();

        public int getStripeCount();
    }

    private static class SplitStripeCompactionRequest
    extends StripeCompactionRequest {
        private final byte[] startRow;
        private final byte[] endRow;
        private final int targetCount;
        private final long targetKvs;

        public SplitStripeCompactionRequest(CompactionRequestImpl request, byte[] startRow, byte[] endRow, int targetCount, long targetKvs) {
            super(request);
            this.startRow = startRow;
            this.endRow = endRow;
            this.targetCount = targetCount;
            this.targetKvs = targetKvs;
        }

        public SplitStripeCompactionRequest(Collection<HStoreFile> files, byte[] startRow, byte[] endRow, long targetKvs) {
            this(files, startRow, endRow, Integer.MAX_VALUE, targetKvs);
        }

        public SplitStripeCompactionRequest(Collection<HStoreFile> files, byte[] startRow, byte[] endRow, int targetCount, long targetKvs) {
            this(new CompactionRequestImpl(files), startRow, endRow, targetCount, targetKvs);
        }

        @Override
        public List<Path> execute(StripeCompactor compactor, ThroughputController throughputController, User user) throws IOException {
            return compactor.compact(this.request, this.targetCount, this.targetKvs, this.startRow, this.endRow, this.majorRangeFromRow, this.majorRangeToRow, throughputController, user);
        }

        public void setMajorRangeFull() {
            this.setMajorRange(this.startRow, this.endRow);
        }
    }

    private static class BoundaryStripeCompactionRequest
    extends StripeCompactionRequest {
        private final List<byte[]> targetBoundaries;

        public BoundaryStripeCompactionRequest(CompactionRequestImpl request, List<byte[]> targetBoundaries) {
            super(request);
            this.targetBoundaries = targetBoundaries;
        }

        public BoundaryStripeCompactionRequest(Collection<HStoreFile> files, List<byte[]> targetBoundaries) {
            this(new CompactionRequestImpl(files), targetBoundaries);
        }

        @Override
        public List<Path> execute(StripeCompactor compactor, ThroughputController throughputController, User user) throws IOException {
            return compactor.compact(this.request, this.targetBoundaries, this.majorRangeFromRow, this.majorRangeToRow, throughputController, user);
        }
    }

    public static abstract class StripeCompactionRequest {
        protected CompactionRequestImpl request;
        protected byte[] majorRangeFromRow = null;
        protected byte[] majorRangeToRow = null;

        public List<Path> execute(StripeCompactor compactor, ThroughputController throughputController) throws IOException {
            return this.execute(compactor, throughputController, null);
        }

        public abstract List<Path> execute(StripeCompactor var1, ThroughputController var2, User var3) throws IOException;

        public StripeCompactionRequest(CompactionRequestImpl request) {
            this.request = request;
        }

        public void setMajorRange(byte[] startRow, byte[] endRow) {
            this.majorRangeFromRow = startRow;
            this.majorRangeToRow = endRow;
        }

        public CompactionRequestImpl getRequest() {
            return this.request;
        }

        public void setRequest(CompactionRequestImpl request) {
            assert (request != null);
            this.request = request;
            this.majorRangeToRow = null;
            this.majorRangeFromRow = null;
        }
    }
}

