/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigListener;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationPeerImpl
implements ReplicationPeer {
    private final Configuration conf;
    private final String id;
    private volatile ReplicationPeerConfig peerConfig;
    private volatile ReplicationPeer.PeerState peerState;
    private final List<ReplicationPeerConfigListener> peerConfigListeners;

    public ReplicationPeerImpl(Configuration conf, String id, boolean peerState, ReplicationPeerConfig peerConfig) {
        this.conf = conf;
        this.id = id;
        this.setPeerState(peerState);
        this.peerConfig = peerConfig;
        this.peerConfigListeners = new ArrayList<ReplicationPeerConfigListener>();
    }

    public void setPeerState(boolean enabled) {
        this.peerState = enabled ? ReplicationPeer.PeerState.ENABLED : ReplicationPeer.PeerState.DISABLED;
    }

    public void setPeerConfig(ReplicationPeerConfig peerConfig) {
        this.peerConfig = peerConfig;
        this.peerConfigListeners.forEach(listener -> listener.peerConfigUpdated(peerConfig));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReplicationPeer.PeerState getPeerState() {
        return this.peerState;
    }

    @Override
    public ReplicationPeerConfig getPeerConfig() {
        return this.peerConfig;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public Map<TableName, List<String>> getTableCFs() {
        return this.peerConfig.getTableCFsMap();
    }

    @Override
    public Set<String> getNamespaces() {
        return this.peerConfig.getNamespaces();
    }

    @Override
    public long getPeerBandwidth() {
        return this.peerConfig.getBandwidth();
    }

    @Override
    public void registerPeerConfigListener(ReplicationPeerConfigListener listener) {
        this.peerConfigListeners.add(listener);
    }
}

