/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.replication.ReplicationListener;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationTrackerZKImpl
implements ReplicationTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationTrackerZKImpl.class);
    private final ZKWatcher zookeeper;
    private final Abortable abortable;
    private final Stoppable stopper;
    private final List<ReplicationListener> listeners = new CopyOnWriteArrayList<ReplicationListener>();
    private final List<ServerName> otherRegionServers = new ArrayList<ServerName>();

    public ReplicationTrackerZKImpl(ZKWatcher zookeeper, Abortable abortable, Stoppable stopper) {
        this.zookeeper = zookeeper;
        this.abortable = abortable;
        this.stopper = stopper;
        this.zookeeper.registerListener(new OtherRegionServerWatcher(this.zookeeper));
        this.refreshOtherRegionServersList(true);
    }

    @Override
    public void registerListener(ReplicationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ReplicationListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServerName> getListOfRegionServers() {
        this.refreshOtherRegionServersList(false);
        ArrayList<ServerName> list = null;
        List<ServerName> list2 = this.otherRegionServers;
        synchronized (list2) {
            list = new ArrayList<ServerName>(this.otherRegionServers);
        }
        return list;
    }

    private String getZNodeName(String fullPath) {
        String[] parts = fullPath.split("/");
        return parts.length > 0 ? parts[parts.length - 1] : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshOtherRegionServersList(boolean watch) {
        List<ServerName> newRsList = this.getRegisteredRegionServers(watch);
        if (newRsList == null) {
            return false;
        }
        List<ServerName> list = this.otherRegionServers;
        synchronized (list) {
            this.otherRegionServers.clear();
            this.otherRegionServers.addAll(newRsList);
        }
        return true;
    }

    private List<ServerName> getRegisteredRegionServers(boolean watch) {
        List<String> result = null;
        try {
            result = watch ? ZKUtil.listChildrenAndWatchThem(this.zookeeper, this.zookeeper.getZNodePaths().rsZNode) : ZKUtil.listChildrenNoWatch(this.zookeeper, this.zookeeper.getZNodePaths().rsZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Get list of registered region servers", e);
        }
        return result == null ? null : result.stream().map(ServerName::parseServerName).collect(Collectors.toList());
    }

    public class OtherRegionServerWatcher
    extends ZKListener {
        public OtherRegionServerWatcher(ZKWatcher watcher) {
            super(watcher);
        }

        @Override
        public void nodeCreated(String path) {
            this.refreshListIfRightPath(path);
        }

        @Override
        public void nodeDeleted(String path) {
            if (ReplicationTrackerZKImpl.this.stopper.isStopped()) {
                return;
            }
            boolean cont = this.refreshListIfRightPath(path);
            if (!cont) {
                return;
            }
            LOG.info(path + " znode expired, triggering replicatorRemoved event");
            for (ReplicationListener rl : ReplicationTrackerZKImpl.this.listeners) {
                rl.regionServerRemoved(ReplicationTrackerZKImpl.this.getZNodeName(path));
            }
        }

        @Override
        public void nodeChildrenChanged(String path) {
            if (ReplicationTrackerZKImpl.this.stopper.isStopped()) {
                return;
            }
            this.refreshListIfRightPath(path);
        }

        private boolean refreshListIfRightPath(String path) {
            if (!path.startsWith(this.watcher.getZNodePaths().rsZNode)) {
                return false;
            }
            return ReplicationTrackerZKImpl.this.refreshOtherRegionServersList(true);
        }
    }
}

