/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MetricsSnapshot;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotTTLExpiredException;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CloneSnapshotProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.CloneSnapshotState> {
    private static final Logger LOG = LoggerFactory.getLogger(CloneSnapshotProcedure.class);
    private TableDescriptor tableDescriptor;
    private SnapshotProtos.SnapshotDescription snapshot;
    private boolean restoreAcl;
    private String customSFT;
    private List<RegionInfo> newRegions = null;
    private Map<String, Pair<String, String>> parentsToChildrenPairMap = new HashMap<String, Pair<String, String>>();
    private MonitoredTask monitorStatus = null;

    public CloneSnapshotProcedure() {
    }

    public CloneSnapshotProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, SnapshotProtos.SnapshotDescription snapshot) {
        this(env, tableDescriptor, snapshot, false);
    }

    public CloneSnapshotProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, SnapshotProtos.SnapshotDescription snapshot, boolean restoreAcl) {
        this(env, tableDescriptor, snapshot, restoreAcl, null);
    }

    public CloneSnapshotProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, SnapshotProtos.SnapshotDescription snapshot, boolean restoreAcl, String customSFT) {
        super(env);
        this.tableDescriptor = tableDescriptor;
        this.snapshot = snapshot;
        this.restoreAcl = restoreAcl;
        this.customSFT = customSFT;
        this.getMonitorStatus();
    }

    private MonitoredTask getMonitorStatus() {
        if (this.monitorStatus == null) {
            this.monitorStatus = TaskMonitor.get().createStatus("Cloning  snapshot '" + this.snapshot.getName() + "' to table " + this.getTableName());
        }
        return this.monitorStatus;
    }

    private void restoreSnapshotAcl(MasterProcedureEnv env) throws IOException {
        Configuration conf = env.getMasterServices().getConfiguration();
        if (this.restoreAcl && this.snapshot.hasUsersAndPermissions() && this.snapshot.getUsersAndPermissions() != null && SnapshotDescriptionUtils.isSecurityAvailable(conf)) {
            RestoreSnapshotHelper.restoreSnapshotAcl(this.snapshot, this.tableDescriptor.getTableName(), conf);
        }
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.CloneSnapshotState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case CLONE_SNAPSHOT_PRE_OPERATION: {
                    this.prepareClone(env);
                    this.preCloneSnapshot(env);
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_WRITE_FS_LAYOUT);
                    break;
                }
                case CLONE_SNAPSHOT_WRITE_FS_LAYOUT: {
                    this.updateTableDescriptorWithSFT();
                    this.newRegions = this.createFilesystemLayout(env, this.tableDescriptor, this.newRegions);
                    env.getMasterServices().getTableDescriptors().update(this.tableDescriptor, true);
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_ADD_TO_META);
                    break;
                }
                case CLONE_SNAPSHOT_ADD_TO_META: {
                    this.addRegionsToMeta(env);
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_ASSIGN_REGIONS);
                    break;
                }
                case CLONE_SNAPSHOT_ASSIGN_REGIONS: {
                    CreateTableProcedure.setEnablingState(env, this.getTableName());
                    ArrayList splitRegions = new ArrayList();
                    ArrayList<RegionInfo> regionsToAssign = new ArrayList<RegionInfo>();
                    this.newRegions.forEach(ri -> {
                        if (ri.isOffline() && (ri.isSplit() || ri.isSplitParent())) {
                            splitRegions.add(ri);
                        } else {
                            regionsToAssign.add((RegionInfo)ri);
                        }
                    });
                    AssignmentManager am = env.getAssignmentManager();
                    splitRegions.forEach(ri -> am.getRegionStates().updateRegionState((RegionInfo)ri, RegionState.State.SPLIT));
                    this.addChildProcedure(env.getAssignmentManager().createRoundRobinAssignProcedures(regionsToAssign));
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_UPDATE_DESC_CACHE);
                    break;
                }
                case CLONE_SNAPSHOT_UPDATE_DESC_CACHE: {
                    CreateTableProcedure.setEnabledState(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPHOST_RESTORE_ACL);
                    break;
                }
                case CLONE_SNAPHOST_RESTORE_ACL: {
                    this.restoreSnapshotAcl(env);
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_POST_OPERATION);
                    break;
                }
                case CLONE_SNAPSHOT_POST_OPERATION: {
                    this.postCloneSnapshot(env);
                    MetricsSnapshot metricsSnapshot = new MetricsSnapshot();
                    metricsSnapshot.addSnapshotClone(this.getMonitorStatus().getCompletionTimestamp() - this.getMonitorStatus().getStartTime());
                    this.getMonitorStatus().markComplete("Clone snapshot '" + this.snapshot.getName() + "' completed!");
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-clone-snapshot", e);
            }
            LOG.warn("Retriable error trying to clone snapshot=" + this.snapshot.getName() + " to table=" + this.getTableName() + " state=" + state, (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void updateTableDescriptorWithSFT() {
        if (StringUtils.isEmpty(this.customSFT)) {
            return;
        }
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder(this.tableDescriptor);
        builder.setValue("hbase.store.file-tracker.impl", this.customSFT);
        for (ColumnFamilyDescriptor family : this.tableDescriptor.getColumnFamilies()) {
            ColumnFamilyDescriptorBuilder cfBuilder = ColumnFamilyDescriptorBuilder.newBuilder(family);
            cfBuilder.setConfiguration("hbase.store.file-tracker.impl", null);
            cfBuilder.setValue("hbase.store.file-tracker.impl", null);
            builder.modifyColumnFamily(cfBuilder.build());
        }
        this.tableDescriptor = builder.build();
    }

    private void validateSFT() {
        if (StringUtils.isEmpty(this.customSFT)) {
            return;
        }
        Configuration sftConfig = new Configuration();
        sftConfig.set("hbase.store.file-tracker.impl", this.customSFT);
        StoreFileTrackerFactory.getTrackerClass(sftConfig);
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.CloneSnapshotState state) throws IOException {
        if (state == MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_PRE_OPERATION) {
            DeleteTableProcedure.deleteTableStates(env, this.getTableName());
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.CloneSnapshotState state) {
        switch (state) {
            case CLONE_SNAPSHOT_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected MasterProcedureProtos.CloneSnapshotState getState(int stateId) {
        return MasterProcedureProtos.CloneSnapshotState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.CloneSnapshotState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.CloneSnapshotState getInitialState() {
        return MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_PRE_OPERATION;
    }

    @Override
    public TableName getTableName() {
        return this.tableDescriptor.getTableName();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.CREATE;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(" snapshot=");
        sb.append(this.snapshot);
        sb.append(")");
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.CloneSnapshotStateData.Builder cloneSnapshotMsg = MasterProcedureProtos.CloneSnapshotStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setSnapshot(this.snapshot).setTableSchema(ProtobufUtil.toTableSchema(this.tableDescriptor));
        cloneSnapshotMsg.setRestoreAcl(this.restoreAcl);
        if (this.newRegions != null) {
            for (RegionInfo hri : this.newRegions) {
                cloneSnapshotMsg.addRegionInfo(ProtobufUtil.toRegionInfo(hri));
            }
        }
        if (!this.parentsToChildrenPairMap.isEmpty()) {
            for (Map.Entry<String, Pair<String, String>> entry : this.parentsToChildrenPairMap.entrySet()) {
                MasterProcedureProtos.RestoreParentToChildRegionsPair.Builder parentToChildrenPair = MasterProcedureProtos.RestoreParentToChildRegionsPair.newBuilder().setParentRegionName(entry.getKey()).setChild1RegionName(entry.getValue().getFirst()).setChild2RegionName(entry.getValue().getSecond());
                cloneSnapshotMsg.addParentToChildRegionsPairList(parentToChildrenPair);
            }
        }
        if (!StringUtils.isEmpty(this.customSFT)) {
            cloneSnapshotMsg.setCustomSFT(this.customSFT);
        }
        serializer.serialize(cloneSnapshotMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.CloneSnapshotStateData cloneSnapshotMsg = serializer.deserialize(MasterProcedureProtos.CloneSnapshotStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(cloneSnapshotMsg.getUserInfo()));
        this.snapshot = cloneSnapshotMsg.getSnapshot();
        this.tableDescriptor = ProtobufUtil.toTableDescriptor(cloneSnapshotMsg.getTableSchema());
        if (cloneSnapshotMsg.hasRestoreAcl()) {
            this.restoreAcl = cloneSnapshotMsg.getRestoreAcl();
        }
        if (cloneSnapshotMsg.getRegionInfoCount() == 0) {
            this.newRegions = null;
        } else {
            this.newRegions = new ArrayList<RegionInfo>(cloneSnapshotMsg.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : cloneSnapshotMsg.getRegionInfoList()) {
                this.newRegions.add(ProtobufUtil.toRegionInfo(hri));
            }
        }
        if (cloneSnapshotMsg.getParentToChildRegionsPairListCount() > 0) {
            this.parentsToChildrenPairMap = new HashMap<String, Pair<String, String>>();
            for (MasterProcedureProtos.RestoreParentToChildRegionsPair parentToChildrenPair : cloneSnapshotMsg.getParentToChildRegionsPairListList()) {
                this.parentsToChildrenPairMap.put(parentToChildrenPair.getParentRegionName(), new Pair<String, String>(parentToChildrenPair.getChild1RegionName(), parentToChildrenPair.getChild2RegionName()));
            }
        }
        if (!StringUtils.isEmpty(cloneSnapshotMsg.getCustomSFT())) {
            this.customSFT = cloneSnapshotMsg.getCustomSFT();
        }
        this.getMonitorStatus();
    }

    private void prepareClone(MasterProcedureEnv env) throws IOException {
        TableName tableName = this.getTableName();
        if (env.getMasterServices().getTableDescriptors().exists(tableName)) {
            throw new TableExistsException(tableName);
        }
        if (SnapshotDescriptionUtils.isExpiredSnapshot(this.snapshot.getTtl(), this.snapshot.getCreationTime(), EnvironmentEdgeManager.currentTime())) {
            throw new SnapshotTTLExpiredException(ProtobufUtil.createSnapshotDesc(this.snapshot));
        }
        this.validateSFT();
    }

    private void preCloneSnapshot(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost;
        if (!this.getTableName().isSystemTable()) {
            MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
            SnapshotManifest manifest = SnapshotManifest.open(env.getMasterConfiguration(), mfs.getFileSystem(), SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, mfs.getRootDir()), this.snapshot);
            ProcedureSyncWait.getMasterQuotaManager(env).checkNamespaceTableAndRegionQuota(this.getTableName(), manifest.getRegionManifestsMap().size());
        }
        if ((cpHost = env.getMasterCoprocessorHost()) != null) {
            cpHost.preCreateTableAction(this.tableDescriptor, null, this.getUser());
        }
    }

    private void postCloneSnapshot(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            RegionInfo[] regions = this.newRegions == null ? null : this.newRegions.toArray(new RegionInfo[this.newRegions.size()]);
            cpHost.postCompletedCreateTableAction(this.tableDescriptor, regions, this.getUser());
        }
    }

    private List<RegionInfo> createFilesystemLayout(MasterProcedureEnv env, final TableDescriptor tableDescriptor, List<RegionInfo> newRegions) throws IOException {
        return this.createFsLayout(env, tableDescriptor, newRegions, new CreateTableProcedure.CreateHdfsRegions(){

            @Override
            public List<RegionInfo> createHdfsRegions(MasterProcedureEnv env, Path tableRootDir, TableName tableName, List<RegionInfo> newRegions) throws IOException {
                MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
                FileSystem fs = mfs.getFileSystem();
                Path rootDir = mfs.getRootDir();
                Configuration conf = env.getMasterConfiguration();
                ForeignExceptionDispatcher monitorException = new ForeignExceptionDispatcher();
                CloneSnapshotProcedure.this.getMonitorStatus().setStatus("Clone snapshot - creating regions for table: " + tableName);
                try {
                    Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(CloneSnapshotProcedure.this.snapshot, rootDir);
                    SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, CloneSnapshotProcedure.this.snapshot);
                    RestoreSnapshotHelper restoreHelper = new RestoreSnapshotHelper(conf, fs, manifest, tableDescriptor, tableRootDir, monitorException, CloneSnapshotProcedure.this.monitorStatus);
                    RestoreSnapshotHelper.RestoreMetaChanges metaChanges = restoreHelper.restoreHdfsRegions();
                    Preconditions.checkArgument(!metaChanges.hasRegionsToRestore(), "A clone should not have regions to restore");
                    Preconditions.checkArgument(!metaChanges.hasRegionsToRemove(), "A clone should not have regions to remove");
                    String msg = "Clone snapshot=" + CloneSnapshotProcedure.this.snapshot.getName() + " on table=" + tableName + " completed!";
                    LOG.info(msg);
                    CloneSnapshotProcedure.this.monitorStatus.setStatus(msg + " Waiting for table to be enabled...");
                    return metaChanges.getRegionsToAdd();
                }
                catch (Exception e) {
                    String msg = "clone snapshot=" + ClientSnapshotDescriptionUtils.toString(CloneSnapshotProcedure.this.snapshot) + " failed because " + e.getMessage();
                    LOG.error(msg, (Throwable)e);
                    RestoreSnapshotException rse = new RestoreSnapshotException(msg, e, ProtobufUtil.createSnapshotDesc(CloneSnapshotProcedure.this.snapshot));
                    monitorException.receive(new ForeignException("Master CloneSnapshotProcedure", rse));
                    throw rse;
                }
            }
        });
    }

    private List<RegionInfo> createFsLayout(MasterProcedureEnv env, TableDescriptor tableDescriptor, List<RegionInfo> newRegions, CreateTableProcedure.CreateHdfsRegions hdfsRegionHandler) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tableDir = CommonFSUtils.getTableDir(mfs.getRootDir(), tableDescriptor.getTableName());
        if (CommonFSUtils.isExists(mfs.getFileSystem(), tableDir)) {
            LOG.warn("temp table dir already exists on disk: {}, will be deleted.", (Object)tableDir);
            CommonFSUtils.deleteDirectory(mfs.getFileSystem(), tableDir);
        }
        ((FSTableDescriptors)env.getMasterServices().getTableDescriptors()).createTableDescriptorForTableDirectory(tableDir, TableDescriptorBuilder.newBuilder(tableDescriptor).build(), false);
        newRegions = hdfsRegionHandler.createHdfsRegions(env, mfs.getRootDir(), tableDescriptor.getTableName(), newRegions);
        return newRegions;
    }

    private void addRegionsToMeta(MasterProcedureEnv env) throws IOException {
        this.newRegions = CreateTableProcedure.addTableToMeta(env, this.tableDescriptor, this.newRegions);
        RestoreSnapshotHelper.RestoreMetaChanges metaChanges = new RestoreSnapshotHelper.RestoreMetaChanges(this.tableDescriptor, this.parentsToChildrenPairMap);
        metaChanges.updateMetaParentRegions(env.getMasterServices().getConnection(), this.newRegions);
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public boolean getRestoreAcl() {
        return this.restoreAcl;
    }
}

