/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CloseExcessRegionReplicasProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.CloseExcessRegionReplicasProcedureState> {
    private static final Logger LOG = LoggerFactory.getLogger(CloseExcessRegionReplicasProcedure.class);
    private TableName tableName;
    private int newReplicaCount;
    private RetryCounter retryCounter;

    public CloseExcessRegionReplicasProcedure() {
    }

    public CloseExcessRegionReplicasProcedure(TableName tableName, int newReplicaCount) {
        this.tableName = tableName;
        this.newReplicaCount = newReplicaCount;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.CloseExcessRegionReplicasProcedureState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        switch (state) {
            case CLOSE_EXCESS_REGION_REPLICAS_SCHEDULE: {
                MutableBoolean submitted = new MutableBoolean(false);
                int inTransitionCount = env.getAssignmentManager().submitUnassignProcedureForClosingExcessRegionReplicas(this.tableName, this.newReplicaCount, p -> {
                    submitted.setTrue();
                    this.addChildProcedure(new TransitRegionStateProcedure[]{p});
                });
                if (inTransitionCount > 0 && submitted.isFalse()) {
                    if (this.retryCounter == null) {
                        this.retryCounter = ProcedureUtil.createRetryCounter(env.getMasterConfiguration());
                    }
                    long backoffMillis = this.retryCounter.getBackoffTimeAndIncrementAttempts();
                    LOG.info("There are still {} region(s) in transition for table {} when closing excess region replicas, suspend {}secs and try again later", new Object[]{inTransitionCount, this.tableName, backoffMillis / 1000L});
                    this.suspend((int)backoffMillis, true);
                }
                this.setNextState(MasterProcedureProtos.CloseExcessRegionReplicasProcedureState.CLOSE_EXCESS_REGION_REPLICAS_CONFIRM);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case CLOSE_EXCESS_REGION_REPLICAS_CONFIRM: {
                int unclosedCount = env.getAssignmentManager().numberOfUnclosedExcessRegionReplicas(this.tableName, this.newReplicaCount);
                if (unclosedCount > 0) {
                    LOG.info("There are still {} unclosed region(s) for table {} when closing excess region replicas, continue...");
                    this.setNextState(MasterProcedureProtos.CloseExcessRegionReplicasProcedureState.CLOSE_EXCESS_REGION_REPLICAS_SCHEDULE);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.CloseExcessRegionReplicasProcedureState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected MasterProcedureProtos.CloseExcessRegionReplicasProcedureState getState(int stateId) {
        return MasterProcedureProtos.CloseExcessRegionReplicasProcedureState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.CloseExcessRegionReplicasProcedureState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.CloseExcessRegionReplicasProcedureState getInitialState() {
        return MasterProcedureProtos.CloseExcessRegionReplicasProcedureState.CLOSE_EXCESS_REGION_REPLICAS_SCHEDULE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData data = MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData.newBuilder().setTableName(ProtobufUtil.toProtoTableName(this.tableName)).setNewReplicaCount(this.newReplicaCount).build();
        serializer.serialize(data);
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData data = serializer.deserialize(MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData.class);
        this.tableName = ProtobufUtil.toTableName(data.getTableName());
        this.newReplicaCount = data.getNewReplicaCount();
    }
}

