/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.master.procedure.SplitWALProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.regionserver.SplitWALCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitWALRemoteProcedure
extends ServerRemoteProcedure
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SplitWALRemoteProcedure.class);
    private String walPath;
    private ServerName crashedServer;

    public SplitWALRemoteProcedure() {
    }

    public SplitWALRemoteProcedure(ServerName worker, ServerName crashedServer, String wal) {
        this.targetServer = worker;
        this.crashedServer = crashedServer;
        this.walPath = wal;
    }

    @Override
    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SplitWALRemoteData.Builder builder = MasterProcedureProtos.SplitWALRemoteData.newBuilder();
        builder.setWalPath(this.walPath).setWorker(ProtobufUtil.toServerName(this.targetServer)).setCrashedServer(ProtobufUtil.toServerName(this.crashedServer)).setState(this.state);
        if (this.remoteError != null) {
            ErrorHandlingProtos.ForeignExceptionMessage fem = ForeignExceptionUtil.toProtoForeignException(this.remoteError);
            builder.setError(fem);
        }
        serializer.serialize(builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SplitWALRemoteData data = serializer.deserialize(MasterProcedureProtos.SplitWALRemoteData.class);
        this.walPath = data.getWalPath();
        this.targetServer = ProtobufUtil.toServerName(data.getWorker());
        this.crashedServer = ProtobufUtil.toServerName(data.getCrashedServer());
        this.state = data.getState();
        if (data.hasError()) {
            this.remoteError = ForeignExceptionUtil.toException(data.getError());
        }
    }

    @Override
    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), SplitWALCallable.class, MasterProcedureProtos.SplitWALParameter.newBuilder().setWalPath(this.walPath).build().toByteArray()));
    }

    @Override
    protected boolean complete(MasterProcedureEnv env, Throwable error) {
        if (error == null) {
            try {
                env.getMasterServices().getSplitWALManager().archive(this.walPath);
            }
            catch (IOException e) {
                LOG.warn("Failed split of {}; ignore...", (Object)this.walPath, (Object)e);
            }
            return true;
        }
        if (error instanceof DoNotRetryIOException) {
            LOG.warn("Sent {} to wrong server {}, try another", new Object[]{this.walPath, this.targetServer, error});
            return true;
        }
        LOG.warn("Failed split of {}, retry...", (Object)this.walPath, (Object)error);
        return false;
    }

    public String getWAL() {
        return this.walPath;
    }

    @Override
    public ServerName getServerName() {
        return this.crashedServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return AbstractFSWALProvider.isMetaFile(new Path(this.walPath));
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.SPLIT_WAL_REMOTE;
    }

    @Override
    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getProcName());
        if (this.targetServer != null) {
            builder.append(", worker=");
            builder.append(this.targetServer);
        }
    }

    @Override
    public String getProcName() {
        return this.getClass().getSimpleName() + " " + SplitWALProcedure.getWALNameFromStrPath(this.getWAL());
    }
}

