/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.replication.regionserver.RefreshPeerCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RefreshPeerProcedure
extends ServerRemoteProcedure
implements PeerProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshPeerProcedure.class);
    private String peerId;
    private PeerProcedureInterface.PeerOperationType type;

    public RefreshPeerProcedure() {
    }

    public RefreshPeerProcedure(String peerId, PeerProcedureInterface.PeerOperationType type, ServerName targetServer) {
        this.peerId = peerId;
        this.type = type;
        this.targetServer = targetServer;
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.REFRESH;
    }

    private static MasterProcedureProtos.PeerModificationType toPeerModificationType(PeerProcedureInterface.PeerOperationType type) {
        switch (type) {
            case ADD: {
                return MasterProcedureProtos.PeerModificationType.ADD_PEER;
            }
            case REMOVE: {
                return MasterProcedureProtos.PeerModificationType.REMOVE_PEER;
            }
            case ENABLE: {
                return MasterProcedureProtos.PeerModificationType.ENABLE_PEER;
            }
            case DISABLE: {
                return MasterProcedureProtos.PeerModificationType.DISABLE_PEER;
            }
            case UPDATE_CONFIG: {
                return MasterProcedureProtos.PeerModificationType.UPDATE_PEER_CONFIG;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    private static PeerProcedureInterface.PeerOperationType toPeerOperationType(MasterProcedureProtos.PeerModificationType type) {
        switch (type) {
            case ADD_PEER: {
                return PeerProcedureInterface.PeerOperationType.ADD;
            }
            case REMOVE_PEER: {
                return PeerProcedureInterface.PeerOperationType.REMOVE;
            }
            case ENABLE_PEER: {
                return PeerProcedureInterface.PeerOperationType.ENABLE;
            }
            case DISABLE_PEER: {
                return PeerProcedureInterface.PeerOperationType.DISABLE;
            }
            case UPDATE_PEER_CONFIG: {
                return PeerProcedureInterface.PeerOperationType.UPDATE_CONFIG;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    @Override
    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName remote) {
        assert (this.targetServer.equals(remote));
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), RefreshPeerCallable.class, MasterProcedureProtos.RefreshPeerParameter.newBuilder().setPeerId(this.peerId).setType(RefreshPeerProcedure.toPeerModificationType(this.type)).setTargetServer(ProtobufUtil.toServerName(remote)).build().toByteArray()));
    }

    @Override
    protected boolean complete(MasterProcedureEnv env, Throwable error) {
        if (error != null) {
            LOG.warn("Refresh peer {} for {} on {} failed", new Object[]{this.peerId, this.type, this.targetServer, error});
            return false;
        }
        LOG.info("Refresh peer {} for {} on {} suceeded", new Object[]{this.peerId, this.type, this.targetServer});
        return true;
    }

    @Override
    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized(this);
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.RefreshPeerStateData.Builder builder = MasterProcedureProtos.RefreshPeerStateData.newBuilder();
        if (this.remoteError != null) {
            ErrorHandlingProtos.ForeignExceptionMessage fem = ForeignExceptionUtil.toProtoForeignException(this.remoteError);
            builder.setError(fem);
        }
        serializer.serialize(builder.setPeerId(this.peerId).setType(RefreshPeerProcedure.toPeerModificationType(this.type)).setTargetServer(ProtobufUtil.toServerName(this.targetServer)).setState(this.state).build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.RefreshPeerStateData data = serializer.deserialize(MasterProcedureProtos.RefreshPeerStateData.class);
        this.peerId = data.getPeerId();
        this.type = RefreshPeerProcedure.toPeerOperationType(data.getType());
        this.targetServer = ProtobufUtil.toServerName(data.getTargetServer());
        this.state = data.getState();
        if (data.hasError()) {
            this.remoteError = ForeignExceptionUtil.toException(data.getError());
        }
    }
}

