/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsSnapshot;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hadoop.hbase.master.snapshot.MasterSnapshotVerifier;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class TakeSnapshotHandler
extends EventHandler
implements SnapshotSentinel,
ForeignExceptionSnare {
    private static final Logger LOG = LoggerFactory.getLogger(TakeSnapshotHandler.class);
    public static final String HBASE_SNAPSHOT_MASTER_LOCK_ACQUIRE_TIMEOUT = "hbase.snapshot.master.lock.acquire.timeout";
    private volatile boolean finished;
    protected final MasterServices master;
    protected final MetricsSnapshot metricsSnapshot = new MetricsSnapshot();
    protected final SnapshotProtos.SnapshotDescription snapshot;
    protected final Configuration conf;
    protected final FileSystem rootFs;
    protected final FileSystem workingDirFs;
    protected final Path rootDir;
    private final Path snapshotDir;
    protected final Path workingDir;
    private final MasterSnapshotVerifier verifier;
    protected final ForeignExceptionDispatcher monitor;
    private final LockManager.MasterLock tableLock;
    protected final MonitoredTask status;
    protected final TableName snapshotTable;
    protected final SnapshotManifest snapshotManifest;
    protected final SnapshotManager snapshotManager;
    private final long lockAcquireTimeoutMs;
    protected TableDescriptor htd;

    public TakeSnapshotHandler(SnapshotProtos.SnapshotDescription snapshot, MasterServices masterServices, SnapshotManager snapshotManager) throws IOException {
        super(masterServices, EventType.C_M_SNAPSHOT_TABLE);
        assert (snapshot != null) : "SnapshotDescription must not be nul1";
        assert (masterServices != null) : "MasterServices must not be nul1";
        this.master = masterServices;
        this.conf = this.master.getConfiguration();
        this.rootDir = this.master.getMasterFileSystem().getRootDir();
        this.workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir, this.conf);
        Preconditions.checkArgument(!SnapshotDescriptionUtils.isSubDirectoryOf(this.workingDir, this.rootDir) || SnapshotDescriptionUtils.isWithinDefaultWorkingDir(this.workingDir, this.conf), "The working directory " + this.workingDir + " cannot be in the root directory unless it is within the default working directory");
        this.snapshot = snapshot;
        this.snapshotManager = snapshotManager;
        this.snapshotTable = TableName.valueOf(snapshot.getTable());
        this.rootFs = this.master.getMasterFileSystem().getFileSystem();
        this.snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, this.rootDir);
        this.workingDirFs = this.workingDir.getFileSystem(this.conf);
        this.monitor = new ForeignExceptionDispatcher(snapshot.getName());
        this.tableLock = this.master.getLockManager().createMasterLock(this.snapshotTable, LockType.EXCLUSIVE, this.getClass().getName() + ": take snapshot " + snapshot.getName());
        this.verifier = new MasterSnapshotVerifier(masterServices, snapshot, this.workingDirFs);
        this.status = TaskMonitor.get().createStatus("Taking " + snapshot.getType() + " snapshot on table: " + this.snapshotTable, false, true);
        this.snapshotManifest = SnapshotManifest.create(this.conf, this.rootFs, this.workingDir, snapshot, this.monitor, this.status);
        this.lockAcquireTimeoutMs = this.conf.getLong(HBASE_SNAPSHOT_MASTER_LOCK_ACQUIRE_TIMEOUT, this.conf.getLong("hbase.rpc.timeout", 60000L));
    }

    private TableDescriptor loadTableDescriptor() throws IOException {
        TableDescriptor htd = this.master.getTableDescriptors().get(this.snapshotTable);
        if (htd == null) {
            throw new IOException("TableDescriptor missing for " + this.snapshotTable);
        }
        if (htd.getMaxFileSize() == -1L && this.snapshot.getMaxFileSize() > 0L) {
            htd = TableDescriptorBuilder.newBuilder(htd).setValue("MAX_FILESIZE", Long.toString(this.snapshot.getMaxFileSize())).build();
        }
        return htd;
    }

    @Override
    public TakeSnapshotHandler prepare() throws Exception {
        super.prepare();
        if (this.tableLock.tryAcquire(this.lockAcquireTimeoutMs)) {
            try {
                this.htd = this.loadTableDescriptor();
            }
            catch (Exception e) {
                this.tableLock.release();
                throw e;
            }
        } else {
            LOG.error("Master lock could not be acquired in {} ms", (Object)this.lockAcquireTimeoutMs);
            throw new DoNotRetryIOException("Master lock could not be acquired");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intentional")
    public void process() {
        String msg = "Running " + this.snapshot.getType() + " table snapshot " + this.snapshot.getName() + " " + (Object)((Object)this.eventType) + " on table " + this.snapshotTable;
        LOG.info(msg);
        LockManager.MasterLock tableLockToRelease = this.tableLock;
        this.status.setStatus(msg);
        try {
            if (this.downgradeToSharedTableLock()) {
                tableLockToRelease = this.master.getLockManager().createMasterLock(this.snapshotTable, LockType.SHARED, this.getClass().getName() + ": take snapshot " + this.snapshot.getName());
                this.tableLock.release();
                boolean isTableLockAcquired = tableLockToRelease.tryAcquire(this.lockAcquireTimeoutMs);
                if (!isTableLockAcquired) {
                    LOG.error("Could not acquire shared lock on table {} in {} ms", (Object)this.snapshotTable, (Object)this.lockAcquireTimeoutMs);
                    throw new IOException("Could not acquire shared lock on table " + this.snapshotTable);
                }
            }
            SnapshotDescriptionUtils.writeSnapshotInfo(this.snapshot, this.workingDir, this.workingDirFs);
            this.snapshotManifest.addTableDescriptor(this.htd);
            this.monitor.rethrowException();
            List<Pair<RegionInfo, ServerName>> regionsAndLocations = this.master.getAssignmentManager().getTableRegionsAndLocations(this.snapshotTable, false);
            this.snapshotRegions(regionsAndLocations);
            this.monitor.rethrowException();
            HashSet<String> serverNames = new HashSet<String>();
            for (Pair<RegionInfo, ServerName> p : regionsAndLocations) {
                RegionInfo hri;
                if (p == null || p.getFirst() == null || p.getSecond() == null || (hri = p.getFirst()).isOffline() && (hri.isSplit() || hri.isSplitParent())) continue;
                serverNames.add(p.getSecond().toString());
            }
            this.status.setStatus("Consolidate snapshot: " + this.snapshot.getName());
            this.snapshotManifest.consolidate();
            this.status.setStatus("Verifying snapshot: " + this.snapshot.getName());
            this.verifier.verifySnapshot(this.workingDir, serverNames);
            SnapshotDescriptionUtils.completeSnapshot(this.snapshotDir, this.workingDir, this.rootFs, this.workingDirFs, this.conf);
            this.finished = true;
            msg = "Snapshot " + this.snapshot.getName() + " of table " + this.snapshotTable + " completed";
            this.status.markComplete(msg);
            LOG.info(msg);
            this.metricsSnapshot.addSnapshot(this.status.getCompletionTimestamp() - this.status.getStartTime());
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postCompletedSnapshotAction(ProtobufUtil.createSnapshotDesc(this.snapshot), this.htd);
            }
        }
        catch (Exception e) {
            this.status.abort("Failed to complete snapshot " + this.snapshot.getName() + " on table " + this.snapshotTable + " because " + e.getMessage());
            String reason = "Failed taking snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " due to exception:" + e.getMessage();
            LOG.error(reason, (Throwable)e);
            ForeignException ee = new ForeignException(reason, e);
            this.monitor.receive(ee);
            this.cancel(reason);
        }
        finally {
            LOG.debug("Launching cleanup of working dir:" + this.workingDir);
            try {
                if (this.workingDirFs.exists(this.workingDir) && !this.workingDirFs.delete(this.workingDir, true)) {
                    LOG.error("Couldn't delete snapshot working directory: {}", (Object)this.workingDir);
                }
            }
            catch (IOException e) {
                LOG.error("Couldn't get or delete snapshot working directory: {}", (Object)this.workingDir, (Object)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Table snapshot journal : \n" + this.status.prettyPrintJournal());
            }
            tableLockToRelease.release();
        }
    }

    protected abstract boolean downgradeToSharedTableLock();

    protected abstract void snapshotRegions(List<Pair<RegionInfo, ServerName>> var1) throws IOException, KeeperException;

    protected void snapshotDisabledRegion(RegionInfo regionInfo) throws IOException {
        this.snapshotManifest.addRegion(CommonFSUtils.getTableDir(this.rootDir, this.snapshotTable), regionInfo);
        this.monitor.rethrowException();
        this.status.setStatus("Completed referencing HFiles for offline region " + regionInfo.toString() + " of table: " + this.snapshotTable);
    }

    @Override
    public void cancel(String why) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        LOG.info("Stop taking snapshot=" + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " because: " + why);
        CancellationException ce = new CancellationException(why);
        this.monitor.receive(new ForeignException(this.master.getServerName().toString(), ce));
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public long getCompletionTimestamp() {
        return this.status.getCompletionTimestamp();
    }

    @Override
    public SnapshotProtos.SnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    @Override
    public ForeignException getExceptionIfFailed() {
        return this.monitor.getException();
    }

    @Override
    public void rethrowExceptionIfFailed() throws ForeignException {
        this.monitor.rethrowException();
    }

    @Override
    public void rethrowException() throws ForeignException {
        this.monitor.rethrowException();
    }

    @Override
    public boolean hasException() {
        return this.monitor.hasException();
    }

    @Override
    public ForeignException getException() {
        return this.monitor.getException();
    }
}

