/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclHelper;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
@InterfaceStability.Evolving
public class SnapshotScannerHDFSAclCleaner
extends BaseHFileCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotScannerHDFSAclCleaner.class);
    private HMaster master;
    private boolean userScanSnapshotEnabled = false;

    @Override
    public void init(Map<String, Object> params) {
        if (params != null && params.containsKey("master")) {
            this.master = (HMaster)params.get("master");
        }
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.userScanSnapshotEnabled = SnapshotScannerHDFSAclHelper.isAclSyncToHdfsEnabled(conf);
    }

    @Override
    protected boolean isFileDeletable(FileStatus fStat) {
        return true;
    }

    @Override
    public boolean isEmptyDirDeletable(Path dir) {
        if (this.userScanSnapshotEnabled) {
            return this.isEmptyArchiveDirDeletable(dir);
        }
        return true;
    }

    private boolean isEmptyArchiveDirDeletable(Path dir) {
        try {
            if (SnapshotScannerHDFSAclCleaner.isArchiveDataDir(dir)) {
                return false;
            }
            if (SnapshotScannerHDFSAclCleaner.isArchiveNamespaceDir(dir) && this.namespaceExists(dir.getName())) {
                return false;
            }
            return !SnapshotScannerHDFSAclCleaner.isArchiveTableDir(dir) || !this.tableExists(TableName.valueOf(dir.getParent().getName(), dir.getName()));
        }
        catch (IOException e) {
            LOG.warn("Check if empty dir {} is deletable error", (Object)dir, (Object)e);
            return false;
        }
    }

    @InterfaceAudience.Private
    static boolean isArchiveDataDir(Path path) {
        if (path != null && path.getName().equals("data")) {
            Path parent = path.getParent();
            return parent != null && parent.getName().equals("archive");
        }
        return false;
    }

    @InterfaceAudience.Private
    static boolean isArchiveNamespaceDir(Path path) {
        return path != null && SnapshotScannerHDFSAclCleaner.isArchiveDataDir(path.getParent());
    }

    @InterfaceAudience.Private
    static boolean isArchiveTableDir(Path path) {
        return path != null && SnapshotScannerHDFSAclCleaner.isArchiveNamespaceDir(path.getParent());
    }

    private boolean namespaceExists(String namespace) throws IOException {
        return this.master != null && this.master.listNamespaces().contains(namespace);
    }

    private boolean tableExists(TableName tableName) throws IOException {
        return this.master != null && this.master.getTableDescriptors().exists(tableName);
    }
}

