/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona;

public final class SemanticVersion {
    private SemanticVersion() {
    }

    public static int compose(int major, int minor, int patch) {
        if (major < 0 || major > 255) {
            throw new IllegalArgumentException("major must be 0-255: " + major);
        }
        if (minor < 0 || minor > 255) {
            throw new IllegalArgumentException("minor must be 0-255: " + minor);
        }
        if (patch < 0 || patch > 255) {
            throw new IllegalArgumentException("patch must be 0-255: " + patch);
        }
        if (major + minor + patch == 0) {
            throw new IllegalArgumentException("all parts cannot be zero");
        }
        return major << 16 | minor << 8 | patch;
    }

    public static int major(int version) {
        return version >> 16 & 0xFF;
    }

    public static int minor(int version) {
        return version >> 8 & 0xFF;
    }

    public static int patch(int version) {
        return version & 0xFF;
    }

    public static String toString(int version) {
        return SemanticVersion.major(version) + "." + SemanticVersion.minor(version) + "." + SemanticVersion.patch(version);
    }
}

