/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.concurrent;

import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.shaded.org.agrona.ErrorHandler;
import org.apache.hadoop.hbase.shaded.org.agrona.concurrent.Agent;
import org.apache.hadoop.hbase.shaded.org.agrona.concurrent.AgentTerminationException;
import org.apache.hadoop.hbase.shaded.org.agrona.concurrent.IdleStrategy;
import org.apache.hadoop.hbase.shaded.org.agrona.concurrent.status.AtomicCounter;

public class AgentRunner
implements Runnable,
AutoCloseable {
    public static final Thread TOMBSTONE = new Thread();
    public static final int RETRY_CLOSE_TIMEOUT_MS = 5000;
    private volatile boolean isRunning = true;
    private volatile boolean isClosed = false;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final IdleStrategy idleStrategy;
    private final Agent agent;
    private final AtomicReference<Thread> thread = new AtomicReference();

    public AgentRunner(IdleStrategy idleStrategy, ErrorHandler errorHandler, AtomicCounter errorCounter, Agent agent) {
        Objects.requireNonNull(idleStrategy, "idleStrategy");
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.idleStrategy = idleStrategy;
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
        this.agent = agent;
    }

    public static Thread startOnThread(AgentRunner runner) {
        return AgentRunner.startOnThread(runner, Thread::new);
    }

    public static Thread startOnThread(AgentRunner runner, ThreadFactory threadFactory) {
        Thread thread = threadFactory.newThread(runner);
        thread.setName(runner.agent().roleName());
        thread.start();
        return thread;
    }

    public Agent agent() {
        return this.agent;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Thread thread() {
        return this.thread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.thread.compareAndSet(null, Thread.currentThread())) {
                return;
            }
            IdleStrategy idleStrategy = this.idleStrategy;
            Agent agent = this.agent;
            try {
                agent.onStart();
            }
            catch (Throwable throwable) {
                this.errorHandler.onError(throwable);
                this.isRunning = false;
            }
            while (this.isRunning) {
                this.doWork(idleStrategy, agent);
            }
            try {
                agent.onClose();
            }
            catch (Throwable throwable) {
                this.errorHandler.onError(throwable);
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    @Override
    public final void close() {
        this.close(5000, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(int retryCloseTimeoutMs, Consumer<Thread> closeFailAction) {
        this.isRunning = false;
        Thread thread = this.thread.getAndSet(TOMBSTONE);
        if (null == thread) {
            try {
                this.agent.onClose();
            }
            catch (Throwable throwable) {
                this.errorHandler.onError(throwable);
            }
            finally {
                this.isClosed = true;
            }
        } else if (TOMBSTONE != thread) {
            try {
                while (true) {
                    if (this.isClosed) {
                        return;
                    }
                    thread.join(retryCloseTimeoutMs);
                    if (!thread.isAlive() || this.isClosed) {
                        return;
                    }
                    this.failAction(closeFailAction, thread, "timeout, retrying...");
                    if (thread.isInterrupted()) continue;
                    thread.interrupt();
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                this.failAction(closeFailAction, thread, "thread interrupt");
                if (!this.isClosed && !thread.isInterrupted()) {
                    thread.interrupt();
                    Thread.yield();
                }
                return;
            }
        }
    }

    private void failAction(Consumer<Thread> closeFailAction, Thread thread, String message) {
        if (null == closeFailAction) {
            System.err.println(this.agent.roleName() + " failed to close due to " + message);
        } else {
            closeFailAction.accept(thread);
        }
    }

    private void doWork(IdleStrategy idleStrategy, Agent agent) {
        block5: {
            try {
                int workCount = agent.doWork();
                idleStrategy.idle(workCount);
                if (0 >= workCount && Thread.currentThread().isInterrupted()) {
                    this.isRunning = false;
                }
            }
            catch (InterruptedException | ClosedByInterruptException ignore) {
                this.isRunning = false;
                Thread.currentThread().interrupt();
            }
            catch (AgentTerminationException ex) {
                this.isRunning = false;
                this.handleError(ex);
            }
            catch (Throwable throwable) {
                this.handleError(throwable);
                if (!Thread.currentThread().isInterrupted()) break block5;
                this.isRunning = false;
            }
        }
    }

    private void handleError(Throwable throwable) {
        if (null != this.errorCounter && this.isRunning && !this.errorCounter.isClosed()) {
            this.errorCounter.increment();
        }
        this.errorHandler.onError(throwable);
    }
}

