/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ClientMetaTableAccessor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MetaTableAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTableAccessor.class);
    private static final Logger METALOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hbase.META");

    private MetaTableAccessor() {
    }

    public static void fullScanRegions(Connection connection, ClientMetaTableAccessor.Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, null, null, ClientMetaTableAccessor.QueryType.REGION, visitor);
    }

    public static List<Result> fullScanRegions(Connection connection) throws IOException {
        return MetaTableAccessor.fullScan(connection, ClientMetaTableAccessor.QueryType.REGION);
    }

    public static void fullScanTables(Connection connection, ClientMetaTableAccessor.Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, null, null, ClientMetaTableAccessor.QueryType.TABLE, visitor);
    }

    private static List<Result> fullScan(Connection connection, ClientMetaTableAccessor.QueryType type) throws IOException {
        ClientMetaTableAccessor.CollectAllVisitor v = new ClientMetaTableAccessor.CollectAllVisitor();
        MetaTableAccessor.scanMeta(connection, null, null, type, (ClientMetaTableAccessor.Visitor)v);
        return v.getResults();
    }

    public static Table getMetaHTable(Connection connection) throws IOException {
        Objects.requireNonNull(connection, "Connection cannot be null");
        if (connection.isClosed()) {
            throw new IOException("connection is closed");
        }
        return connection.getTable(TableName.META_TABLE_NAME);
    }

    @Deprecated
    public static Pair<RegionInfo, ServerName> getRegion(Connection connection, byte[] regionName) throws IOException {
        HRegionLocation location = MetaTableAccessor.getRegionLocation(connection, regionName);
        return location == null ? null : new Pair<RegionInfo, ServerName>(location.getRegion(), location.getServerName());
    }

    public static HRegionLocation getRegionLocation(Connection connection, byte[] regionName) throws IOException {
        Result r;
        byte[] row = regionName;
        RegionInfo parsedInfo = null;
        try {
            parsedInfo = CatalogFamilyFormat.parseRegionInfoFromRegionName(regionName);
            row = CatalogFamilyFormat.getMetaKeyForRegion(parsedInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            r = t.get(get);
        }
        RegionLocations locations = CatalogFamilyFormat.getRegionLocations(r);
        return locations == null ? null : locations.getRegionLocation(parsedInfo == null ? 0 : parsedInfo.getReplicaId());
    }

    public static HRegionLocation getRegionLocation(Connection connection, RegionInfo regionInfo) throws IOException {
        return CatalogFamilyFormat.getRegionLocation(MetaTableAccessor.getCatalogFamilyRow(connection, regionInfo), regionInfo, regionInfo.getReplicaId());
    }

    public static Result getCatalogFamilyRow(Connection connection, RegionInfo ri) throws IOException {
        Get get = new Get(CatalogFamilyFormat.getMetaKeyForRegion(ri));
        get.addFamily(HConstants.CATALOG_FAMILY);
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            Result result = t.get(get);
            return result;
        }
    }

    public static Result getRegionResult(Connection connection, RegionInfo regionInfo) throws IOException {
        Get get = new Get(CatalogFamilyFormat.getMetaKeyForRegion(regionInfo));
        get.addFamily(HConstants.CATALOG_FAMILY);
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            Result result = t.get(get);
            return result;
        }
    }

    /*
     * Exception decompiling
     */
    public static Result scanByRegionEncodedName(Connection connection, String regionEncodedName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<RegionInfo> getAllRegions(Connection connection, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<RegionInfo, ServerName>> result = MetaTableAccessor.getTableRegionsAndLocations(connection, null, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfRegionInfos(result);
    }

    public static List<RegionInfo> getTableRegions(Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegions(connection, tableName, false);
    }

    public static List<RegionInfo> getTableRegions(Connection connection, TableName tableName, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<RegionInfo, ServerName>> result = MetaTableAccessor.getTableRegionsAndLocations(connection, tableName, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfRegionInfos(result);
    }

    private static List<RegionInfo> getListOfRegionInfos(List<Pair<RegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegionInfo> result = new ArrayList<RegionInfo>(pairs.size());
        for (Pair<RegionInfo, ServerName> pair : pairs) {
            result.add(pair.getFirst());
        }
        return result;
    }

    public static Scan getScanForTableName(Configuration conf, TableName tableName) {
        byte[] startKey = ClientMetaTableAccessor.getTableStartRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REGION);
        byte[] stopKey = ClientMetaTableAccessor.getTableStopRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REGION);
        Scan scan = MetaTableAccessor.getMetaScan(conf, -1);
        scan.withStartRow(startKey);
        scan.withStopRow(stopKey);
        return scan;
    }

    private static Scan getMetaScan(Configuration conf, int rowUpperLimit) {
        Scan scan = new Scan();
        int scannerCaching = conf.getInt("hbase.meta.scanner.caching", 100);
        if (conf.getBoolean("hbase.meta.replicas.use", false)) {
            scan.setConsistency(Consistency.TIMELINE);
        }
        if (rowUpperLimit > 0) {
            scan.setLimit(rowUpperLimit);
            scan.setReadType(Scan.ReadType.PREAD);
        }
        scan.setCaching(scannerCaching);
        return scan;
    }

    public static List<Pair<RegionInfo, ServerName>> getTableRegionsAndLocations(Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegionsAndLocations(connection, tableName, true);
    }

    public static List<Pair<RegionInfo, ServerName>> getTableRegionsAndLocations(Connection connection, @Nullable TableName tableName, boolean excludeOfflinedSplitParents) throws IOException {
        if (tableName != null && tableName.equals(TableName.META_TABLE_NAME)) {
            throw new IOException("This method can't be used to locate meta regions; use MetaTableLocator instead");
        }
        ClientMetaTableAccessor.CollectRegionLocationsVisitor visitor = new ClientMetaTableAccessor.CollectRegionLocationsVisitor(excludeOfflinedSplitParents);
        MetaTableAccessor.scanMeta(connection, ClientMetaTableAccessor.getTableStartRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REGION), ClientMetaTableAccessor.getTableStopRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REGION), ClientMetaTableAccessor.QueryType.REGION, (ClientMetaTableAccessor.Visitor)visitor);
        return visitor.getResults();
    }

    public static void fullScanMetaAndPrint(Connection connection) throws IOException {
        ClientMetaTableAccessor.Visitor v = r -> {
            if (r == null || r.isEmpty()) {
                return true;
            }
            LOG.info("fullScanMetaAndPrint.Current Meta Row: " + r);
            TableState state = CatalogFamilyFormat.getTableState(r);
            if (state != null) {
                LOG.info("fullScanMetaAndPrint.Table State={}" + state);
            } else {
                RegionLocations locations = CatalogFamilyFormat.getRegionLocations(r);
                if (locations == null) {
                    return true;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null) continue;
                    LOG.info("fullScanMetaAndPrint.HRI Print={}", (Object)loc.getRegion());
                }
            }
            return true;
        };
        MetaTableAccessor.scanMeta(connection, null, null, ClientMetaTableAccessor.QueryType.ALL, v);
    }

    public static void scanMetaForTableRegions(Connection connection, ClientMetaTableAccessor.Visitor visitor, TableName tableName) throws IOException {
        MetaTableAccessor.scanMeta(connection, tableName, ClientMetaTableAccessor.QueryType.REGION, Integer.MAX_VALUE, visitor);
    }

    private static void scanMeta(Connection connection, TableName table, ClientMetaTableAccessor.QueryType type, int maxRows, ClientMetaTableAccessor.Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, ClientMetaTableAccessor.getTableStartRowForMeta(table, type), ClientMetaTableAccessor.getTableStopRowForMeta(table, type), type, maxRows, visitor);
    }

    public static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, ClientMetaTableAccessor.QueryType type, ClientMetaTableAccessor.Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, type, Integer.MAX_VALUE, visitor);
    }

    public static void scanMeta(Connection connection, ClientMetaTableAccessor.Visitor visitor, TableName tableName, byte[] row, int rowLimit) throws IOException {
        byte[] startRow = null;
        byte[] stopRow = null;
        if (tableName != null) {
            startRow = ClientMetaTableAccessor.getTableStartRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REGION);
            if (row != null) {
                RegionInfo closestRi = MetaTableAccessor.getClosestRegionInfo(connection, tableName, row);
                startRow = RegionInfo.createRegionName(tableName, closestRi.getStartKey(), "00000000000000", false);
            }
            stopRow = ClientMetaTableAccessor.getTableStopRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REGION);
        }
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, ClientMetaTableAccessor.QueryType.REGION, rowLimit, visitor);
    }

    public static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, ClientMetaTableAccessor.QueryType type, int maxRows, ClientMetaTableAccessor.Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, type, null, maxRows, visitor);
    }

    public static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, ClientMetaTableAccessor.QueryType type, @Nullable Filter filter, int maxRows, ClientMetaTableAccessor.Visitor visitor) throws IOException {
        int rowUpperLimit = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        Scan scan = MetaTableAccessor.getMetaScan(connection.getConfiguration(), rowUpperLimit);
        for (byte[] family : type.getFamilies()) {
            scan.addFamily(family);
        }
        if (startRow != null) {
            scan.withStartRow(startRow);
        }
        if (stopRow != null) {
            scan.withStopRow(stopRow);
        }
        if (filter != null) {
            scan.setFilter(filter);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Scanning META starting at row=" + Bytes.toStringBinary(startRow) + " stopping at row=" + Bytes.toStringBinary(stopRow) + " for max=" + rowUpperLimit + " with caching=" + scan.getCaching());
        }
        int currentRow = 0;
        try (Table metaTable = MetaTableAccessor.getMetaHTable(connection);
             ResultScanner scanner = metaTable.getScanner(scan);){
            Result data;
            while ((data = scanner.next()) != null) {
                if (data.isEmpty()) continue;
                if (!visitor.visit(data)) {
                } else if (++currentRow < rowUpperLimit) continue;
                break;
            }
        }
        if (visitor instanceof Closeable) {
            try {
                ((Closeable)((Object)visitor)).close();
            }
            catch (Throwable t) {
                ExceptionUtil.rethrowIfInterrupt(t);
                LOG.debug("Got exception in closing the meta scanner visitor", t);
            }
        }
    }

    @NonNull
    private static RegionInfo getClosestRegionInfo(Connection connection, @NonNull TableName tableName, @NonNull byte[] row) throws IOException {
        byte[] searchRow = RegionInfo.createRegionName(tableName, row, "99999999999999", false);
        Scan scan = MetaTableAccessor.getMetaScan(connection.getConfiguration(), 1);
        scan.setReversed(true);
        scan.withStartRow(searchRow);
        try (ResultScanner resultScanner = MetaTableAccessor.getMetaHTable(connection).getScanner(scan);){
            Result result = resultScanner.next();
            if (result == null) {
                throw new TableNotFoundException("Cannot find row in META  for table: " + tableName + ", row=" + Bytes.toStringBinary(row));
            }
            RegionInfo regionInfo = CatalogFamilyFormat.getRegionInfo(result);
            if (regionInfo == null) {
                throw new IOException("RegionInfo was null or empty in Meta for " + tableName + ", row=" + Bytes.toStringBinary(row));
            }
            RegionInfo regionInfo2 = regionInfo;
            return regionInfo2;
        }
    }

    @Nullable
    public static ServerName getTargetServerName(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerNameColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            HRegionLocation location;
            RegionLocations locations = CatalogFamilyFormat.getRegionLocations(r);
            if (locations != null && (location = locations.getRegionLocation(replicaId)) != null) {
                return location.getServerName();
            }
            return null;
        }
        return ServerName.parseServerName(Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
    }

    public static PairOfSameType<RegionInfo> getDaughterRegions(Result data) {
        RegionInfo splitA = CatalogFamilyFormat.getRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        RegionInfo splitB = CatalogFamilyFormat.getRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType<RegionInfo>(splitA, splitB);
    }

    @Nullable
    public static TableState getTableState(Connection conn, TableName tableName) throws IOException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return new TableState(tableName, TableState.State.ENABLED);
        }
        Table metaHTable = MetaTableAccessor.getMetaHTable(conn);
        Get get = new Get(tableName.getName()).addColumn(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER);
        Result result = metaHTable.get(get);
        return CatalogFamilyFormat.getTableState(result);
    }

    public static Map<TableName, TableState> getTableStates(Connection conn) throws IOException {
        LinkedHashMap<TableName, TableState> states = new LinkedHashMap<TableName, TableState>();
        ClientMetaTableAccessor.Visitor collector = r -> {
            TableState state = CatalogFamilyFormat.getTableState(r);
            if (state != null) {
                states.put(state.getTableName(), state);
            }
            return true;
        };
        MetaTableAccessor.fullScanTables(conn, collector);
        return states;
    }

    public static void updateTableState(Connection conn, TableName tableName, TableState.State actual) throws IOException {
        MetaTableAccessor.updateTableState(conn, new TableState(tableName, actual));
    }

    public static Put makePutFromRegionInfo(RegionInfo regionInfo) throws IOException {
        return MetaTableAccessor.makePutFromRegionInfo(regionInfo, EnvironmentEdgeManager.currentTime());
    }

    public static Put makePutFromRegionInfo(RegionInfo regionInfo, long ts) throws IOException {
        return MetaTableAccessor.addRegionInfo(new Put(CatalogFamilyFormat.getMetaKeyForRegion(regionInfo), ts), regionInfo);
    }

    public static Delete makeDeleteFromRegionInfo(RegionInfo regionInfo, long ts) {
        if (regionInfo == null) {
            throw new IllegalArgumentException("Can't make a delete for null region");
        }
        if (regionInfo.getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't make delete for a replica region. Operate on the primary");
        }
        Delete delete = new Delete(CatalogFamilyFormat.getMetaKeyForRegion(regionInfo));
        delete.addFamily(HConstants.CATALOG_FAMILY, ts);
        return delete;
    }

    public static Put addDaughtersToPut(Put put, RegionInfo splitA, RegionInfo splitB) throws IOException {
        if (splitA != null) {
            put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.SPLITA_QUALIFIER).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(splitA)).build());
        }
        if (splitB != null) {
            put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.SPLITB_QUALIFIER).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(splitB)).build());
        }
        return put;
    }

    private static void putToMetaTable(Connection connection, Put p) throws IOException {
        try (Table table = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.put(table, p);
        }
    }

    private static void put(Table t, Put p) throws IOException {
        MetaTableAccessor.debugLogMutation(p);
        t.put(p);
    }

    public static void putsToMetaTable(Connection connection, List<Put> ps) throws IOException {
        if (ps.isEmpty()) {
            return;
        }
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.debugLogMutations(ps);
            if (ps.size() == 1) {
                t.put(ps.get(0));
            } else {
                t.put(ps);
            }
        }
    }

    private static void deleteFromMetaTable(Connection connection, Delete d) throws IOException {
        ArrayList<Delete> dels = new ArrayList<Delete>(1);
        dels.add(d);
        MetaTableAccessor.deleteFromMetaTable(connection, dels);
    }

    private static void deleteFromMetaTable(Connection connection, List<Delete> deletes) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.debugLogMutations(deletes);
            t.delete(deletes);
        }
    }

    public static Put addRegionStateToPut(Put put, int replicaId, RegionState.State state) throws IOException {
        put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(CatalogFamilyFormat.getRegionStateColumn(replicaId)).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(state.name())).build());
        return put;
    }

    public static void updateRegionState(Connection connection, RegionInfo ri, RegionState.State state) throws IOException {
        Put put = MetaTableAccessor.makePutFromRegionInfo(ri);
        MetaTableAccessor.addRegionStateToPut(put, ri.getReplicaId(), state);
        MetaTableAccessor.putsToMetaTable(connection, Collections.singletonList(put));
    }

    public static void addSplitsToParent(Connection connection, RegionInfo regionInfo, RegionInfo splitA, RegionInfo splitB) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            Put put = MetaTableAccessor.makePutFromRegionInfo(regionInfo);
            MetaTableAccessor.addDaughtersToPut(put, splitA, splitB);
            meta.put(put);
            MetaTableAccessor.debugLogMutation(put);
            LOG.debug("Added region {}", (Object)regionInfo.getRegionNameAsString());
        }
    }

    public static void addRegionsToMeta(Connection connection, List<RegionInfo> regionInfos, int regionReplication) throws IOException {
        MetaTableAccessor.addRegionsToMeta(connection, regionInfos, regionReplication, EnvironmentEdgeManager.currentTime());
    }

    public static void addRegionsToMeta(Connection connection, List<RegionInfo> regionInfos, int regionReplication, long ts) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (RegionInfo regionInfo : regionInfos) {
            if (!RegionReplicaUtil.isDefaultReplica(regionInfo)) continue;
            Put put = MetaTableAccessor.makePutFromRegionInfo(regionInfo, ts);
            MetaTableAccessor.addRegionStateToPut(put, regionInfo.getReplicaId(), RegionState.State.CLOSED);
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(put, i);
            }
            puts.add(put);
        }
        MetaTableAccessor.putsToMetaTable(connection, puts);
        LOG.info("Added {} regions to meta.", (Object)puts.size());
    }

    private static void updateTableState(Connection connection, TableState state) throws IOException {
        Put put = MetaTableAccessor.makePutFromTableState(state, EnvironmentEdgeManager.currentTime());
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info("Updated {} in hbase:meta", (Object)state);
    }

    public static Put makePutFromTableState(TableState state, long ts) {
        Put put = new Put(state.getTableName().getName(), ts);
        put.addColumn(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER, state.convert().toByteArray());
        return put;
    }

    public static void deleteTableState(Connection connection, TableName table) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete = new Delete(table.getName());
        delete.addColumns(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER, time);
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info("Deleted table " + table + " state from META");
    }

    public static void updateRegionLocation(Connection connection, RegionInfo regionInfo, ServerName sn, long openSeqNum, long masterSystemTime) throws IOException {
        MetaTableAccessor.updateLocation(connection, regionInfo, sn, openSeqNum, masterSystemTime);
    }

    private static void updateLocation(Connection connection, RegionInfo regionInfo, ServerName sn, long openSeqNum, long masterSystemTime) throws IOException {
        Put put = new Put(CatalogFamilyFormat.getMetaKeyForRegion(regionInfo), masterSystemTime);
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        MetaTableAccessor.addLocation(put, sn, openSeqNum, regionInfo.getReplicaId());
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info("Updated row {} with server=", (Object)regionInfo.getRegionNameAsString(), (Object)sn);
    }

    public static Put addRegionInfo(Put p, RegionInfo hri) throws IOException {
        p.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.REGIONINFO_QUALIFIER).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(RegionReplicaUtil.getRegionInfoForDefaultReplica(hri))).build());
        return p;
    }

    public static Put addLocation(Put p, ServerName sn, long openSeqNum, int replicaId) throws IOException {
        CellBuilder builder = CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
        return p.add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(CatalogFamilyFormat.getServerColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(sn.getAddress().toString())).build()).add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(CatalogFamilyFormat.getStartCodeColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(sn.getStartcode())).build()).add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(CatalogFamilyFormat.getSeqNumColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(openSeqNum)).build());
    }

    public static Put addEmptyLocation(Put p, int replicaId) throws IOException {
        CellBuilder builder = CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
        return p.add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(CatalogFamilyFormat.getServerColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).build()).add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(CatalogFamilyFormat.getStartCodeColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).build()).add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(CatalogFamilyFormat.getSeqNumColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).build());
    }

    private static void debugLogMutations(List<? extends Mutation> mutations) throws IOException {
        if (!METALOG.isDebugEnabled()) {
            return;
        }
        for (Mutation mutation : mutations) {
            MetaTableAccessor.debugLogMutation(mutation);
        }
    }

    private static void debugLogMutation(Mutation p) throws IOException {
        METALOG.debug("{} {}", (Object)p.getClass().getSimpleName(), (Object)p.toJSON());
    }
}

