/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.trace.ConnectionSpanBuilder;
import org.apache.hadoop.hbase.client.trace.TableSpanBuilder;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TableOperationSpanBuilder
implements Supplier<Span> {
    private static final String unknown = "UNKNOWN";
    private TableName tableName;
    private final Map<AttributeKey<?>, Object> attributes = new HashMap();

    public TableOperationSpanBuilder(AsyncConnectionImpl conn) {
        ConnectionSpanBuilder.populateConnectionAttributes(this.attributes, conn);
    }

    @Override
    public Span get() {
        return this.build();
    }

    public TableOperationSpanBuilder setOperation(Scan scan) {
        return this.setOperation(TableOperationSpanBuilder.valueFrom(scan));
    }

    public TableOperationSpanBuilder setOperation(Row row) {
        return this.setOperation(TableOperationSpanBuilder.valueFrom(row));
    }

    public TableOperationSpanBuilder setOperation(Collection<? extends Row> operations) {
        return this.setOperation(HBaseSemanticAttributes.Operation.BATCH);
    }

    public TableOperationSpanBuilder setOperation(HBaseSemanticAttributes.Operation operation) {
        this.attributes.put(HBaseSemanticAttributes.DB_OPERATION, operation.name());
        return this;
    }

    public TableOperationSpanBuilder setContainerOperations(RowMutations mutations) {
        HBaseSemanticAttributes.Operation[] ops = (HBaseSemanticAttributes.Operation[])mutations.getMutations().stream().flatMap(row -> Stream.concat(Stream.of(TableOperationSpanBuilder.valueFrom(row)), TableOperationSpanBuilder.unpackRowOperations(row).stream())).toArray(HBaseSemanticAttributes.Operation[]::new);
        return this.setContainerOperations(ops);
    }

    public TableOperationSpanBuilder setContainerOperations(Row row) {
        HBaseSemanticAttributes.Operation[] ops = (HBaseSemanticAttributes.Operation[])Stream.concat(Stream.of(TableOperationSpanBuilder.valueFrom(row)), TableOperationSpanBuilder.unpackRowOperations(row).stream()).toArray(HBaseSemanticAttributes.Operation[]::new);
        return this.setContainerOperations(ops);
    }

    public TableOperationSpanBuilder setContainerOperations(Collection<? extends Row> operations) {
        HBaseSemanticAttributes.Operation[] ops = (HBaseSemanticAttributes.Operation[])operations.stream().flatMap(row -> Stream.concat(Stream.of(TableOperationSpanBuilder.valueFrom(row)), TableOperationSpanBuilder.unpackRowOperations(row).stream())).toArray(HBaseSemanticAttributes.Operation[]::new);
        return this.setContainerOperations(ops);
    }

    private static Set<HBaseSemanticAttributes.Operation> unpackRowOperations(Row row) {
        HashSet<HBaseSemanticAttributes.Operation> ops = new HashSet<HBaseSemanticAttributes.Operation>();
        if (row instanceof CheckAndMutate) {
            CheckAndMutate cam = (CheckAndMutate)row;
            ops.addAll(TableOperationSpanBuilder.unpackRowOperations(cam));
        }
        if (row instanceof RowMutations) {
            RowMutations mutations = (RowMutations)row;
            List operations = mutations.getMutations().stream().map(TableOperationSpanBuilder::valueFrom).collect(Collectors.toList());
            ops.addAll(operations);
        }
        return ops;
    }

    private static Set<HBaseSemanticAttributes.Operation> unpackRowOperations(CheckAndMutate cam) {
        HashSet<HBaseSemanticAttributes.Operation> ops = new HashSet<HBaseSemanticAttributes.Operation>();
        HBaseSemanticAttributes.Operation op = TableOperationSpanBuilder.valueFrom(cam.getAction());
        switch (op) {
            case BATCH: 
            case CHECK_AND_MUTATE: {
                ops.addAll(TableOperationSpanBuilder.unpackRowOperations(cam.getAction()));
                break;
            }
            default: {
                ops.add(op);
            }
        }
        return ops;
    }

    public TableOperationSpanBuilder setContainerOperations(HBaseSemanticAttributes.Operation ... operations) {
        List ops = Arrays.stream(operations).map(op -> op == null ? unknown : op.name()).sorted().distinct().collect(Collectors.toList());
        this.attributes.put(HBaseSemanticAttributes.CONTAINER_DB_OPERATIONS_KEY, ops);
        return this;
    }

    public TableOperationSpanBuilder setTableName(TableName tableName) {
        this.tableName = tableName;
        TableSpanBuilder.populateTableNameAttributes(this.attributes, tableName);
        return this;
    }

    public Span build() {
        String name = this.attributes.getOrDefault(HBaseSemanticAttributes.DB_OPERATION, unknown) + " " + (this.tableName != null ? this.tableName.getNameWithNamespaceInclAsString() : unknown);
        SpanBuilder builder = TraceUtil.getGlobalTracer().spanBuilder(name).setSpanKind(SpanKind.CLIENT);
        this.attributes.forEach((k, v) -> builder.setAttribute(k, v));
        return builder.startSpan();
    }

    private static HBaseSemanticAttributes.Operation valueFrom(Scan scan) {
        if (scan == null) {
            return null;
        }
        return HBaseSemanticAttributes.Operation.SCAN;
    }

    private static HBaseSemanticAttributes.Operation valueFrom(Row row) {
        if (row == null) {
            return null;
        }
        if (row instanceof Append) {
            return HBaseSemanticAttributes.Operation.APPEND;
        }
        if (row instanceof CheckAndMutate) {
            return HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE;
        }
        if (row instanceof Delete) {
            return HBaseSemanticAttributes.Operation.DELETE;
        }
        if (row instanceof Get) {
            return HBaseSemanticAttributes.Operation.GET;
        }
        if (row instanceof Increment) {
            return HBaseSemanticAttributes.Operation.INCREMENT;
        }
        if (row instanceof Put) {
            return HBaseSemanticAttributes.Operation.PUT;
        }
        if (row instanceof RegionCoprocessorServiceExec) {
            return HBaseSemanticAttributes.Operation.COPROC_EXEC;
        }
        if (row instanceof RowMutations) {
            return HBaseSemanticAttributes.Operation.BATCH;
        }
        return null;
    }
}

