/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.constraint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.constraint.Constraint;
import org.apache.hadoop.hbase.constraint.ConstraintProcessor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public final class Constraints {
    private static final int DEFAULT_PRIORITY = -1;
    private static final Logger LOG = LoggerFactory.getLogger(Constraints.class);
    private static final String CONSTRAINT_HTD_KEY_PREFIX = "constraint $";
    private static final Pattern CONSTRAINT_HTD_ATTR_KEY_PATTERN = Pattern.compile("constraint $", 16);
    private static final String ENABLED_KEY = "_ENABLED";
    private static final String PRIORITY_KEY = "_PRIORITY";
    private static final long MIN_PRIORITY = 0L;
    private static final long UNSET_PRIORITY = -1L;
    private static String COUNTER_KEY = "hbase.constraint.counter";
    private static final Comparator<Constraint> constraintComparator = new Comparator<Constraint>(){

        @Override
        public int compare(Constraint c1, Constraint c2) {
            return Long.compare(c1.getConf().getLong(Constraints.PRIORITY_KEY, -1L), c2.getConf().getLong(Constraints.PRIORITY_KEY, -1L));
        }
    };

    private Constraints() {
    }

    public static TableDescriptorBuilder enable(TableDescriptorBuilder builder) throws IOException {
        if (!builder.hasCoprocessor(ConstraintProcessor.class.getName())) {
            builder.setCoprocessor(ConstraintProcessor.class.getName());
        }
        return builder;
    }

    public static TableDescriptorBuilder disable(TableDescriptorBuilder builder) throws IOException {
        try {
            return builder.removeCoprocessor(ConstraintProcessor.class.getName());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("ConstraintProcessor was unset.", (Throwable)e);
            return builder;
        }
    }

    public static TableDescriptorBuilder remove(TableDescriptorBuilder builder) throws IOException {
        Constraints.disable(builder);
        return builder.removeValue((k, v) -> CONSTRAINT_HTD_ATTR_KEY_PATTERN.split(k.toString()).length == 2);
    }

    public static boolean has(TableDescriptor desc, Class<? extends Constraint> clazz) {
        return Constraints.getKeyValueForClass(desc, clazz) != null;
    }

    private static Pair<String, String> getKeyValueForClass(TableDescriptor desc, Class<? extends Constraint> clazz) {
        String key = Constraints.serializeConstraintClass(clazz);
        String value = desc.getValue(key);
        return value == null ? null : new Pair<String, String>(key, value);
    }

    private static Pair<String, String> getKeyValueForClass(TableDescriptorBuilder builder, Class<? extends Constraint> clazz) {
        String key = Constraints.serializeConstraintClass(clazz);
        String value = builder.getValue(key);
        return value == null ? null : new Pair<String, String>(key, value);
    }

    @SafeVarargs
    public static TableDescriptorBuilder add(TableDescriptorBuilder builder, Class<? extends Constraint> ... constraints) throws IOException {
        Constraints.enable(builder);
        long priority = Constraints.getNextPriority(builder);
        for (Class<? extends Constraint> clazz : constraints) {
            Constraints.addConstraint(builder, clazz, null, priority++);
        }
        return Constraints.updateLatestPriority(builder, priority);
    }

    @SafeVarargs
    public static TableDescriptorBuilder add(TableDescriptorBuilder builder, Pair<Class<? extends Constraint>, Configuration> ... constraints) throws IOException {
        Constraints.enable(builder);
        long priority = Constraints.getNextPriority(builder);
        for (Pair<Class<? extends Constraint>, Configuration> pair : constraints) {
            Constraints.addConstraint(builder, pair.getFirst(), pair.getSecond(), priority++);
        }
        return Constraints.updateLatestPriority(builder, priority);
    }

    public static TableDescriptorBuilder add(TableDescriptorBuilder builder, Class<? extends Constraint> constraint, Configuration conf) throws IOException {
        Constraints.enable(builder);
        long priority = Constraints.getNextPriority(builder);
        Constraints.addConstraint(builder, constraint, conf, priority++);
        return Constraints.updateLatestPriority(builder, priority);
    }

    private static TableDescriptorBuilder addConstraint(TableDescriptorBuilder builder, Class<? extends Constraint> clazz, Configuration conf, long priority) throws IOException {
        return Constraints.writeConstraint(builder, Constraints.serializeConstraintClass(clazz), Constraints.configure(conf, true, priority));
    }

    private static Configuration configure(Configuration conf, boolean enabled, long priority) {
        Configuration toWrite = conf == null ? new Configuration() : new Configuration(conf);
        toWrite.setBooleanIfUnset(ENABLED_KEY, enabled);
        if (toWrite.getLong(PRIORITY_KEY, -1L) == -1L) {
            toWrite.setLong(PRIORITY_KEY, priority);
        }
        return toWrite;
    }

    private static String serializeConstraintClass(Class<? extends Constraint> clazz) {
        String constraintClazz = clazz.getName();
        return CONSTRAINT_HTD_KEY_PREFIX + constraintClazz;
    }

    private static TableDescriptorBuilder writeConstraint(TableDescriptorBuilder builder, String key, Configuration conf) throws IOException {
        return builder.setValue(key, Constraints.serializeConfiguration(conf));
    }

    private static String serializeConfiguration(Configuration conf) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        conf.writeXml((OutputStream)dos);
        dos.flush();
        byte[] data = bos.toByteArray();
        return Bytes.toString(data);
    }

    private static Configuration readConfiguration(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Configuration conf = new Configuration(false);
        conf.addResource((InputStream)is);
        return conf;
    }

    private static Configuration readConfiguration(String bytes) throws IOException {
        return Constraints.readConfiguration(Bytes.toBytes(bytes));
    }

    private static long getNextPriority(TableDescriptorBuilder builder) {
        String value = builder.getValue(COUNTER_KEY);
        long priority = value == null ? 0L : Long.parseLong(value) + 1L;
        return priority;
    }

    private static TableDescriptorBuilder updateLatestPriority(TableDescriptorBuilder builder, long priority) {
        return builder.setValue(COUNTER_KEY, Long.toString(priority));
    }

    public static TableDescriptorBuilder setConfiguration(TableDescriptorBuilder builder, Class<? extends Constraint> clazz, Configuration configuration) throws IOException, IllegalArgumentException {
        Pair<String, String> e = Constraints.getKeyValueForClass(builder, clazz);
        if (e == null) {
            throw new IllegalArgumentException("Constraint: " + clazz.getName() + " is not associated with this table.");
        }
        Configuration conf = new Configuration(configuration);
        Configuration internal = Constraints.readConfiguration(e.getSecond());
        conf.setIfUnset(ENABLED_KEY, internal.get(ENABLED_KEY));
        conf.setIfUnset(PRIORITY_KEY, internal.get(PRIORITY_KEY));
        return Constraints.writeConstraint(builder, e.getFirst(), conf);
    }

    public static TableDescriptorBuilder remove(TableDescriptorBuilder builder, Class<? extends Constraint> clazz) {
        String key = Constraints.serializeConstraintClass(clazz);
        return builder.removeValue(key);
    }

    public static void enableConstraint(TableDescriptorBuilder builder, Class<? extends Constraint> clazz) throws IOException {
        Constraints.changeConstraintEnabled(builder, clazz, true);
    }

    public static void disableConstraint(TableDescriptorBuilder builder, Class<? extends Constraint> clazz) throws IOException {
        Constraints.changeConstraintEnabled(builder, clazz, false);
    }

    private static TableDescriptorBuilder changeConstraintEnabled(TableDescriptorBuilder builder, Class<? extends Constraint> clazz, boolean enabled) throws IOException {
        Pair<String, String> entry = Constraints.getKeyValueForClass(builder, clazz);
        if (entry == null) {
            throw new IllegalArgumentException("Constraint: " + clazz.getName() + " is not associated with this table. You can't enable it!");
        }
        Configuration conf = Constraints.readConfiguration(entry.getSecond());
        conf.setBoolean(ENABLED_KEY, enabled);
        return Constraints.writeConstraint(builder, entry.getFirst(), conf);
    }

    public static boolean enabled(TableDescriptor desc, Class<? extends Constraint> clazz) throws IOException {
        Pair<String, String> entry = Constraints.getKeyValueForClass(desc, clazz);
        if (entry == null) {
            return false;
        }
        Configuration conf = Constraints.readConfiguration(entry.getSecond());
        return conf.getBoolean(ENABLED_KEY, false);
    }

    static List<? extends Constraint> getConstraints(TableDescriptor desc, ClassLoader classloader) throws IOException {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (Map.Entry<Bytes, Bytes> e : desc.getValues().entrySet()) {
            Configuration conf;
            String key = Bytes.toString(e.getKey().get()).trim();
            String[] className = CONSTRAINT_HTD_ATTR_KEY_PATTERN.split(key);
            if (className.length != 2) continue;
            key = className[1];
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading constraint:" + key);
            }
            try {
                conf = Constraints.readConfiguration(e.getValue().get());
            }
            catch (IOException e1) {
                LOG.warn("Corrupted configuration found for key:" + key + ",  skipping it.");
                continue;
            }
            if (!conf.getBoolean(ENABLED_KEY, false)) {
                LOG.debug("Constraint: {} is DISABLED - skipping it", (Object)key);
                continue;
            }
            try {
                Class<Constraint> clazz = classloader.loadClass(key).asSubclass(Constraint.class);
                Constraint constraint = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                constraint.setConf(conf);
                constraints.add(constraint);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
                throw new IOException(e1);
            }
        }
        Collections.sort(constraints, constraintComparator);
        return constraints;
    }
}

