/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.hbase.thirdparty.com.google.common.net.InetAddresses;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class HBaseHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseHostnameVerifier.class);

    HBaseHostnameVerifier() {
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate x509 = (X509Certificate)certs[0];
            this.verify(host, x509);
            return true;
        }
        catch (SSLException ex) {
            LOG.debug("Unexpected exception", (Throwable)ex);
            return false;
        }
    }

    void verify(String host, X509Certificate cert) throws SSLException {
        List<SubjectName> subjectAlts = HBaseHostnameVerifier.getSubjectAltNames(cert);
        if (subjectAlts != null && !subjectAlts.isEmpty()) {
            Optional<InetAddress> inetAddress = HBaseHostnameVerifier.parseIpAddress(host);
            if (inetAddress.isPresent()) {
                HBaseHostnameVerifier.matchIPAddress(host, inetAddress.get(), subjectAlts);
            } else {
                HBaseHostnameVerifier.matchDNSName(host, subjectAlts);
            }
        } else {
            X500Principal subjectPrincipal = cert.getSubjectX500Principal();
            String cn = HBaseHostnameVerifier.extractCN(subjectPrincipal.getName("RFC2253"));
            if (cn == null) {
                throw new SSLException("Certificate subject for <" + host + "> doesn't contain a common name and does not have alternative names");
            }
            HBaseHostnameVerifier.matchCN(host, cn);
        }
    }

    private static void matchIPAddress(String host, InetAddress inetAddress, List<SubjectName> subjectAlts) throws SSLException {
        for (SubjectName subjectAlt : subjectAlts) {
            Optional<InetAddress> parsed;
            if (subjectAlt.getType() != 7 || !(parsed = HBaseHostnameVerifier.parseIpAddress(subjectAlt.getValue())).filter(altAddr -> altAddr.equals(inetAddress)).isPresent()) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + host + "> doesn't match any of the subject alternative names: " + subjectAlts);
    }

    private static void matchDNSName(String host, List<SubjectName> subjectAlts) throws SSLException {
        String normalizedHost = host.toLowerCase(Locale.ROOT);
        for (SubjectName subjectAlt : subjectAlts) {
            String normalizedSubjectAlt;
            if (subjectAlt.getType() != 2 || !HBaseHostnameVerifier.matchIdentityStrict(normalizedHost, normalizedSubjectAlt = subjectAlt.getValue().toLowerCase(Locale.ROOT))) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + host + "> doesn't match any of the subject alternative names: " + subjectAlts);
    }

    private static void matchCN(String host, String cn) throws SSLException {
        String normalizedCn;
        String normalizedHost = host.toLowerCase(Locale.ROOT);
        if (!HBaseHostnameVerifier.matchIdentityStrict(normalizedHost, normalizedCn = cn.toLowerCase(Locale.ROOT))) {
            throw new SSLPeerUnverifiedException("Certificate for <" + host + "> doesn't match common name of the certificate subject: " + cn);
        }
    }

    private static boolean matchIdentity(String host, String identity, boolean strict) {
        int asteriskIdx = identity.indexOf(42);
        if (asteriskIdx != -1) {
            String prefix = identity.substring(0, asteriskIdx);
            String suffix = identity.substring(asteriskIdx + 1);
            if (!prefix.isEmpty() && !host.startsWith(prefix)) {
                return false;
            }
            if (!suffix.isEmpty() && !host.endsWith(suffix)) {
                return false;
            }
            if (strict) {
                String remainder = host.substring(prefix.length(), host.length() - suffix.length());
                return !remainder.contains(".");
            }
            return true;
        }
        return host.equalsIgnoreCase(identity);
    }

    private static boolean matchIdentityStrict(String host, String identity) {
        return HBaseHostnameVerifier.matchIdentity(host, identity, true);
    }

    private static String extractCN(String subjectPrincipal) throws SSLException {
        if (subjectPrincipal == null) {
            return null;
        }
        try {
            LdapName subjectDN = new LdapName(subjectPrincipal);
            List<Rdn> rdns = subjectDN.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rds = rdns.get(i);
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    return value.toString();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (InvalidNameException e) {
            throw new SSLException(subjectPrincipal + " is not a valid X500 distinguished name");
        }
    }

    private static Optional<InetAddress> parseIpAddress(String host) {
        if ((host = host.trim()).startsWith("[") && host.endsWith("]")) {
            return HBaseHostnameVerifier.parseIpAddressUriString(host);
        }
        return HBaseHostnameVerifier.parseIpAddressString(host);
    }

    private static Optional<InetAddress> parseIpAddressUriString(String host) {
        if (InetAddresses.isUriInetAddress(host)) {
            return Optional.of(InetAddresses.forUriString(host));
        }
        return Optional.empty();
    }

    private static Optional<InetAddress> parseIpAddressString(String host) {
        if (InetAddresses.isInetAddress(host)) {
            return Optional.of(InetAddresses.forString(host));
        }
        return Optional.empty();
    }

    private static List<SubjectName> getSubjectAltNames(X509Certificate cert) {
        try {
            Collection<List<?>> entries = cert.getSubjectAlternativeNames();
            if (entries == null) {
                return Collections.emptyList();
            }
            ArrayList<SubjectName> result = new ArrayList<SubjectName>();
            for (List<?> entry : entries) {
                Integer type = entry.size() >= 2 ? (Integer)entry.get(0) : null;
                if (type == null || type != 2 && type != 7) continue;
                Object o = entry.get(1);
                if (o instanceof String) {
                    result.add(new SubjectName((String)o, type));
                    continue;
                }
                LOG.debug("non-string Subject Alt Name type detected, not currently supported: {}", o);
            }
            return result;
        }
        catch (CertificateParsingException ignore) {
            return Collections.emptyList();
        }
    }

    private static final class SubjectName {
        static final int DNS = 2;
        static final int IP = 7;
        private final String value;
        private final int type;

        SubjectName(String value, int type) {
            if (type != 2 && type != 7) {
                throw new IllegalArgumentException("Invalid type: " + type);
            }
            this.value = Objects.requireNonNull(value);
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

