/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseRpcServicesBase;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AnnotationReadingPriorityFunction<T extends HBaseRpcServicesBase<?>>
implements PriorityFunction {
    protected final Map<String, Integer> annotatedQos;
    protected final T rpcServices;

    public AnnotationReadingPriorityFunction(T rpcServices) {
        HashMap<String, Integer> qosMap = new HashMap<String, Integer>();
        for (Method m3 : rpcServices.getClass().getMethods()) {
            QosPriority p = m3.getAnnotation(QosPriority.class);
            if (p == null) continue;
            String capitalizedMethodName = StringUtils.capitalize(m3.getName());
            qosMap.put(capitalizedMethodName, p.priority());
        }
        this.rpcServices = rpcServices;
        this.annotatedQos = qosMap;
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        int priorityByAnnotation = this.getAnnotatedPriority(header);
        if (priorityByAnnotation >= 0) {
            return priorityByAnnotation;
        }
        if (param == null) {
            return 0;
        }
        return this.getBasePriority(header, param);
    }

    protected int getAnnotatedPriority(RPCProtos.RequestHeader header) {
        String methodName = header.getMethodName();
        Integer priorityByAnnotation = this.annotatedQos.get(methodName);
        if (priorityByAnnotation != null) {
            return this.normalizePriority(priorityByAnnotation);
        }
        return -1;
    }

    protected abstract int normalizePriority(int var1);

    protected abstract int getBasePriority(RPCProtos.RequestHeader var1, Message var2);
}

