/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ipc.NettyRpcFrameDecoder;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyRpcServerRequestDecoder;
import org.apache.hadoop.hbase.ipc.NettyServerCall;
import org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerRpcConnection;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyServerRpcConnection
extends ServerRpcConnection {
    final Channel channel;

    NettyServerRpcConnection(NettyRpcServer rpcServer, Channel channel) {
        super(rpcServer);
        this.channel = channel;
        rpcServer.allChannels.add(channel);
        NettyRpcServer.LOG.trace("Connection {}; # active connections={}", (Object)channel.remoteAddress(), (Object)(rpcServer.allChannels.size() - 1));
        NettyFutureUtils.addListener(channel.closeFuture(), f -> {
            this.disposeSasl();
            this.callCleanupIfNeeded();
            NettyRpcServer.LOG.trace("Disconnection {}; # active connections={}", (Object)channel.remoteAddress(), (Object)(rpcServer.allChannels.size() - 1));
            rpcServer.allChannels.remove(channel);
        });
        InetSocketAddress inetSocketAddress = (InetSocketAddress)channel.remoteAddress();
        this.addr = inetSocketAddress.getAddress();
        this.hostAddress = this.addr == null ? "*Unknown*" : inetSocketAddress.getAddress().getHostAddress();
        this.remotePort = inetSocketAddress.getPort();
    }

    void setupHandler() {
        this.channel.pipeline().addBefore("NettyRpcServerResponseEncoder", "frameDecoder", new NettyRpcFrameDecoder(this.rpcServer.maxRequestSize, this)).addBefore("NettyRpcServerResponseEncoder", "decoder", new NettyRpcServerRequestDecoder(this.rpcServer.metrics, this));
    }

    void process(ByteBuf buf) throws IOException, InterruptedException {
        if (this.skipInitialSaslHandshake) {
            this.skipInitialSaslHandshake = false;
            buf.release();
            return;
        }
        this.callCleanup = () -> buf.release();
        SingleByteBuff byteBuff = new SingleByteBuff(buf.nioBuffer());
        try {
            this.processOneRpc(byteBuff);
        }
        catch (Exception e) {
            this.callCleanupIfNeeded();
            throw e;
        }
        finally {
            this.callCleanup = null;
        }
    }

    @Override
    public synchronized void close() {
        this.channel.close();
    }

    @Override
    public boolean isConnectionOpen() {
        return this.channel.isOpen();
    }

    public NettyServerCall createCall(int id, BlockingService service, Descriptors.MethodDescriptor md, RPCProtos.RequestHeader header, Message param, CellScanner cellScanner, long size, InetAddress remoteAddress, int timeout, RpcServer.CallCleanup reqCleanup) {
        return new NettyServerCall(id, service, md, header, param, cellScanner, this, size, remoteAddress, EnvironmentEdgeManager.currentTime(), timeout, this.rpcServer.bbAllocator, this.rpcServer.cellBlockBuilder, reqCleanup);
    }

    @Override
    protected void doRespond(RpcResponse resp) {
        NettyFutureUtils.safeWriteAndFlush(this.channel, resp);
    }
}

