/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterAnnotationReadingPriorityFunction
extends AnnotationReadingPriorityFunction<MasterRpcServices> {
    public static final int META_TRANSITION_QOS = 300;

    MasterAnnotationReadingPriorityFunction(MasterRpcServices rpcServices) {
        super(rpcServices);
    }

    @Override
    protected int normalizePriority(int priority) {
        if (priority >= 300) {
            return 299;
        }
        return priority;
    }

    @Override
    protected int getBasePriority(RPCProtos.RequestHeader header, Message param) {
        if (param instanceof RegionServerStatusProtos.ReportRegionStateTransitionRequest) {
            RegionServerStatusProtos.ReportRegionStateTransitionRequest tRequest = (RegionServerStatusProtos.ReportRegionStateTransitionRequest)param;
            for (RegionServerStatusProtos.RegionStateTransition rst : tRequest.getTransitionList()) {
                if (rst.getRegionInfoList() == null) continue;
                for (HBaseProtos.RegionInfo info : rst.getRegionInfoList()) {
                    TableName tn = ProtobufUtil.toTableName(info.getTableName());
                    if (!TableName.META_TABLE_NAME.equals(tn)) continue;
                    return 300;
                }
            }
            return 200;
        }
        if (param instanceof RegionServerStatusProtos.RegionServerReportRequest) {
            return 200;
        }
        if (header.hasPriority()) {
            return header.getPriority();
        }
        return 0;
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, Message param) {
        return 0L;
    }
}

