/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.ClientMetaTableAccessor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.util.IdReadWriteLock;
import org.apache.hadoop.hbase.util.IdReadWriteLockWithObjectPool;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(TableStateManager.class);
    private final IdReadWriteLock<TableName> tnLock = new IdReadWriteLockWithObjectPool<TableName>();
    private final MasterServices master;
    private final ConcurrentMap<TableName, TableState.State> tableName2State = new ConcurrentHashMap<TableName, TableState.State>();

    TableStateManager(MasterServices master) {
        this.master = master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableState(TableName tableName, TableState.State newState) throws IOException {
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.writeLock().lock();
        try {
            this.updateMetaState(tableName, newState);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public boolean isTableState(TableName tableName, TableState.State ... states) {
        try {
            TableState tableState = this.getTableState(tableName);
            return tableState.isInStates(states);
        }
        catch (IOException e) {
            LOG.error("Unable to get table " + tableName + " state", (Throwable)e);
            return false;
        }
    }

    public void setDeletedTable(TableName tableName) throws IOException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return;
        }
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.writeLock().lock();
        try {
            MetaTableAccessor.deleteTableState(this.master.getConnection(), tableName);
        }
        finally {
            this.tableName2State.remove(tableName);
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(TableName tableName) throws IOException {
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.readLock().lock();
        try {
            boolean bl = this.readMetaState(tableName) != null;
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    Set<TableName> getTablesInStates(final TableState.State ... states) throws IOException {
        final HashSet<TableName> rv = Sets.newHashSet();
        MetaTableAccessor.fullScanTables(this.master.getConnection(), new ClientMetaTableAccessor.Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                TableState tableState = CatalogFamilyFormat.getTableState(r);
                if (tableState != null && tableState.inStates(states)) {
                    rv.add(tableState.getTableName());
                }
                return true;
            }
        });
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TableState getTableState(TableName tableName) throws IOException {
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.readLock().lock();
        try {
            TableState currentState = this.readMetaState(tableName);
            if (currentState == null) {
                throw new TableNotFoundException("No state found for " + tableName);
            }
            TableState tableState = currentState;
            return tableState;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetaState(TableName tableName, TableState.State newState) throws IOException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            if (TableState.State.DISABLING.equals((Object)newState) || TableState.State.DISABLED.equals((Object)newState)) {
                throw new IllegalArgumentIOException("Cannot disable meta table; " + (Object)((Object)newState));
            }
            return;
        }
        boolean succ = false;
        try {
            MetaTableAccessor.updateTableState(this.master.getConnection(), tableName, newState);
            this.tableName2State.put(tableName, newState);
            succ = true;
        }
        finally {
            if (!succ) {
                this.tableName2State.remove(tableName);
            }
        }
    }

    @Nullable
    private TableState readMetaState(TableName tableName) throws IOException {
        TableState.State state = (TableState.State)((Object)this.tableName2State.get(tableName));
        if (state != null) {
            return new TableState(tableName, state);
        }
        TableState tableState = MetaTableAccessor.getTableState(this.master.getConnection(), tableName);
        if (tableState != null) {
            this.tableName2State.putIfAbsent(tableName, tableState.getState());
        }
        return tableState;
    }
}

