/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.hbck;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.hbck.HbckReport;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HbckRegionInfo;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HbckChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger((String)HbckChore.class.getName());
    private static final String HBCK_CHORE_INTERVAL = "hbase.master.hbck.chore.interval";
    private static final int DEFAULT_HBCK_CHORE_INTERVAL = 3600000;
    private final MasterServices master;
    private volatile HbckReport lastReport = null;
    private volatile boolean running = false;
    private boolean disabled = false;

    public HbckChore(MasterServices master) {
        super("HbckChore-", master, master.getConfiguration().getInt(HBCK_CHORE_INTERVAL, 3600000));
        this.master = master;
        int interval = master.getConfiguration().getInt(HBCK_CHORE_INTERVAL, 3600000);
        if (interval <= 0) {
            LOG.warn("hbase.master.hbck.chore.interval is <=0 hence disabling hbck chore");
            this.disableChore();
        }
    }

    public HbckReport getLastReport() {
        return this.lastReport;
    }

    @Override
    protected synchronized void chore() {
        if (this.isDisabled() || this.isRunning()) {
            LOG.warn("hbckChore is either disabled or is already running. Can't run the chore");
            return;
        }
        this.running = true;
        HbckReport report = new HbckReport();
        report.setCheckingStartTimestamp(Instant.ofEpochMilli(EnvironmentEdgeManager.currentTime()));
        try {
            this.loadRegionsFromInMemoryState(report);
            this.loadRegionsFromRSReport(report);
            try {
                this.loadRegionsFromFS(this.scanForMergedParentRegions(), report);
            }
            catch (IOException e) {
                LOG.warn("Failed to load the regions from filesystem", (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.warn("Unexpected", t);
        }
        report.setCheckingEndTimestamp(Instant.ofEpochMilli(EnvironmentEdgeManager.currentTime()));
        this.lastReport = report;
        this.running = false;
        this.updateAssignmentManagerMetrics(report);
    }

    public boolean runChore() {
        if (this.isDisabled() || this.isRunning()) {
            if (this.isDisabled()) {
                LOG.warn("hbck chore is disabled! Set hbase.master.hbck.chore.interval > 0 to enable it.");
            } else {
                LOG.warn("hbck chore already running. Can't run till it finishes.");
            }
            return false;
        }
        this.chore();
        return true;
    }

    private void disableChore() {
        this.disabled = true;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    private HashSet<String> scanForMergedParentRegions() throws IOException {
        HashSet<String> mergedParentRegions = new HashSet<String>();
        MetaTableAccessor.scanMetaForTableRegions(this.master.getConnection(), r -> {
            List<RegionInfo> mergeParents = CatalogFamilyFormat.getMergeRegions(r.rawCells());
            if (mergeParents != null) {
                for (RegionInfo mergeRegion : mergeParents) {
                    if (mergeRegion == null) continue;
                    mergedParentRegions.add(mergeRegion.getEncodedName());
                }
            }
            return true;
        }, null);
        return mergedParentRegions;
    }

    private void loadRegionsFromInMemoryState(HbckReport report) {
        ArrayList<RegionState> regionStates = this.master.getAssignmentManager().getRegionStates().getRegionStates();
        for (RegionState regionState : regionStates) {
            RegionInfo regionInfo = regionState.getRegion();
            if (this.master.getTableStateManager().isTableState(regionInfo.getTable(), TableState.State.DISABLED)) {
                report.getDisabledTableRegions().add(regionInfo.getRegionNameAsString());
            }
            if (regionState.isSplit() || regionInfo.isSplit()) {
                report.getSplitParentRegions().add(regionInfo.getRegionNameAsString());
            }
            HbckRegionInfo.MetaEntry metaEntry = new HbckRegionInfo.MetaEntry(regionInfo, regionState.getServerName(), regionState.getStamp());
            report.getRegionInfoMap().put(regionInfo.getEncodedName(), new HbckRegionInfo(metaEntry));
        }
        LOG.info("Loaded {} regions ({} disabled, {} split parents) from in-memory state", new Object[]{regionStates.size(), report.getDisabledTableRegions().size(), report.getSplitParentRegions().size()});
        if (LOG.isDebugEnabled()) {
            HashMap<RegionState.State, Integer> stateCountMap = new HashMap<RegionState.State, Integer>();
            for (RegionState regionState : regionStates) {
                stateCountMap.compute(regionState.getState(), (k, v) -> v == null ? 1 : v + 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Regions by state: ");
            stateCountMap.entrySet().forEach(e -> {
                sb.append(e.getKey());
                sb.append('=');
                sb.append(e.getValue());
                sb.append(' ');
            });
            LOG.debug(stringBuffer.toString());
        }
        if (LOG.isTraceEnabled()) {
            for (RegionState regionState : regionStates) {
                LOG.trace("{}: {}, serverName={}", new Object[]{regionState.getRegion(), regionState.getState(), regionState.getServerName()});
            }
        }
    }

    private void loadRegionsFromRSReport(HbckReport report) {
        int numRegions = 0;
        Map<ServerName, Set<byte[]>> rsReports = this.master.getAssignmentManager().getRSReports();
        for (Map.Entry<ServerName, Set<byte[]>> entry : rsReports.entrySet()) {
            ServerName serverName = entry.getKey();
            for (byte[] regionName : entry.getValue()) {
                String encodedRegionName = RegionInfo.encodeRegionName(regionName);
                HbckRegionInfo hri = report.getRegionInfoMap().get(encodedRegionName);
                if (hri == null) {
                    report.getOrphanRegionsOnRS().put(RegionInfo.getRegionNameAsString(regionName), serverName);
                    continue;
                }
                hri.addServer(hri.getMetaEntry().getRegionInfo(), serverName);
            }
            numRegions += entry.getValue().size();
        }
        LOG.info("Loaded {} regions from {} regionservers' reports and found {} orphan regions", new Object[]{numRegions, rsReports.size(), report.getOrphanRegionsOnRS().size()});
        for (Map.Entry<Object, Object> entry : report.getRegionInfoMap().entrySet()) {
            HbckRegionInfo hri = (HbckRegionInfo)entry.getValue();
            ServerName locationInMeta = hri.getMetaEntry().getRegionServer();
            if (hri.getDeployedOn().size() == 0) {
                if (report.getDisabledTableRegions().contains(hri.getRegionNameAsString()) || report.getSplitParentRegions().contains(hri.getRegionNameAsString())) continue;
                report.getInconsistentRegions().put(hri.getRegionNameAsString(), new Pair(locationInMeta, new LinkedList()));
                continue;
            }
            if (hri.getDeployedOn().size() > 1) {
                report.getInconsistentRegions().put(hri.getRegionNameAsString(), new Pair<ServerName, List<ServerName>>(locationInMeta, hri.getDeployedOn()));
                continue;
            }
            if (hri.getDeployedOn().get(0).equals(locationInMeta)) continue;
            report.getInconsistentRegions().put(hri.getRegionNameAsString(), new Pair<ServerName, List<ServerName>>(locationInMeta, hri.getDeployedOn()));
        }
    }

    private void loadRegionsFromFS(HashSet<String> mergedParentRegions, HbckReport report) throws IOException {
        Path rootDir = this.master.getMasterFileSystem().getRootDir();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        int numRegions = 0;
        List<Path> tableDirs = FSUtils.getTableDirs(fs, rootDir);
        for (Path tableDir : tableDirs) {
            List<Path> regionDirs = FSUtils.getRegionDirs(fs, tableDir);
            for (Path regionDir : regionDirs) {
                String encodedRegionName = regionDir.getName();
                if (encodedRegionName == null) {
                    LOG.warn("Failed get of encoded name from {}", (Object)regionDir);
                    continue;
                }
                HbckRegionInfo hri = report.getRegionInfoMap().get(encodedRegionName);
                if (hri != null || mergedParentRegions.contains(encodedRegionName)) continue;
                report.getOrphanRegionsOnFS().put(encodedRegionName, regionDir);
            }
            numRegions += regionDirs.size();
        }
        LOG.info("Loaded {} tables {} regions from filesystem and found {} orphan regions", new Object[]{tableDirs.size(), numRegions, report.getOrphanRegionsOnFS().size()});
    }

    private void updateAssignmentManagerMetrics(HbckReport report) {
        this.master.getAssignmentManager().getAssignmentManagerMetrics().updateOrphanRegionsOnRs(report.getOrphanRegionsOnRS().size());
        this.master.getAssignmentManager().getAssignmentManagerMetrics().updateOrphanRegionsOnFs(report.getOrphanRegionsOnFS().size());
        this.master.getAssignmentManager().getAssignmentManagerMetrics().updateInconsistentRegions(report.getInconsistentRegions().size());
    }

    public boolean isRunning() {
        return this.running;
    }
}

