/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractPeerNoLockProcedure<TState>
extends StateMachineProcedure<MasterProcedureEnv, TState>
implements PeerProcedureInterface {
    protected String peerId;
    private RetryCounter retryCounter;

    protected AbstractPeerNoLockProcedure() {
    }

    protected AbstractPeerNoLockProcedure(String peerId) {
        this.peerId = peerId;
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized(this);
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, TState state) throws IOException, InterruptedException {
        if (state == this.getInitialState()) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize(MasterProcedureProtos.PeerProcedureStateData.newBuilder().setPeerId(this.peerId).build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        this.peerId = serializer.deserialize(MasterProcedureProtos.PeerProcedureStateData.class).getPeerId();
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    protected final ProcedureSuspendedException suspend(Configuration conf, LongConsumer backoffConsumer) throws ProcedureSuspendedException {
        if (this.retryCounter == null) {
            this.retryCounter = ProcedureUtil.createRetryCounter(conf);
        }
        long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
        backoffConsumer.accept(backoff);
        throw this.suspend(Math.toIntExact(backoff), false);
    }

    protected final void resetRetry() {
        this.retryCounter = null;
    }
}

