/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RSAnnotationReadingPriorityFunction
extends AnnotationReadingPriorityFunction<RSRpcServices> {
    private static final Logger LOG = LoggerFactory.getLogger(RSAnnotationReadingPriorityFunction.class);
    public static final String SCAN_VTIME_WEIGHT_CONF_KEY = "hbase.ipc.server.scan.vtime.weight";
    private final Class<? extends Message>[] knownArgumentClasses = new Class[]{AdminProtos.GetRegionInfoRequest.class, AdminProtos.GetStoreFileRequest.class, AdminProtos.CloseRegionRequest.class, AdminProtos.FlushRegionRequest.class, AdminProtos.CompactRegionRequest.class, ClientProtos.GetRequest.class, ClientProtos.MutateRequest.class, ClientProtos.ScanRequest.class};
    private final Map<String, Class<? extends Message>> argumentToClassMap = new HashMap<String, Class<? extends Message>>();
    private final Map<String, Map<Class<? extends Message>, Method>> methodMap = new HashMap<String, Map<Class<? extends Message>, Method>>();
    private final float scanVirtualTimeWeight;

    RSAnnotationReadingPriorityFunction(RSRpcServices rpcServices) {
        super(rpcServices);
        if (this.methodMap.get("getRegion") == null) {
            this.methodMap.put("hasRegion", new HashMap());
            this.methodMap.put("getRegion", new HashMap());
        }
        for (Class<? extends Message> cls : this.knownArgumentClasses) {
            this.argumentToClassMap.put(cls.getName(), cls);
            try {
                this.methodMap.get("hasRegion").put(cls, cls.getDeclaredMethod("hasRegion", new Class[0]));
                this.methodMap.get("getRegion").put(cls, cls.getDeclaredMethod("getRegion", new Class[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Configuration conf = rpcServices.getConfiguration();
        this.scanVirtualTimeWeight = conf.getFloat(SCAN_VTIME_WEIGHT_CONF_KEY, 1.0f);
    }

    @Override
    protected int normalizePriority(int priority) {
        return priority;
    }

    @Override
    protected int getBasePriority(RPCProtos.RequestHeader header, Message param) {
        if (header.hasPriority()) {
            return header.getPriority();
        }
        if (param instanceof ClientProtos.BulkLoadHFileRequest) {
            return 4;
        }
        String cls = param.getClass().getName();
        Class<? extends Message> rpcArgClass = this.argumentToClassMap.get(cls);
        HBaseProtos.RegionSpecifier regionSpecifier = null;
        try {
            Method getRegion;
            HRegion region;
            Method hasRegion = this.methodMap.get("hasRegion").get(rpcArgClass);
            if (hasRegion != null && ((Boolean)hasRegion.invoke((Object)param, (Object[])null)).booleanValue() && (region = ((RSRpcServices)this.rpcServices).getRegion(regionSpecifier = (HBaseProtos.RegionSpecifier)(getRegion = this.methodMap.get("getRegion").get(rpcArgClass)).invoke((Object)param, (Object[])null))).getRegionInfo().getTable().isSystemTable()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("High priority because region=" + region.getRegionInfo().getRegionNameAsString());
                }
                return 200;
            }
        }
        catch (Exception ex) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Marking normal priority after getting exception=" + ex);
            }
            return 0;
        }
        if (param instanceof ClientProtos.ScanRequest) {
            ClientProtos.ScanRequest request = (ClientProtos.ScanRequest)param;
            if (!request.hasScannerId()) {
                return 0;
            }
            RegionScanner scanner = ((RSRpcServices)this.rpcServices).getScanner(request.getScannerId());
            if (scanner != null && scanner.getRegionInfo().getTable().isSystemTable()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("High priority scanner request " + TextFormat.shortDebugString(request));
                }
                return 200;
            }
        }
        return 0;
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, Message param) {
        if (param instanceof ClientProtos.ScanRequest) {
            ClientProtos.ScanRequest request = (ClientProtos.ScanRequest)param;
            if (!request.hasScannerId()) {
                return 0L;
            }
            long vtime = ((RSRpcServices)this.rpcServices).getScannerVirtualTime(request.getScannerId());
            return Math.round(Math.sqrt((float)vtime * this.scanVirtualTimeWeight));
        }
        return 0L;
    }
}

