/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.NonReversedNonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RowTooBigException;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.handler.ParallelSeekHandler;
import org.apache.hadoop.hbase.regionserver.querymatcher.CompactionScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.UserScanQueryMatcher;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StoreScanner
extends NonReversedNonLazyKeyValueScanner
implements KeyValueScanner,
InternalScanner,
ChangedReadersObserver {
    private static final Logger LOG = LoggerFactory.getLogger(StoreScanner.class);
    protected final HStore store;
    private final CellComparator comparator;
    private ScanQueryMatcher matcher;
    protected KeyValueHeap heap;
    private boolean cacheBlocks;
    private long countPerRow = 0L;
    private int storeLimit = -1;
    private int storeOffset = 0;
    private volatile boolean closing = false;
    private final boolean get;
    private final boolean explicitColumnQuery;
    private final boolean useRowColBloom;
    private boolean parallelSeekEnabled = false;
    private ExecutorService executor;
    private final Scan scan;
    private final long oldestUnexpiredTS;
    private final long now;
    private final int minVersions;
    private final long maxRowSize;
    private final long cellsPerHeartbeatCheck;
    long memstoreOnlyReads;
    long mixedReads;
    private final List<KeyValueScanner> scannersForDelayedClose = new ArrayList<KeyValueScanner>();
    private long kvsScanned = 0L;
    private Cell prevCell = null;
    private final long preadMaxBytes;
    private long bytesRead;
    static final boolean LAZY_SEEK_ENABLED_BY_DEFAULT = true;
    public static final String STORESCANNER_PARALLEL_SEEK_ENABLE = "hbase.storescanner.parallel.seek.enable";
    private static boolean lazySeekEnabledGlobally = true;
    public static final String HBASE_CELLS_SCANNED_PER_HEARTBEAT_CHECK = "hbase.cells.scanned.per.heartbeat.check";
    public static final long DEFAULT_HBASE_CELLS_SCANNED_PER_HEARTBEAT_CHECK = 10000L;
    public static final String STORESCANNER_PREAD_MAX_BYTES = "hbase.storescanner.pread.max.bytes";
    private final Scan.ReadType readType;
    private boolean scanUsePread;
    private volatile boolean flushed = false;
    private final List<KeyValueScanner> flushedstoreFileScanners = new ArrayList<KeyValueScanner>(1);
    private final List<KeyValueScanner> memStoreScannersAfterFlush = new ArrayList<KeyValueScanner>(3);
    final List<KeyValueScanner> currentScanners = new ArrayList<KeyValueScanner>();
    private final ReentrantLock flushLock = new ReentrantLock();
    private final ReentrantLock closeLock = new ReentrantLock();
    protected final long readPt;
    private boolean topChanged = false;
    private static final Scan SCAN_FOR_COMPACTION = new Scan();

    private StoreScanner(HStore store, Scan scan, ScanInfo scanInfo, int numColumns, long readPt, boolean cacheBlocks, ScanType scanType) {
        RegionServerServices rsService;
        this.readPt = readPt;
        this.store = store;
        this.cacheBlocks = cacheBlocks;
        this.comparator = Preconditions.checkNotNull(scanInfo.getComparator());
        this.get = scan.isGetScan();
        this.explicitColumnQuery = numColumns > 0;
        this.scan = scan;
        this.now = EnvironmentEdgeManager.currentTime();
        this.oldestUnexpiredTS = scan.isRaw() ? 0L : this.now - scanInfo.getTtl();
        this.minVersions = scanInfo.getMinVersions();
        this.useRowColBloom = numColumns > 1 || !this.get && numColumns == 1 && (store == null || store.getColumnFamilyDescriptor().getBloomFilterType() == BloomType.ROWCOL);
        this.maxRowSize = scanInfo.getTableMaxRowSize();
        this.preadMaxBytes = scanInfo.getPreadMaxBytes();
        if (this.get) {
            this.readType = Scan.ReadType.PREAD;
            this.scanUsePread = true;
        } else if (scanType != ScanType.USER_SCAN) {
            this.readType = Scan.ReadType.STREAM;
            this.scanUsePread = false;
        } else {
            this.readType = scan.getReadType() == Scan.ReadType.DEFAULT ? (scanInfo.isUsePread() ? Scan.ReadType.PREAD : (this.preadMaxBytes < 0L ? Scan.ReadType.STREAM : Scan.ReadType.DEFAULT)) : scan.getReadType();
            this.scanUsePread = this.readType != Scan.ReadType.STREAM;
        }
        this.cellsPerHeartbeatCheck = scanInfo.getCellsPerTimeoutCheck();
        if (store != null && store.getStorefilesCount() > 1 && (rsService = store.getHRegion().getRegionServerServices()) != null && scanInfo.isParallelSeekEnabled()) {
            this.parallelSeekEnabled = true;
            this.executor = rsService.getExecutorService();
        }
    }

    private void addCurrentScanners(List<? extends KeyValueScanner> scanners) {
        this.currentScanners.addAll(scanners);
    }

    public StoreScanner(HStore store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
        this(store, scan, scanInfo, columns != null ? columns.size() : 0, readPt, scan.getCacheBlocks(), ScanType.USER_SCAN);
        if (columns != null && scan.isRaw()) {
            throw new DoNotRetryIOException("Cannot specify any column for a raw scan");
        }
        this.matcher = UserScanQueryMatcher.create(scan, scanInfo, columns, this.oldestUnexpiredTS, this.now, store.getCoprocessorHost());
        store.addChangedReaderObserver(this);
        List<KeyValueScanner> scanners = null;
        try {
            scanners = this.selectScannersFrom(store, store.getScanners(this.cacheBlocks, this.scanUsePread, false, this.matcher, scan.getStartRow(), scan.includeStartRow(), scan.getStopRow(), scan.includeStopRow(), this.readPt));
            this.seekScanners(scanners, this.matcher.getStartKey(), this.explicitColumnQuery && lazySeekEnabledGlobally, this.parallelSeekEnabled);
            this.storeLimit = scan.getMaxResultsPerColumnFamily();
            this.storeOffset = scan.getRowOffsetPerColumnFamily();
            this.addCurrentScanners(scanners);
            this.resetKVHeap(scanners, this.comparator);
        }
        catch (IOException e) {
            StoreScanner.clearAndClose(scanners);
            store.deleteChangedReaderObserver(this);
            throw e;
        }
    }

    public StoreScanner(HStore store, ScanInfo scanInfo, List<? extends KeyValueScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        this(store, scanInfo, scanners, scanType, smallestReadPoint, earliestPutTs, null, null);
    }

    public StoreScanner(HStore store, ScanInfo scanInfo, List<? extends KeyValueScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        this(store, scanInfo, scanners, ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, earliestPutTs, dropDeletesFromRow, dropDeletesToRow);
    }

    private StoreScanner(HStore store, ScanInfo scanInfo, List<? extends KeyValueScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        this(store, SCAN_FOR_COMPACTION, scanInfo, 0, store.getHRegion().getReadPoint(IsolationLevel.READ_COMMITTED), false, scanType);
        assert (scanType != ScanType.USER_SCAN);
        this.matcher = CompactionScanQueryMatcher.create(scanInfo, scanType, smallestReadPoint, earliestPutTs, this.oldestUnexpiredTS, this.now, dropDeletesFromRow, dropDeletesToRow, store.getCoprocessorHost());
        scanners = this.selectScannersFrom(store, scanners);
        this.seekScanners(scanners, this.matcher.getStartKey(), false, this.parallelSeekEnabled);
        this.addCurrentScanners(scanners);
        this.resetKVHeap(scanners, this.comparator);
    }

    private void seekAllScanner(ScanInfo scanInfo, List<? extends KeyValueScanner> scanners) throws IOException {
        this.seekScanners(scanners, this.matcher.getStartKey(), false, this.parallelSeekEnabled);
        this.addCurrentScanners(scanners);
        this.resetKVHeap(scanners, this.comparator);
    }

    public StoreScanner(ScanInfo scanInfo, ScanType scanType, List<? extends KeyValueScanner> scanners) throws IOException {
        this(null, SCAN_FOR_COMPACTION, scanInfo, 0, Long.MAX_VALUE, false, scanType);
        assert (scanType != ScanType.USER_SCAN);
        this.matcher = CompactionScanQueryMatcher.create(scanInfo, scanType, Long.MAX_VALUE, 0L, this.oldestUnexpiredTS, this.now, null, null, null);
        this.seekAllScanner(scanInfo, scanners);
    }

    StoreScanner(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, List<? extends KeyValueScanner> scanners, ScanType scanType) throws IOException {
        this(null, scan, scanInfo, columns != null ? columns.size() : 0, 0L, scan.getCacheBlocks(), scanType);
        this.matcher = scanType == ScanType.USER_SCAN ? UserScanQueryMatcher.create(scan, scanInfo, columns, this.oldestUnexpiredTS, this.now, null) : CompactionScanQueryMatcher.create(scanInfo, scanType, Long.MAX_VALUE, Long.MIN_VALUE, this.oldestUnexpiredTS, this.now, null, null, null);
        this.seekAllScanner(scanInfo, scanners);
    }

    StoreScanner(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, List<? extends KeyValueScanner> scanners) throws IOException {
        this(null, scan, scanInfo, columns != null ? columns.size() : 0, 0L, scan.getCacheBlocks(), ScanType.USER_SCAN);
        this.matcher = UserScanQueryMatcher.create(scan, scanInfo, columns, this.oldestUnexpiredTS, this.now, null);
        this.seekAllScanner(scanInfo, scanners);
    }

    StoreScanner(ScanInfo scanInfo, int maxVersions, ScanType scanType, List<? extends KeyValueScanner> scanners) throws IOException {
        this(null, maxVersions > 0 ? new Scan().readVersions(maxVersions) : SCAN_FOR_COMPACTION, scanInfo, 0, 0L, false, scanType);
        this.matcher = CompactionScanQueryMatcher.create(scanInfo, scanType, Long.MAX_VALUE, Long.MIN_VALUE, this.oldestUnexpiredTS, this.now, null, null, null);
        this.seekAllScanner(scanInfo, scanners);
    }

    boolean isScanUsePread() {
        return this.scanUsePread;
    }

    protected void seekScanners(List<? extends KeyValueScanner> scanners, Cell seekKey, boolean isLazy, boolean isParallelSeek) throws IOException {
        if (isLazy) {
            for (KeyValueScanner keyValueScanner : scanners) {
                keyValueScanner.requestSeek(seekKey, false, true);
            }
        } else if (!isParallelSeek) {
            long totalScannersSoughtBytes = 0L;
            for (KeyValueScanner keyValueScanner : scanners) {
                if (this.matcher.isUserScan() && totalScannersSoughtBytes >= this.maxRowSize) {
                    throw new RowTooBigException("Max row size allowed: " + this.maxRowSize + ", but row is bigger than that");
                }
                keyValueScanner.seek(seekKey);
                Cell c = keyValueScanner.peek();
                if (c == null) continue;
                totalScannersSoughtBytes += (long)PrivateCellUtil.estimatedSerializedSizeOf(c);
            }
        } else {
            this.parallelSeek(scanners, seekKey);
        }
    }

    protected void resetKVHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
        this.heap = this.newKVHeap(scanners, comparator);
    }

    protected KeyValueHeap newKVHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
        return new KeyValueHeap(scanners, comparator);
    }

    protected List<KeyValueScanner> selectScannersFrom(HStore store, List<? extends KeyValueScanner> allScanners) {
        boolean filesOnly;
        boolean memOnly;
        if (this.scan instanceof InternalScan) {
            InternalScan iscan = (InternalScan)this.scan;
            memOnly = iscan.isCheckOnlyMemStore();
            filesOnly = iscan.isCheckOnlyStoreFiles();
        } else {
            memOnly = false;
            filesOnly = false;
        }
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(allScanners.size());
        long expiredTimestampCutoff = this.minVersions == 0 ? this.oldestUnexpiredTS : Long.MIN_VALUE;
        for (KeyValueScanner keyValueScanner : allScanners) {
            boolean isFile = keyValueScanner.isFileScanner();
            if (!isFile && filesOnly || isFile && memOnly) {
                keyValueScanner.close();
                continue;
            }
            if (keyValueScanner.shouldUseScanner(this.scan, store, expiredTimestampCutoff)) {
                scanners.add(keyValueScanner);
                continue;
            }
            keyValueScanner.close();
        }
        return scanners;
    }

    @Override
    public Cell peek() {
        return this.heap != null ? this.heap.peek() : null;
    }

    @Override
    public KeyValue next() {
        throw new RuntimeException("Never call StoreScanner.next()");
    }

    @Override
    public void close() {
        this.close(true);
    }

    private void close(boolean withDelayedScannersClose) {
        this.closeLock.lock();
        try {
            if (this.closing) {
                return;
            }
            if (withDelayedScannersClose) {
                this.closing = true;
            }
            if (this.store != null) {
                this.store.deleteChangedReaderObserver(this);
            }
            if (withDelayedScannersClose) {
                StoreScanner.clearAndClose(this.scannersForDelayedClose);
                StoreScanner.clearAndClose(this.memStoreScannersAfterFlush);
                StoreScanner.clearAndClose(this.flushedstoreFileScanners);
                if (this.heap != null) {
                    this.heap.close();
                    this.currentScanners.clear();
                    this.heap = null;
                }
            } else if (this.heap != null) {
                this.scannersForDelayedClose.add(this.heap);
                this.currentScanners.clear();
                this.heap = null;
            }
        }
        finally {
            this.closeLock.unlock();
        }
    }

    @Override
    public boolean seek(Cell key) throws IOException {
        if (this.checkFlushed()) {
            this.reopenAfterFlush();
        }
        return this.heap.seek(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(List<Cell> outResult, ScannerContext scannerContext) throws IOException {
        if (scannerContext == null) {
            throw new IllegalArgumentException("Scanner context cannot be null");
        }
        if (this.checkFlushed() && this.reopenAfterFlush()) {
            return scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
        }
        if (this.heap == null) {
            this.close(false);
            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
        }
        Cell cell = this.heap.peek();
        if (cell == null) {
            this.close(false);
            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
        }
        if (!scannerContext.hasAnyLimit(ScannerContext.LimitScope.BETWEEN_CELLS) || this.matcher.currentRow() == null) {
            this.countPerRow = 0L;
            this.matcher.setToNewRow(cell);
        }
        if (!scannerContext.getKeepProgress() && !scannerContext.getSkippingRow()) {
            scannerContext.clearProgress();
        }
        Optional<RpcCall> rpcCall = this.matcher.isUserScan() ? RpcServer.getCurrentCall() : Optional.empty();
        int count = 0;
        long totalBytesRead = 0L;
        boolean onlyFromMemstore = this.matcher.isUserScan();
        try {
            boolean bl;
            block24: do {
                if ((this.kvsScanned % this.cellsPerHeartbeatCheck == 0L || this.scanUsePread && this.readType == Scan.ReadType.DEFAULT && this.bytesRead > this.preadMaxBytes) && scannerContext.checkTimeLimit(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                    bl = scannerContext.setScannerState(ScannerContext.NextState.TIME_LIMIT_REACHED).hasMoreValues();
                    return bl;
                }
                if (this.prevCell != cell) {
                    ++this.kvsScanned;
                }
                this.checkScanOrder(this.prevCell, cell, this.comparator);
                int cellSize = PrivateCellUtil.estimatedSerializedSizeOf(cell);
                this.bytesRead += (long)cellSize;
                if (this.scanUsePread && this.readType == Scan.ReadType.DEFAULT && this.bytesRead > this.preadMaxBytes) {
                    scannerContext.returnImmediately();
                }
                this.heap.recordBlockSize(blockSize -> {
                    if (rpcCall.isPresent()) {
                        ((RpcCall)rpcCall.get()).incrementBlockBytesScanned(blockSize);
                    }
                    scannerContext.incrementBlockProgress(blockSize);
                });
                this.prevCell = cell;
                scannerContext.setLastPeekedCell(cell);
                this.topChanged = false;
                ScanQueryMatcher.MatchCode qcode = this.matcher.match(cell);
                switch (qcode) {
                    case INCLUDE: 
                    case INCLUDE_AND_SEEK_NEXT_ROW: 
                    case INCLUDE_AND_SEEK_NEXT_COL: {
                        Filter f = this.matcher.getFilter();
                        if (f != null) {
                            cell = f.transformCell(cell);
                        }
                        ++this.countPerRow;
                        if (this.countPerRow > (long)this.storeOffset) {
                            outResult.add(cell);
                            ++count;
                            onlyFromMemstore = onlyFromMemstore && this.heap.isLatestCellFromMemstore();
                            scannerContext.incrementSizeProgress(cellSize, cell.heapSize());
                            scannerContext.incrementBatchProgress(1);
                            if (this.matcher.isUserScan() && (totalBytesRead += (long)cellSize) > this.maxRowSize) {
                                String message = "Max row size allowed: " + this.maxRowSize + ", but the row is bigger than that, the row info: " + CellUtil.toString(cell, false) + ", already have process row cells = " + outResult.size() + ", it belong to region = " + this.store.getHRegion().getRegionInfo().getRegionNameAsString();
                                LOG.warn(message);
                                throw new RowTooBigException(message);
                            }
                            if (this.storeLimit > -1 && this.countPerRow >= (long)(this.storeLimit + this.storeOffset)) {
                                if (!this.matcher.moreRowsMayExistAfter(cell)) {
                                    this.close(false);
                                    boolean message = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                                    return message;
                                }
                                this.matcher.clearCurrentRow();
                                this.seekToNextRow(cell);
                                break block24;
                            }
                        }
                        if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW) {
                            if (!this.matcher.moreRowsMayExistAfter(cell)) {
                                this.close(false);
                                boolean message = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                                return message;
                            }
                            this.matcher.clearCurrentRow();
                            this.seekOrSkipToNextRow(cell);
                        } else if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL) {
                            this.seekOrSkipToNextColumn(cell);
                        } else {
                            this.heap.next();
                        }
                        if (!scannerContext.checkBatchLimit(ScannerContext.LimitScope.BETWEEN_CELLS) && !scannerContext.checkSizeLimit(ScannerContext.LimitScope.BETWEEN_CELLS)) continue block24;
                        break block24;
                    }
                    case DONE: {
                        if (this.get) {
                            this.close(false);
                            boolean message = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                            return message;
                        }
                        this.matcher.clearCurrentRow();
                        boolean message = scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                        return message;
                    }
                    case DONE_SCAN: {
                        this.close(false);
                        boolean message = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        return message;
                    }
                    case SEEK_NEXT_ROW: {
                        if (!this.matcher.moreRowsMayExistAfter(cell)) {
                            this.close(false);
                            boolean message = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                            return message;
                        }
                        this.matcher.clearCurrentRow();
                        this.seekOrSkipToNextRow(cell);
                        ScannerContext.NextState stateAfterSeekNextRow = this.needToReturn(outResult);
                        if (stateAfterSeekNextRow == null) break;
                        boolean bl2 = scannerContext.setScannerState(stateAfterSeekNextRow).hasMoreValues();
                        return bl2;
                    }
                    case SEEK_NEXT_COL: {
                        this.seekOrSkipToNextColumn(cell);
                        ScannerContext.NextState stateAfterSeekNextColumn = this.needToReturn(outResult);
                        if (stateAfterSeekNextColumn == null) break;
                        boolean bl3 = scannerContext.setScannerState(stateAfterSeekNextColumn).hasMoreValues();
                        return bl3;
                    }
                    case SKIP: {
                        this.heap.next();
                        break;
                    }
                    case SEEK_NEXT_USING_HINT: {
                        Cell nextKV = this.matcher.getNextKeyHint(cell);
                        if (nextKV != null) {
                            int difference = this.comparator.compare(nextKV, cell);
                            if (!this.scan.isReversed() && difference > 0 || this.scan.isReversed() && difference < 0) {
                                this.seekAsDirection(nextKV);
                                ScannerContext.NextState stateAfterSeekByHint = this.needToReturn(outResult);
                                if (stateAfterSeekByHint == null) break;
                                boolean bl4 = scannerContext.setScannerState(stateAfterSeekByHint).hasMoreValues();
                                return bl4;
                            }
                        }
                        this.heap.next();
                        break;
                    }
                    default: {
                        throw new RuntimeException("UNEXPECTED");
                    }
                }
                if (!scannerContext.checkSizeLimit(ScannerContext.LimitScope.BETWEEN_CELLS)) continue;
                boolean bl5 = scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                return bl5;
            } while ((cell = this.heap.peek()) != null);
            if (count > 0) {
                bl = scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                return bl;
            }
            this.close(false);
            bl = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
            return bl;
        }
        finally {
            if (count > 0 && this.matcher.isUserScan()) {
                this.updateMetricsStore(onlyFromMemstore);
            }
        }
    }

    private void updateMetricsStore(boolean memstoreRead) {
        if (this.store != null) {
            this.store.updateMetricsStore(memstoreRead);
        } else if (memstoreRead) {
            ++this.memstoreOnlyReads;
        } else {
            ++this.mixedReads;
        }
    }

    private ScannerContext.NextState needToReturn(List<Cell> outResult) {
        if (!outResult.isEmpty() && this.topChanged) {
            return this.heap.peek() == null ? ScannerContext.NextState.NO_MORE_VALUES : ScannerContext.NextState.MORE_VALUES;
        }
        return null;
    }

    private void seekOrSkipToNextRow(Cell cell) throws IOException {
        if (!this.get && this.trySkipToNextRow(cell)) {
            return;
        }
        this.seekToNextRow(cell);
    }

    private void seekOrSkipToNextColumn(Cell cell) throws IOException {
        if (!this.trySkipToNextColumn(cell)) {
            this.seekAsDirection(this.matcher.getKeyForNextColumn(cell));
        }
    }

    protected boolean trySkipToNextRow(Cell cell) throws IOException {
        Cell nextCell = null;
        Cell previousIndexedKey = null;
        do {
            Cell nextIndexedKey;
            if ((nextIndexedKey = this.getNextIndexedKey()) != null && nextIndexedKey != KeyValueScanner.NO_NEXT_INDEXED_KEY && (nextIndexedKey == previousIndexedKey || this.matcher.compareKeyForNextRow(nextIndexedKey, cell) >= 0)) {
                this.heap.next();
                ++this.kvsScanned;
            } else {
                return false;
            }
            previousIndexedKey = nextIndexedKey;
        } while ((nextCell = this.heap.peek()) != null && CellUtil.matchingRows(cell, nextCell));
        return true;
    }

    protected boolean trySkipToNextColumn(Cell cell) throws IOException {
        Cell nextCell = null;
        Cell previousIndexedKey = null;
        do {
            Cell nextIndexedKey;
            if ((nextIndexedKey = this.getNextIndexedKey()) != null && nextIndexedKey != KeyValueScanner.NO_NEXT_INDEXED_KEY && (nextIndexedKey == previousIndexedKey || this.matcher.compareKeyForNextColumn(nextIndexedKey, cell) >= 0)) {
                this.heap.next();
                ++this.kvsScanned;
            } else {
                return false;
            }
            previousIndexedKey = nextIndexedKey;
        } while ((nextCell = this.heap.peek()) != null && CellUtil.matchingRowColumn(cell, nextCell));
        return !this.useRowColBloom || nextCell == null || cell.getTimestamp() != Long.MIN_VALUE;
    }

    @Override
    public long getReadPoint() {
        return this.readPt;
    }

    private static void clearAndClose(List<KeyValueScanner> scanners) {
        if (scanners == null) {
            return;
        }
        for (KeyValueScanner s2 : scanners) {
            s2.close();
        }
        scanners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReaders(List<HStoreFile> sfs, List<KeyValueScanner> memStoreScanners) throws IOException {
        if (CollectionUtils.isEmpty(sfs) && CollectionUtils.isEmpty(memStoreScanners)) {
            return;
        }
        boolean updateReaders = false;
        this.flushLock.lock();
        try {
            if (!this.closeLock.tryLock()) {
                LOG.debug("StoreScanner already has the close lock. There is no need to updateReaders");
                StoreScanner.clearAndClose(memStoreScanners);
                return;
            }
            updateReaders = true;
            if (this.closing) {
                LOG.debug("StoreScanner already closing. There is no need to updateReaders");
                StoreScanner.clearAndClose(memStoreScanners);
                return;
            }
            this.flushed = true;
            boolean isCompaction = false;
            boolean usePread = this.get || this.scanUsePread;
            List<KeyValueScanner> scanners = this.store.getScanners(sfs, this.cacheBlocks, this.get, usePread, false, this.matcher, this.scan.getStartRow(), this.scan.getStopRow(), this.readPt, false);
            this.flushedstoreFileScanners.addAll(scanners);
            if (!CollectionUtils.isEmpty(memStoreScanners)) {
                StoreScanner.clearAndClose(this.memStoreScannersAfterFlush);
                this.memStoreScannersAfterFlush.addAll(memStoreScanners);
            }
        }
        finally {
            this.flushLock.unlock();
            if (updateReaders) {
                this.closeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean reopenAfterFlush() throws IOException {
        List<KeyValueScanner> scanners;
        Cell lastTop = this.heap.peek();
        this.flushLock.lock();
        try {
            ArrayList<KeyValueScanner> allScanners = new ArrayList<KeyValueScanner>(this.flushedstoreFileScanners.size() + this.memStoreScannersAfterFlush.size());
            allScanners.addAll(this.flushedstoreFileScanners);
            allScanners.addAll(this.memStoreScannersAfterFlush);
            scanners = this.selectScannersFrom(this.store, allScanners);
            this.flushedstoreFileScanners.clear();
            this.memStoreScannersAfterFlush.clear();
        }
        finally {
            this.flushLock.unlock();
        }
        this.seekScanners(scanners, lastTop, false, this.parallelSeekEnabled);
        for (int i = this.currentScanners.size() - 1; i >= 0 && !this.currentScanners.get(i).isFileScanner(); --i) {
            this.scannersForDelayedClose.add(this.currentScanners.remove(i));
        }
        this.addCurrentScanners(scanners);
        this.resetKVHeap(this.currentScanners, this.store.getComparator());
        this.resetQueryMatcher(lastTop);
        if (this.heap.peek() == null || this.store.getComparator().compareRows(lastTop, this.heap.peek()) != 0) {
            LOG.info("Storescanner.peek() is changed where before = " + lastTop.toString() + ",and after = " + this.heap.peek());
            this.topChanged = true;
        } else {
            this.topChanged = false;
        }
        return this.topChanged;
    }

    private void resetQueryMatcher(Cell lastTopKey) {
        Cell cell = this.heap.peek();
        if (cell == null) {
            cell = lastTopKey;
        }
        if (this.matcher.currentRow() == null || !CellUtil.matchingRows(cell, this.matcher.currentRow())) {
            this.countPerRow = 0L;
            this.matcher.setToNewRow(cell);
        }
    }

    protected void checkScanOrder(Cell prevKV, Cell kv, CellComparator comparator) throws IOException {
        assert (prevKV == null || comparator == null || comparator.compare(prevKV, kv) <= 0) : "Key " + prevKV + " followed by a smaller key " + kv + " in cf " + this.store;
    }

    protected boolean seekToNextRow(Cell c) throws IOException {
        return this.reseek(PrivateCellUtil.createLastOnRow(c));
    }

    protected boolean seekAsDirection(Cell kv) throws IOException {
        return this.reseek(kv);
    }

    @Override
    public boolean reseek(Cell kv) throws IOException {
        if (this.checkFlushed()) {
            this.reopenAfterFlush();
        }
        if (this.explicitColumnQuery && lazySeekEnabledGlobally) {
            return this.heap.requestSeek(kv, true, this.useRowColBloom);
        }
        return this.heap.reseek(kv);
    }

    void trySwitchToStreamRead() {
        KeyValueHeap newHeap;
        ArrayList<KeyValueScanner> newCurrentScanners;
        if (this.readType != Scan.ReadType.DEFAULT || !this.scanUsePread || this.closing || this.heap.peek() == null || this.bytesRead < this.preadMaxBytes) {
            return;
        }
        LOG.debug("Switch to stream read (scanned={} bytes) of {}", (Object)this.bytesRead, (Object)this.store.getColumnFamilyName());
        this.scanUsePread = false;
        Cell lastTop = this.heap.peek();
        ArrayList<KeyValueScanner> memstoreScanners = new ArrayList<KeyValueScanner>();
        ArrayList<KeyValueScanner> scannersToClose = new ArrayList<KeyValueScanner>();
        for (KeyValueScanner kvs : this.currentScanners) {
            if (!kvs.isFileScanner()) {
                memstoreScanners.add(kvs);
                continue;
            }
            scannersToClose.add(kvs);
        }
        List<KeyValueScanner> fileScanners = null;
        try {
            fileScanners = this.store.recreateScanners(scannersToClose, this.cacheBlocks, false, false, this.matcher, this.scan.getStartRow(), this.scan.includeStartRow(), this.scan.getStopRow(), this.scan.includeStopRow(), this.readPt, false);
            if (fileScanners == null) {
                return;
            }
            this.seekScanners(fileScanners, lastTop, false, this.parallelSeekEnabled);
            newCurrentScanners = new ArrayList<KeyValueScanner>(fileScanners.size() + memstoreScanners.size());
            newCurrentScanners.addAll(fileScanners);
            newCurrentScanners.addAll(memstoreScanners);
            newHeap = this.newKVHeap(newCurrentScanners, this.comparator);
        }
        catch (Exception e) {
            LOG.warn("failed to switch to stream read", (Throwable)e);
            if (fileScanners != null) {
                fileScanners.forEach(KeyValueScanner::close);
            }
            return;
        }
        this.currentScanners.clear();
        this.addCurrentScanners(newCurrentScanners);
        this.heap = newHeap;
        this.resetQueryMatcher(lastTop);
        scannersToClose.forEach(KeyValueScanner::close);
    }

    protected final boolean checkFlushed() {
        if (this.flushed) {
            if (this.closing) {
                return false;
            }
            this.flushed = false;
            return true;
        }
        return false;
    }

    private void parallelSeek(List<? extends KeyValueScanner> scanners, Cell kv) throws IOException {
        if (scanners.isEmpty()) {
            return;
        }
        int storeFileScannerCount = scanners.size();
        CountDownLatch latch = new CountDownLatch(storeFileScannerCount);
        ArrayList<ParallelSeekHandler> handlers = new ArrayList<ParallelSeekHandler>(storeFileScannerCount);
        for (KeyValueScanner keyValueScanner : scanners) {
            if (keyValueScanner instanceof StoreFileScanner) {
                ParallelSeekHandler seekHandler = new ParallelSeekHandler(keyValueScanner, kv, this.readPt, latch);
                this.executor.submit(seekHandler);
                handlers.add(seekHandler);
                continue;
            }
            keyValueScanner.seek(kv);
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(ie);
        }
        for (ParallelSeekHandler parallelSeekHandler : handlers) {
            if (parallelSeekHandler.getErr() == null) continue;
            throw new IOException(parallelSeekHandler.getErr());
        }
    }

    List<KeyValueScanner> getAllScannersForTesting() {
        ArrayList<KeyValueScanner> allScanners = new ArrayList<KeyValueScanner>();
        KeyValueScanner current = this.heap.getCurrentForTesting();
        if (current != null) {
            allScanners.add(current);
        }
        for (KeyValueScanner scanner : this.heap.getHeap()) {
            allScanners.add(scanner);
        }
        return allScanners;
    }

    static void enableLazySeekGlobally(boolean enable) {
        lazySeekEnabledGlobally = enable;
    }

    public long getEstimatedNumberOfKvsScanned() {
        return this.kvsScanned;
    }

    @Override
    public Cell getNextIndexedKey() {
        return this.heap.getNextIndexedKey();
    }

    @Override
    public void shipped() throws IOException {
        if (this.prevCell != null) {
            this.prevCell = KeyValueUtil.toNewKeyCell(this.prevCell);
        }
        this.matcher.beforeShipped();
        StoreScanner.clearAndClose(this.scannersForDelayedClose);
        if (this.heap != null) {
            this.heap.shipped();
            this.trySwitchToStreamRead();
        }
    }
}

