/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsTableRequests {
    public static final String ENABLE_TABLE_LATENCIES_METRICS_KEY = "hbase.regionserver.enable.table.latencies";
    public static final boolean ENABLE_TABLE_LATENCIES_METRICS_DEFAULT = true;
    public static final String ENABLE_TABLE_QUERY_METER_METRICS_KEY = "hbase.regionserver.enable.table.query.meter";
    public static final boolean ENABLE_TABLE_QUERY_METER_METRICS_KEY_DEFAULT = false;
    private static final String METRICS_NAME = "TableRequests";
    private static final String METRICS_CONTEXT = "regionserver";
    private static final String METRICS_DESCRIPTION = "Metrics about Tables on a single HBase RegionServer";
    private static final String METRICS_JMX_CONTEXT = "RegionServer,sub=TableRequests";
    private static final String GET_TIME = "getTime";
    private static final String SCAN_TIME = "scanTime";
    private static final String SCAN_SIZE = "scanSize";
    private static final String PUT_TIME = "putTime";
    private static final String PUT_BATCH_TIME = "putBatchTime";
    private static final String DELETE_TIME = "deleteTime";
    private static final String DELETE_BATCH_TIME = "deleteBatchTime";
    private static final String INCREMENT_TIME = "incrementTime";
    private static final String APPEND_TIME = "appendTime";
    private static final String CHECK_AND_DELETE_TIME = "checkAndDeleteTime";
    private static final String CHECK_AND_PUT_TIME = "checkAndPutTime";
    private static final String CHECK_AND_MUTATE_TIME = "checkAndMutateTime";
    String BLOCK_BYTES_SCANNED_KEY = "blockBytesScannedCount";
    String GET_BLOCK_BYTES_SCANNED_KEY = "getBlockBytesScanned";
    String SCAN_BLOCK_BYTES_SCANNED_KEY = "scanBlockBytesScanned";
    String CHECK_AND_MUTATE_BLOCK_BYTES_SCANNED_KEY = "checkAndMutateBlockBytesScanned";
    String INCREMENT_BLOCK_BYTES_SCANNED_KEY = "incrementBlockBytesScanned";
    String APPEND_BLOCK_BYTES_SCANNED_KEY = "appendBlockBytesScanned";
    private static final String TABLE_READ_QUERY_PER_SECOND = "tableReadQueryPerSecond";
    private static final String TABLE_WRITE_QUERY_PER_SECOND = "tableWriteQueryPerSecond";
    private Histogram getTimeHistogram;
    private Histogram scanTimeHistogram;
    private Histogram scanSizeHistogram;
    private Histogram putTimeHistogram;
    private Histogram putBatchTimeHistogram;
    private Histogram deleteTimeHistogram;
    private Histogram deleteBatchTimeHistogram;
    private Histogram incrementTimeHistogram;
    private Histogram appendTimeHistogram;
    private Histogram checkAndDeleteTimeHistogram;
    private Histogram checkAndPutTimeHistogram;
    private Histogram checkAndMutateTimeHistogram;
    private Counter blockBytesScannedCount;
    private Histogram checkAndMutateBlockBytesScanned;
    private Histogram getBlockBytesScanned;
    private Histogram incrementBlockBytesScanned;
    private Histogram appendBlockBytesScanned;
    private Histogram scanBlockBytesScanned;
    private Meter readMeter;
    private Meter writeMeter;
    private MetricRegistry registry;
    private TableName tableName;
    private Configuration conf;
    private MetricRegistryInfo registryInfo;
    private boolean enableTableLatenciesMetrics;
    private boolean enabTableQueryMeterMetrics;

    public boolean isEnableTableLatenciesMetrics() {
        return this.enableTableLatenciesMetrics;
    }

    public boolean isEnabTableQueryMeterMetrics() {
        return this.enabTableQueryMeterMetrics;
    }

    public MetricsTableRequests(TableName tableName, Configuration conf) {
        this.init(tableName, conf);
    }

    private void init(TableName tableName, Configuration conf) {
        this.tableName = tableName;
        this.conf = conf;
        this.enableTableLatenciesMetrics = this.conf.getBoolean(ENABLE_TABLE_LATENCIES_METRICS_KEY, true);
        this.enabTableQueryMeterMetrics = this.conf.getBoolean(ENABLE_TABLE_QUERY_METER_METRICS_KEY, false);
        if (this.enableTableLatenciesMetrics || this.enabTableQueryMeterMetrics) {
            this.registry = this.createRegistryForTableRequests();
            if (this.enableTableLatenciesMetrics) {
                this.getTimeHistogram = this.registry.histogram(GET_TIME);
                this.scanTimeHistogram = this.registry.histogram(SCAN_TIME);
                this.scanSizeHistogram = this.registry.histogram(SCAN_SIZE);
                this.putTimeHistogram = this.registry.histogram(PUT_TIME);
                this.putBatchTimeHistogram = this.registry.histogram(PUT_BATCH_TIME);
                this.deleteTimeHistogram = this.registry.histogram(DELETE_TIME);
                this.deleteBatchTimeHistogram = this.registry.histogram(DELETE_BATCH_TIME);
                this.incrementTimeHistogram = this.registry.histogram(INCREMENT_TIME);
                this.appendTimeHistogram = this.registry.histogram(APPEND_TIME);
                this.checkAndDeleteTimeHistogram = this.registry.histogram(CHECK_AND_DELETE_TIME);
                this.checkAndPutTimeHistogram = this.registry.histogram(CHECK_AND_PUT_TIME);
                this.checkAndMutateTimeHistogram = this.registry.histogram(CHECK_AND_MUTATE_TIME);
                this.blockBytesScannedCount = this.registry.counter(this.BLOCK_BYTES_SCANNED_KEY);
                this.checkAndMutateBlockBytesScanned = this.registry.histogram(this.CHECK_AND_MUTATE_BLOCK_BYTES_SCANNED_KEY);
                this.getBlockBytesScanned = this.registry.histogram(this.GET_BLOCK_BYTES_SCANNED_KEY);
                this.incrementBlockBytesScanned = this.registry.histogram(this.INCREMENT_BLOCK_BYTES_SCANNED_KEY);
                this.appendBlockBytesScanned = this.registry.histogram(this.APPEND_BLOCK_BYTES_SCANNED_KEY);
                this.scanBlockBytesScanned = this.registry.histogram(this.SCAN_BLOCK_BYTES_SCANNED_KEY);
            }
            if (this.enabTableQueryMeterMetrics) {
                this.readMeter = this.registry.meter(TABLE_READ_QUERY_PER_SECOND);
                this.writeMeter = this.registry.meter(TABLE_WRITE_QUERY_PER_SECOND);
            }
        }
    }

    private MetricRegistry createRegistryForTableRequests() {
        return MetricRegistries.global().create(this.createRegistryInfoForTableRequests());
    }

    private MetricRegistryInfo createRegistryInfoForTableRequests() {
        this.registryInfo = new MetricRegistryInfo(MetricsTableRequests.qualifyMetrics(METRICS_NAME, this.tableName), METRICS_DESCRIPTION, MetricsTableRequests.qualifyMetrics(METRICS_JMX_CONTEXT, this.tableName), METRICS_CONTEXT, false);
        return this.registryInfo;
    }

    public void removeRegistry() {
        if (this.enableTableLatenciesMetrics || this.enabTableQueryMeterMetrics) {
            MetricRegistries.global().remove(this.registry.getMetricRegistryInfo());
        }
    }

    private static String qualifyMetrics(String prefix, TableName tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("_");
        sb.append("Namespace_").append(tableName.getNamespaceAsString());
        sb.append("_table_").append(tableName.getQualifierAsString());
        return sb.toString();
    }

    public void updatePut(long t) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.putTimeHistogram.update(t);
        }
    }

    public void updatePutBatch(long t) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.putBatchTimeHistogram.update(t);
        }
    }

    public void updateDelete(long t) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.deleteTimeHistogram.update(t);
        }
    }

    public void updateDeleteBatch(long t) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.deleteBatchTimeHistogram.update(t);
        }
    }

    public void updateGet(long time, long blockBytesScanned) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.getTimeHistogram.update(time);
            if (blockBytesScanned > 0L) {
                this.blockBytesScannedCount.increment(blockBytesScanned);
                this.getBlockBytesScanned.update(blockBytesScanned);
            }
        }
    }

    public void updateIncrement(long time, long blockBytesScanned) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.incrementTimeHistogram.update(time);
            if (blockBytesScanned > 0L) {
                this.blockBytesScannedCount.increment(blockBytesScanned);
                this.incrementBlockBytesScanned.update(blockBytesScanned);
            }
        }
    }

    public void updateAppend(long time, long blockBytesScanned) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.appendTimeHistogram.update(time);
            if (blockBytesScanned > 0L) {
                this.blockBytesScannedCount.increment(blockBytesScanned);
                this.appendBlockBytesScanned.update(blockBytesScanned);
            }
        }
    }

    public void updateScan(long time, long responseCellSize, long blockBytesScanned) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.scanTimeHistogram.update(time);
            this.scanSizeHistogram.update(responseCellSize);
            if (blockBytesScanned > 0L) {
                this.blockBytesScannedCount.increment(blockBytesScanned);
                this.scanBlockBytesScanned.update(blockBytesScanned);
            }
        }
    }

    public void updateCheckAndDelete(long time) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.checkAndDeleteTimeHistogram.update(time);
        }
    }

    public void updateCheckAndPut(long time) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.checkAndPutTimeHistogram.update(time);
        }
    }

    public void updateCheckAndMutate(long time, long blockBytesScanned) {
        if (this.isEnableTableLatenciesMetrics()) {
            this.checkAndMutateTimeHistogram.update(time);
            if (blockBytesScanned > 0L) {
                this.blockBytesScannedCount.increment(blockBytesScanned);
                this.checkAndMutateBlockBytesScanned.update(blockBytesScanned);
            }
        }
    }

    public void updateTableReadQueryMeter(long count) {
        if (this.isEnabTableQueryMeterMetrics()) {
            this.readMeter.mark(count);
        }
    }

    public void updateTableReadQueryMeter() {
        if (this.isEnabTableQueryMeterMetrics()) {
            this.readMeter.mark();
        }
    }

    public void updateTableWriteQueryMeter(long count) {
        if (this.isEnabTableQueryMeterMetrics()) {
            this.writeMeter.mark(count);
        }
    }

    public void updateTableWriteQueryMeter() {
        if (this.isEnabTableQueryMeterMetrics()) {
            this.writeMeter.mark();
        }
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.registryInfo;
    }
}

