/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.regionserver.wal.CombinedWriterBase;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class CombinedAsyncWriter
extends CombinedWriterBase<WALProvider.AsyncWriter>
implements WALProvider.AsyncWriter {
    private CombinedAsyncWriter(ImmutableList<WALProvider.AsyncWriter> writers) {
        super(writers);
    }

    @Override
    public void append(WAL.Entry entry) {
        this.writers.forEach(w -> w.append(entry));
    }

    @Override
    public CompletableFuture<Long> sync(boolean forceSync) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        AtomicInteger remaining = new AtomicInteger(this.writers.size());
        this.writers.forEach(w -> FutureUtils.addListener(w.sync(forceSync), (length, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (remaining.decrementAndGet() == 0) {
                future.complete((Long)length);
            }
        }));
        return future;
    }

    public static CombinedAsyncWriter create(WALProvider.AsyncWriter writer, WALProvider.AsyncWriter ... writers) {
        return new CombinedAsyncWriter((ImmutableList<WALProvider.AsyncWriter>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(writer)).add(writers)).build());
    }
}

