/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CombinedWriterBase<T extends WALProvider.WriterBase>
implements WALProvider.WriterBase {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedWriterBase.class);
    protected final ImmutableList<T> writers;

    protected CombinedWriterBase(ImmutableList<T> writers) {
        this.writers = writers;
    }

    @Override
    public void close() throws IOException {
        Exception error = null;
        for (WALProvider.WriterBase writer : this.writers) {
            try {
                writer.close();
            }
            catch (Exception e) {
                LOG.warn("close writer failed", (Throwable)e);
                if (error != null) continue;
                error = e;
            }
        }
        if (error != null) {
            throw new IOException("Failed to close at least one writer, please see the warn log above. The cause is the first exception occurred", error);
        }
    }

    @Override
    public long getLength() {
        return ((WALProvider.WriterBase)this.writers.get(0)).getLength();
    }

    @Override
    public long getSyncedLength() {
        return ((WALProvider.WriterBase)this.writers.get(0)).getSyncedLength();
    }
}

