/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.io.DelegatingInputStream;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.regionserver.wal.AbstractProtobufWALReader;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALStreamReader;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALTailingReader;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProtobufWALTailingReader
extends AbstractProtobufWALReader
implements WALTailingReader {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufWALStreamReader.class);
    private DelegatingInputStream delegatingInput;
    private static final ReadWALKeyResult KEY_ERROR_AND_RESET = new ReadWALKeyResult(WALTailingReader.State.ERROR_AND_RESET, null, 0);
    private static final ReadWALKeyResult KEY_EOF_AND_RESET = new ReadWALKeyResult(WALTailingReader.State.EOF_AND_RESET, null, 0);

    private IOException unwrapIPBE(IOException e) {
        if (e instanceof InvalidProtocolBufferException) {
            return ((InvalidProtocolBufferException)e).unwrapIOException();
        }
        return e;
    }

    private ReadWALKeyResult readWALKey(long originalPosition) {
        WALProtos.WALKey walKey;
        int available;
        int size;
        int firstByte;
        try {
            firstByte = this.delegatingInput.read();
        }
        catch (IOException e) {
            LOG.warn("Failed to read wal key length first byte", (Throwable)e);
            return KEY_ERROR_AND_RESET;
        }
        if (firstByte == -1) {
            return KEY_EOF_AND_RESET;
        }
        try {
            size = CodedInputStream.readRawVarint32(firstByte, this.delegatingInput);
        }
        catch (IOException e) {
            if (e instanceof InvalidProtocolBufferException && ProtobufUtil.isEOF((InvalidProtocolBufferException)e)) {
                LOG.info("EOF while reading WALKey, originalPosition={}, currentPosition={}, error={}", new Object[]{originalPosition, this.getPositionQuietly(), e.toString()});
                return KEY_EOF_AND_RESET;
            }
            LOG.warn("Failed to read wal key length", (Throwable)e);
            return KEY_ERROR_AND_RESET;
        }
        if (size < 0) {
            LOG.warn("Negative pb message size read: {}, malformed WAL file?", (Object)size);
            return KEY_ERROR_AND_RESET;
        }
        try {
            available = this.delegatingInput.available();
        }
        catch (IOException e) {
            LOG.warn("Failed to get available bytes", (Throwable)e);
            return KEY_ERROR_AND_RESET;
        }
        if (available > 0 && available < size) {
            LOG.info("Available stream not enough for edit, available={}, entry size={} at offset={}", new Object[]{available, size, this.getPositionQuietly()});
            return KEY_EOF_AND_RESET;
        }
        try {
            if (available > 0) {
                walKey = WALProtos.WALKey.parseFrom(ByteStreams.limit(this.delegatingInput, size));
            } else {
                byte[] content = new byte[size];
                ByteStreams.readFully(this.delegatingInput, content);
                walKey = WALProtos.WALKey.parseFrom(content);
            }
        }
        catch (IOException e) {
            boolean isWALTrailer;
            e = this.unwrapIPBE(e);
            if (e instanceof EOFException || e instanceof InvalidProtocolBufferException && ProtobufUtil.isEOF((InvalidProtocolBufferException)e)) {
                LOG.info("EOF while reading WALKey, originalPosition={}, currentPosition={}, error={}", new Object[]{originalPosition, this.getPositionQuietly(), e.toString()});
                return KEY_EOF_AND_RESET;
            }
            try {
                isWALTrailer = this.isWALTrailer(originalPosition);
            }
            catch (IOException ioe) {
                LOG.warn("Error while testing whether this is a partial WAL trailer, originalPosition={}, currentPosition={}", new Object[]{originalPosition, this.getPositionQuietly(), e});
                return KEY_ERROR_AND_RESET;
            }
            if (isWALTrailer) {
                LOG.info("Reached partial WAL Trailer(EOF) while reading WALKey, originalPosition={}, currentPosition={}", new Object[]{originalPosition, this.getPositionQuietly(), e});
                return KEY_EOF_AND_RESET;
            }
            LOG.warn("Error while reading WALKey, originalPosition={}, currentPosition={}", new Object[]{originalPosition, this.getPositionQuietly(), e});
            return KEY_ERROR_AND_RESET;
        }
        WAL.Entry entry = new WAL.Entry();
        try {
            entry.getKey().readFieldsFromPb(walKey, this.byteStringUncompressor);
        }
        catch (IOException e) {
            LOG.warn("Failed to read wal key fields from pb message", (Throwable)e);
            return KEY_ERROR_AND_RESET;
        }
        return new ReadWALKeyResult(WALTailingReader.State.NORMAL, entry, walKey.hasFollowingKvCount() ? walKey.getFollowingKvCount() : 0);
    }

    private WALTailingReader.Result editEof() {
        return this.hasCompression ? WALTailingReader.State.EOF_AND_RESET_COMPRESSION.getResult() : WALTailingReader.State.EOF_AND_RESET.getResult();
    }

    private WALTailingReader.Result editError() {
        return this.hasCompression ? WALTailingReader.State.ERROR_AND_RESET_COMPRESSION.getResult() : WALTailingReader.State.ERROR_AND_RESET.getResult();
    }

    private WALTailingReader.Result readWALEdit(WAL.Entry entry, int followingKvCount) {
        long posAfter;
        int actualCells;
        long posBefore;
        try {
            posBefore = this.inputStream.getPos();
        }
        catch (IOException e) {
            LOG.warn("failed to get position", (Throwable)e);
            return WALTailingReader.State.ERROR_AND_RESET.getResult();
        }
        if (followingKvCount == 0) {
            LOG.trace("WALKey has no KVs that follow it; trying the next one. current offset={}", (Object)posBefore);
            return new WALTailingReader.Result(WALTailingReader.State.NORMAL, entry, posBefore);
        }
        try {
            actualCells = entry.getEdit().readFromCells(this.cellDecoder, followingKvCount);
        }
        catch (Exception e) {
            String message = " while reading " + followingKvCount + " WAL KVs; started reading at " + posBefore + " and read up to " + this.getPositionQuietly();
            IOException realEofEx = this.extractHiddenEof(e);
            if (realEofEx != null) {
                LOG.warn("EOF " + message, (Throwable)realEofEx);
                return this.editEof();
            }
            LOG.warn("Error " + message, (Throwable)e);
            return this.editError();
        }
        if (actualCells != followingKvCount) {
            LOG.warn("Only read {} cells, expected {}; started reading at {} and read up to {}", new Object[]{actualCells, followingKvCount, posBefore, this.getPositionQuietly()});
            return this.editEof();
        }
        try {
            posAfter = this.inputStream.getPos();
        }
        catch (IOException e) {
            LOG.warn("failed to get position", (Throwable)e);
            return this.editError();
        }
        if (this.trailerPresent && posAfter > this.walEditsStopOffset) {
            LOG.error("Read WALTrailer while reading WALEdits. wal: {}, inputStream.getPos(): {}, walEditsStopOffset: {}", new Object[]{this.path, posAfter, this.walEditsStopOffset});
            return this.editEof();
        }
        return new WALTailingReader.Result(WALTailingReader.State.NORMAL, entry, posAfter);
    }

    @Override
    public WALTailingReader.Result next(long limit) {
        long originalPosition;
        try {
            originalPosition = this.inputStream.getPos();
        }
        catch (IOException e) {
            LOG.warn("failed to get position", (Throwable)e);
            return WALTailingReader.State.EOF_AND_RESET.getResult();
        }
        if (this.reachWALEditsStopOffset(originalPosition)) {
            return WALTailingReader.State.EOF_WITH_TRAILER.getResult();
        }
        if (limit < 0L) {
            this.delegatingInput.setDelegate((InputStream)this.inputStream);
        } else {
            if (limit <= originalPosition) {
                return WALTailingReader.State.EOF_AND_RESET.getResult();
            }
            this.delegatingInput.setDelegate(ByteStreams.limit((InputStream)this.inputStream, limit - originalPosition));
        }
        ReadWALKeyResult readKeyResult = this.readWALKey(originalPosition);
        if (readKeyResult.state != WALTailingReader.State.NORMAL) {
            return readKeyResult.state.getResult();
        }
        return this.readWALEdit(readKeyResult.entry, readKeyResult.followingKvCount);
    }

    private void skipHeader(FSDataInputStream stream) throws IOException {
        stream.seek((long)PB_WAL_MAGIC.length);
        int headerLength = StreamUtils.readRawVarint32((InputStream)stream);
        stream.seek(stream.getPos() + (long)headerLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetTo(long position, boolean resetCompression) throws IOException {
        this.close();
        Pair<FSDataInputStream, FileStatus> pair = this.open();
        boolean resetSucceed = false;
        try {
            if (!this.trailerPresent) {
                this.readTrailer(pair.getFirst(), pair.getSecond());
            }
            this.inputStream = pair.getFirst();
            this.delegatingInput.setDelegate((InputStream)this.inputStream);
            if (position < 0L) {
                if (this.compressionCtx != null) {
                    this.compressionCtx.clear();
                }
                this.skipHeader(this.inputStream);
            } else if (resetCompression && this.compressionCtx != null) {
                this.compressionCtx.clear();
                this.skipHeader(this.inputStream);
                if (position != this.inputStream.getPos()) {
                    this.skipTo(position);
                }
            } else {
                this.inputStream.seek(position);
            }
            resetSucceed = true;
        }
        finally {
            if (!resetSucceed) {
                this.close();
            }
        }
    }

    @Override
    protected InputStream getCellCodecInputStream(FSDataInputStream stream) {
        this.delegatingInput = new DelegatingInputStream((InputStream)stream);
        return this.delegatingInput;
    }

    @Override
    protected void skipTo(long position) throws IOException {
        WALTailingReader.Result result;
        do {
            if ((result = this.next(-1L)).getState() != WALTailingReader.State.NORMAL) {
                throw new IOException("Can not skip to the given position " + position + ", stopped at " + result.getEntryEndPos() + " which is still before the give position");
            }
            if (result.getEntryEndPos() != position) continue;
            return;
        } while (result.getEntryEndPos() <= position);
        throw new IOException("Can not skip to the given position " + position + ", stopped at " + result.getEntryEndPos() + " which is already beyond the give position, malformed WAL?");
    }

    private static final class ReadWALKeyResult {
        final WALTailingReader.State state;
        final WAL.Entry entry;
        final int followingKvCount;

        public ReadWALKeyResult(WALTailingReader.State state, WAL.Entry entry, int followingKvCount) {
            this.state = state;
            this.entry = entry;
            this.followingKvCount = followingKvCount;
        }
    }
}

