/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class ChainWALEntryFilter
implements WALEntryFilter {
    private final WALEntryFilter[] filters;
    private WALCellFilter[] cellFilters;

    public ChainWALEntryFilter(WALEntryFilter ... filters) {
        this.filters = filters;
        this.initCellFilters();
    }

    public ChainWALEntryFilter(List<WALEntryFilter> filters) {
        ArrayList<WALEntryFilter> rawFilters = new ArrayList<WALEntryFilter>(filters.size());
        for (WALEntryFilter filter : filters) {
            if (filter instanceof ChainWALEntryFilter) {
                Collections.addAll(rawFilters, ((ChainWALEntryFilter)filter).filters);
                continue;
            }
            rawFilters.add(filter);
        }
        this.filters = rawFilters.toArray(new WALEntryFilter[rawFilters.size()]);
        this.initCellFilters();
    }

    public void initCellFilters() {
        ArrayList<WALCellFilter> cellFilters = new ArrayList<WALCellFilter>(this.filters.length);
        for (WALEntryFilter filter : this.filters) {
            if (!(filter instanceof WALCellFilter)) continue;
            cellFilters.add((WALCellFilter)((Object)filter));
        }
        this.cellFilters = cellFilters.toArray(new WALCellFilter[cellFilters.size()]);
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        if ((entry = this.filterEntry(entry)) == null) {
            return null;
        }
        this.filterCells(entry);
        return entry;
    }

    protected WAL.Entry filterEntry(WAL.Entry entry) {
        for (WALEntryFilter filter : this.filters) {
            if (entry == null) {
                return null;
            }
            entry = filter.filter(entry);
        }
        return entry;
    }

    protected void filterCells(WAL.Entry entry) {
        if (entry == null || this.cellFilters.length == 0) {
            return;
        }
        WALUtil.filterCells(entry.getEdit(), c -> this.filterCell(entry, (Cell)c));
    }

    private Cell filterCell(WAL.Entry entry, Cell cell) {
        WALCellFilter filter;
        WALCellFilter[] wALCellFilterArray = this.cellFilters;
        int n = wALCellFilterArray.length;
        for (int i = 0; i < n && (cell = (filter = wALCellFilterArray[i]).filterCell(entry, cell)) != null; ++i) {
        }
        return cell;
    }
}

