/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ZKReplicationStorageBase;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKReplicationQueueStorageForMigration
extends ZKReplicationStorageBase {
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY = "zookeeper.znode.replication.hfile.refs";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT = "hfile-refs";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_REGIONS_KEY = "zookeeper.znode.replication.regions";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_REGIONS_DEFAULT = "regions";
    private final String queuesZNode;
    private final String hfileRefsZNode;
    private final String regionsZNode;
    private static final MigrationIterator EMPTY_ITER = new MigrationIterator(){

        public Object next() {
            return null;
        }
    };

    public ZKReplicationQueueStorageForMigration(ZKWatcher zookeeper, Configuration conf) {
        super(zookeeper, conf);
        String queuesZNodeName = conf.get("zookeeper.znode.replication.rs", "rs");
        String hfileRefsZNodeName = conf.get(ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY, ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT);
        this.queuesZNode = ZNodePaths.joinZNode(this.replicationZNode, queuesZNodeName);
        this.hfileRefsZNode = ZNodePaths.joinZNode(this.replicationZNode, hfileRefsZNodeName);
        this.regionsZNode = ZNodePaths.joinZNode(this.replicationZNode, conf.get(ZOOKEEPER_ZNODE_REPLICATION_REGIONS_KEY, ZOOKEEPER_ZNODE_REPLICATION_REGIONS_DEFAULT));
    }

    private String getRsNode(ServerName serverName) {
        return ZNodePaths.joinZNode(this.queuesZNode, serverName.getServerName());
    }

    private String getQueueNode(ServerName serverName, String queueId) {
        return ZNodePaths.joinZNode(this.getRsNode(serverName), queueId);
    }

    private String getFileNode(String queueNode, String fileName) {
        return ZNodePaths.joinZNode(queueNode, fileName);
    }

    private String getFileNode(ServerName serverName, String queueId, String fileName) {
        return this.getFileNode(this.getQueueNode(serverName, queueId), fileName);
    }

    public MigrationIterator<Pair<ServerName, List<ZkReplicationQueueData>>> listAllQueues() throws KeeperException {
        List<String> replicators = ZKUtil.listChildrenNoWatch(this.zookeeper, this.queuesZNode);
        if (replicators == null || replicators.isEmpty()) {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.queuesZNode);
            return EMPTY_ITER;
        }
        final Iterator<String> iter = replicators.iterator();
        return new MigrationIterator<Pair<ServerName, List<ZkReplicationQueueData>>>(){
            private ServerName previousServerName;

            @Override
            public Pair<ServerName, List<ZkReplicationQueueData>> next() throws Exception {
                ServerName serverName;
                if (this.previousServerName != null) {
                    ZKUtil.deleteNodeRecursively(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.getRsNode(this.previousServerName));
                }
                if (!iter.hasNext()) {
                    ZKUtil.deleteNodeRecursively(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.queuesZNode);
                    return null;
                }
                String replicator = (String)iter.next();
                this.previousServerName = serverName = ServerName.parseServerName(replicator);
                List<String> queueIdList = ZKUtil.listChildrenNoWatch(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.getRsNode(serverName));
                if (queueIdList == null || queueIdList.isEmpty()) {
                    return Pair.newPair(serverName, Collections.emptyList());
                }
                ArrayList<ZkReplicationQueueData> queueDataList = new ArrayList<ZkReplicationQueueData>(queueIdList.size());
                for (String queueIdStr : queueIdList) {
                    ZkReplicationQueueData queueData;
                    ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueIdStr);
                    ReplicationQueueId queueId = queueInfo.getDeadRegionServers().isEmpty() ? new ReplicationQueueId(serverName, queueInfo.getPeerId()) : new ReplicationQueueId(serverName, queueInfo.getPeerId(), queueInfo.getDeadRegionServers().get(0));
                    List<String> wals = ZKUtil.listChildrenNoWatch(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.getQueueNode(serverName, queueIdStr));
                    if (wals == null || wals.isEmpty()) {
                        queueData = new ZkReplicationQueueData(queueId, Collections.emptyMap());
                    } else {
                        HashMap<String, Long> walOffsets = new HashMap<String, Long>();
                        for (String wal : wals) {
                            byte[] data = ZKUtil.getData(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.getFileNode(serverName, queueIdStr, wal));
                            if (data == null || data.length == 0) {
                                walOffsets.put(wal, 0L);
                                continue;
                            }
                            walOffsets.put(wal, ZKUtil.parseWALPositionFrom(data));
                        }
                        queueData = new ZkReplicationQueueData(queueId, walOffsets);
                    }
                    queueDataList.add(queueData);
                }
                return Pair.newPair(serverName, queueDataList);
            }
        };
    }

    public MigrationIterator<List<ZkLastPushedSeqId>> listAllLastPushedSeqIds() throws KeeperException {
        List<String> level1Prefixs = ZKUtil.listChildrenNoWatch(this.zookeeper, this.regionsZNode);
        if (level1Prefixs == null || level1Prefixs.isEmpty()) {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.regionsZNode);
            return EMPTY_ITER;
        }
        final Iterator<String> level1Iter = level1Prefixs.iterator();
        return new MigrationIterator<List<ZkLastPushedSeqId>>(){
            private String level1Prefix;
            private Iterator<String> level2Iter;
            private String level2Prefix;

            @Override
            public List<ZkLastPushedSeqId> next() throws Exception {
                while (this.level2Iter == null || !this.level2Iter.hasNext()) {
                    if (!level1Iter.hasNext()) {
                        ZKUtil.deleteNodeRecursively(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.regionsZNode);
                        return null;
                    }
                    if (this.level1Prefix != null) {
                        ZKUtil.deleteNodeRecursively(ZKReplicationQueueStorageForMigration.this.zookeeper, ZNodePaths.joinZNode(ZKReplicationQueueStorageForMigration.this.regionsZNode, this.level1Prefix));
                    }
                    this.level1Prefix = (String)level1Iter.next();
                    List<String> level2Prefixes = ZKUtil.listChildrenNoWatch(ZKReplicationQueueStorageForMigration.this.zookeeper, ZNodePaths.joinZNode(ZKReplicationQueueStorageForMigration.this.regionsZNode, this.level1Prefix));
                    if (level2Prefixes == null) continue;
                    this.level2Iter = level2Prefixes.iterator();
                    this.level2Prefix = null;
                }
                if (this.level2Prefix != null) {
                    ZKUtil.deleteNodeRecursively(ZKReplicationQueueStorageForMigration.this.zookeeper, ZNodePaths.joinZNode(ZKReplicationQueueStorageForMigration.this.regionsZNode, this.level1Prefix, this.level2Prefix));
                }
                this.level2Prefix = this.level2Iter.next();
                List<String> encodedRegionNameAndPeerIds = ZKUtil.listChildrenNoWatch(ZKReplicationQueueStorageForMigration.this.zookeeper, ZNodePaths.joinZNode(ZKReplicationQueueStorageForMigration.this.regionsZNode, this.level1Prefix, this.level2Prefix));
                if (encodedRegionNameAndPeerIds == null || encodedRegionNameAndPeerIds.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<ZkLastPushedSeqId> lastPushedSeqIds = new ArrayList<ZkLastPushedSeqId>();
                for (String encodedRegionNameAndPeerId : encodedRegionNameAndPeerIds) {
                    byte[] data = ZKUtil.getData(ZKReplicationQueueStorageForMigration.this.zookeeper, ZNodePaths.joinZNode(ZKReplicationQueueStorageForMigration.this.regionsZNode, this.level1Prefix, this.level2Prefix, encodedRegionNameAndPeerId));
                    long lastPushedSeqId = ZKUtil.parseWALPositionFrom(data);
                    Iterator<String> iter = Splitter.on('-').split(encodedRegionNameAndPeerId).iterator();
                    String encodedRegionName = this.level1Prefix + this.level2Prefix + iter.next();
                    String peerId = iter.next();
                    lastPushedSeqIds.add(new ZkLastPushedSeqId(encodedRegionName, peerId, lastPushedSeqId));
                }
                return Collections.unmodifiableList(lastPushedSeqIds);
            }
        };
    }

    private String getHFileRefsPeerNode(String peerId) {
        return ZNodePaths.joinZNode(this.hfileRefsZNode, peerId);
    }

    public MigrationIterator<Pair<String, List<String>>> listAllHFileRefs() throws KeeperException {
        List<String> peerIds = ZKUtil.listChildrenNoWatch(this.zookeeper, this.hfileRefsZNode);
        if (peerIds == null || peerIds.isEmpty()) {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.hfileRefsZNode);
            return EMPTY_ITER;
        }
        final Iterator<String> iter = peerIds.iterator();
        return new MigrationIterator<Pair<String, List<String>>>(){
            private String previousPeerId;

            @Override
            public Pair<String, List<String>> next() throws KeeperException {
                if (this.previousPeerId != null) {
                    ZKUtil.deleteNodeRecursively(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.getHFileRefsPeerNode(this.previousPeerId));
                }
                if (!iter.hasNext()) {
                    ZKUtil.deleteNodeRecursively(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.hfileRefsZNode);
                    return null;
                }
                String peerId = (String)iter.next();
                List<String> refs = ZKUtil.listChildrenNoWatch(ZKReplicationQueueStorageForMigration.this.zookeeper, ZKReplicationQueueStorageForMigration.this.getHFileRefsPeerNode(peerId));
                this.previousPeerId = peerId;
                return Pair.newPair(peerId, refs != null ? refs : Collections.emptyList());
            }
        };
    }

    public boolean hasData() throws KeeperException {
        return ZKUtil.checkExists(this.zookeeper, this.queuesZNode) != -1 || ZKUtil.checkExists(this.zookeeper, this.regionsZNode) != -1 || ZKUtil.checkExists(this.zookeeper, this.hfileRefsZNode) != -1;
    }

    public void deleteAllData() throws KeeperException {
        ZKUtil.deleteNodeRecursively(this.zookeeper, this.queuesZNode);
        ZKUtil.deleteNodeRecursively(this.zookeeper, this.regionsZNode);
        ZKUtil.deleteNodeRecursively(this.zookeeper, this.hfileRefsZNode);
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    String getQueuesZNode() {
        return this.queuesZNode;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    String getHfileRefsZNode() {
        return this.hfileRefsZNode;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    String getRegionsZNode() {
        return this.regionsZNode;
    }

    public static final class ZkLastPushedSeqId {
        private final String encodedRegionName;
        private final String peerId;
        private final long lastPushedSeqId;

        ZkLastPushedSeqId(String encodedRegionName, String peerId, long lastPushedSeqId) {
            this.encodedRegionName = encodedRegionName;
            this.peerId = peerId;
            this.lastPushedSeqId = lastPushedSeqId;
        }

        public String getEncodedRegionName() {
            return this.encodedRegionName;
        }

        public String getPeerId() {
            return this.peerId;
        }

        public long getLastPushedSeqId() {
            return this.lastPushedSeqId;
        }
    }

    public static final class ZkReplicationQueueData {
        private final ReplicationQueueId queueId;
        private final Map<String, Long> walOffsets;

        public ZkReplicationQueueData(ReplicationQueueId queueId, Map<String, Long> walOffsets) {
            this.queueId = queueId;
            this.walOffsets = walOffsets;
        }

        public ReplicationQueueId getQueueId() {
            return this.queueId;
        }

        public Map<String, Long> getWalOffsets() {
            return this.walOffsets;
        }
    }

    public static interface MigrationIterator<T> {
        public T next() throws Exception;
    }
}

