/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationLogCleanerBarrier {
    private State state = State.NOT_RUNNING;
    private int numberDisabled = 0;

    public synchronized boolean start() {
        if (this.state == State.NOT_RUNNING) {
            this.state = State.RUNNING;
            return true;
        }
        if (this.state == State.DISABLED) {
            return false;
        }
        throw new IllegalStateException("Unexpected state " + (Object)((Object)this.state));
    }

    public synchronized void stop() {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Unexpected state " + (Object)((Object)this.state));
        }
        this.state = State.NOT_RUNNING;
    }

    public synchronized boolean disable() {
        if (this.state == State.RUNNING) {
            return false;
        }
        if (this.state == State.NOT_RUNNING) {
            this.state = State.DISABLED;
        }
        ++this.numberDisabled;
        return true;
    }

    public synchronized void enable() {
        if (this.state != State.DISABLED) {
            throw new IllegalStateException("Unexpected state " + (Object)((Object)this.state));
        }
        --this.numberDisabled;
        if (this.numberDisabled == 0) {
            this.state = State.NOT_RUNNING;
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        DISABLED;

    }
}

