/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.RecoveredReplicationSourceShipper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceShipper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RecoveredReplicationSource
extends ReplicationSource {
    @Override
    protected void startShippers() {
        for (String walGroupId : this.logQueue.getQueues().keySet()) {
            this.workerThreads.put(walGroupId, this.createNewShipper(walGroupId));
        }
        for (ReplicationSourceShipper shipper : this.workerThreads.values()) {
            this.startShipper(shipper);
        }
    }

    @Override
    protected RecoveredReplicationSourceShipper createNewShipper(String walGroupId, ReplicationSourceWALReader walReader) {
        return new RecoveredReplicationSourceShipper(this.conf, walGroupId, this, walReader, this.queueStorage, () -> {
            if (this.workerThreads.isEmpty()) {
                this.getSourceMetrics().clear();
                this.manager.finishRecoveredSource(this);
            }
        });
    }
}

