/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPromoter;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.ClusterInfoProvider;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.balancer.MasterClusterInfoProvider;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSGroupBasedLoadBalancer
implements LoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupBasedLoadBalancer.class);
    private MasterServices masterServices;
    private ClusterInfoProvider provider;
    private FavoredNodesManager favoredNodesManager;
    private volatile RSGroupInfoManager rsGroupInfoManager;
    private volatile LoadBalancer internalBalancer;
    public static final String FALLBACK_GROUP_ENABLE_KEY = "hbase.rsgroup.fallback.enable";
    private volatile boolean fallbackEnabled = false;

    @InterfaceAudience.Private
    public RSGroupBasedLoadBalancer() {
    }

    @Override
    public synchronized void updateClusterMetrics(ClusterMetrics sm) {
        assert (this.internalBalancer != null);
        this.internalBalancer.updateClusterMetrics(sm);
    }

    @Override
    public synchronized void updateBalancerLoadInfo(Map<TableName, Map<ServerName, List<RegionInfo>>> loadOfAllTable) {
        this.internalBalancer.updateBalancerLoadInfo(loadOfAllTable);
    }

    public void setMasterServices(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    @Override
    public synchronized List<RegionPlan> balanceCluster(Map<TableName, Map<ServerName, List<RegionInfo>>> loadOfAllTable) throws IOException {
        if (!this.isOnline()) {
            throw new ConstraintException(RSGroupInfoManager.class.getSimpleName() + " is not online, unable to perform balance");
        }
        Pair<Map<TableName, Map<ServerName, List<RegionInfo>>>, List<RegionPlan>> correctedStateAndRegionPlans = this.correctAssignments(loadOfAllTable);
        Map<TableName, Map<ServerName, List<RegionInfo>>> correctedLoadOfAllTable = correctedStateAndRegionPlans.getFirst();
        List<RegionPlan> regionPlans = correctedStateAndRegionPlans.getSecond();
        RSGroupInfo defaultInfo = this.rsGroupInfoManager.getRSGroup("default");
        try {
            for (RSGroupInfo rsgroup : this.rsGroupInfoManager.listRSGroups()) {
                LOG.debug("Balancing RSGroup={}", (Object)rsgroup.getName());
                HashMap<TableName, Map<ServerName, List<RegionInfo>>> loadOfTablesInGroup = new HashMap<TableName, Map<ServerName, List<RegionInfo>>>();
                for (Map.Entry<TableName, Map<ServerName, List<RegionInfo>>> entry : correctedLoadOfAllTable.entrySet()) {
                    TableName tableName = entry.getKey();
                    RSGroupInfo targetRSGInfo = RSGroupUtil.getRSGroupInfo(this.masterServices, this.rsGroupInfoManager, tableName).orElse(defaultInfo);
                    if (!targetRSGInfo.getName().equals(rsgroup.getName())) continue;
                    loadOfTablesInGroup.put(tableName, entry.getValue());
                }
                List<RegionPlan> groupPlans = null;
                if (!loadOfTablesInGroup.isEmpty()) {
                    LOG.info("Start Generate Balance plan for group: " + rsgroup.getName());
                    groupPlans = this.internalBalancer.balanceCluster(loadOfTablesInGroup);
                }
                if (groupPlans == null) continue;
                regionPlans.addAll(groupPlans);
            }
        }
        catch (IOException exp) {
            LOG.warn("Exception while balancing cluster.", (Throwable)exp);
            regionPlans.clear();
        }
        return regionPlans;
    }

    @Override
    @NonNull
    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) throws IOException {
        HashMap<ServerName, List<RegionInfo>> assignments = Maps.newHashMap();
        List<Pair<List<RegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(regions, servers);
        for (Pair<List<RegionInfo>, List<ServerName>> pair : pairs) {
            Map<ServerName, List<RegionInfo>> result = this.internalBalancer.roundRobinAssignment(pair.getFirst(), pair.getSecond());
            result.forEach((server, regionInfos) -> assignments.computeIfAbsent((ServerName)server, s2 -> Lists.newArrayList()).addAll(regionInfos));
        }
        return assignments;
    }

    @Override
    @NonNull
    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
        try {
            TreeMap<ServerName, List<RegionInfo>> assignments = new TreeMap<ServerName, List<RegionInfo>>();
            List<Pair<List<RegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(Lists.newArrayList(regions.keySet()), servers);
            for (Pair<List<RegionInfo>, List<ServerName>> pair : pairs) {
                List<RegionInfo> regionList = pair.getFirst();
                TreeMap<RegionInfo, ServerName> currentAssignmentMap = Maps.newTreeMap();
                regionList.forEach(r -> {
                    ServerName cfr_ignored_0 = (ServerName)currentAssignmentMap.put((RegionInfo)r, (ServerName)regions.get(r));
                });
                Map<ServerName, List<RegionInfo>> pairResult = this.internalBalancer.retainAssignment(currentAssignmentMap, pair.getSecond());
                pairResult.forEach((server, rs) -> assignments.computeIfAbsent((ServerName)server, s2 -> Lists.newArrayList()).addAll(rs));
            }
            return assignments;
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to do online retain assignment", e);
        }
    }

    @Override
    public ServerName randomAssignment(RegionInfo region, List<ServerName> servers) throws IOException {
        List<Pair<List<RegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(Lists.newArrayList(region), servers);
        List<ServerName> filteredServers = pairs.iterator().next().getSecond();
        return this.internalBalancer.randomAssignment(region, filteredServers);
    }

    private List<Pair<List<RegionInfo>, List<ServerName>>> generateGroupAssignments(List<RegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        try {
            ArrayListMultimap<String, RegionInfo> regionMap = ArrayListMultimap.create();
            ArrayListMultimap<String, ServerName> serverMap = ArrayListMultimap.create();
            RSGroupInfo defaultInfo = this.rsGroupInfoManager.getRSGroup("default");
            for (RegionInfo region : regions) {
                String groupName = RSGroupUtil.getRSGroupInfo(this.masterServices, this.rsGroupInfoManager, region.getTable()).orElse(defaultInfo).getName();
                regionMap.put(groupName, region);
            }
            for (String groupKey : regionMap.keySet()) {
                RSGroupInfo info = this.rsGroupInfoManager.getRSGroup(groupKey);
                serverMap.putAll(groupKey, this.filterOfflineServers(info, servers));
            }
            ArrayList<Pair<List<RegionInfo>, List<ServerName>>> result = Lists.newArrayList();
            ArrayList fallbackRegions = Lists.newArrayList();
            for (String groupKey : regionMap.keySet()) {
                if (serverMap.get((Object)groupKey).isEmpty()) {
                    fallbackRegions.addAll(regionMap.get((Object)groupKey));
                    continue;
                }
                result.add(Pair.newPair(regionMap.get((Object)groupKey), serverMap.get((Object)groupKey)));
            }
            if (!fallbackRegions.isEmpty()) {
                List<ServerName> candidates = null;
                if (this.isFallbackEnabled()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Falling back {} regions to servers outside their RSGroup. Regions: {}", (Object)fallbackRegions.size(), fallbackRegions.stream().map(RegionInfo::getRegionNameAsString).collect(Collectors.toSet()));
                    }
                    candidates = this.getFallBackCandidates(servers);
                }
                candidates = candidates == null || candidates.isEmpty() ? Lists.newArrayList(BOGUS_SERVER_NAME) : candidates;
                result.add(Pair.newPair(fallbackRegions, candidates));
            }
            return result;
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to generate group assignments", e);
        }
    }

    private List<ServerName> filterOfflineServers(RSGroupInfo RSGroupInfo2, List<ServerName> onlineServers) {
        if (RSGroupInfo2 != null) {
            return this.filterServers(RSGroupInfo2.getServers(), onlineServers);
        }
        LOG.warn("RSGroup Information found to be null. Some regions might be unassigned.");
        return Collections.emptyList();
    }

    private List<ServerName> filterServers(Set<Address> servers, List<ServerName> onlineServers) {
        ArrayList<ServerName> finalList = new ArrayList<ServerName>();
        for (ServerName onlineServer : onlineServers) {
            if (!servers.contains(onlineServer.getAddress())) continue;
            finalList.add(onlineServer);
        }
        return finalList;
    }

    private Pair<Map<TableName, Map<ServerName, List<RegionInfo>>>, List<RegionPlan>> correctAssignments(Map<TableName, Map<ServerName, List<RegionInfo>>> existingAssignments) throws IOException {
        HashMap correctAssignments = new HashMap();
        ArrayList regionPlansForMisplacedRegions = new ArrayList();
        RSGroupInfo defaultInfo = this.rsGroupInfoManager.getRSGroup("default");
        for (Map.Entry<TableName, Map<ServerName, List<RegionInfo>>> assignments : existingAssignments.entrySet()) {
            TableName tableName = assignments.getKey();
            Map<ServerName, List<RegionInfo>> clusterLoad = assignments.getValue();
            RSGroupInfo targetRSGInfo = null;
            TreeMap<ServerName, List<RegionInfo>> correctServerRegion = new TreeMap<ServerName, List<RegionInfo>>();
            try {
                targetRSGInfo = RSGroupUtil.getRSGroupInfo(this.masterServices, this.rsGroupInfoManager, tableName).orElse(defaultInfo);
            }
            catch (IOException exp) {
                LOG.debug("RSGroup information null for region of table " + tableName, (Throwable)exp);
            }
            for (Map.Entry<ServerName, List<RegionInfo>> serverRegionMap : clusterLoad.entrySet()) {
                ServerName currentHostServer = serverRegionMap.getKey();
                List<RegionInfo> regionInfoList = serverRegionMap.getValue();
                if (targetRSGInfo == null || !targetRSGInfo.containsServer(currentHostServer.getAddress())) {
                    regionInfoList.forEach(regionInfo -> regionPlansForMisplacedRegions.add(new RegionPlan((RegionInfo)regionInfo, currentHostServer, null)));
                    continue;
                }
                correctServerRegion.put(currentHostServer, regionInfoList);
            }
            correctAssignments.put(tableName, correctServerRegion);
        }
        return new Pair<Map<TableName, Map<ServerName, List<RegionInfo>>>, List<RegionPlan>>(correctAssignments, regionPlansForMisplacedRegions);
    }

    @Override
    public void initialize() throws IOException {
        Class<LoadBalancer> balancerClass;
        Configuration conf;
        String balancerClassName;
        if (this.rsGroupInfoManager == null) {
            this.rsGroupInfoManager = this.masterServices.getRSGroupInfoManager();
            if (this.rsGroupInfoManager == null) {
                String msg = "RSGroupInfoManager hasn't been initialized";
                LOG.error(msg);
                throw new HBaseIOException(msg);
            }
            this.rsGroupInfoManager.start();
        }
        if ((balancerClassName = (conf = this.masterServices.getConfiguration()).get("hbase.rsgroup.grouploadbalancer.class")) == null) {
            balancerClass = conf.getClass("hbase.master.loadbalancer.class", LoadBalancerFactory.getDefaultLoadBalancerClass(), LoadBalancer.class);
        } else {
            try {
                balancerClass = Class.forName(balancerClassName).asSubclass(LoadBalancer.class);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        this.provider = new MasterClusterInfoProvider(this.masterServices);
        if (this.getClass().isAssignableFrom(balancerClass)) {
            balancerClass = LoadBalancerFactory.getDefaultLoadBalancerClass();
        }
        this.internalBalancer = ReflectionUtils.newInstance(balancerClass, new Object[0]);
        this.internalBalancer.setClusterInfoProvider(this.provider);
        if (this.internalBalancer instanceof FavoredNodesPromoter) {
            this.favoredNodesManager = new FavoredNodesManager(this.provider);
            ((FavoredNodesPromoter)((Object)this.internalBalancer)).setFavoredNodesManager(this.favoredNodesManager);
        }
        this.internalBalancer.initialize();
        this.fallbackEnabled = conf.getBoolean(FALLBACK_GROUP_ENABLE_KEY, false);
    }

    public boolean isOnline() {
        if (this.rsGroupInfoManager == null) {
            return false;
        }
        return this.rsGroupInfoManager.isOnline();
    }

    public boolean isFallbackEnabled() {
        return this.fallbackEnabled;
    }

    @Override
    public void regionOnline(RegionInfo regionInfo, ServerName sn) {
    }

    @Override
    public void regionOffline(RegionInfo regionInfo) {
    }

    @Override
    public synchronized void onConfigurationChange(Configuration conf) {
        boolean newFallbackEnabled = conf.getBoolean(FALLBACK_GROUP_ENABLE_KEY, false);
        if (this.fallbackEnabled != newFallbackEnabled) {
            LOG.info("Changing the value of {} from {} to {}", new Object[]{FALLBACK_GROUP_ENABLE_KEY, this.fallbackEnabled, newFallbackEnabled});
            this.fallbackEnabled = newFallbackEnabled;
        }
        this.provider.onConfigurationChange(conf);
        this.internalBalancer.onConfigurationChange(conf);
    }

    @Override
    public void stop(String why) {
        this.internalBalancer.stop(why);
    }

    @Override
    public boolean isStopped() {
        return this.internalBalancer.isStopped();
    }

    public LoadBalancer getInternalBalancer() {
        return this.internalBalancer;
    }

    public FavoredNodesManager getFavoredNodesManager() {
        return this.favoredNodesManager;
    }

    @Override
    public synchronized void postMasterStartupInitialize() {
        this.internalBalancer.postMasterStartupInitialize();
    }

    @Override
    public void updateBalancerStatus(boolean status) {
        this.internalBalancer.updateBalancerStatus(status);
    }

    private List<ServerName> getFallBackCandidates(List<ServerName> servers) {
        List<ServerName> serverNames = null;
        try {
            RSGroupInfo info = this.rsGroupInfoManager.getRSGroup("default");
            serverNames = this.filterOfflineServers(info, servers);
        }
        catch (IOException e) {
            LOG.error("Failed to get default rsgroup info to fallback", (Throwable)e);
        }
        return serverNames == null || serverNames.isEmpty() ? servers : serverNames;
    }

    @Override
    public void setClusterInfoProvider(ClusterInfoProvider provider) {
        throw new UnsupportedOperationException("Just call set master service instead");
    }
}

