/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class OOMEChecker {
    private static final Logger LOG = LoggerFactory.getLogger(OOMEChecker.class);

    private OOMEChecker() {
    }

    public static boolean exitIfOOME(Throwable e, String service) {
        boolean stop = false;
        try {
            if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
                stop = true;
                LOG.error(HBaseMarkers.FATAL, "Run out of memory; {} will abort itself immediately", (Object)service, (Object)e);
            }
        }
        finally {
            if (stop) {
                Runtime.getRuntime().halt(1);
            }
        }
        return stop;
    }
}

